/////////////////////////////////////////////////////////////////////////////
// Name:        MainWin.h
// Purpose:     Main window
// Author:      Alex Thuering
// Created:	10.10.2003
// RCS-ID:      $Id: MainWin.h,v 1.31 2009/02/11 21:32:25 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef MAINWIN_H
#define MAINWIN_H

#include <wx/wx.h>
#include <wx/image.h>
#include <wx/html/helpctrl.h>
#include "DirCtrl.h"
#include <wxVillaLib/Thumbnails.h>
#include "MenuEditor.h"
#include "TitlesetManager.h"
#include "StatusBar.h"


// begin wxGlade: dependencies
#include <wx/splitter.h>
// end wxGlade


class MainWin: public wxFrame {
public:
    // begin wxGlade: MainWin::ids
    enum {
        MENU_BURN_ID = 2105,
        MENU_DVD_ADD_MENU_ID = 2111,
        MENU_DVD_ADD_VMMENU_ID = 2112,
        MENU_DVD_ADD_TITLESET_ID = 2113,
        MENU_DVD_OPTIONS_ID = 2110,
        MENU_SETTINGS_ID = 2120,
        DIR_TREE_ID = 2000,
        THUMBNAILS_ID = 2001,
        MENU_EDITOR_ID = 2002,
        TITLESET_MANAGER_ID = 2003,
        SPLIITTER_TITLE_ID = 2010
    };
    // end wxGlade

    MainWin();
    /** loads a project file */
	void Open(wxString filename);
    /** adds a title to dvd */
	void AddTitle(wxString filename) { m_titlesetManager->AddVideo(filename); }
    void Burn(bool start_close);
	
  private:
    // begin wxGlade: MainWin::attributes
    wxMenuBar* m_menubar;
    wxToolBar* m_dirBar;
    DirCtrl* m_dirTree;
    wxStaticText* m_thumbLabel;
    wxThumbnails* m_thumbnails;
    wxPanel* m_thumbPanel;
    MenuEditor* m_menuEditor;
    wxSplitterWindow* m_splitterThumb;
    wxSplitterWindow* m_splitterDir;
    TitlesetManager* m_titlesetManager;
    wxSplitterWindow* m_splitterTitle;
    // end wxGlade
    StatusBar* m_statusbar;
    wxHtmlHelpController m_helpController;
	
    // begin wxGlade: MainWin::methods
    void set_properties();
    void do_layout();
    // end wxGlade
	
	DVD* m_dvd;
	wxString m_lastDir;
	wxString m_filename; /** project file name */
	bool m_changed;
	
    /** Creates new project */
	void NewDVD(wxString discLabel, DiscCapacity capacity, int videoBitrate,
			VideoFormat videoFormat, AudioFormat audioFormat, AspectRatio aspectRatio);
    /** It must be called after m_dvd was changed */
	void UpdateDVD();
	
    /** sets project status to changed */
    void SetChanged(bool changed);
    /** returns true if project is changed */
	bool GetChanged() { return m_changed; }
    void OnChangedMenu(wxCommandEvent& event);
	void OnChangedDVD(wxCommandEvent& event);
	
    /** checks if project is saved and asks for saving */
    bool TestSaved();
	
	wxToolBar* m_toolbar;
	int m_splitterDirSash;
	int m_splitterTitleSash;
	
    /** shows directory tree */
	void ShowDirTree(bool show);
	void OnDirTreeBt(wxCommandEvent& event);
    void OnBackgroundsBt(wxCommandEvent& event);
	void OnButtonsBt(wxCommandEvent& event);
	
	void OnDirSelected(wxTreeEvent& event);
	void OnThumbDoubleClick(wxCommandEvent& event);
	void OnThumbInfo(wxCommandEvent& event);
	void OnTitleInfo(wxCommandEvent& event);
	void OnMenuObjectInfo(wxCommandEvent& event);
    void OnSelectMenu(wxCommandEvent& event);
    
    void OnSetBackground(wxCommandEvent& event);
	void OnUpdateUISetBackground(wxUpdateUIEvent& event);
	void OnRefresh(wxCommandEvent& event);
	
	virtual void OnNew(wxCommandEvent& event); // wxGlade: <event_handler>
	virtual void OnOpen(wxCommandEvent& event); // wxGlade: <event_handler>
	virtual void OnSave(wxCommandEvent& event); // wxGlade: <event_handler>
	virtual void OnSaveAs(wxCommandEvent& event); // wxGlade: <event_handler>
	virtual void OnBurn(wxCommandEvent& event); // wxGlade: <event_handler>
	virtual void OnExit(wxCommandEvent& event); // wxGlade: <event_handler>
	virtual void OnAddMenu(wxCommandEvent& WXUNUSED(event)); // wxGlade: <event_handler>
	virtual void OnAddVmMenu(wxCommandEvent& WXUNUSED(event)); // wxGlade: <event_handler>
	virtual void OnAddTitleset(wxCommandEvent& WXUNUSED(event)); // wxGlade: <event_handler>
	virtual void OnAddTitlesetUpdateUI(wxUpdateUIEvent& event); // wxGlade: <event_handler>
	virtual void OnDVDOptions(wxCommandEvent& event); // wxGlade: <event_handler>
	virtual void OnSettings(wxCommandEvent& event); // wxGlade: <event_handler>
	virtual void OnAbout(wxCommandEvent& event); // wxGlade: <event_handler>
    virtual void OnHelpContents(wxCommandEvent &event); // wxGlade: <event_handler>
	
	void OnSplitterTitleSash(wxSplitterEvent &event);
	void OnResize(wxSizeEvent &event);
	void OnClose(wxCloseEvent &event);
    DECLARE_EVENT_TABLE()
}; // wxGlade: end class

#endif // MAINWIN_H
