/////////////////////////////////////////////////////////////////////////////
// Name:        dvdstyler.cpp
// Purpose:     DVD Authoring Application
// Author:      Alex Thuering
// Created:	10.10.2003
// RCS-ID:      $Id: dvdstyler.cpp,v 1.35 2009/02/11 21:35:07 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#include "MainWin.h"
#include "About.h"
#include "Config.h"
#include "Languages.h"
#include "MPEG.h"
#include <wx/config.h>
#include <wx/filesys.h>
#include <wx/fs_zip.h>
#include <wxVillaLib/imagjpg.h>
#include <wxVillaLib/utils.h>
#include <wxVillaLib/ThumbnailFactory.h>
#include <wxSVG/SVGCanvas.h>
#include <wxSVG/mediadec_ffmpeg.h>
#include <wx/cmdline.h>

#ifndef __WXWINCE__
#include <locale.h>
#endif

#include "rc/dvdstyler.png.h"

#define LOCALE_DIR wxFindDataDirectory(_T("..") + wxString(wxFILE_SEP_PATH) + _T("locale"))

class DVDStyler : public wxApp {
public:
	bool OnInit();

protected:
	wxLocale m_locale;
};

IMPLEMENT_APP(DVDStyler)

bool DVDStyler::OnInit() {
	// fix config
	s_config.Init();
	wxString version = s_config.GetVersion();
	if (version.length() < 3 || version.Mid(0, 3) != APP_VERSION.Mid(0, 3)) {
		wxLogNull log;
		s_config.SetVersion(APP_VERSION);
		if (version.length() >= 3 && version.Mid(0, 3) == wxT("1.5")) {
			s_config.DeleteGroup(_T("Generate"));
		} else {
			s_config.DeleteGroup(_T("Generate"));
			s_config.DeleteGroup(_T("Preview"));
			s_config.DeleteGroup(_T("Iso"));
			s_config.DeleteGroup(_T("Burn"));
		}
		s_config.Flush();
	}

	wxInitAllImageHandlers();
	// load new jpeg handler (with scale option)
	if (!wxImage::RemoveHandler(_T("JPEG file")))
		wxMessageBox(_T("Error: Can't remove old JPEG handler"));
	wxImage::InsertHandler(new wxJPGHandler);
	
    wxFileSystem::AddHandler(new wxZipFSHandler);

	wxThumbnailFactory::InitGnome(APP_NAME.mb_str(), APP_VERSION.mb_str(), argc, (char**)argv);

	// locale
	int lang = s_config.GetLanguage();
	bool firstStart = lang == -1;
	if (firstStart)
		lang = ChooseLanguage();
	if (lang != wxLANGUAGE_ENGLISH) {
		m_locale.Init(lang);
		m_locale.AddCatalogLookupPathPrefix(LOCALE_DIR);
		m_locale.AddCatalog(wxT("dvdstyler"));
	}

#ifndef __WXWINCE__
	setlocale(LC_NUMERIC, "C");
#endif

	wxFfmpegMediaDecoder::Init();
#ifndef __WXMSW__
	if (firstStart) {
		// check if mplex exists
		wxLogNull log;
		bool mplex = wxExecute(wxT("mplex"), wxEXEC_SYNC | wxEXEC_NODISABLE) == 1;
		s_config.SetUseMplex(mplex);
	}
#endif
	
	// create main window
	MainWin* mainWin = new MainWin();
	mainWin->SetIcon(wxICON_FROM_MEMORY(dvdstyler));
	
	// parse command line
	static const wxCmdLineEntryDesc cmdLineDesc[] = {
		{ wxCMD_LINE_SWITCH, wxT("s"), wxT("start"), _("automatically starts the generation and burning") },
		{ wxCMD_LINE_SWITCH, wxT("e"), wxT("stderr"), _("write log messages to standard error") },
		{ wxCMD_LINE_SWITCH, wxT("v"), wxT("version"), _("show version of program") },
		{ wxCMD_LINE_SWITCH, wxT("h"), wxT("help"), _("show summary of options") },
		{ wxCMD_LINE_PARAM, NULL, NULL, _("input file"), wxCMD_LINE_VAL_STRING,
				wxCMD_LINE_PARAM_OPTIONAL | wxCMD_LINE_PARAM_MULTIPLE },
		{ wxCMD_LINE_NONE }
	};
	
	wxCmdLineParser parser(cmdLineDesc, argc, argv);
	wxString logoText= wxT("DVDStyler, version ") + APP_VERSION
			+ wxString("\nCopyright  2008 Alex Thring. All Rights Reserved.\n", wxConvISO8859_1);
	parser.SetLogo(logoText);
	if (parser.Parse() != 0) {
		exit(1);
	} else if (parser.Found(wxT("v"))) {
		fprintf(stdout, "%s", (const char*) logoText.mb_str());
		exit(0);
	} else if (parser.Found(wxT("h"))) {
		parser.Usage();
		exit(0);
	}
	
	if (parser.Found(wxT("e"))) {
		wxLog::SetActiveTarget(new wxLogStderr);
		wxLog::GetActiveTarget()->SetVerbose(true);
	}
	
	for (int i=0; i<(int)parser.GetParamCount(); i++) {
		wxString filename = parser.GetParam(i);
		if (i == 0 && filename.Right(4).Lower() == _T(".xml")) 
			mainWin->Open(filename);
		else if (wxThumbnails::IsVideo(filename)) {
			wxFfmpegMediaDecoder decoder;
			if (!decoder.Load(filename)) {
				wxLogError(filename + _(": unknown format"));
				exit(1);
			}
			mainWin->AddTitle(filename);
		}
	}
	
	// show main window
	mainWin->Show();
	SetTopWindow(mainWin);
	if (parser.Found(wxT("s")))
		mainWin->Burn(true);
	
	s_config.SetLanguage(lang); // save choosed languages if all ok
	
	return true;
}
