/////////////////////////////////////////////////////////////////////////////
// Name:        VideoPropDlg.h
// Purpose:     The video properties dialog
// Author:      Alex Thuering
// Created:     09.09.2010
// RCS-ID:      $Id: VideoPropDlg.h,v 1.4 2010/10/17 18:13:07 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef VIDEO_PROP_DLG_H
#define VIDEO_PROP_DLG_H

#include "DVD.h"

// begin wxGlade: ::dependencies
#include <wx/spinctrl.h>
// end wxGlade

// begin wxGlade: ::extracode

// end wxGlade


class VideoPropDlg: public wxDialog {
public:
    // begin wxGlade: VideoPropDlg::ids
    // end wxGlade
	
	/**
	 * Constructor
	 */
	VideoPropDlg(wxWindow* parent, Vob* vob, AspectRatio aspectRatio);
    
    /**
	 * Displays dialog
	 */
	virtual int ShowModal();
	
	/**
	 * Returns selected aspect ratio
	 */
	AspectRatio GetAspectRatio() { return m_aspectRatio; }
    
private:
    // begin wxGlade: VideoPropDlg::methods
    void set_properties();
    void do_layout();
    // end wxGlade
    
    // begin wxGlade: VideoPropDlg::attributes
    wxStaticBox* m_cropBox_staticbox;
    wxStaticBox* m_padBox_staticbox;
    wxStaticText* m_fileNameLabel;
    wxStaticText* m_fileNameText;
    wxStaticText* m_durLabel;
    wxStaticText* m_durText;
    wxStaticText* m_srcLabel;
    wxStaticText* m_srcText;
    wxStaticText* m_dstLabel;
    wxChoice* m_dstChoice;
    wxChoice* m_aspectChoice;
    wxChoice* m_interlacedChoice;
    wxChoice* m_ffChoice;
    wxSpinCtrl* m_padTop;
    wxSpinCtrl* m_padLeft;
    wxSpinCtrl* m_padRight;
    wxSpinCtrl* m_padBottom;
    wxSpinCtrl* m_cropTop;
    wxSpinCtrl* m_cropLeft;
    wxSpinCtrl* m_cropRight;
    wxSpinCtrl* m_cropBottom;
    wxButton* m_okBt;
    wxButton* m_cancelBt;
    // end wxGlade
    
    Vob* m_vob;
    Stream* m_stream;
    AspectRatio m_aspectRatio;
    virtual void OnChangeFormat(wxCommandEvent &event); // wxGlade: <event_handler>
    virtual void OnInterlaced(wxCommandEvent &event); // wxGlade: <event_handler>

protected:
    DECLARE_EVENT_TABLE()
}; // wxGlade: end class


#endif // VIDEO_PROP_DLG_H
