///////////////////////////////////////////////////////////////////////////////
// Name:        Palettes3D.h
// Purpose:     The class to create and store palette with 3 colours per entry 
// Author:      Alex Thuering
// Created:	05.11.2006
// RCS-ID:      $Id: Palette3D.h,v 1.2 2006/12/06 14:53:37 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
///////////////////////////////////////////////////////////////////////////////

#ifndef PALETTE_3D_H
#define PALETTE_3D_H

#include <wx/dynarray.h>
#include <wx/colour.h>

class Palette3D
{
  private:
  	wxArrayInt m_colours1;
  	wxArrayInt m_colours2;
  	wxArrayInt m_colours3;
  	
  public:
	Palette3D() {}
	virtual ~Palette3D() {}
	
	void Add(const wxColour& colour1, const wxColour& colour2,
		const wxColour& colour3);
		
	/**
	 * Searches for matched colours in palette and replace given with them.
	 * Returns true if colour was changed.
	 **/
	bool Apply(wxColour& colour1, wxColour& colour2, wxColour& colour3);
	
	/** Reduces the number of colours in palette to given value. */
	void ReduceColours(int maxColours);
	
	/** Returns the number of colours in palette */
	inline int GetColoursCount() { return m_colours1.GetCount(); }
};

#endif // PALETTE_3D_H
