/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.KeyPairInfo;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.Options;

public class DescribeKeyPairs
extends BaseCmd {
    public DescribeKeyPairs(String[] args) {
        super("ec2dkey", "ec2-describe-keypairs");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        return new Options();
    }

    protected String getOptionString() {
        return "[KEY [KEY [...]]]";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     List and describe keypairs you've created (or have access to)");
        System.out.println("     The KEY parameter specifies the name(s) of the key(s) to be described.");
        System.out.println("     If unspecified all keypairs visible to you will be returned.");
    }

    public void printOptions() {
        super.printOptions();
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String[] keyNames = this.getNonOptions();
        RequestResultPair rsp = jec2.describeKeyPairs(keyNames);
        for (KeyPairInfo kp : (List)rsp.getResponse()) {
            out.outputKeyPair(System.out, kp.keyName, kp.keyFingerprint);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new DescribeKeyPairs(args).invoke();
    }
}

