/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.SnapshotDescription;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.Options;

public class DescribeSnapshots
extends BaseCmd {
    public DescribeSnapshots(String[] args) {
        super("ec2dsnap", "ec2-describe-snapshots");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        return new Options();
    }

    protected String getOptionString() {
        return "[SNAPSHOT [SNAPSHOT [...]]]";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     List and describe previously created snapshots.");
        System.out.println("     The SNAPSHOT parameter list specifies the snapshot(s) to be described.");
        System.out.println("     If unspecified, all snapshots will be described.");
    }

    public void printOptions() {
        super.printOptions();
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String[] snapshots = this.getNonOptions();
        RequestResultPair rsp = jec2.describeSnapshots(snapshots);
        for (SnapshotDescription d : (List)rsp.getResponse()) {
            out.output(System.out, d);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new DescribeSnapshots(args).invoke();
    }
}

