/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.AttachmentDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class DetachVolume
extends BaseCmd {
    private static final String[] FORCE_DESC = new String[]{"Forcefully disconnect VOLUME from INSTANCE.", "WARNING: This can lead to data loss or a corrupted file system.", "         Use this option only as a last resort to detach a volume", "         from a failed instance.  The instance will not have an", "         opportunity to flush file system caches nor file system", "         meta data."};
    private static final String DEVICE_DESC = "A device name as which the VOLUME is exposed inside INSTANCE.";
    private static final String INSTANCE_DESC = "The running instance to which the volume is attached.";

    public DetachVolume(String[] args) {
        super("ec2detvol", "ec2-detach-volume");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"instance");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)INSTANCE_DESC);
        result.addOption(OptionBuilder.create((String)"i"));
        OptionBuilder.withLongOpt((String)"device");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)DEVICE_DESC);
        result.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.withLongOpt((String)"force");
        OptionBuilder.withDescription((String)DetachVolume.joinDescription(FORCE_DESC));
        result.addOption(OptionBuilder.create((String)"f"));
        return result;
    }

    protected String getOptionString() {
        return "VOLUME [-i INSTANCE [-d DEVICE]] [-f|--force]";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Detach an attached volume, forcefully if indicated, from the specified instance.");
        System.out.println("     The VOLUME parameter specifies the volume which to detach.");
    }

    public void printOptions() {
        super.printOptions();
        this.printOption("instance");
        this.printOption("device");
        this.printOption("force");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        this.assertNonOptionSet("volume");
        if (this.isOptionSet("device")) {
            this.assertOptionSet("instance");
        }
        this.warnIfTooManyNonOptions();
        String volume = this.getNonOptions()[0];
        String instance = this.isOptionSet("instance") ? this.getOptionValue("instance") : "";
        String device = this.isOptionSet("device") ? this.getOptionValue("device") : "";
        Boolean force = this.isOptionSet("force");
        RequestResultPair rsp = jec2.detachVolume(volume, instance, device, force);
        if (rsp != null) {
            out.output(System.out, (AttachmentDescription)rsp.getResponse());
            out.printRequestId(System.out, (RequestResult)rsp);
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        new DetachVolume(args).invoke();
    }
}

