/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.service.RegionMapping;
import com.amazon.aes.service.RegionMappingFactory;
import com.amazon.aes.service.RegionMappingUtils;
import com.amazon.aes.service.S3Connection;
import com.amazon.aes.service.S3Service;
import com.amazon.aes.service.impl.RegionMappingFactoryCsvImpl;
import com.amazon.aes.service.impl.S3ServiceImpl;
import com.amazon.aes.util.CryptoUtils;
import com.amazon.aes.util.EccUtils;
import com.amazon.aes.util.LangUtils;
import com.amazon.aes.util.XmlUtils;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.GeneralError;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.cmd.MissingAtLeastOneArgument;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.Options;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrateBundle
extends BaseCmd {
    private static final String ACL = "acl";
    private static final String SOURCE_BUCKET = "bucket";
    private static final String DESTINATION_BUCKET = "destination-bucket";
    private static final String LOCATION = "location";
    private static final String MAPPING_FILE = "mapping-file";
    private static final String MAPPING_URL = "mapping-url";
    private static final String NO_MAPPING = "no-mapping";
    private static final String SOURCE_BUCKET_DESC = "S3 source bucket name";
    private static final String DESTINATION_BUCKET_DESC = "S3 destination bucket name";
    private static final String MANIFEST_DESC = "Manifest name";
    private static final String ACL_DESC = "The access control list policy of the bundled image";
    private static final String LOCATION_DESC = "The location of the destination Amazon S3 bucket";
    private static final String KERNEL_DESC = "The ID of the kernel to select.";
    private static final String RAMDIK_DESC = "The ID of the RAM disk to select.";
    private static final String MAPPING_FILE_DESC = "Overrides the file containing kernel and RAM disk region mappings.";
    private static final String MAPPING_URL_DESC = "Overrides the file containing kernel and RAM disk region mappings.";
    private static final String NO_MAPPING_DESC = "Disables automatic mapping of kernels and RAM disks.";
    private static final String REGION_DESC = "Region to look up in the mapping file. If no region is specified, Amazon EC2 attempts to determine the region from the location of the Amazon S3 bucket.";
    private static final Pattern MANIFEST_START_PATTERN = Pattern.compile("^\\s*<\\?");
    private static final int MAX_PART_RETRY = 5;
    private static final String USER_ID_XPATH = "manifest/image/user";
    private static final String KERNEL_XPATH = "manifest/machine_configuration/kernel_id";
    private static final String RAMDISK_XPATH = "manifest/machine_configuration/ramdisk_id";
    private static final String MACHINE_CONFIG_XPATH = "manifest/machine_configuration";
    private static final String IMAGE_XPATH = "manifest/image";
    private static final String SIGNATURE_XPATH = "manifest/signature";
    private static final String EC2_MAPPING_URL = "https://ec2-downloads.s3.amazonaws.com/mappings.csv";
    private static final String UNIX_ACL = "aws-exec-read";
    private static final String WINDOWS_ACL = "ec2-bundle-read";
    private S3Service s3Service = new S3ServiceImpl();
    private RegionMappingFactory regionMappingFactory = new RegionMappingFactoryCsvImpl();
    private PrintStream out = System.out;
    private String userName;
    private String password;
    private String sourceBucketName;
    private String destinationBucketName;
    private byte[] manifestData;
    private byte[] originalManifestData;
    private String manifestName;
    private String acl;
    private String location;
    private String privateKey;
    private String kernel;
    private String ramdisk;
    private String mappingFile;
    private String mappingUrl;
    private String region;
    private boolean verbose;
    private boolean mapManifest;
    private boolean canReadManifest = true;
    private boolean isManifestEncrypted = false;
    private boolean manifestAltered = false;
    private Document manifestDocument;

    public MigrateBundle(String[] args) {
        super("ec2mim", "ec2-migrate-image");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        return new Options().addOption("o", "owner-akid", true, "AWS Access Key Id of the owner of BUCKET.").addOption("w", "owner-sak", true, OWNER_SAK_DESC).addOption(null, SOURCE_BUCKET, true, SOURCE_BUCKET_DESC).addOption(null, DESTINATION_BUCKET, true, DESTINATION_BUCKET_DESC).addOption(null, "manifest", true, MANIFEST_DESC).addOption(null, ACL, true, ACL_DESC).addOption(null, LOCATION, true, LOCATION_DESC).addOption(null, "kernel", true, KERNEL_DESC).addOption(null, "ramdisk", true, RAMDIK_DESC).addOption(null, MAPPING_FILE, true, "Overrides the file containing kernel and RAM disk region mappings.").addOption(null, MAPPING_URL, true, "Overrides the file containing kernel and RAM disk region mappings.").addOption(null, NO_MAPPING, false, NO_MAPPING_DESC).addOption(null, "region", true, REGION_DESC);
    }

    @Override
    protected void parseOpts(String[] args) {
        super.parseOpts(args);
        if (this.cmd == null) {
            return;
        }
        this.userName = this.getOptionValue("owner-akid");
        this.password = this.getOptionValue("owner-sak");
        this.sourceBucketName = this.getOptionValue(SOURCE_BUCKET);
        this.destinationBucketName = this.getOptionValue(DESTINATION_BUCKET);
        this.manifestName = this.getOptionValue("manifest");
        this.acl = this.getOptionValue(ACL);
        this.location = this.getOptionValue(LOCATION);
        this.privateKey = this.getOptionValue("private-key");
        this.verbose = this.isOptionSet("verbose");
        this.mapManifest = !this.isOptionSet(NO_MAPPING);
        this.kernel = this.getOptionValue("kernel");
        this.ramdisk = this.getOptionValue("ramdisk");
        this.mappingFile = this.getOptionValue(MAPPING_FILE);
        this.mappingUrl = this.getOptionValue(MAPPING_URL, EC2_MAPPING_URL);
        this.region = this.getOptionValue("region");
    }

    @Override
    protected String getOptionString() {
        return "";
    }

    @Override
    public void printOptions() {
        super.printOptions();
        this.printOption("owner-akid");
        this.printOption("owner-sak");
        this.printOption(SOURCE_BUCKET);
        this.printOption(DESTINATION_BUCKET);
        this.printOption("manifest");
        this.printOption(ACL);
        this.printOption(LOCATION);
        this.printOption("kernel");
        this.printOption("ramdisk");
        this.printOption(MAPPING_FILE);
        this.printOption(MAPPING_URL);
        this.printOption(NO_MAPPING);
        this.printOption("region");
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Migrates an AMI to another bucket.");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        List<Object> parts;
        this.validateParameters();
        S3Connection srcConn = this.s3Service.makeS3Connection(this.userName, this.password, this.sourceBucketName);
        this.downloadManifest(srcConn);
        if (this.canReadManifest) {
            if (this.verbose) {
                this.out.println("Reading parts from manifest.");
            }
            this.manifestDocument = XmlUtils.readXml(this.manifestData);
            parts = this.getPartNames(this.manifestDocument);
        } else {
            String prefix = MigrateBundle.getPrefixFromManifestName(this.manifestName);
            parts = new ArrayList();
            for (String part : srcConn.getContentList(prefix).getValue()) {
                parts.add(new String[]{part, part});
            }
            if (this.verbose) {
                this.out.println("Reading parts from bucket list.");
            }
        }
        S3Connection dstConn = this.s3Service.makeS3Connection(this.userName, this.password, this.destinationBucketName);
        S3Connection.OperationResult bucketStatus = dstConn.bucketStatus();
        S3Connection.OperationCode bucketCode = bucketStatus.getOperationCode();
        if (S3Connection.OperationCode.NOT_FOUND == bucketCode) {
            S3Connection.OperationResult operationResult;
            S3Connection.OperationCode operationCode;
            if (LangUtils.isEmpty(this.location)) {
                this.location = this.guessLocation();
                if (this.verbose) {
                    this.out.println("Location not specified. Guessing by EC2 region: " + this.location);
                }
            }
            if (this.verbose) {
                this.out.println("Bucket " + this.destinationBucketName + " does not exist. Creating it with location " + (this.location == null ? "none" : this.location) + ".");
            }
            if (S3Connection.OperationCode.OK != (operationCode = (operationResult = dstConn.createBucket(this.location)).getOperationCode()) && S3Connection.OperationCode.CONFLICT != operationCode) {
                String string = "Could not create bucket " + this.destinationBucketName + (operationResult.getMsg() == null ? "." : ": " + operationResult.getMsg());
                throw new GeneralError(string);
            }
        } else {
            if (S3Connection.OperationCode.NOT_AUTHORIZED == bucketCode) {
                throw new GeneralError("Not authorized to access destination bucket: " + this.destinationBucketName);
            }
            if (S3Connection.OperationCode.OK == bucketCode) {
                S3Connection.OperationValueResult<String> locationResult;
                if (this.verbose) {
                    this.out.println("Bucket " + this.destinationBucketName + " already exists.");
                }
                if (S3Connection.OperationCode.OK != (locationResult = dstConn.bucketLocation()).getOperationCode()) {
                    throw new GeneralError("Could not determine location of the destination bucket");
                }
                if (this.location != null && !this.location.equals(locationResult.getValue())) {
                    throw new GeneralError("Bucket already exists, but not in the specified location");
                }
                this.location = locationResult.getValue();
            } else {
                throw new GeneralError("Unexpecteted status " + bucketStatus + " for destination bucket: " + this.destinationBucketName);
            }
        }
        if (LangUtils.isEmpty(this.region)) {
            String string = this.region = "EU".equals(this.location) ? "eu-west-1" : "us-east-1";
            if (this.verbose) {
                this.out.println("Guessing region by destination bucket: " + this.region);
            }
        }
        if (LangUtils.isEmpty(this.acl)) {
            this.acl = this.canReadManifest && !LangUtils.isEmpty(XmlUtils.getTextFromDocument(this.manifestDocument, KERNEL_XPATH)) ? UNIX_ACL : WINDOWS_ACL;
            if (this.verbose) {
                this.out.println("Guessing ACL from manifest: " + this.acl);
            }
        }
        if (this.canReadManifest) {
            this.migrateManifest(parts);
            this.uploadManifest(dstConn);
        }
        for (int retry = 0; retry < 5 && !parts.isEmpty(); ++retry) {
            if (this.verbose && retry > 0) {
                this.out.println("Retrying " + parts.size() + " parts.");
            }
            ArrayList<String[]> failedParts = new ArrayList<String[]>();
            for (String[] stringArray : parts) {
                if (this.copyPart(dstConn, this.sourceBucketName, stringArray[0], stringArray[1], this.acl)) continue;
                failedParts.add(stringArray);
            }
            parts = failedParts;
        }
        if (!parts.isEmpty()) {
            this.out.println("Could not copy the following parts (" + parts.size() + "): ");
            for (String[] stringArray : parts) {
                this.out.println(" - " + stringArray[0]);
            }
            return false;
        }
        String bundleLocation = this.destinationBucketName + "/" + this.manifestName;
        this.out.println("Your new bundle is in S3 at the following location: " + bundleLocation);
        return true;
    }

    protected void migrateManifest(List<String[]> parts) {
        if (this.mapManifest) {
            RegionMapping regionMapping = this.getRegionMapping();
            String documentKernel = XmlUtils.getTextFromDocument(this.manifestDocument, KERNEL_XPATH);
            String documentRamdisk = XmlUtils.getTextFromDocument(this.manifestDocument, RAMDISK_XPATH);
            if (LangUtils.isEmpty(this.kernel) && !LangUtils.isEmpty(documentKernel)) {
                this.kernel = regionMapping.map(documentKernel, this.region);
            }
            if (LangUtils.isEmpty(this.ramdisk) && !LangUtils.isEmpty(documentRamdisk)) {
                this.ramdisk = regionMapping.map(documentRamdisk, this.region);
            }
        }
        if (!LangUtils.isEmpty(this.kernel)) {
            this.manifestAltered = true;
            XmlUtils.setTextInDocument(this.manifestDocument, KERNEL_XPATH, this.kernel);
        }
        if (!LangUtils.isEmpty(this.ramdisk)) {
            this.manifestAltered = true;
            XmlUtils.setTextInDocument(this.manifestDocument, RAMDISK_XPATH, this.ramdisk);
        }
        if (this.manifestAltered) {
            String signature;
            StringBuilder toSign = new StringBuilder().append(XmlUtils.getXmlPartAsString(this.manifestDocument, MACHINE_CONFIG_XPATH)).append(XmlUtils.getXmlPartAsString(this.manifestDocument, IMAGE_XPATH));
            try {
                signature = CryptoUtils.signSha1(toSign.toString(), this.privateKey);
            }
            catch (Exception e) {
                throw new GeneralError("Error signing the manifest: " + e.getMessage(), e);
            }
            XmlUtils.setTextInDocument(this.manifestDocument, SIGNATURE_XPATH, signature);
        }
    }

    protected RegionMapping getRegionMapping() {
        if (!LangUtils.isEmpty(this.mappingFile)) {
            File mappingFileFile = new File(this.mappingFile);
            if (!mappingFileFile.exists()) {
                throw new RuntimeException("Mapping file does not exist at this path: " + this.mappingFile);
            }
            try {
                return RegionMappingUtils.createRegionMappingFromFile(this.regionMappingFactory, mappingFileFile, "UTF-8");
            }
            catch (IOException e) {
                String msg = "Error reading from mapping file '" + this.mappingFile + "': " + e.getMessage();
                throw new GeneralError(msg, e);
            }
        }
        if (!LangUtils.isEmpty(this.mappingUrl)) {
            try {
                return RegionMappingUtils.createRegionMappingFromUrl(this.regionMappingFactory, this.mappingUrl);
            }
            catch (IOException e) {
                String msg = "Error reading from mapping file '" + this.mappingFile + "': " + e.getMessage();
                throw new GeneralError(msg, e);
            }
        }
        throw new RuntimeException("Need either mapping url or mapping file.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadManifest(S3Connection conn) {
        if (this.manifestName == null || this.manifestName.length() == 0) {
            throw new RuntimeException("Need either manifest file path or manifest name");
        }
        this.out.print("Downloading manifest " + this.manifestName + " from " + this.sourceBucketName + "...");
        ByteArrayOutputStream writer = new ByteArrayOutputStream(12288);
        try {
            S3Connection.OperationResult result = conn.get(this.manifestName, writer);
            this.out.println(" " + (Object)((Object)result.getOperationCode()));
            if (result.getOperationCode() != S3Connection.OperationCode.OK) {
                throw new GeneralError("Could not download manifest " + this.manifestName + (result.getMsg() == null ? "." : ": " + result.getMsg()));
            }
            this.originalManifestData = writer.toByteArray();
            this.manifestData = this.originalManifestData;
        }
        finally {
            try {
                writer.close();
            }
            catch (IOException ignored) {}
        }
        this.isManifestEncrypted = MigrateBundle.isDataEncrypted(this.manifestData);
        if (this.isManifestEncrypted) {
            try {
                if (this.verbose) {
                    this.out.println("Manifest seems to be encrypted. Trying to decrypt it.");
                }
                this.manifestData = CryptoUtils.decryptData(this.manifestData, this.privateKey);
                if (this.verbose) {
                    this.out.println("Manifest decrypted.");
                }
            }
            catch (Exception ignored) {
                if (this.verbose) {
                    this.out.println("Decrypting failed. Hence, assume we cannot read the manifest.");
                }
                this.canReadManifest = false;
            }
        }
    }

    protected void updatePartNames(List<String[]> parts) {
        NodeList nodeList = this.manifestDocument.getElementsByTagName("part");
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            Node partNode = nodeList.item(i);
            if (partNode.getNodeType() != 1) {
                throw new GeneralError("part node is not an element");
            }
            String indexStr = partNode.getAttributes().getNamedItem("index").getTextContent();
            Integer index = Integer.valueOf(indexStr);
            String sourcePartName = ((Element)partNode).getElementsByTagName("filename").item(0).getTextContent();
            if (!parts.get(index)[0].equals(sourcePartName)) continue;
            ((Element)partNode).getElementsByTagName("filename").item(0).setTextContent(parts.get(index)[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void uploadManifest(S3Connection dstConn) throws FileNotFoundException, IOException {
        String manifestName = this.manifestName;
        if (this.verbose) {
            this.out.print("Uploading " + (this.manifestAltered ? "modified" : "unmodified") + " manifest " + manifestName + "...");
        }
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("x-amz-acl", this.acl);
        ByteArrayInputStream inputStream = this.manifestAltered ? new ByteArrayInputStream(XmlUtils.toXmlString(this.manifestDocument, false).getBytes("UTF-8")) : new ByteArrayInputStream(this.originalManifestData);
        try {
            S3Connection.OperationResult result = dstConn.upload(manifestName, "text/xml", inputStream, options);
            if (this.verbose) {
                this.out.println(" " + (Object)((Object)result.getOperationCode()));
            }
            if (S3Connection.OperationCode.OK != result.getOperationCode()) {
                this.out.println("Uploading manifest failed: " + LangUtils.defaultStr(result.getMsg(), result.getOperationCode().toString()));
            }
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    protected boolean copyPart(S3Connection dstConn, String sourceBucketName, String sourcePart, String dstPart, String acl) {
        String manifestS3Prefix = "";
        if (this.manifestName.indexOf("/") > -1) {
            manifestS3Prefix = this.manifestName.replaceFirst("/[^/]*?$", "") + "/";
        }
        String source = "/" + sourceBucketName + "/" + manifestS3Prefix + sourcePart;
        if (this.verbose) {
            this.out.print("Copying '" + sourcePart + "' with acl " + acl + " from '" + source + "' to '" + this.destinationBucketName + "/" + dstPart + "'...");
        } else {
            this.out.print("Copying '" + sourcePart + "' to '" + this.destinationBucketName + "/" + dstPart + "'...");
        }
        HashMap<String, String> options = new HashMap<String, String>();
        if (acl != null && acl.length() > 0) {
            options.put("x-amz-acl", acl);
        }
        S3Connection.OperationResult result = dstConn.copy(dstPart, source, options);
        this.out.println(" " + (Object)((Object)result.getOperationCode()));
        if (S3Connection.OperationCode.OK == result.getOperationCode()) {
            return true;
        }
        this.out.println("Copying part " + source + " failed: " + (result.getMsg() == null ? result.getOperationCode() : result.getMsg()));
        return false;
    }

    protected void validateParameters() {
        this.ensureParameterNotEmpty("manifest", this.manifestName, DESTINATION_BUCKET, this.destinationBucketName, SOURCE_BUCKET, this.sourceBucketName);
        if (this.location != null && !this.location.equals("EU") && !this.location.equals("US")) {
            throw new InvalidArgument(LOCATION, this.location);
        }
    }

    protected void ensureParameterNotEmpty(String ... args) {
        if (args == null || args.length % 2 != 0) {
            throw new RuntimeException("Invalid argument args");
        }
        ArrayList<String> missingArgs = new ArrayList<String>(args.length / 2);
        for (int i = 0; i < args.length; i += 2) {
            if (!LangUtils.isEmpty(args[i + 1])) continue;
            missingArgs.add(args[i]);
        }
        if (!missingArgs.isEmpty()) {
            throw new MissingAtLeastOneArgument(missingArgs.toArray(new String[missingArgs.size()]));
        }
    }

    protected String guessLocation() {
        String region = !LangUtils.isEmpty(this.region) ? this.region : EccUtils.getRegionFromUrl(this.getOptionValue("url"));
        if (region == null || region.length() < 2) {
            throw new GeneralError("Cannot guess location with this region: " + region);
        }
        return region.substring(0, 2).toUpperCase();
    }

    protected static boolean isDataEncrypted(byte[] data) {
        String start;
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("data must not be empty");
        }
        try {
            start = new String(data, 0, Math.min(80, data.length), "ISO8859_1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Character encoding problem", e);
        }
        return MANIFEST_START_PATTERN.matcher(start).matches();
    }

    protected static String getPrefixFromManifestName(String manifestName) {
        Pattern pattern = Pattern.compile("(.*?)(\\.manifest)?(\\.xml)?", 2);
        Matcher matcher = pattern.matcher(manifestName);
        if (!matcher.matches()) {
            throw new RuntimeException("Regular expression must always match. Please fix regular expression.");
        }
        return matcher.group(1);
    }

    protected List<String[]> getPartNames(Document document) {
        NodeList nodeList = document.getElementsByTagName("part");
        int len = nodeList.getLength();
        TreeMap<Integer, String[]> partNames = new TreeMap<Integer, String[]>();
        for (int i = 0; i < len; ++i) {
            String sourcePartName;
            Node partNode = nodeList.item(i);
            if (partNode.getNodeType() != 1) {
                throw new GeneralError("part node is not an element");
            }
            String indexStr = partNode.getAttributes().getNamedItem("index").getTextContent();
            Integer index = Integer.valueOf(indexStr);
            if (partNames.containsKey(index)) {
                throw new GeneralError("Found more than one part node with index " + index);
            }
            String dstPartName = sourcePartName = ((Element)partNode).getElementsByTagName("filename").item(0).getTextContent();
            partNames.put(index, new String[]{sourcePartName, dstPartName});
        }
        return new ArrayList<String[]>(partNames.values());
    }

    public static void main(String[] args) {
        new MigrateBundle(args).invoke();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

