/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.AttachmentDescription;
import com.amazon.aes.webservices.client.AvailabilityZoneDescription;
import com.amazon.aes.webservices.client.BundleInstanceTask;
import com.amazon.aes.webservices.client.ConsoleOutput;
import com.amazon.aes.webservices.client.ImageAttribute;
import com.amazon.aes.webservices.client.ImageDescription;
import com.amazon.aes.webservices.client.ImageListAttribute;
import com.amazon.aes.webservices.client.ImageListAttributeItem;
import com.amazon.aes.webservices.client.ImageMapAttribute;
import com.amazon.aes.webservices.client.ImageMapAttributeItem;
import com.amazon.aes.webservices.client.ImageValueAttribute;
import com.amazon.aes.webservices.client.MonitorInstance;
import com.amazon.aes.webservices.client.RegionDescription;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.ReservationDescription;
import com.amazon.aes.webservices.client.ReservedInstancesDescription;
import com.amazon.aes.webservices.client.ReservedInstancesOfferingDescription;
import com.amazon.aes.webservices.client.SecurityGroupDescription;
import com.amazon.aes.webservices.client.SnapshotDescription;
import com.amazon.aes.webservices.client.TerminatingInstanceDescription;
import com.amazon.aes.webservices.client.VolumeDescription;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Outputter {
    private static String FIELDSEP = "\t";
    private static String NULLFIELD = "(nil)";
    private static String EMPTY_STRING = "";
    private static int SECONDS_IN_YEAR = 31536000;
    private static int SECONDS_IN_MONTH = 2592000;
    private boolean showHeaders;
    private boolean showDebug;
    private boolean showNullFields;
    private boolean showRequestId;

    public static String getDurationString(long duration) {
        long years = duration / (long)SECONDS_IN_YEAR;
        long months = duration % (long)SECONDS_IN_YEAR / (long)SECONDS_IN_MONTH;
        String durationString = "";
        if (years > 0L) {
            durationString = durationString + years + "y ";
        }
        if (months > 0L) {
            durationString = durationString + months + "m ";
        }
        return durationString;
    }

    public Outputter(boolean showHeaders, boolean showDebug, boolean showNullFields, boolean showRequestId) {
        this.showHeaders = showHeaders;
        this.showDebug = showDebug;
        this.showNullFields = showNullFields;
        this.showRequestId = showRequestId;
    }

    private String toPaddedHexString(int v) {
        String s = Integer.toHexString(v);
        while (s.length() < 4) {
            s = '0' + s;
        }
        return s;
    }

    private String toDisplayState(String name, int code) {
        String stateName = name;
        if (this.showDebug) {
            stateName = stateName + "(" + this.toPaddedHexString(code) + ")";
        }
        return stateName;
    }

    public void output(PrintStream stream, String productCode, String instanceId, boolean confirmed, String ownerId) {
        this.printHeaders(stream, "ProductCode", "InstanceID", "Confirmed", "OwnerID");
        stream.println(this.join(productCode, instanceId, Boolean.toString(confirmed), ownerId));
    }

    public void output(PrintStream stream, ReservationDescription.Instance inst) {
        String ali;
        this.printHeaders(stream, "Type", "InstanceID", "ImageID", "PublicDNSName", "PrivateDNSName", "State", "KeyPair", "AmiLaunchIndex", "ProductCodes", "InstanceType", "LaunchTime", "AvailabilityZone", "KernelId", "RamdiskId", "Monitoring");
        String keyName = inst.keyName;
        if (keyName == null) {
            keyName = "";
        }
        if ((ali = inst.amiLaunchIndex) == null) {
            ali = "";
        }
        stream.println(this.join("INSTANCE", inst.instanceId, inst.imageId, inst.dnsName, inst.privateDnsName, this.toDisplayState(inst.state, inst.stateCode), keyName, ali, this.joinCollection(inst.productCodes, ","), inst.instanceType, this.iso8601(inst.launchTime), inst.placement.availabilityZone, inst.kernelId, inst.ramdiskId, inst.platform, "monitoring-" + inst.monitoring.getState()));
    }

    public String joinCollection(Collection<String> strs, String sep) {
        StringBuilder jstr = new StringBuilder();
        if (strs != null) {
            for (String str : strs) {
                if (jstr.length() != 0) {
                    jstr.append(sep);
                }
                jstr.append(str);
            }
        }
        return jstr.toString();
    }

    public void output(PrintStream stream, ReservationDescription res) {
        this.printHeaders(stream, "Type", "ReservationID", "Owner", "Groups", "Platform");
        StringBuffer groups = new StringBuffer();
        for (String i : res.groups) {
            groups.append(",");
            groups.append(i);
        }
        if (groups.length() > 0) {
            groups.deleteCharAt(0);
        }
        stream.println(this.join("RESERVATION", res.resId, res.owner, groups));
        for (String i : res.instances) {
            this.output(System.out, (ReservationDescription.Instance)i);
        }
    }

    public void output(PrintStream stream, ImageDescription img) {
        this.printHeaders(stream, "Type", "ImageID", "Location", "Owner", "State", "Accessibility", "ProductCodes", "Architecture", "ImageType", "KernelId", "RamdiskId", "Platform");
        stream.println(this.join("IMAGE", img.imageId, img.imageLocation, img.imageOwnerId, img.imageState, img.isPublic ? "public" : "private", this.joinCollection(img.productCodes, ","), img.architecture, img.imageType, img.kernelId, img.ramdiskId, img.platform));
    }

    public void outputImageId(PrintStream stream, String imageId) {
        this.printHeaders(stream, "Type", "ImageID");
        stream.println(this.join("IMAGE", imageId));
    }

    public void outputGroup(PrintStream stream, String name, String description) {
        this.printHeaders(stream, "Type", "Name", description);
        stream.println(this.join("GROUP", name, description));
    }

    public void outputGroup(PrintStream stream, String name) {
        this.printHeaders(stream, "Type", "Name");
        stream.println(this.join("GROUP", name));
    }

    public void output(PrintStream stream, TerminatingInstanceDescription inst) {
        this.printHeaders(stream, "Type", "Name");
        String prevState = this.toDisplayState(inst.prevState, inst.prevStateCode);
        String shutdownState = this.toDisplayState(inst.shutdownState, inst.shutdownStateCode);
        stream.println(this.join("INSTANCE", inst.instanceId, prevState, shutdownState));
    }

    public void output(PrintStream stream, boolean b) {
        stream.print(b);
    }

    public void output(PrintStream stream, String s) {
        stream.print(s);
    }

    protected void output(PrintStream stream, String uid, String groupName, SecurityGroupDescription.IpPermission perm) {
        if (!perm.cidrIps.isEmpty()) {
            for (String cidr : perm.cidrIps) {
                this.outputCIDRSource(stream, uid, groupName, perm);
                stream.println(this.join("", "CIDR", cidr));
            }
        }
        if (!perm.uid_group_pairs.isEmpty()) {
            for (String[] group : perm.uid_group_pairs) {
                this.outputGroupSource(stream, uid, groupName, perm);
                stream.println(this.join("", "USER", group[0], "GRPNAME", group[1]));
            }
        }
    }

    private void outputEntireGroupSource(PrintStream stream, String uid, String groupName) {
        stream.print(this.join("PERMISSION", uid, groupName, "ALLOWS", "all", "", "", "FROM"));
    }

    private void outputGroupSource(PrintStream stream, String uid, String groupName, SecurityGroupDescription.IpPermission perm) {
        stream.print(this.join("PERMISSION", uid, groupName, "ALLOWS", perm.protocol, perm.fromPort, perm.toPort, "FROM"));
    }

    private void outputCIDRSource(PrintStream stream, String uid, String groupName, SecurityGroupDescription.IpPermission perm) {
        stream.print(this.join("PERMISSION", uid, groupName, "ALLOWS", perm.protocol, perm.fromPort, perm.toPort, "FROM"));
    }

    public void output(PrintStream stream, SecurityGroupDescription grp) {
        int bitmap;
        String key;
        this.printHeaders(stream, "GROUP", "Owner", "Name", "Description");
        stream.println(this.join("GROUP", grp.owner, grp.name, grp.desc));
        HashMap<String, Integer> permMap = new HashMap<String, Integer>();
        for (SecurityGroupDescription.IpPermission p : grp.perms) {
            for (String[] pair : p.uid_group_pairs) {
                key = pair[0] + ":" + pair[1];
                bitmap = 0;
                if (permMap.containsKey(key)) {
                    bitmap = (Integer)permMap.get(key);
                }
                if (p.fromPort == 0 && p.toPort == 65535) {
                    bitmap = p.protocol.equalsIgnoreCase("tcp") ? (bitmap |= 1) : (bitmap |= 2);
                }
                if (p.fromPort == -1 && p.toPort == -1 && p.protocol.equalsIgnoreCase("icmp")) {
                    bitmap |= 4;
                }
                permMap.put(key, bitmap);
            }
        }
        for (SecurityGroupDescription.IpPermission p : grp.perms) {
            block7: for (String[] pair : p.uid_group_pairs) {
                key = pair[0] + ":" + pair[1];
                bitmap = (Integer)permMap.get(key);
                switch (bitmap) {
                    case -1: {
                        continue block7;
                    }
                    case 7: {
                        this.outputEntireGroupSource(stream, grp.owner, grp.name);
                        stream.println(this.join("", "USER", pair[0], "GRPNAME", pair[1]));
                        permMap.put(key, -1);
                        continue block7;
                    }
                }
                this.outputGroupSource(stream, grp.owner, grp.name, p);
                stream.println(this.join("", "USER", pair[0], "GRPNAME", pair[1]));
            }
            if (p.cidrIps.isEmpty()) continue;
            for (String cidr : p.cidrIps) {
                this.outputCIDRSource(stream, grp.owner, grp.name, p);
                stream.println(this.join("", "CIDR", cidr));
            }
        }
    }

    public void output(PrintStream stream, AvailabilityZoneDescription zone) {
        this.printHeaders(stream, "AVAILABILITYZONE", "Name", "State", "Region");
        stream.println(this.join("AVAILABILITYZONE", zone.name, zone.state, zone.region));
    }

    public void output(PrintStream stream, RegionDescription region) {
        this.printHeaders(stream, "REGION", "Name", "Endpoint");
        stream.println(this.join("REGION", region.name, region.endpoint));
    }

    public void outputAttachment(PrintStream stream, String volumeId) {
        this.printHeaders(stream, "Type", "VolumeId");
        stream.println(this.join("ATTACHMENT", volumeId));
    }

    public void output(PrintStream stream, AttachmentDescription ad) {
        this.printHeaders(stream, "VolumeId", "InstanceId", "Device", "Status", "AttachTime");
        stream.println(this.join("ATTACHMENT", ad.volumeId, ad.instanceId, ad.device, ad.status, this.iso8601(ad.attachTime)));
    }

    public void outputVolume(PrintStream stream, String volumeId) {
        this.printHeaders(stream, "Type", "VolumeId");
        stream.println(this.join("VOLUME", volumeId));
    }

    public void output(PrintStream stream, VolumeDescription vd) {
        this.printHeaders(stream, "VolumeId", "Size", "SnapshotId", "AvailabilityZone", "Status", "CreateTime");
        stream.println(this.join("VOLUME", vd.volumeId, vd.size, vd.snapshotId, vd.availabilityZone, vd.status, this.iso8601(vd.createTime)));
        if (vd.attachments != null && !vd.attachments.isEmpty()) {
            for (AttachmentDescription ad : vd.attachments) {
                this.output(stream, ad);
            }
        }
    }

    public void output(PrintStream stream, ReservedInstancesOfferingDescription riod) {
        this.printHeaders(stream, "Type", "ReservedInstancesOfferingId", "AvailabilityZone", "InstanceType", "Duration", "FixedPrice", "UsagePrice", "ProductDescription");
        stream.println(this.join("OFFERING", riod.reservedInstancesOfferingId, riod.availabilityZone, riod.instanceType, Outputter.getDurationString(riod.duration), riod.fixedPrice, riod.usagePrice, riod.productDescription));
    }

    public void output(PrintStream stream, ReservedInstancesDescription rid) {
        this.printHeaders(stream, "Type", "ReservedInstancesId", "AvailabilityZone", "InstanceType", "ProductDescription", "Duration", "FixedPrice", "UsagePrice", "InstanceCount", "Start", "State");
        stream.println(this.join("RESERVEDINSTANCES", rid.reservedInstancesId, rid.availabilityZone, rid.instanceType, rid.productDescription, Outputter.getDurationString(rid.duration), rid.fixedPrice, rid.usagePrice, rid.instanceCount, this.iso8601(rid.start), rid.state));
    }

    public void outputReservedInstancesId(PrintStream stream, String reservedInstancesId) {
        this.printHeaders(stream, "Type", "ReservedInstancesId");
        stream.println(this.join("RESERVEDINSTANCES", reservedInstancesId));
    }

    public void outputSnapshot(PrintStream stream, String snapshotId) {
        this.printHeaders(stream, "Type", "SnapshotId");
        stream.println(this.join("SNAPSHOT", snapshotId));
    }

    public void output(PrintStream stream, SnapshotDescription sd) {
        this.printHeaders(stream, "SnapshotId", "VolumeId", "Status", "StartTime", "Progress");
        stream.println(this.join("SNAPSHOT", sd.snapshotId, sd.volumeId, sd.status, this.iso8601(sd.startTime), sd.progress));
    }

    public void output(PrintStream stream, String imageId, ImageAttribute attribute) {
        this.printHeaders(stream, "Attribute", "ImageID", "ItemType", "ItemValue");
        if (attribute instanceof ImageMapAttribute) {
            ImageMapAttribute mapAttribute = (ImageMapAttribute)attribute;
            for (ImageMapAttributeItem item : mapAttribute.items) {
                stream.println(this.join(attribute.type.name(), imageId, item.type.name(), item.key + ": " + item.value));
            }
        } else if (attribute instanceof ImageListAttribute) {
            ImageListAttribute listAttribute = (ImageListAttribute)attribute;
            for (ImageListAttributeItem item : listAttribute.items) {
                stream.println(this.join(attribute.type.name(), imageId, item.type.name(), item.value));
            }
        } else if (attribute instanceof ImageValueAttribute) {
            ImageValueAttribute valueAttribute = (ImageValueAttribute)attribute;
            if (valueAttribute.value != null) {
                stream.println(this.join(attribute.type.name(), imageId, "", valueAttribute.value));
            }
        }
    }

    public void output(PrintStream stream, String imageId, ImageAttribute attribute, ImageListAttribute.ImageListAttributeOperationType operation) {
        this.printHeaders(stream, "Attribute", "ImageID", "Operation", "ItemType", "ItemValue");
        if (attribute instanceof ImageMapAttribute) {
            ImageMapAttribute mapAttribute = (ImageMapAttribute)attribute;
            for (ImageMapAttributeItem item : mapAttribute.items) {
                String operationName = operation != null ? operation.name().toUpperCase() : "SET";
                stream.println(this.join(attribute.type.name(), imageId, operationName, item.type.name(), item.key + ": " + item.value));
            }
        } else if (attribute instanceof ImageListAttribute) {
            ImageListAttribute listAttribute = (ImageListAttribute)attribute;
            for (ImageListAttributeItem item : listAttribute.items) {
                String operationName = operation != null ? operation.name().toUpperCase() : "";
                stream.println(this.join(attribute.type.name(), imageId, operationName, item.type.name(), item.value));
            }
        } else if (attribute instanceof ImageValueAttribute) {
            ImageValueAttribute valueAttribute = (ImageValueAttribute)attribute;
            stream.println(this.join(attribute.type.name(), imageId, "SET", "", valueAttribute.value != null ? valueAttribute.value : ""));
        }
    }

    public void output(PrintStream stream, String imageId, ImageAttribute.ImageAttributeType attributeType) {
        this.printHeaders(stream, "Attribute", "ImageID", "Operation");
        stream.println(this.join(attributeType.name(), imageId, "RESET"));
    }

    public void output(PrintStream stream, MonitorInstance inst) {
        this.printHeaders(stream, "InstanceId", "State");
        stream.println(this.join(inst.getInstanceId(), "monitoring-" + inst.getMonitoring().getState()));
    }

    public void outputConsoleOutput(PrintStream stream, ConsoleOutput co, boolean rawOutput) {
        stream.println(co.instanceId);
        stream.println(this.iso8601(co.timestamp));
        stream.println(rawOutput ? new String(co.output) : this.escapeConsoleOutput(co.output));
    }

    public String iso8601(Calendar cal) {
        Formatter fmt = new Formatter(Locale.US);
        fmt.format("%1$tFT%1$tH:%1$tM:%1$tS%1$tz", cal);
        return fmt.toString();
    }

    public String escapeConsoleOutput(String output) {
        String lineSep = System.getProperty("line.separator");
        StringBuilder sb = new StringBuilder();
        char prev = '\u0000';
        int len = output.length();
        for (int i = 0; i < len; ++i) {
            char c = output.charAt(i);
            if (c != '\u001b' && (c != '\n' || prev != '\n')) {
                sb.append(c != '\n' ? new Character(c).toString() : lineSep);
            }
            prev = c;
        }
        return sb.toString();
    }

    public void outputKeyPair(PrintStream stream, String keyName, String keyFP) {
        this.outputKeyPair(stream, keyName, keyFP, null);
    }

    public void outputKeyPair(PrintStream stream, String keyName, String keyFP, String keyMaterial) {
        this.printHeaders(stream, "KeyPair", "Fingerprint");
        stream.println(this.join("KEYPAIR", keyName, keyFP));
        if (keyMaterial != null) {
            stream.println(keyMaterial);
        }
    }

    public void outputKeyID(PrintStream stream, String keyName) {
        this.printHeaders(stream, "KeyPair");
        stream.println(this.join("KEYPAIR", keyName));
    }

    public void output(PrintStream stream, BundleInstanceTask task) {
        this.printHeaders(stream, "Type", "Bundle", "Instance", "Bucket", "Prefix", "StartTime", "UpdateTime", "State");
        stream.println(this.join("BUNDLE", task.bundleId, task.instanceId, task.bucket, task.prefix, this.iso8601(task.startTime), this.iso8601(task.updateTime), task.state, task.progress, task.errorCode, task.errorMessage));
    }

    public void outputAddress(PrintStream stream, String publicIp, String instanceId) {
        this.printHeaders(stream, "Type", "Address", "Instance");
        stream.println(this.join("ADDRESS", publicIp, instanceId));
    }

    public void printRequestId(PrintStream stream, RequestResult result) {
        if (result != null && this.showRequestId) {
            stream.println(this.join("REQUEST ID", result.getRequestId()));
        }
    }

    private void printHeaders(PrintStream stream, Object ... values) {
        if (this.showHeaders) {
            stream.println(this.join(values));
            this.showHeaders = false;
        }
    }

    private String join(Object ... values) {
        StringBuffer sb = new StringBuffer(this.stringValue(values[0]));
        for (int i = 1; i < values.length; ++i) {
            sb.append(FIELDSEP);
            sb.append(this.stringValue(values[i]));
        }
        return sb.toString();
    }

    private String stringValue(Object value) {
        if (value == null || value.toString().length() == 0) {
            if (this.showNullFields) {
                return NULLFIELD;
            }
            return EMPTY_STRING;
        }
        return value.toString();
    }
}

