/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.DhcpOptionsDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.List;
import org.apache.commons.cli.Options;

public class DescribeDhcpOptions
extends BaseCmd {
    public DescribeDhcpOptions(String[] args) {
        super("ec2ddopt", "ec2-describe-dhcp-options");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    protected String getOptionString() {
        return "[ DHCP_OPTIONS ... ]";
    }

    private Options getOptions() {
        return new Options();
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Gives you information about one or more sets of DHCP options. The");
        System.out.println("     DHCP_OPTIONS parameters, if specified, are the IDs of the DHCP options");
        System.out.println("     to describe.");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        RequestResultPair rsp = jec2.describeDhcpOptions(this.getNonOptions());
        for (DhcpOptionsDescription dhcpOptions : (List)rsp.getResponse()) {
            out.output(System.out, dhcpOptions);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    public static void main(String[] args) {
        new DescribeDhcpOptions(args).invoke();
    }
}

