/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.ConversionTaskDescription;
import com.amazon.aes.webservices.client.ImportVolumeConversionTask;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.GeneralError;
import com.amazon.aes.webservices.client.vmconversion.Importer;
import com.amazon.aes.webservices.client.vmconversion.InternalException;
import com.amazon.aes.webservices.client.vmconversion.ManifestFactory;
import com.amazon.aes.webservices.client.vmconversion.VerificationException;
import com.amazon.aes.webservices.client.vmconversionschema.Manifest;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.ProviderCredentials;

public abstract class Uploadable
extends BaseCmd {
    public static final int DEFAULT_PART_SIZE = 10;
    public static final long ONE_MB = 0x100000L;
    public static final String DEFAULT_USER_THREADS = "20";
    public static final String USER_THREADS = "user-threads";
    public static final String USER_THREADS_ARG = "THREADS";
    public static final String[] USER_THREADS_DESC = new String[]{"Maximum number of threads to concurrently upload the file with. Defaults to ", "20 threads. [OPTIONAL]"};
    public static final int DEFAULT_EXPIRATION = 30;
    public static final String EXPIRES_ARG = "DAYS";
    public static final String[] EXPIRES_DESC = new String[]{"Validity period for the signed S3 URLS that allow EC2 to access your file.", "Defaults to 30 days. [OPTIONAL]"};
    protected String s3AccessId;
    protected String s3SecretKey;
    protected File imageFile;
    protected URL manifestUrl;
    protected S3Service s3Service;
    protected String userThreads;
    protected int partSize;
    protected int expires;
    protected boolean verifyFormat;
    protected boolean dryRun;
    protected ConversionTaskDescription task;

    public Uploadable(String short_form, String long_form) {
        super(short_form, long_form);
    }

    public Uploadable(String short_form, String[] long_form) {
        super(short_form, long_form);
    }

    protected static void populateS3ProxyProperties(Jets3tProperties props, String ec2URL, boolean verboseSet) {
        try {
            String proxyHost = null;
            String proxyPort = "8080";
            URL url = new URL(ec2URL);
            if (url.getProtocol().equalsIgnoreCase("https")) {
                proxyHost = System.getProperty("https.proxyHost", proxyHost);
                proxyPort = System.getProperty("https.proxyPort", proxyPort);
            } else {
                proxyHost = System.getProperty("http.proxyHost", proxyHost);
                proxyPort = System.getProperty("http.proxyPort", proxyPort);
            }
            if (proxyHost != null) {
                if (verboseSet) {
                    System.out.println("S3: Using proxy [" + proxyHost + ":" + proxyPort + "]");
                }
                props.setProperty("httpclient.proxy-autodetect", "false");
                props.setProperty("httpclient.proxy-host", proxyHost);
                props.setProperty("httpclient.proxy-port", proxyPort);
                String proxyUser = System.getProperty("http.proxyUser", null);
                String proxyPass = System.getProperty("http.proxyPass", null);
                if (proxyUser != null) {
                    if (verboseSet) {
                        System.out.println("S3: Using proxy credentials [" + proxyUser + "@" + proxyPass + "] for all realms");
                    }
                    props.setProperty("httpclient.proxy-user", proxyUser);
                    props.setProperty("httpclient.proxy-password", proxyPass);
                }
            }
        }
        catch (MalformedURLException e) {
            System.err.println("Malformed URL: '" + ec2URL + "'");
        }
    }

    protected void validateAndSetupS3Access() throws GeneralError {
        this.assertOptionSet("owner-akid");
        this.s3AccessId = this.getOptionValue("owner-akid");
        this.assertOptionSet("owner-sak");
        this.s3SecretKey = this.getOptionValue("owner-sak");
        try {
            Jets3tProperties props = new Jets3tProperties();
            props.setProperty("httpclient.max-connections", this.userThreads);
            props.setProperty("threaded-service.max-thread-count", this.userThreads);
            Uploadable.populateS3ProxyProperties(props, this.getURL(), this.isOptionSet("verbose"));
            this.s3Service = new RestS3Service((ProviderCredentials)new AWSCredentials(this.s3AccessId, this.s3SecretKey), null, null, props);
        }
        catch (S3ServiceException e) {
            throw new GeneralError("Error accessing S3 with the given user credentials. " + e.getMessage());
        }
    }

    protected void validateParameters() throws GeneralError, VerificationException {
        this.verifyFormat = !this.isOptionSet("dont-verify-format");
        this.dryRun = this.isOptionSet("dry-run");
        this.validateAndSetupS3Access();
        this.partSize = 10;
        this.userThreads = this.isOptionSet(USER_THREADS) ? this.getOptionValue(USER_THREADS) : DEFAULT_USER_THREADS;
        this.expires = this.isOptionSet("expires") ? Integer.parseInt(this.getOptionValue("expires")) : 30;
        try {
            String imageFilename = this.getNonOptions()[0];
            this.warnIfTooManyNonOptions();
            this.imageFile = new File(imageFilename);
            if (!this.imageFile.exists()) {
                throw new VerificationException("File " + this.imageFile + " does not exist");
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new VerificationException("Required argument 'disk-image' missing (-h for usage).");
        }
    }

    protected boolean uploadDisk(ImportVolumeConversionTask importTask) throws Exception {
        try {
            this.manifestUrl = new URL(importTask.getImportManifestUrl());
            int volumeSize = importTask.getVolumeSize();
            Long part = (long)this.partSize * 0x100000L;
            String format = importTask.getDiskImageFormat();
            ManifestFactory mf = new ManifestFactory(this.s3Service);
            Manifest manifest = mf.createManifestUnlessExists(this.manifestUrl, this.imageFile, format, (long)volumeSize, part.longValue(), this.expires, this.dryRun);
            if (this.dryRun) {
                return true;
            }
            if (manifest == null) {
                System.err.println("Unexpected error, could not create manifest. ");
                return false;
            }
            String bucketName = ManifestFactory.getBucketName((S3Object)ManifestFactory.getManifestS3Object((URL)this.manifestUrl));
            Importer importer = new Importer(manifest, this.s3Service, bucketName, this.imageFile);
            importer.startOrResumeImport();
            System.out.print("The disk image for " + this.task.getTaskId() + " has been uploaded to Amazon S3\n" + "where it is being converted into an ");
            if (this.task.getTaskType().equals("ImportVolume")) {
                System.out.print("EBS volume");
            } else {
                System.out.print("EC2 instance");
            }
            System.out.print(".  You may monitor the\nprogress of this task by running ec2-describe-conversion-tasks.  When\nthe task is completed, you may use ec2-delete-disk-image to remove the\nimage from S3.\n");
            return true;
        }
        catch (VerificationException e) {
            System.err.println("ERROR: " + e.getMessage());
            return false;
        }
        catch (InternalException e) {
            System.err.println("ERROR: " + e.getMessage());
            return false;
        }
    }

    protected ImportVolumeConversionTask retrieveImportVolumeConversionTask(ConversionTaskDescription task) throws GeneralError {
        ImportVolumeConversionTask importTask = null;
        String tasktype = task.getTaskType();
        if (tasktype.equals("ImportVolume")) {
            importTask = task.getImportVolumeConversionTask();
        } else if (tasktype.equals("ImportInstance")) {
            importTask = (ImportVolumeConversionTask)task.getImportInstanceConversionTask().getVolumes().get(0);
        } else {
            throw new GeneralError("The task ID " + task + " is not a known task type.");
        }
        if (importTask == null) {
            throw new GeneralError("The task ID " + task + " has no details for uploading disk image");
        }
        return importTask;
    }
}

