/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client;

import com.amazon.aes.webservices.client.ActivateLicenseResponse;
import com.amazon.aes.webservices.client.AddressInfo;
import com.amazon.aes.webservices.client.AttachmentDescription;
import com.amazon.aes.webservices.client.AvailabilityZoneDescription;
import com.amazon.aes.webservices.client.BlockDeviceMappingAttribute;
import com.amazon.aes.webservices.client.BlockDeviceMappingDescription;
import com.amazon.aes.webservices.client.BundleInstanceTask;
import com.amazon.aes.webservices.client.CancelSpotInstanceRequestDescription;
import com.amazon.aes.webservices.client.ConfirmProductInstanceDescription;
import com.amazon.aes.webservices.client.ConsoleOutput;
import com.amazon.aes.webservices.client.ConversionTaskDescription;
import com.amazon.aes.webservices.client.CreateVolumePermissionAttribute;
import com.amazon.aes.webservices.client.CustomerGatewayDescription;
import com.amazon.aes.webservices.client.DeactivateLicenseResponse;
import com.amazon.aes.webservices.client.DescribeImageAttributeResult;
import com.amazon.aes.webservices.client.DescribeSnapshotAttributeResult;
import com.amazon.aes.webservices.client.DhcpOptionsDescription;
import com.amazon.aes.webservices.client.EbsSnapshotDescription;
import com.amazon.aes.webservices.client.EbsVolumeDescription;
import com.amazon.aes.webservices.client.ElasticIpAssociationDescription;
import com.amazon.aes.webservices.client.ElasticIpDescription;
import com.amazon.aes.webservices.client.ExportTaskDescription;
import com.amazon.aes.webservices.client.ExportTaskDestinationDescription;
import com.amazon.aes.webservices.client.ExportTaskSourceDescription;
import com.amazon.aes.webservices.client.Filter;
import com.amazon.aes.webservices.client.GroupDescription;
import com.amazon.aes.webservices.client.IamInstanceProfile;
import com.amazon.aes.webservices.client.IamInstanceProfileRequestDescription;
import com.amazon.aes.webservices.client.IcmpTypeCodeDescription;
import com.amazon.aes.webservices.client.ImageAttribute;
import com.amazon.aes.webservices.client.ImageDescription;
import com.amazon.aes.webservices.client.ImageListAttribute;
import com.amazon.aes.webservices.client.ImageListAttributeItem;
import com.amazon.aes.webservices.client.ImageMapAttributeItem;
import com.amazon.aes.webservices.client.ImportInstanceConversionTask;
import com.amazon.aes.webservices.client.ImportInstanceVolumeDetail;
import com.amazon.aes.webservices.client.ImportVolumeConversionTask;
import com.amazon.aes.webservices.client.InstanceAttribute;
import com.amazon.aes.webservices.client.InstanceBlockDeviceMappingDescription;
import com.amazon.aes.webservices.client.InstanceBlockDeviceMappingResponseDescription;
import com.amazon.aes.webservices.client.InstanceLicense;
import com.amazon.aes.webservices.client.InstanceNetworkInterface;
import com.amazon.aes.webservices.client.InstanceNetworkInterfaceAssociationDescription;
import com.amazon.aes.webservices.client.InstanceNetworkInterfaceAttachmentDescription;
import com.amazon.aes.webservices.client.InstancePlacement;
import com.amazon.aes.webservices.client.InstancePrivateIpAddressResponseDescription;
import com.amazon.aes.webservices.client.InstanceStateChangeDescription;
import com.amazon.aes.webservices.client.InternetGatewayAttachmentDescription;
import com.amazon.aes.webservices.client.InternetGatewayDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.Jec2Options;
import com.amazon.aes.webservices.client.KernelAttribute;
import com.amazon.aes.webservices.client.KeyPairInfo;
import com.amazon.aes.webservices.client.LaunchPermissionAttribute;
import com.amazon.aes.webservices.client.LaunchSpecification;
import com.amazon.aes.webservices.client.License;
import com.amazon.aes.webservices.client.ModifyNetworkInterfaceAttributeDescription;
import com.amazon.aes.webservices.client.ModifyVolumeAttributeDescription;
import com.amazon.aes.webservices.client.MonitorInstance;
import com.amazon.aes.webservices.client.NetworkAclAssociationDescription;
import com.amazon.aes.webservices.client.NetworkAclDescription;
import com.amazon.aes.webservices.client.NetworkAclEntryDescription;
import com.amazon.aes.webservices.client.NetworkInterfaceAssociationDescription;
import com.amazon.aes.webservices.client.NetworkInterfaceAttachmentDescription;
import com.amazon.aes.webservices.client.NetworkInterfaceAttachmentRequestDescription;
import com.amazon.aes.webservices.client.NetworkInterfaceAttributeDescription;
import com.amazon.aes.webservices.client.NetworkInterfaceAttributeType;
import com.amazon.aes.webservices.client.NetworkInterfaceDescription;
import com.amazon.aes.webservices.client.PasswordData;
import com.amazon.aes.webservices.client.PlacementDescription;
import com.amazon.aes.webservices.client.PlacementGroupDescription;
import com.amazon.aes.webservices.client.PortRangeDescription;
import com.amazon.aes.webservices.client.PrivateIpAddressDescription;
import com.amazon.aes.webservices.client.ProductCodeDescription;
import com.amazon.aes.webservices.client.ProductCodesAttribute;
import com.amazon.aes.webservices.client.RamdiskAttribute;
import com.amazon.aes.webservices.client.RegionDescription;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.ReservationDescription;
import com.amazon.aes.webservices.client.ReservedInstancesDescription;
import com.amazon.aes.webservices.client.ReservedInstancesOfferingDescription;
import com.amazon.aes.webservices.client.ResourceTagDescription;
import com.amazon.aes.webservices.client.RouteDescription;
import com.amazon.aes.webservices.client.RouteResourceType;
import com.amazon.aes.webservices.client.RouteTableAssociationDescription;
import com.amazon.aes.webservices.client.RouteTableDescription;
import com.amazon.aes.webservices.client.SecurityGroupDescription;
import com.amazon.aes.webservices.client.SnapshotAttribute;
import com.amazon.aes.webservices.client.SnapshotDescription;
import com.amazon.aes.webservices.client.SnapshotListAttribute;
import com.amazon.aes.webservices.client.SnapshotListAttributeItem;
import com.amazon.aes.webservices.client.SpotDatafeedSubscription;
import com.amazon.aes.webservices.client.SpotInstanceRequestDescription;
import com.amazon.aes.webservices.client.SpotPriceHistoryContainer;
import com.amazon.aes.webservices.client.SpotPriceHistoryDescription;
import com.amazon.aes.webservices.client.SubnetDescription;
import com.amazon.aes.webservices.client.TagDescription;
import com.amazon.aes.webservices.client.TagType;
import com.amazon.aes.webservices.client.Tenancy;
import com.amazon.aes.webservices.client.UserIdGroupPair;
import com.amazon.aes.webservices.client.VgwTelemetryDescription;
import com.amazon.aes.webservices.client.VolumeAttributeDescription;
import com.amazon.aes.webservices.client.VolumeAttributeType;
import com.amazon.aes.webservices.client.VolumeDescription;
import com.amazon.aes.webservices.client.VpcDescription;
import com.amazon.aes.webservices.client.VpnConnectionDescription;
import com.amazon.aes.webservices.client.VpnGatewayAttachmentDescription;
import com.amazon.aes.webservices.client.VpnGatewayDescription;
import com.amazon.aes.webservices.client.instanceStatus.Event;
import com.amazon.aes.webservices.client.instanceStatus.InstanceState;
import com.amazon.aes.webservices.client.instanceStatus.InstanceStatus;
import com.amazon.aes.webservices.client.instanceStatus.InstanceStatusContainer;
import com.amazon.aes.webservices.client.instanceStatus.InstanceStatusDescription;
import com.amazon.aes.webservices.client.instanceStatus.InstanceStatusDetail;
import com.amazon.aes.webservices.client.volumeStatus.ActionSet;
import com.amazon.aes.webservices.client.volumeStatus.EventSet;
import com.amazon.aes.webservices.client.volumeStatus.VolumeDetails;
import com.amazon.aes.webservices.client.volumeStatus.VolumeStatus;
import com.amazon.aes.webservices.client.volumeStatus.VolumeStatusContainer;
import com.amazon.aes.webservices.client.volumeStatus.VolumeStatusDescription;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.ActivateLicenseRequest;
import com.amazonaws.services.ec2.model.Address;
import com.amazonaws.services.ec2.model.AllocateAddressRequest;
import com.amazonaws.services.ec2.model.AllocateAddressResult;
import com.amazonaws.services.ec2.model.AssignPrivateIpAddressesRequest;
import com.amazonaws.services.ec2.model.AssociateAddressRequest;
import com.amazonaws.services.ec2.model.AssociateAddressResult;
import com.amazonaws.services.ec2.model.AssociateDhcpOptionsRequest;
import com.amazonaws.services.ec2.model.AssociateRouteTableRequest;
import com.amazonaws.services.ec2.model.AssociateRouteTableResult;
import com.amazonaws.services.ec2.model.AttachInternetGatewayRequest;
import com.amazonaws.services.ec2.model.AttachNetworkInterfaceRequest;
import com.amazonaws.services.ec2.model.AttachNetworkInterfaceResult;
import com.amazonaws.services.ec2.model.AttachVolumeRequest;
import com.amazonaws.services.ec2.model.AttachVolumeResult;
import com.amazonaws.services.ec2.model.AttachVpnGatewayRequest;
import com.amazonaws.services.ec2.model.AttachVpnGatewayResult;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.AvailabilityZone;
import com.amazonaws.services.ec2.model.AvailabilityZoneMessage;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.BundleInstanceRequest;
import com.amazonaws.services.ec2.model.BundleInstanceResult;
import com.amazonaws.services.ec2.model.BundleTask;
import com.amazonaws.services.ec2.model.CancelBundleTaskRequest;
import com.amazonaws.services.ec2.model.CancelBundleTaskResult;
import com.amazonaws.services.ec2.model.CancelConversionTaskRequest;
import com.amazonaws.services.ec2.model.CancelExportTaskRequest;
import com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsRequest;
import com.amazonaws.services.ec2.model.CancelSpotInstanceRequestsResult;
import com.amazonaws.services.ec2.model.CancelledSpotInstanceRequest;
import com.amazonaws.services.ec2.model.ConfirmProductInstanceRequest;
import com.amazonaws.services.ec2.model.ConfirmProductInstanceResult;
import com.amazonaws.services.ec2.model.ConversionTask;
import com.amazonaws.services.ec2.model.CreateCustomerGatewayRequest;
import com.amazonaws.services.ec2.model.CreateCustomerGatewayResult;
import com.amazonaws.services.ec2.model.CreateDhcpOptionsRequest;
import com.amazonaws.services.ec2.model.CreateDhcpOptionsResult;
import com.amazonaws.services.ec2.model.CreateImageRequest;
import com.amazonaws.services.ec2.model.CreateImageResult;
import com.amazonaws.services.ec2.model.CreateInstanceExportTaskRequest;
import com.amazonaws.services.ec2.model.CreateInstanceExportTaskResult;
import com.amazonaws.services.ec2.model.CreateInternetGatewayRequest;
import com.amazonaws.services.ec2.model.CreateInternetGatewayResult;
import com.amazonaws.services.ec2.model.CreateKeyPairRequest;
import com.amazonaws.services.ec2.model.CreateKeyPairResult;
import com.amazonaws.services.ec2.model.CreateNetworkAclEntryRequest;
import com.amazonaws.services.ec2.model.CreateNetworkAclRequest;
import com.amazonaws.services.ec2.model.CreateNetworkAclResult;
import com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest;
import com.amazonaws.services.ec2.model.CreateNetworkInterfaceResult;
import com.amazonaws.services.ec2.model.CreatePlacementGroupRequest;
import com.amazonaws.services.ec2.model.CreateRouteRequest;
import com.amazonaws.services.ec2.model.CreateRouteTableRequest;
import com.amazonaws.services.ec2.model.CreateRouteTableResult;
import com.amazonaws.services.ec2.model.CreateSecurityGroupRequest;
import com.amazonaws.services.ec2.model.CreateSecurityGroupResult;
import com.amazonaws.services.ec2.model.CreateSnapshotRequest;
import com.amazonaws.services.ec2.model.CreateSnapshotResult;
import com.amazonaws.services.ec2.model.CreateSpotDatafeedSubscriptionRequest;
import com.amazonaws.services.ec2.model.CreateSpotDatafeedSubscriptionResult;
import com.amazonaws.services.ec2.model.CreateSubnetRequest;
import com.amazonaws.services.ec2.model.CreateSubnetResult;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.CreateVolumePermission;
import com.amazonaws.services.ec2.model.CreateVolumeRequest;
import com.amazonaws.services.ec2.model.CreateVolumeResult;
import com.amazonaws.services.ec2.model.CreateVpcRequest;
import com.amazonaws.services.ec2.model.CreateVpcResult;
import com.amazonaws.services.ec2.model.CreateVpnConnectionRequest;
import com.amazonaws.services.ec2.model.CreateVpnConnectionResult;
import com.amazonaws.services.ec2.model.CreateVpnGatewayRequest;
import com.amazonaws.services.ec2.model.CreateVpnGatewayResult;
import com.amazonaws.services.ec2.model.CustomerGateway;
import com.amazonaws.services.ec2.model.DeactivateLicenseRequest;
import com.amazonaws.services.ec2.model.DeleteCustomerGatewayRequest;
import com.amazonaws.services.ec2.model.DeleteDhcpOptionsRequest;
import com.amazonaws.services.ec2.model.DeleteInternetGatewayRequest;
import com.amazonaws.services.ec2.model.DeleteKeyPairRequest;
import com.amazonaws.services.ec2.model.DeleteNetworkAclEntryRequest;
import com.amazonaws.services.ec2.model.DeleteNetworkAclRequest;
import com.amazonaws.services.ec2.model.DeleteNetworkInterfaceRequest;
import com.amazonaws.services.ec2.model.DeletePlacementGroupRequest;
import com.amazonaws.services.ec2.model.DeleteRouteRequest;
import com.amazonaws.services.ec2.model.DeleteRouteTableRequest;
import com.amazonaws.services.ec2.model.DeleteSecurityGroupRequest;
import com.amazonaws.services.ec2.model.DeleteSnapshotRequest;
import com.amazonaws.services.ec2.model.DeleteSpotDatafeedSubscriptionRequest;
import com.amazonaws.services.ec2.model.DeleteSubnetRequest;
import com.amazonaws.services.ec2.model.DeleteTagsRequest;
import com.amazonaws.services.ec2.model.DeleteVolumeRequest;
import com.amazonaws.services.ec2.model.DeleteVpcRequest;
import com.amazonaws.services.ec2.model.DeleteVpnConnectionRequest;
import com.amazonaws.services.ec2.model.DeleteVpnGatewayRequest;
import com.amazonaws.services.ec2.model.DeregisterImageRequest;
import com.amazonaws.services.ec2.model.DescribeAddressesRequest;
import com.amazonaws.services.ec2.model.DescribeAddressesResult;
import com.amazonaws.services.ec2.model.DescribeAvailabilityZonesRequest;
import com.amazonaws.services.ec2.model.DescribeAvailabilityZonesResult;
import com.amazonaws.services.ec2.model.DescribeBundleTasksRequest;
import com.amazonaws.services.ec2.model.DescribeBundleTasksResult;
import com.amazonaws.services.ec2.model.DescribeConversionTasksRequest;
import com.amazonaws.services.ec2.model.DescribeConversionTasksResult;
import com.amazonaws.services.ec2.model.DescribeCustomerGatewaysRequest;
import com.amazonaws.services.ec2.model.DescribeCustomerGatewaysResult;
import com.amazonaws.services.ec2.model.DescribeDhcpOptionsRequest;
import com.amazonaws.services.ec2.model.DescribeDhcpOptionsResult;
import com.amazonaws.services.ec2.model.DescribeExportTasksRequest;
import com.amazonaws.services.ec2.model.DescribeExportTasksResult;
import com.amazonaws.services.ec2.model.DescribeImageAttributeRequest;
import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.services.ec2.model.DescribeImagesResult;
import com.amazonaws.services.ec2.model.DescribeInstanceAttributeRequest;
import com.amazonaws.services.ec2.model.DescribeInstanceAttributeResult;
import com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest;
import com.amazonaws.services.ec2.model.DescribeInstanceStatusResult;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.DescribeInternetGatewaysRequest;
import com.amazonaws.services.ec2.model.DescribeInternetGatewaysResult;
import com.amazonaws.services.ec2.model.DescribeKeyPairsRequest;
import com.amazonaws.services.ec2.model.DescribeKeyPairsResult;
import com.amazonaws.services.ec2.model.DescribeLicensesRequest;
import com.amazonaws.services.ec2.model.DescribeLicensesResult;
import com.amazonaws.services.ec2.model.DescribeNetworkAclsRequest;
import com.amazonaws.services.ec2.model.DescribeNetworkAclsResult;
import com.amazonaws.services.ec2.model.DescribeNetworkInterfaceAttributeRequest;
import com.amazonaws.services.ec2.model.DescribeNetworkInterfaceAttributeResult;
import com.amazonaws.services.ec2.model.DescribeNetworkInterfacesRequest;
import com.amazonaws.services.ec2.model.DescribeNetworkInterfacesResult;
import com.amazonaws.services.ec2.model.DescribePlacementGroupsRequest;
import com.amazonaws.services.ec2.model.DescribePlacementGroupsResult;
import com.amazonaws.services.ec2.model.DescribeRegionsRequest;
import com.amazonaws.services.ec2.model.DescribeRegionsResult;
import com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsRequest;
import com.amazonaws.services.ec2.model.DescribeReservedInstancesOfferingsResult;
import com.amazonaws.services.ec2.model.DescribeReservedInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeReservedInstancesResult;
import com.amazonaws.services.ec2.model.DescribeRouteTablesRequest;
import com.amazonaws.services.ec2.model.DescribeRouteTablesResult;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsResult;
import com.amazonaws.services.ec2.model.DescribeSnapshotAttributeRequest;
import com.amazonaws.services.ec2.model.DescribeSnapshotsRequest;
import com.amazonaws.services.ec2.model.DescribeSnapshotsResult;
import com.amazonaws.services.ec2.model.DescribeSpotDatafeedSubscriptionRequest;
import com.amazonaws.services.ec2.model.DescribeSpotDatafeedSubscriptionResult;
import com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import com.amazonaws.services.ec2.model.DescribeSpotInstanceRequestsResult;
import com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryRequest;
import com.amazonaws.services.ec2.model.DescribeSpotPriceHistoryResult;
import com.amazonaws.services.ec2.model.DescribeSubnetsRequest;
import com.amazonaws.services.ec2.model.DescribeSubnetsResult;
import com.amazonaws.services.ec2.model.DescribeTagsRequest;
import com.amazonaws.services.ec2.model.DescribeTagsResult;
import com.amazonaws.services.ec2.model.DescribeVolumeAttributeRequest;
import com.amazonaws.services.ec2.model.DescribeVolumeAttributeResult;
import com.amazonaws.services.ec2.model.DescribeVolumeStatusRequest;
import com.amazonaws.services.ec2.model.DescribeVolumeStatusResult;
import com.amazonaws.services.ec2.model.DescribeVolumesRequest;
import com.amazonaws.services.ec2.model.DescribeVolumesResult;
import com.amazonaws.services.ec2.model.DescribeVpcsRequest;
import com.amazonaws.services.ec2.model.DescribeVpcsResult;
import com.amazonaws.services.ec2.model.DescribeVpnConnectionsRequest;
import com.amazonaws.services.ec2.model.DescribeVpnConnectionsResult;
import com.amazonaws.services.ec2.model.DescribeVpnGatewaysRequest;
import com.amazonaws.services.ec2.model.DescribeVpnGatewaysResult;
import com.amazonaws.services.ec2.model.DetachInternetGatewayRequest;
import com.amazonaws.services.ec2.model.DetachNetworkInterfaceRequest;
import com.amazonaws.services.ec2.model.DetachVolumeRequest;
import com.amazonaws.services.ec2.model.DetachVolumeResult;
import com.amazonaws.services.ec2.model.DetachVpnGatewayRequest;
import com.amazonaws.services.ec2.model.DhcpConfiguration;
import com.amazonaws.services.ec2.model.DhcpOptions;
import com.amazonaws.services.ec2.model.DisassociateAddressRequest;
import com.amazonaws.services.ec2.model.DisassociateRouteTableRequest;
import com.amazonaws.services.ec2.model.DiskImage;
import com.amazonaws.services.ec2.model.DiskImageDescription;
import com.amazonaws.services.ec2.model.DiskImageDetail;
import com.amazonaws.services.ec2.model.DiskImageVolumeDescription;
import com.amazonaws.services.ec2.model.EbsBlockDevice;
import com.amazonaws.services.ec2.model.EbsInstanceBlockDevice;
import com.amazonaws.services.ec2.model.EbsInstanceBlockDeviceSpecification;
import com.amazonaws.services.ec2.model.EnableVolumeIORequest;
import com.amazonaws.services.ec2.model.ExportTaskResponse;
import com.amazonaws.services.ec2.model.ExportToS3Task;
import com.amazonaws.services.ec2.model.ExportToS3TaskResponse;
import com.amazonaws.services.ec2.model.GetConsoleOutputRequest;
import com.amazonaws.services.ec2.model.GetConsoleOutputResult;
import com.amazonaws.services.ec2.model.GetPasswordDataRequest;
import com.amazonaws.services.ec2.model.GetPasswordDataResult;
import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.IamInstanceProfileRequest;
import com.amazonaws.services.ec2.model.IcmpTypeCode;
import com.amazonaws.services.ec2.model.Image;
import com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification;
import com.amazonaws.services.ec2.model.ImportInstanceRequest;
import com.amazonaws.services.ec2.model.ImportInstanceResult;
import com.amazonaws.services.ec2.model.ImportInstanceTaskDetails;
import com.amazonaws.services.ec2.model.ImportInstanceVolumeDetailItem;
import com.amazonaws.services.ec2.model.ImportKeyPairRequest;
import com.amazonaws.services.ec2.model.ImportKeyPairResult;
import com.amazonaws.services.ec2.model.ImportVolumeRequest;
import com.amazonaws.services.ec2.model.ImportVolumeResult;
import com.amazonaws.services.ec2.model.ImportVolumeTaskDetails;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceBlockDeviceMapping;
import com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification;
import com.amazonaws.services.ec2.model.InstanceExportTaskResponse;
import com.amazonaws.services.ec2.model.InstanceLicenseSpecification;
import com.amazonaws.services.ec2.model.InstanceMonitoring;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceAssociation;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceAttachment;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceResponse;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.InstancePrivateIpAddress;
import com.amazonaws.services.ec2.model.InstancePrivateIpAddressResponse;
import com.amazonaws.services.ec2.model.InstanceStateChange;
import com.amazonaws.services.ec2.model.InstanceStatusDetails;
import com.amazonaws.services.ec2.model.InstanceStatusEvent;
import com.amazonaws.services.ec2.model.InstanceStatusSummary;
import com.amazonaws.services.ec2.model.InternetGateway;
import com.amazonaws.services.ec2.model.InternetGatewayAttachment;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.KeyPair;
import com.amazonaws.services.ec2.model.LaunchPermission;
import com.amazonaws.services.ec2.model.LaunchPermissionModifications;
import com.amazonaws.services.ec2.model.LaunchSpecificationResponse;
import com.amazonaws.services.ec2.model.ModifyImageAttributeRequest;
import com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest;
import com.amazonaws.services.ec2.model.ModifyNetworkInterfaceAttributeRequest;
import com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest;
import com.amazonaws.services.ec2.model.ModifyVolumeAttributeRequest;
import com.amazonaws.services.ec2.model.MonitorInstancesRequest;
import com.amazonaws.services.ec2.model.MonitorInstancesResult;
import com.amazonaws.services.ec2.model.Monitoring;
import com.amazonaws.services.ec2.model.MonitoringDetail;
import com.amazonaws.services.ec2.model.NetworkAcl;
import com.amazonaws.services.ec2.model.NetworkAclAssociation;
import com.amazonaws.services.ec2.model.NetworkAclEntry;
import com.amazonaws.services.ec2.model.NetworkInterface;
import com.amazonaws.services.ec2.model.NetworkInterfaceAssociation;
import com.amazonaws.services.ec2.model.NetworkInterfaceAttachment;
import com.amazonaws.services.ec2.model.NetworkInterfaceAttachmentChanges;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.PlacementGroup;
import com.amazonaws.services.ec2.model.PortRange;
import com.amazonaws.services.ec2.model.PrivateIpAddress;
import com.amazonaws.services.ec2.model.ProductCode;
import com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingRequest;
import com.amazonaws.services.ec2.model.PurchaseReservedInstancesOfferingResult;
import com.amazonaws.services.ec2.model.RebootInstancesRequest;
import com.amazonaws.services.ec2.model.Region;
import com.amazonaws.services.ec2.model.RegisterImageRequest;
import com.amazonaws.services.ec2.model.RegisterImageResult;
import com.amazonaws.services.ec2.model.ReleaseAddressRequest;
import com.amazonaws.services.ec2.model.ReplaceNetworkAclAssociationRequest;
import com.amazonaws.services.ec2.model.ReplaceNetworkAclAssociationResult;
import com.amazonaws.services.ec2.model.ReplaceNetworkAclEntryRequest;
import com.amazonaws.services.ec2.model.ReplaceRouteRequest;
import com.amazonaws.services.ec2.model.ReplaceRouteTableAssociationRequest;
import com.amazonaws.services.ec2.model.ReplaceRouteTableAssociationResult;
import com.amazonaws.services.ec2.model.ReportInstanceStatusRequest;
import com.amazonaws.services.ec2.model.RequestSpotInstancesRequest;
import com.amazonaws.services.ec2.model.RequestSpotInstancesResult;
import com.amazonaws.services.ec2.model.Reservation;
import com.amazonaws.services.ec2.model.ReservedInstances;
import com.amazonaws.services.ec2.model.ReservedInstancesOffering;
import com.amazonaws.services.ec2.model.ResetImageAttributeRequest;
import com.amazonaws.services.ec2.model.ResetInstanceAttributeRequest;
import com.amazonaws.services.ec2.model.ResetNetworkInterfaceAttributeRequest;
import com.amazonaws.services.ec2.model.ResetSnapshotAttributeRequest;
import com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.Route;
import com.amazonaws.services.ec2.model.RouteTable;
import com.amazonaws.services.ec2.model.RouteTableAssociation;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.amazonaws.services.ec2.model.S3Storage;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.ec2.model.Snapshot;
import com.amazonaws.services.ec2.model.SpotInstanceRequest;
import com.amazonaws.services.ec2.model.SpotInstanceStateFault;
import com.amazonaws.services.ec2.model.SpotPlacement;
import com.amazonaws.services.ec2.model.SpotPrice;
import com.amazonaws.services.ec2.model.StartInstancesRequest;
import com.amazonaws.services.ec2.model.StartInstancesResult;
import com.amazonaws.services.ec2.model.StateReason;
import com.amazonaws.services.ec2.model.StopInstancesRequest;
import com.amazonaws.services.ec2.model.StopInstancesResult;
import com.amazonaws.services.ec2.model.Storage;
import com.amazonaws.services.ec2.model.Subnet;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.amazonaws.services.ec2.model.TerminateInstancesResult;
import com.amazonaws.services.ec2.model.UnassignPrivateIpAddressesRequest;
import com.amazonaws.services.ec2.model.UnmonitorInstancesRequest;
import com.amazonaws.services.ec2.model.UnmonitorInstancesResult;
import com.amazonaws.services.ec2.model.VgwTelemetry;
import com.amazonaws.services.ec2.model.Volume;
import com.amazonaws.services.ec2.model.VolumeAttachment;
import com.amazonaws.services.ec2.model.VolumeDetail;
import com.amazonaws.services.ec2.model.VolumeStatusAction;
import com.amazonaws.services.ec2.model.VolumeStatusDetails;
import com.amazonaws.services.ec2.model.VolumeStatusEvent;
import com.amazonaws.services.ec2.model.VolumeStatusInfo;
import com.amazonaws.services.ec2.model.VolumeStatusItem;
import com.amazonaws.services.ec2.model.Vpc;
import com.amazonaws.services.ec2.model.VpcAttachment;
import com.amazonaws.services.ec2.model.VpnConnection;
import com.amazonaws.services.ec2.model.VpnGateway;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.codehaus.xfire.util.Base64;

public class Jec2SdkImpl
implements Jec2 {
    public static final String SECURITY_GROUP_ID = "sg-[0-9a-f]{8}";
    private final AmazonEC2 ec2Client;

    public Jec2SdkImpl(String accessKey, String secretKey, String delegationToken, String endpoint, Jec2Options options) {
        this((AWSCredentials)(null == delegationToken ? new BasicAWSCredentials(accessKey, secretKey) : new BasicSessionCredentials(accessKey, secretKey, delegationToken)), endpoint, options);
    }

    public Jec2SdkImpl(AWSCredentials credentials, String endpoint, Jec2Options options) {
        ClientConfiguration configuration = new ClientConfiguration();
        if (null != options) {
            String userAgent;
            Integer requestTimeout;
            Integer connectionTimeout = options.getConnectionTimeoutSeconds();
            if (null != connectionTimeout) {
                configuration.setConnectionTimeout(connectionTimeout * 1000);
            }
            if (null != (requestTimeout = options.getRequestTimeoutSeconds())) {
                configuration.setSocketTimeout(requestTimeout * 1000);
            }
            if (null != (userAgent = options.getUserAgent()) && !"".equals(userAgent)) {
                configuration.setUserAgent(userAgent);
            }
            if (options.isVerbose()) {
                Logger log = LogManager.getLogger((String)"org.apache.http.wire");
                log.setLevel(Level.DEBUG);
            }
        }
        configuration.setMaxErrorRetry(0);
        AmazonEC2Client client = new AmazonEC2Client(credentials, configuration);
        this.ec2Client = client;
        if (null != endpoint && !"".equals(endpoint)) {
            this.ec2Client.setEndpoint(endpoint);
        }
    }

    private <R extends AmazonWebServiceRequest> R prepareRequest(R request) {
        return request;
    }

    @Override
    public RequestResultPair<String> registerImage(String imageLocation) throws Exception {
        RegisterImageRequest request = new RegisterImageRequest(imageLocation);
        RegisterImageResult result = this.getEc2Client().registerImage(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, result.getImageId());
    }

    @Override
    public RequestResultPair<String> registerImage(String imageLocation, String name, String description, String architecture, String kernelId, String ramdiskId, String rootDeviceName, List<BlockDeviceMappingDescription> blockDeviceMappings) throws Exception {
        RegisterImageRequest request = new RegisterImageRequest();
        request.setImageLocation(imageLocation);
        request.setName(name);
        request.setDescription(description);
        request.setArchitecture(architecture);
        request.setKernelId(kernelId);
        request.setRamdiskId(ramdiskId);
        request.setRootDeviceName(rootDeviceName);
        request.setBlockDeviceMappings(this.translateBlockDeviceMappingDescription(blockDeviceMappings));
        RegisterImageResult result = this.getEc2Client().registerImage(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, result.getImageId());
    }

    @Override
    public String deregisterImage(String imageId) throws Exception {
        DeregisterImageRequest request = new DeregisterImageRequest(imageId);
        this.getEc2Client().deregisterImage(this.prepareRequest(request));
        return imageId;
    }

    @Override
    public RequestResultPair<String> createImage(String instanceId, String name, String description, boolean noReboot, List<BlockDeviceMappingDescription> blockDeviceMappings) throws Exception {
        CreateImageRequest request = new CreateImageRequest().withInstanceId(instanceId).withName(name).withDescription(description).withNoReboot(Boolean.valueOf(noReboot)).withBlockDeviceMapping(this.translateBlockDeviceMappingDescription(blockDeviceMappings));
        CreateImageResult result = this.getEc2Client().createImage(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, result.getImageId());
    }

    @Override
    public RequestResultPair<List<ImageDescription>> describeImages(String[] imageIds) throws Exception {
        DescribeImagesRequest request = new DescribeImagesRequest().withImageIds(imageIds);
        DescribeImagesResult result = this.getEc2Client().describeImages(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateImages(result.getImages()));
    }

    @Override
    public RequestResultPair<List<ImageDescription>> describeImages(String[] imageIds, List<Filter> filters) throws Exception {
        DescribeImagesRequest request = new DescribeImagesRequest().withImageIds(imageIds).withFilters(this.translateFilterDescriptions(filters));
        DescribeImagesResult result = this.getEc2Client().describeImages(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateImages(result.getImages()));
    }

    @Override
    public RequestResultPair<List<ImageDescription>> describeImages(String[] imageIds, String[] owners, String[] executableBy) throws Exception {
        DescribeImagesRequest request = new DescribeImagesRequest().withImageIds(imageIds).withExecutableUsers(executableBy).withOwners(owners);
        DescribeImagesResult result = this.getEc2Client().describeImages(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateImages(result.getImages()));
    }

    @Override
    public RequestResultPair<List<ImageDescription>> describeImages(String[] imageIds, String[] owners, String[] executableBy, List<Filter> filters) throws Exception {
        DescribeImagesRequest request = new DescribeImagesRequest().withImageIds(imageIds).withExecutableUsers(executableBy).withOwners(owners).withFilters(this.translateFilterDescriptions(filters));
        DescribeImagesResult result = this.getEc2Client().describeImages(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateImages(result.getImages()));
    }

    @Override
    public RequestResultPair<List<ImageDescription>> describeImages(List<String> imageIds, List<Filter> filters) throws Exception {
        DescribeImagesRequest request = new DescribeImagesRequest().withImageIds(imageIds).withFilters(this.translateFilterDescriptions(filters));
        DescribeImagesResult result = this.getEc2Client().describeImages(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateImages(result.getImages()));
    }

    @Override
    public RequestResultPair<List<ImageDescription>> describeImages(List<String> imageIds, List<String> ownerList, List<String> executableByList, List<Filter> filters) throws Exception {
        DescribeImagesRequest request = new DescribeImagesRequest().withImageIds(imageIds).withExecutableUsers(executableByList).withOwners(ownerList).withFilters(this.translateFilterDescriptions(filters));
        DescribeImagesResult result = this.getEc2Client().describeImages(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateImages(result.getImages()));
    }

    @Override
    public RequestResultPair<InstanceAttribute<?>> describeInstanceAttribute(String instanceId, InstanceAttribute.InstanceAttributeType instanceAttributeType) throws Exception {
        List<Object> value;
        DescribeInstanceAttributeRequest request = new DescribeInstanceAttributeRequest().withInstanceId(instanceId).withAttribute(instanceAttributeType.name());
        DescribeInstanceAttributeResult result = this.getEc2Client().describeInstanceAttribute(this.prepareRequest(request));
        com.amazonaws.services.ec2.model.InstanceAttribute attr = result.getInstanceAttribute();
        switch (instanceAttributeType) {
            case blockDeviceMapping: {
                value = this.translateInstanceBlockDeviceMappings(attr.getBlockDeviceMappings());
                break;
            }
            case disableApiTermination: {
                value = attr.isDisableApiTermination();
                break;
            }
            case sourceDestCheck: 
            case groupSet: {
                throw new RuntimeException("Not implemented yet.");
            }
            case instanceInitiatedShutdownBehavior: {
                value = attr.getInstanceInitiatedShutdownBehavior();
                break;
            }
            case instanceType: {
                value = attr.getInstanceType();
                break;
            }
            case kernel: {
                value = attr.getKernelId();
                break;
            }
            case ramdisk: {
                value = attr.getRamdiskId();
                break;
            }
            case rootDeviceName: {
                value = attr.getRootDeviceName();
                break;
            }
            case userData: {
                value = attr.getUserData();
                break;
            }
            case productCodes: {
                value = this.translateProductCodes(attr.getProductCodes());
                break;
            }
            case ebsOptimized: {
                value = attr.isEbsOptimized();
                break;
            }
            default: {
                throw new RuntimeException("Don't know how to unmarshall response for attribute type: " + (Object)((Object)instanceAttributeType));
            }
        }
        String requestId = this.getEc2Client().getCachedResponseMetadata((AmazonWebServiceRequest)request).getRequestId();
        return new RequestResultPair(new InstanceAttribute<List<InstanceBlockDeviceMappingResponseDescription>>(instanceAttributeType, value), requestId);
    }

    @Override
    public RequestResultPair<Boolean> resetInstanceAttribute(String instanceId, InstanceAttribute.InstanceAttributeType instanceAttributeType) throws Exception {
        ResetInstanceAttributeRequest request = new ResetInstanceAttributeRequest().withInstanceId(instanceId).withAttribute(instanceAttributeType.name());
        this.getEc2Client().resetInstanceAttribute(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<Boolean> modifyInstanceAttribute(String instanceId, InstanceAttribute<?> instanceAttribute) throws Exception {
        ModifyInstanceAttributeRequest request = new ModifyInstanceAttributeRequest().withInstanceId(instanceId);
        Object value = instanceAttribute.getValue();
        switch (instanceAttribute.getType()) {
            case blockDeviceMapping: {
                request.setBlockDeviceMappings(this.translateInstanceBlockDeviceMappingDescrptions((List)value));
                break;
            }
            case disableApiTermination: {
                request.setDisableApiTermination((Boolean)value);
                break;
            }
            case groupSet: {
                request.setGroups(Arrays.asList((String[])value));
                break;
            }
            case instanceInitiatedShutdownBehavior: {
                request.setInstanceInitiatedShutdownBehavior(value.toString());
                break;
            }
            case instanceType: {
                request.setInstanceType((String)value);
                break;
            }
            case kernel: {
                request.setKernel((String)value);
                break;
            }
            case ramdisk: {
                request.setRamdisk((String)value);
                break;
            }
            case sourceDestCheck: {
                request.setSourceDestCheck((Boolean)value);
                break;
            }
            case userData: {
                request.setUserData((String)value);
                break;
            }
            case ebsOptimized: {
                request.setEbsOptimized((Boolean)value);
                break;
            }
            default: {
                throw new RuntimeException("Got invalid instance attribute type: " + (Object)((Object)instanceAttribute.getType()));
            }
        }
        this.getEc2Client().modifyInstanceAttribute(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<Boolean> modifyImageAttribute(String imageId, ImageAttribute attribute, ImageListAttribute.ImageListAttributeOperationType operationType) throws Exception {
        ModifyImageAttributeRequest request = new ModifyImageAttributeRequest().withImageId(imageId).withAttribute(attribute.type.name()).withOperationType(operationType.name());
        switch (attribute.type) {
            case launchPermission: {
                request.setLaunchPermission(this.translateLaunchPermissionDescription(operationType, (ImageListAttribute)attribute));
            }
        }
        this.getEc2Client().modifyImageAttribute(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<Boolean> resetImageAttribute(String imageId, ImageAttribute.ImageAttributeType imageAttribute) throws Exception {
        ResetImageAttributeRequest request = new ResetImageAttributeRequest().withImageId(imageId).withAttribute(imageAttribute.name());
        this.getEc2Client().resetImageAttribute(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<DescribeImageAttributeResult> describeImageAttribute(String imageId, ImageAttribute.ImageAttributeType imageAttribute) throws Exception {
        DescribeImageAttributeRequest request = new DescribeImageAttributeRequest().withImageId(imageId).withAttribute(imageAttribute.name());
        com.amazonaws.services.ec2.model.DescribeImageAttributeResult result = this.getEc2Client().describeImageAttribute(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateImageAttribute(imageAttribute, result.getImageAttribute()));
    }

    @Override
    public RequestResultPair<ReservationDescription> runInstances(String imageId, int minCount, int maxCount, List<String> groupSet, String additionalInfo, String keyName, String b64UserData, String addressingType, String instanceType, PlacementDescription placement, String kernelId, String ramdiskId, List<BlockDeviceMappingDescription> blockDeviceMapping, Boolean monitoring, String subnetId, Boolean disableApiTermination, String instanceInitiatedShutdownBehavior, String licensePool, String privateIpAddress, List<NetworkInterfaceAttachmentRequestDescription> networkInterfaceAttachments, Boolean ebsOptimized, IamInstanceProfileRequestDescription iamInstanceProfile, String clientToken) throws Exception {
        IamInstanceProfileRequest callIamInstanceProfile = null;
        if (null != iamInstanceProfile) {
            callIamInstanceProfile = new IamInstanceProfileRequest().withArn(iamInstanceProfile.getArn()).withName(iamInstanceProfile.getName());
        }
        RunInstancesRequest request = new RunInstancesRequest().withImageId(imageId).withMinCount(Integer.valueOf(minCount)).withMaxCount(Integer.valueOf(maxCount)).withSecurityGroupIds(groupSet).withAdditionalInfo(additionalInfo).withKeyName(keyName).withUserData(b64UserData).withAddressingType(addressingType).withInstanceType(instanceType).withPlacement(this.translatePlacementDescription(placement)).withKernelId(kernelId).withRamdiskId(ramdiskId).withBlockDeviceMappings(this.translateBlockDeviceMappingDescription(blockDeviceMapping)).withMonitoring(monitoring).withSubnetId(subnetId).withDisableApiTermination(disableApiTermination).withInstanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior).withLicense(this.translateInstanceLicenseDescription(licensePool)).withNetworkInterfaces(this.translateNetworkInterfaceAttachmentRequests(networkInterfaceAttachments)).withEbsOptimized(ebsOptimized).withIamInstanceProfile(callIamInstanceProfile).withClientToken(clientToken);
        RunInstancesResult result = this.getEc2Client().runInstances(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateReservation(result.getReservation()));
    }

    @Override
    public RequestResultPair<Boolean> rebootInstances(String[] instanceIds) throws Exception {
        RebootInstancesRequest request = new RebootInstancesRequest().withInstanceIds(instanceIds);
        this.getEc2Client().rebootInstances(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<Boolean> rebootInstances(List<String> instanceIds) throws Exception {
        RebootInstancesRequest request = new RebootInstancesRequest().withInstanceIds(instanceIds);
        this.getEc2Client().rebootInstances(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<List<InstanceStateChangeDescription>> terminateInstances(String[] instanceIds) throws Exception {
        TerminateInstancesRequest request = new TerminateInstancesRequest().withInstanceIds(instanceIds);
        TerminateInstancesResult result = this.getEc2Client().terminateInstances(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateInstanceStateChange(result.getTerminatingInstances()));
    }

    @Override
    public RequestResultPair<List<InstanceStateChangeDescription>> terminateInstances(List<String> instanceIds) throws Exception {
        TerminateInstancesRequest request = new TerminateInstancesRequest().withInstanceIds(instanceIds);
        TerminateInstancesResult result = this.getEc2Client().terminateInstances(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateInstanceStateChange(result.getTerminatingInstances()));
    }

    @Override
    public RequestResultPair<List<InstanceStateChangeDescription>> stopInstances(String[] instanceIds, boolean force) throws Exception {
        StopInstancesRequest request = new StopInstancesRequest().withInstanceIds(instanceIds).withForce(Boolean.valueOf(force));
        StopInstancesResult result = this.getEc2Client().stopInstances(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateInstanceStateChange(result.getStoppingInstances()));
    }

    @Override
    public RequestResultPair<List<InstanceStateChangeDescription>> stopInstances(List<String> instanceIds, boolean force) throws Exception {
        StopInstancesRequest request = new StopInstancesRequest().withInstanceIds(instanceIds).withForce(Boolean.valueOf(force));
        StopInstancesResult result = this.getEc2Client().stopInstances(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateInstanceStateChange(result.getStoppingInstances()));
    }

    @Override
    public RequestResultPair<List<InstanceStateChangeDescription>> startInstances(String[] instanceIds) throws Exception {
        StartInstancesRequest request = new StartInstancesRequest().withInstanceIds(instanceIds);
        StartInstancesResult result = this.getEc2Client().startInstances(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateInstanceStateChange(result.getStartingInstances()));
    }

    @Override
    public RequestResultPair<List<InstanceStateChangeDescription>> startInstances(List<String> instanceIds) throws Exception {
        StartInstancesRequest request = new StartInstancesRequest().withInstanceIds(instanceIds);
        StartInstancesResult result = this.getEc2Client().startInstances(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateInstanceStateChange(result.getStartingInstances()));
    }

    @Override
    public RequestResultPair<List<ReservationDescription>> describeInstances(String[] instanceIds) throws Exception {
        DescribeInstancesRequest request = new DescribeInstancesRequest().withInstanceIds(instanceIds);
        DescribeInstancesResult result = this.getEc2Client().describeInstances(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateReservations(result.getReservations()));
    }

    @Override
    public RequestResultPair<List<ReservationDescription>> describeInstances(String[] instanceIds, List<Filter> filters) throws Exception {
        DescribeInstancesRequest request = new DescribeInstancesRequest().withInstanceIds(instanceIds).withFilters(this.translateFilterDescriptions(filters));
        DescribeInstancesResult result = this.getEc2Client().describeInstances(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateReservations(result.getReservations()));
    }

    @Override
    public RequestResultPair<List<ReservationDescription>> describeInstances(List<String> instanceIds, List<Filter> filters) throws Exception {
        DescribeInstancesRequest request = new DescribeInstancesRequest().withInstanceIds(instanceIds).withFilters(this.translateFilterDescriptions(filters));
        DescribeInstancesResult result = this.getEc2Client().describeInstances(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateReservations(result.getReservations()));
    }

    @Override
    public ConfirmProductInstanceDescription confirmProductInstance(String productCode, String instanceId) throws Exception {
        ConfirmProductInstanceRequest request = new ConfirmProductInstanceRequest().withProductCode(productCode).withInstanceId(instanceId);
        ConfirmProductInstanceResult result = this.getEc2Client().confirmProductInstance(this.prepareRequest(request));
        return new ConfirmProductInstanceDescription(true, result.getOwnerId());
    }

    @Override
    public RequestResultPair<String> createSecurityGroup(String name, String desc, String vpcId) throws Exception {
        CreateSecurityGroupRequest request = new CreateSecurityGroupRequest().withGroupName(name).withDescription(desc).withVpcId(vpcId);
        CreateSecurityGroupResult result = this.getEc2Client().createSecurityGroup(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, result.getGroupId());
    }

    @Override
    public RequestResultPair<Boolean> createPlacementGroup(String name, String strategy) throws Exception {
        CreatePlacementGroupRequest request = new CreatePlacementGroupRequest().withGroupName(name).withStrategy(strategy);
        this.getEc2Client().createPlacementGroup(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<Boolean> deletePlacementGroup(String name) throws Exception {
        DeletePlacementGroupRequest request = new DeletePlacementGroupRequest().withGroupName(name);
        this.getEc2Client().deletePlacementGroup(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<List<PlacementGroupDescription>> describePlacementGroups(List<String> groupNames, List<Filter> filters) throws Exception {
        DescribePlacementGroupsRequest request = new DescribePlacementGroupsRequest().withGroupNames(groupNames).withFilters(this.translateFilterDescriptions(filters));
        DescribePlacementGroupsResult result = this.getEc2Client().describePlacementGroups(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translatePlacementGroups(result.getPlacementGroups()));
    }

    @Override
    public RequestResultPair<ConsoleOutput> getConsoleOutput(String instanceId) throws Exception {
        GetConsoleOutputRequest request = new GetConsoleOutputRequest(instanceId);
        GetConsoleOutputResult result = this.getEc2Client().getConsoleOutput(this.prepareRequest(request));
        ConsoleOutput consoleOutput = new ConsoleOutput(result.getInstanceId(), this.translateDateToCalendar(result.getTimestamp()), new String(Base64.decode((String)result.getOutput())));
        return this.createResponse((AmazonWebServiceRequest)request, consoleOutput);
    }

    @Override
    public RequestResultPair<PasswordData> getPasswordData(String instanceId) throws Exception {
        GetPasswordDataRequest request = new GetPasswordDataRequest(instanceId);
        GetPasswordDataResult result = this.getEc2Client().getPasswordData(this.prepareRequest(request));
        PasswordData passwordData = new PasswordData(result.getInstanceId(), this.translateDateToCalendar(result.getTimestamp()), result.getPasswordData());
        return this.createResponse((AmazonWebServiceRequest)request, passwordData);
    }

    @Override
    public RequestResultPair<Boolean> deleteSecurityGroup(String name, String groupId) throws Exception {
        DeleteSecurityGroupRequest request = new DeleteSecurityGroupRequest(name).withGroupId(groupId);
        this.getEc2Client().deleteSecurityGroup(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<List<SecurityGroupDescription>> describeSecurityGroups(String[] groupNames, String[] groupIds) throws Exception {
        DescribeSecurityGroupsRequest request = new DescribeSecurityGroupsRequest().withGroupNames(groupNames).withGroupIds(groupIds);
        DescribeSecurityGroupsResult result = this.getEc2Client().describeSecurityGroups(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateSecurityGroups(result.getSecurityGroups()));
    }

    @Override
    public RequestResultPair<List<SecurityGroupDescription>> describeSecurityGroups(String[] groupNames) throws Exception {
        DescribeSecurityGroupsRequest request = new DescribeSecurityGroupsRequest().withGroupNames(groupNames);
        DescribeSecurityGroupsResult result = this.getEc2Client().describeSecurityGroups(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateSecurityGroups(result.getSecurityGroups()));
    }

    @Override
    public RequestResultPair<List<SecurityGroupDescription>> describeSecurityGroups(String[] inputs, List<Filter> filters) throws Exception {
        ArrayList<String> groupIds = new ArrayList<String>();
        ArrayList<String> groupNames = new ArrayList<String>();
        if (inputs != null) {
            for (String groupName : inputs) {
                if (groupName.matches(SECURITY_GROUP_ID)) {
                    groupIds.add(groupName);
                    continue;
                }
                groupNames.add(groupName);
            }
        }
        return this.describeSecurityGroups(groupNames, groupIds, filters);
    }

    @Override
    public boolean isIdFormat(String groupName) {
        if (groupName.length() != 11) {
            return false;
        }
        return "sg-".equals(groupName.substring(0, 3));
    }

    @Override
    public RequestResultPair<List<SecurityGroupDescription>> describeSecurityGroups(List<String> groupNames, List<String> groupIds, List<Filter> filters) throws Exception {
        DescribeSecurityGroupsRequest request = new DescribeSecurityGroupsRequest().withGroupNames(groupNames).withGroupIds(groupIds).withFilters(this.translateFilterDescriptions(filters));
        DescribeSecurityGroupsResult result = this.getEc2Client().describeSecurityGroups(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateSecurityGroups(result.getSecurityGroups()));
    }

    @Override
    public RequestResultPair<Boolean> authorizeSecurityGroup(SecurityGroupDescription gDesc) throws Exception {
        AuthorizeSecurityGroupIngressRequest request = new AuthorizeSecurityGroupIngressRequest().withGroupId(gDesc.id).withGroupName(gDesc.name).withIpPermissions(this.translateIpPermissionsDescription(gDesc.perms));
        this.getEc2Client().authorizeSecurityGroupIngress(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<Boolean> revokeSecurityGroupIngress(SecurityGroupDescription gDesc) throws Exception {
        RevokeSecurityGroupIngressRequest request = new RevokeSecurityGroupIngressRequest().withGroupId(gDesc.id).withGroupName(gDesc.name).withIpPermissions(this.translateIpPermissionsDescription(gDesc.perms));
        this.getEc2Client().revokeSecurityGroupIngress(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<KeyPairInfo> createKeyPair(String keyName) throws Exception {
        CreateKeyPairRequest request = new CreateKeyPairRequest().withKeyName(keyName);
        CreateKeyPairResult result = this.getEc2Client().createKeyPair(this.prepareRequest(request));
        KeyPair keyPair = result.getKeyPair();
        return this.createResponse((AmazonWebServiceRequest)request, new KeyPairInfo(keyPair.getKeyName(), keyPair.getKeyFingerprint(), keyPair.getKeyMaterial()));
    }

    @Override
    public RequestResultPair<List<KeyPairInfo>> describeKeyPairs(String[] keyIds) throws Exception {
        DescribeKeyPairsRequest request = new DescribeKeyPairsRequest().withKeyNames(keyIds);
        DescribeKeyPairsResult result = this.getEc2Client().describeKeyPairs(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateKeyPairs(result.getKeyPairs()));
    }

    @Override
    public RequestResultPair<List<KeyPairInfo>> describeKeyPairs(String[] keyIds, List<Filter> filters) throws Exception {
        DescribeKeyPairsRequest request = new DescribeKeyPairsRequest().withKeyNames(keyIds).withFilters(this.translateFilterDescriptions(filters));
        DescribeKeyPairsResult result = this.getEc2Client().describeKeyPairs(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateKeyPairs(result.getKeyPairs()));
    }

    @Override
    public RequestResultPair<List<KeyPairInfo>> describeKeyPairs(List<String> keyIds, List<Filter> filters) throws Exception {
        DescribeKeyPairsRequest request = new DescribeKeyPairsRequest().withKeyNames(keyIds).withFilters(this.translateFilterDescriptions(filters));
        DescribeKeyPairsResult result = this.getEc2Client().describeKeyPairs(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateKeyPairs(result.getKeyPairs()));
    }

    @Override
    public RequestResultPair<Boolean> deleteKeyPair(String keyName) throws Exception {
        DeleteKeyPairRequest request = new DeleteKeyPairRequest(keyName);
        this.getEc2Client().deleteKeyPair(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<List<AvailabilityZoneDescription>> describeAvailabilityZones(String[] zoneNames) throws Exception {
        DescribeAvailabilityZonesRequest request = new DescribeAvailabilityZonesRequest().withZoneNames(zoneNames);
        DescribeAvailabilityZonesResult result = this.getEc2Client().describeAvailabilityZones(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateAvailabilityZones(result.getAvailabilityZones()));
    }

    @Override
    public RequestResultPair<List<AvailabilityZoneDescription>> describeAvailabilityZones(String[] zoneNames, List<Filter> filters) throws Exception {
        DescribeAvailabilityZonesRequest request = new DescribeAvailabilityZonesRequest().withZoneNames(zoneNames).withFilters(this.translateFilterDescriptions(filters));
        DescribeAvailabilityZonesResult result = this.getEc2Client().describeAvailabilityZones(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateAvailabilityZones(result.getAvailabilityZones()));
    }

    @Override
    public RequestResultPair<List<AvailabilityZoneDescription>> describeAvailabilityZones(List<String> zoneNames, List<Filter> filters) throws Exception {
        DescribeAvailabilityZonesRequest request = new DescribeAvailabilityZonesRequest().withZoneNames(zoneNames).withFilters(this.translateFilterDescriptions(filters));
        DescribeAvailabilityZonesResult result = this.getEc2Client().describeAvailabilityZones(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateAvailabilityZones(result.getAvailabilityZones()));
    }

    @Override
    public RequestResultPair<List<RegionDescription>> describeRegions(String[] regionNames, List<Filter> filters) throws Exception {
        DescribeRegionsRequest request = new DescribeRegionsRequest().withRegionNames(regionNames).withFilters(this.translateFilterDescriptions(filters));
        DescribeRegionsResult result = this.getEc2Client().describeRegions(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateRegions(result.getRegions()));
    }

    @Override
    public RequestResultPair<List<RegionDescription>> describeRegions(List<String> regionNames, List<Filter> filters) throws Exception {
        DescribeRegionsRequest request = new DescribeRegionsRequest().withRegionNames(regionNames).withFilters(this.translateFilterDescriptions(filters));
        DescribeRegionsResult result = this.getEc2Client().describeRegions(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateRegions(result.getRegions()));
    }

    @Override
    public RequestResultPair<ElasticIpDescription> allocateAddress() throws Exception {
        AllocateAddressRequest request = new AllocateAddressRequest();
        AllocateAddressResult result = this.getEc2Client().allocateAddress(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, new ElasticIpDescription(result.getAllocationId(), result.getDomain(), result.getPublicIp()));
    }

    @Override
    public RequestResultPair<ElasticIpDescription> allocateAddress(String domain) throws Exception {
        AllocateAddressRequest request = new AllocateAddressRequest().withDomain(domain);
        AllocateAddressResult result = this.getEc2Client().allocateAddress(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, new ElasticIpDescription(result.getAllocationId(), result.getDomain(), result.getPublicIp()));
    }

    @Override
    public RequestResultPair<Boolean> releaseAddress(String publicIp, String allocationId) throws Exception {
        ReleaseAddressRequest request = new ReleaseAddressRequest().withPublicIp(publicIp).withAllocationId(allocationId);
        this.getEc2Client().releaseAddress(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<List<AddressInfo>> describeAddresses(String[] publicIps, String[] allocationIds, List<Filter> filters) throws Exception {
        DescribeAddressesRequest request = new DescribeAddressesRequest().withPublicIps(publicIps).withAllocationIds(allocationIds).withFilters(this.translateFilterDescriptions(filters));
        DescribeAddressesResult result = this.getEc2Client().describeAddresses(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateAddresses(result.getAddresses()));
    }

    @Override
    public RequestResultPair<List<AddressInfo>> describeAddresses(List<String> publicIps, List<String> allocationIds, List<Filter> filters) throws Exception {
        DescribeAddressesRequest request = new DescribeAddressesRequest().withPublicIps(publicIps).withAllocationIds(allocationIds).withFilters(this.translateFilterDescriptions(filters));
        DescribeAddressesResult result = this.getEc2Client().describeAddresses(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateAddresses(result.getAddresses()));
    }

    @Override
    public RequestResultPair<ElasticIpAssociationDescription> associateAddress(String publicIp, String instanceId, String networkInterfaceId, String allocationId, String privateIp, Boolean allowReassociation) throws Exception {
        AssociateAddressRequest request = new AssociateAddressRequest().withPublicIp(publicIp).withInstanceId(instanceId).withNetworkInterfaceId(networkInterfaceId).withAllocationId(allocationId).withPrivateIpAddress(privateIp).withAllowReassociation(allowReassociation);
        AssociateAddressResult result = this.getEc2Client().associateAddress(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, new ElasticIpAssociationDescription(result.getAssociationId()));
    }

    @Override
    public RequestResultPair<Boolean> disassociateAddress(String publicIp, String associationId) throws Exception {
        DisassociateAddressRequest request = new DisassociateAddressRequest().withPublicIp(publicIp).withAssociationId(associationId);
        this.getEc2Client().disassociateAddress(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<Boolean> assignPrivateIPAddresses(String networkInterfaceId, Integer addressCount, List<String> privateIPAddresses, boolean allowReassignment) throws Exception {
        AssignPrivateIpAddressesRequest request = new AssignPrivateIpAddressesRequest();
        request.setNetworkInterfaceId(networkInterfaceId);
        if (null != addressCount) {
            request.setSecondaryPrivateIpAddressCount(addressCount);
        }
        if (null != privateIPAddresses) {
            request.setPrivateIpAddresses(privateIPAddresses);
        }
        request.setAllowReassignment(Boolean.valueOf(allowReassignment));
        this.getEc2Client().assignPrivateIpAddresses(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<Boolean> unassignPrivateIPAddresses(String networkInterfaceId, List<String> privateIPAddresses) throws Exception {
        UnassignPrivateIpAddressesRequest request = new UnassignPrivateIpAddressesRequest().withNetworkInterfaceId(networkInterfaceId).withPrivateIpAddresses(privateIPAddresses);
        this.getEc2Client().unassignPrivateIpAddresses(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<BundleInstanceTask> bundleInstance(String instanceId, String awsAccessKeyId, String bucket, String prefix, String policy, String policySignature) throws Exception {
        S3Storage s3Storage = new S3Storage().withAWSAccessKeyId(awsAccessKeyId).withBucket(bucket).withPrefix(prefix).withUploadPolicy(policy).withUploadPolicySignature(policySignature);
        BundleInstanceRequest request = new BundleInstanceRequest().withInstanceId(instanceId).withStorage(new Storage().withS3(s3Storage));
        BundleInstanceResult result = this.getEc2Client().bundleInstance(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateBundleTask(result.getBundleTask()));
    }

    @Override
    public RequestResultPair<List<BundleInstanceTask>> describeBundleTasks(List<String> bundleIds, List<Filter> filters) throws Exception {
        DescribeBundleTasksRequest request = new DescribeBundleTasksRequest().withBundleIds(bundleIds).withFilters(this.translateFilterDescriptions(filters));
        DescribeBundleTasksResult result = this.getEc2Client().describeBundleTasks(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.tranlsateBundleTasks(result.getBundleTasks()));
    }

    @Override
    public RequestResultPair<BundleInstanceTask> cancelBundleTask(String bundleId) throws Exception {
        CancelBundleTaskRequest request = new CancelBundleTaskRequest().withBundleId(bundleId);
        CancelBundleTaskResult result = this.getEc2Client().cancelBundleTask(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateBundleTask(result.getBundleTask()));
    }

    @Override
    public RequestResultPair<VolumeDescription> createVolume(String size, String snapshotId, String availabilityZone, String volumeType, Integer iops) throws Exception {
        CreateVolumeRequest request = new CreateVolumeRequest().withSize(size == null || "".equals(size) ? null : Integer.valueOf(Integer.parseInt(size))).withSnapshotId(snapshotId).withAvailabilityZone(availabilityZone).withVolumeType(volumeType).withIops(iops);
        CreateVolumeResult result = this.getEc2Client().createVolume(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateVolume(result.getVolume()));
    }

    @Override
    public RequestResultPair<Boolean> deleteVolume(String volumeId) throws Exception {
        DeleteVolumeRequest request = new DeleteVolumeRequest().withVolumeId(volumeId);
        this.getEc2Client().deleteVolume(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<List<VolumeDescription>> describeVolumes(List<String> volumes, List<Filter> filters) throws Exception {
        DescribeVolumesRequest request = new DescribeVolumesRequest().withVolumeIds(volumes).withFilters(this.translateFilterDescriptions(filters));
        DescribeVolumesResult result = this.getEc2Client().describeVolumes(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateVolumes(result.getVolumes()));
    }

    @Override
    public RequestResultPair<List<VolumeDescription>> describeVolumes(String[] volumes, List<Filter> filters) throws Exception {
        DescribeVolumesRequest request = new DescribeVolumesRequest().withVolumeIds(volumes).withFilters(this.translateFilterDescriptions(filters));
        DescribeVolumesResult result = this.getEc2Client().describeVolumes(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateVolumes(result.getVolumes()));
    }

    @Override
    public RequestResultPair<AttachmentDescription> attachVolume(String volumeId, String instanceId, String device) throws Exception {
        AttachVolumeRequest request = new AttachVolumeRequest().withVolumeId(volumeId).withInstanceId(instanceId).withDevice(device);
        AttachVolumeResult result = this.getEc2Client().attachVolume(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateVolumeAttachment(result.getAttachment()));
    }

    @Override
    public RequestResultPair<AttachmentDescription> detachVolume(String volumeId, String instanceId, String device, Boolean force) throws Exception {
        DetachVolumeRequest request = new DetachVolumeRequest().withVolumeId(volumeId).withInstanceId(instanceId).withDevice(device).withForce(force);
        DetachVolumeResult result = this.getEc2Client().detachVolume(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateVolumeAttachment(result.getAttachment()));
    }

    @Override
    public RequestResultPair<SnapshotDescription> createSnapshot(String volumeId, String description) throws Exception {
        CreateSnapshotRequest request = new CreateSnapshotRequest().withVolumeId(volumeId).withDescription(description);
        CreateSnapshotResult result = this.getEc2Client().createSnapshot(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateSnapshot(result.getSnapshot()));
    }

    @Override
    public RequestResultPair<Boolean> deleteSnapshot(String snapshotId) throws Exception {
        DeleteSnapshotRequest request = new DeleteSnapshotRequest().withSnapshotId(snapshotId);
        this.getEc2Client().deleteSnapshot(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<List<SnapshotDescription>> describeSnapshots(List<String> snapshotsList, List<String> ownerList, List<String> restoreableByList, List<Filter> filters) throws Exception {
        DescribeSnapshotsRequest request = new DescribeSnapshotsRequest().withSnapshotIds(snapshotsList).withOwnerIds(ownerList).withRestorableByUserIds(restoreableByList).withFilters(this.translateFilterDescriptions(filters));
        DescribeSnapshotsResult result = this.getEc2Client().describeSnapshots(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateSnapshots(result.getSnapshots()));
    }

    @Override
    public RequestResultPair<DescribeSnapshotAttributeResult> describeSnapshotAttribute(String snapshotId, SnapshotAttribute.SnapshotAttributeType snapshotAttribute) throws Exception {
        DescribeSnapshotAttributeResult snapshotAttributeResult;
        DescribeSnapshotAttributeRequest request = new DescribeSnapshotAttributeRequest().withSnapshotId(snapshotId).withAttribute(snapshotAttribute.name());
        com.amazonaws.services.ec2.model.DescribeSnapshotAttributeResult result = this.getEc2Client().describeSnapshotAttribute(this.prepareRequest(request));
        switch (snapshotAttribute) {
            case createVolumePermission: {
                CreateVolumePermissionAttribute attr = new CreateVolumePermissionAttribute();
                List perms = result.getCreateVolumePermissions();
                if (null != perms) {
                    for (CreateVolumePermission perm : perms) {
                        if (null != perm.getUserId()) {
                            attr.addSnapshotListAttributeItem(SnapshotListAttributeItem.SnapshotListAttributeItemType.userId, perm.getUserId());
                            continue;
                        }
                        attr.addSnapshotListAttributeItem(SnapshotListAttributeItem.SnapshotListAttributeItemType.group, perm.getGroup());
                    }
                }
                snapshotAttributeResult = new DescribeSnapshotAttributeResult(result.getSnapshotId(), attr);
                break;
            }
            case productCodes: {
                snapshotAttributeResult = new DescribeSnapshotAttributeResult(result.getSnapshotId(), this.translateProductCodes(result.getProductCodes()));
                break;
            }
            default: {
                snapshotAttributeResult = null;
            }
        }
        return this.createResponse((AmazonWebServiceRequest)request, snapshotAttributeResult);
    }

    @Override
    public RequestResultPair<Boolean> modifySnapshotAttribute(String snapshotId, SnapshotAttribute attribute, SnapshotListAttribute.SnapshotListAttributeOperationType operationType) throws Exception {
        ArrayList<String> userIds = new ArrayList<String>();
        ArrayList<String> groups = new ArrayList<String>();
        switch (attribute.type) {
            case createVolumePermission: {
                CreateVolumePermissionAttribute attr = (CreateVolumePermissionAttribute)attribute;
                for (SnapshotListAttributeItem item : attr.items) {
                    switch (item.type) {
                        case group: {
                            groups.add(item.value);
                        }
                        case userId: {
                            userIds.add(item.value);
                        }
                    }
                }
                break;
            }
        }
        ModifySnapshotAttributeRequest request = new ModifySnapshotAttributeRequest().withSnapshotId(snapshotId).withOperationType(operationType.name()).withAttribute(attribute.type.name()).withUserIds(userIds).withGroupNames(groups);
        this.getEc2Client().modifySnapshotAttribute(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<Boolean> resetSnapshotAttribute(String snapshotId, SnapshotAttribute.SnapshotAttributeType snapshotAttribute) throws Exception {
        ResetSnapshotAttributeRequest request = new ResetSnapshotAttributeRequest().withSnapshotId(snapshotId).withAttribute(snapshotAttribute.name());
        this.getEc2Client().resetSnapshotAttribute(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<List<ReservedInstancesOfferingDescription>> describeReservedInstancesOfferings(List<String> offeringsIds, String availabilityZone, String instanceType, String productDescription, Tenancy instanceTenancy, String offeringType, List<Filter> filters) throws Exception {
        DescribeReservedInstancesOfferingsRequest request = new DescribeReservedInstancesOfferingsRequest().withReservedInstancesOfferingIds(offeringsIds).withAvailabilityZone(availabilityZone).withInstanceType(instanceType).withProductDescription(productDescription).withInstanceTenancy(instanceTenancy == null ? null : instanceTenancy.externalName()).withOfferingType(offeringType).withFilters(this.translateFilterDescriptions(filters));
        DescribeReservedInstancesOfferingsResult result = this.getEc2Client().describeReservedInstancesOfferings(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateReservedInstancesOfferings(result.getReservedInstancesOfferings()));
    }

    @Override
    public RequestResultPair<List<ReservedInstancesDescription>> describeReservedInstances(List<String> instanceReservationIds, List<Filter> filters) throws Exception {
        DescribeReservedInstancesRequest request = new DescribeReservedInstancesRequest().withReservedInstancesIds(instanceReservationIds).withFilters(this.translateFilterDescriptions(filters));
        DescribeReservedInstancesResult result = this.getEc2Client().describeReservedInstances(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateReservedInstancesList(result.getReservedInstances()));
    }

    @Override
    public RequestResultPair<String> purchaseReservedInstancesOffering(String offeringId, int instanceCount) throws Exception {
        PurchaseReservedInstancesOfferingRequest request = new PurchaseReservedInstancesOfferingRequest().withReservedInstancesOfferingId(offeringId).withInstanceCount(Integer.valueOf(instanceCount));
        PurchaseReservedInstancesOfferingResult result = this.getEc2Client().purchaseReservedInstancesOffering(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, result.getReservedInstancesId());
    }

    @Override
    public RequestResultPair<List<SnapshotDescription>> describeSnapshots(String[] snapshots, List<Filter> filters) throws Exception {
        DescribeSnapshotsRequest request = new DescribeSnapshotsRequest().withSnapshotIds(snapshots).withFilters(this.translateFilterDescriptions(filters));
        DescribeSnapshotsResult result = this.getEc2Client().describeSnapshots(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateSnapshots(result.getSnapshots()));
    }

    @Override
    public RequestResultPair<List<MonitorInstance>> monitorInstances(String[] instanceIds) throws Exception {
        MonitorInstancesRequest request = new MonitorInstancesRequest().withInstanceIds(instanceIds);
        MonitorInstancesResult result = this.getEc2Client().monitorInstances(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateInstanceMonitoring(result.getInstanceMonitorings()));
    }

    @Override
    public RequestResultPair<List<MonitorInstance>> unmonitorInstances(String[] instanceIds) throws Exception {
        UnmonitorInstancesRequest request = new UnmonitorInstancesRequest().withInstanceIds(instanceIds);
        UnmonitorInstancesResult result = this.getEc2Client().unmonitorInstances(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateInstanceMonitoring(result.getInstanceMonitorings()));
    }

    @Override
    public RequestResultPair<Boolean> associateDhcpOptions(String vpcId, String dhcpOptionId) throws Exception {
        AssociateDhcpOptionsRequest request = new AssociateDhcpOptionsRequest().withVpcId(vpcId).withDhcpOptionsId(dhcpOptionId);
        this.getEc2Client().associateDhcpOptions(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<VpnGatewayAttachmentDescription> attachVpnGateway(String vpcId, String vpnGatewayId) throws Exception {
        AttachVpnGatewayRequest request = new AttachVpnGatewayRequest().withVpcId(vpcId).withVpnGatewayId(vpnGatewayId);
        AttachVpnGatewayResult result = this.getEc2Client().attachVpnGateway(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateVpcAttachment(result.getVpcAttachement()));
    }

    @Override
    public RequestResultPair<VpcDescription> createVpc(String cidr, Tenancy instanceTenancy) throws Exception {
        CreateVpcRequest request = new CreateVpcRequest().withCidrBlock(cidr).withInstanceTenancy(instanceTenancy == null ? null : instanceTenancy.externalName());
        CreateVpcResult result = this.getEc2Client().createVpc(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateVpc(result.getVpc()));
    }

    @Override
    public RequestResultPair<CustomerGatewayDescription> createCustomerGateway(String type, String ipAddress, int bgpAsn) throws Exception {
        CreateCustomerGatewayRequest request = new CreateCustomerGatewayRequest().withType(type).withPublicIp(ipAddress).withBgpAsn(Integer.valueOf(bgpAsn));
        CreateCustomerGatewayResult result = this.getEc2Client().createCustomerGateway(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateCustomerGateway(result.getCustomerGateway()));
    }

    @Override
    public RequestResultPair<DhcpOptionsDescription> createDhcpOptions(Map<String, List<String>> options) throws Exception {
        CreateDhcpOptionsRequest request = new CreateDhcpOptionsRequest().withDhcpConfigurations(this.translateDhcpOptionsMap(options));
        CreateDhcpOptionsResult result = this.getEc2Client().createDhcpOptions(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateDhcpOptions(result.getDhcpOptions()));
    }

    @Override
    public RequestResultPair<Boolean> deleteVpc(String vpcId) throws Exception {
        DeleteVpcRequest request = new DeleteVpcRequest().withVpcId(vpcId);
        this.getEc2Client().deleteVpc(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<Boolean> deleteCustomerGateway(String customerGatewayId) throws Exception {
        DeleteCustomerGatewayRequest request = new DeleteCustomerGatewayRequest().withCustomerGatewayId(customerGatewayId);
        this.getEc2Client().deleteCustomerGateway(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<Boolean> deleteDhcpOptions(String dhcpOptionsId) throws Exception {
        DeleteDhcpOptionsRequest request = new DeleteDhcpOptionsRequest().withDhcpOptionsId(dhcpOptionsId);
        this.getEc2Client().deleteDhcpOptions(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<Boolean> deleteVpnConnection(String vpnConnectionId) throws Exception {
        DeleteVpnConnectionRequest request = new DeleteVpnConnectionRequest().withVpnConnectionId(vpnConnectionId);
        this.getEc2Client().deleteVpnConnection(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<Boolean> deleteVpnGateway(String vpnGatewayId) throws Exception {
        DeleteVpnGatewayRequest request = new DeleteVpnGatewayRequest().withVpnGatewayId(vpnGatewayId);
        this.getEc2Client().deleteVpnGateway(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<Boolean> deleteSubnet(String subnetId) throws Exception {
        DeleteSubnetRequest request = new DeleteSubnetRequest().withSubnetId(subnetId);
        this.getEc2Client().deleteSubnet(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<VpnConnectionDescription> createVpnConnection(String type, String customerGatewayId, String vpnGatewayId) throws Exception {
        CreateVpnConnectionRequest request = new CreateVpnConnectionRequest().withType(type).withCustomerGatewayId(customerGatewayId).withVpnGatewayId(vpnGatewayId);
        CreateVpnConnectionResult result = this.getEc2Client().createVpnConnection(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateVpnConnection(result.getVpnConnection()));
    }

    @Override
    public RequestResultPair<VpnGatewayDescription> createVpnGateway(String type, String availabilityZone) throws Exception {
        CreateVpnGatewayRequest request = new CreateVpnGatewayRequest().withType(type).withAvailabilityZone(availabilityZone);
        CreateVpnGatewayResult result = this.getEc2Client().createVpnGateway(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateVpnGateway(result.getVpnGateway()));
    }

    @Override
    public RequestResultPair<SubnetDescription> createSubnet(String vpcId, String cidr, String availabilityZone) throws Exception {
        CreateSubnetRequest request = new CreateSubnetRequest().withVpcId(vpcId).withCidrBlock(cidr).withAvailabilityZone(availabilityZone);
        CreateSubnetResult result = this.getEc2Client().createSubnet(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateSubnet(result.getSubnet()));
    }

    @Override
    public RequestResultPair<List<SpotInstanceRequestDescription>> requestSpotInstances(String price, String imageId, List<String> groupSet, String keyName, String addressingType, String instanceType, String availabilityZone, String placementGroupName, String subnetId, String kernelId, String ramdiskId, List<BlockDeviceMappingDescription> blockDeviceMapping, Boolean monitoring, Boolean ebsOptimized, String userData, List<NetworkInterfaceAttachmentRequestDescription> networkInterfaceAttachments, String instanceCount, String requestType, GregorianCalendar validUntil, GregorianCalendar validFrom, String launchGroup, String availabilityZoneGroup, IamInstanceProfileRequestDescription iamInstanceProfile) throws Exception {
        SpotPlacement spotPlacement = new SpotPlacement().withAvailabilityZone(availabilityZone).withGroupName(placementGroupName);
        IamInstanceProfileRequest callIamInstanceProfile = null;
        if (null != iamInstanceProfile) {
            callIamInstanceProfile = new IamInstanceProfileRequest().withArn(iamInstanceProfile.getArn()).withName(iamInstanceProfile.getName());
        }
        com.amazonaws.services.ec2.model.LaunchSpecification launchSpecification = new com.amazonaws.services.ec2.model.LaunchSpecification().withAddressingType(addressingType).withBlockDeviceMappings(this.translateBlockDeviceMappingDescription(blockDeviceMapping)).withImageId(imageId).withInstanceType(instanceType).withKernelId(kernelId).withKeyName(keyName).withMonitoringEnabled(monitoring).withEbsOptimized(ebsOptimized).withPlacement(spotPlacement).withRamdiskId(ramdiskId).withSecurityGroups(groupSet).withSubnetId(subnetId).withUserData(userData).withNetworkInterfaces(this.translateNetworkInterfaceAttachmentRequestDescriptions(networkInterfaceAttachments)).withIamInstanceProfile(callIamInstanceProfile);
        RequestSpotInstancesRequest request = new RequestSpotInstancesRequest().withAvailabilityZoneGroup(availabilityZoneGroup).withInstanceCount(this.translateStringToInteger(instanceCount)).withLaunchGroup(launchGroup).withLaunchSpecification(launchSpecification).withSpotPrice(price).withType(requestType).withValidFrom(this.translateCalendar(validFrom)).withValidUntil(this.translateCalendar(validUntil));
        RequestSpotInstancesResult result = this.getEc2Client().requestSpotInstances(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateSpotInstanceRequests(result.getSpotInstanceRequests()));
    }

    @Override
    public RequestResultPair<List<SpotInstanceRequestDescription>> describeSpotInstanceRequests(String[] requestIds, List<Filter> filters) throws Exception {
        DescribeSpotInstanceRequestsRequest request = new DescribeSpotInstanceRequestsRequest().withSpotInstanceRequestIds(requestIds).withFilters(this.translateFilterDescriptions(filters));
        DescribeSpotInstanceRequestsResult result = this.getEc2Client().describeSpotInstanceRequests(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateSpotInstanceRequests(result.getSpotInstanceRequests()));
    }

    @Override
    public RequestResultPair<List<CancelSpotInstanceRequestDescription>> cancelSpotInstanceRequests(String[] requestIds) throws Exception {
        CancelSpotInstanceRequestsRequest request = new CancelSpotInstanceRequestsRequest().withSpotInstanceRequestIds(requestIds);
        CancelSpotInstanceRequestsResult result = this.getEc2Client().cancelSpotInstanceRequests(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateCancelledSpotInstanceRequests(result.getCancelledSpotInstanceRequests()));
    }

    @Override
    public RequestResultPair<SpotPriceHistoryContainer> describeSpotPriceHistory(GregorianCalendar startTime, GregorianCalendar endTime, List<String> instanceTypes, List<String> productDescriptions, String availabilityZone, BigInteger maxResults, List<Filter> filters, String nextToken) throws Exception {
        DescribeSpotPriceHistoryRequest request = new DescribeSpotPriceHistoryRequest().withStartTime(this.translateCalendar(startTime)).withEndTime(this.translateCalendar(endTime)).withInstanceTypes(instanceTypes).withProductDescriptions(productDescriptions).withAvailabilityZone(availabilityZone).withMaxResults(this.translateBigInteger(maxResults)).withFilters(this.translateFilterDescriptions(filters)).withNextToken(nextToken);
        DescribeSpotPriceHistoryResult result = this.getEc2Client().describeSpotPriceHistory(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateSpotPriceHistory(result.getSpotPriceHistory(), result.getNextToken()));
    }

    @Override
    public RequestResultPair<SpotDatafeedSubscription> createSpotDatafeedSubscription(String bucket, String prefix) throws Exception {
        CreateSpotDatafeedSubscriptionRequest request = new CreateSpotDatafeedSubscriptionRequest().withBucket(bucket).withPrefix(prefix);
        CreateSpotDatafeedSubscriptionResult result = this.getEc2Client().createSpotDatafeedSubscription(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateSpotDataFeedSubscription(result.getSpotDatafeedSubscription()));
    }

    @Override
    public RequestResultPair<SpotDatafeedSubscription> describeSpotDatafeedSubscription() throws Exception {
        DescribeSpotDatafeedSubscriptionRequest request = new DescribeSpotDatafeedSubscriptionRequest();
        DescribeSpotDatafeedSubscriptionResult result = this.getEc2Client().describeSpotDatafeedSubscription(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateSpotDataFeedSubscription(result.getSpotDatafeedSubscription()));
    }

    @Override
    public RequestResultPair<Boolean> deleteSpotDatafeedSubscription() throws Exception {
        DeleteSpotDatafeedSubscriptionRequest request = new DeleteSpotDatafeedSubscriptionRequest();
        this.getEc2Client().deleteSpotDatafeedSubscription(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<List<VpcDescription>> describeVpcs(Map<String, List<String>> filterMap, String ... ids) throws Exception {
        DescribeVpcsRequest request = new DescribeVpcsRequest().withFilters(this.translateFilterMap(filterMap)).withVpcIds(ids);
        DescribeVpcsResult result = this.getEc2Client().describeVpcs(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateVpcs(result.getVpcs()));
    }

    @Override
    public RequestResultPair<List<CustomerGatewayDescription>> describeCustomerGateways(Map<String, List<String>> filterMap, String ... ids) throws Exception {
        DescribeCustomerGatewaysRequest request = new DescribeCustomerGatewaysRequest().withFilters(this.translateFilterMap(filterMap)).withCustomerGatewayIds(ids);
        DescribeCustomerGatewaysResult result = this.getEc2Client().describeCustomerGateways(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateCustomerGateways(result.getCustomerGateways()));
    }

    @Override
    public RequestResultPair<List<DhcpOptionsDescription>> describeDhcpOptions(List<Filter> filters, String ... ids) throws Exception {
        DescribeDhcpOptionsRequest request = new DescribeDhcpOptionsRequest().withFilters(this.translateFilterDescriptions(filters)).withDhcpOptionsIds(ids);
        DescribeDhcpOptionsResult result = this.getEc2Client().describeDhcpOptions(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateDhcpOptions(result.getDhcpOptions()));
    }

    @Override
    public RequestResultPair<List<VpnGatewayDescription>> describeVpnGateways(Map<String, List<String>> filterMap, String ... ids) throws Exception {
        DescribeVpnGatewaysRequest request = new DescribeVpnGatewaysRequest().withFilters(this.translateFilterMap(filterMap)).withVpnGatewayIds(ids);
        DescribeVpnGatewaysResult result = this.getEc2Client().describeVpnGateways(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateVpnGateways(result.getVpnGateways()));
    }

    @Override
    public RequestResultPair<List<VpnConnectionDescription>> describeVpnConnections(Map<String, List<String>> filterMap, String ... ids) throws Exception {
        DescribeVpnConnectionsRequest request = new DescribeVpnConnectionsRequest().withFilters(this.translateFilterMap(filterMap)).withVpnConnectionIds(ids);
        DescribeVpnConnectionsResult result = this.getEc2Client().describeVpnConnections(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateVpnConnections(result.getVpnConnections()));
    }

    @Override
    public RequestResultPair<List<SubnetDescription>> describeSubnets(Map<String, List<String>> filterMap, String ... ids) throws Exception {
        DescribeSubnetsRequest request = new DescribeSubnetsRequest().withFilters(this.translateFilterMap(filterMap)).withSubnetIds(ids);
        DescribeSubnetsResult result = this.getEc2Client().describeSubnets(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateSubnets(result.getSubnets()));
    }

    @Override
    public RequestResultPair<Boolean> detachVpnGateway(String vpcId, String vpnGatewayId) throws Exception {
        DetachVpnGatewayRequest request = new DetachVpnGatewayRequest().withVpcId(vpcId).withVpnGatewayId(vpnGatewayId);
        this.getEc2Client().detachVpnGateway(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<List<License>> describeLicenses(List<Filter> filters, String ... licenseIds) throws Exception {
        DescribeLicensesRequest request = new DescribeLicensesRequest().withFilters(this.translateFilterDescriptions(filters)).withLicenseIds(licenseIds);
        DescribeLicensesResult result = this.getEc2Client().describeLicenses(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateLicenses(result.getLicenses()));
    }

    @Override
    public RequestResultPair<ActivateLicenseResponse> activateLicense(String licenseId, int capacity) throws Exception {
        ActivateLicenseRequest request = new ActivateLicenseRequest().withLicenseId(licenseId).withCapacity(Integer.valueOf(capacity));
        this.getEc2Client().activateLicense(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, new ActivateLicenseResponse(true));
    }

    @Override
    public RequestResultPair<DeactivateLicenseResponse> deactivateLicense(String licenseId, int capacity) throws Exception {
        DeactivateLicenseRequest request = new DeactivateLicenseRequest().withLicenseId(licenseId).withCapacity(Integer.valueOf(capacity));
        this.getEc2Client().deactivateLicense(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, new DeactivateLicenseResponse(true));
    }

    @Override
    public RequestResultPair<Boolean> createTags(List<String> resourceIds, List<TagType> tags) throws Exception {
        CreateTagsRequest request = new CreateTagsRequest().withResources(resourceIds).withTags(this.translateTagTypes(tags));
        this.getEc2Client().createTags(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<List<TagDescription>> describeTags(List<Filter> filters) throws Exception {
        DescribeTagsRequest request = new DescribeTagsRequest().withFilters(this.translateFilterDescriptions(filters));
        DescribeTagsResult result = this.getEc2Client().describeTags(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateTagDescriptions(result.getTags()));
    }

    @Override
    public List<ConversionTaskDescription> describeConversionTasks(String[] ids) throws Exception {
        DescribeConversionTasksRequest request = new DescribeConversionTasksRequest().withConversionTaskIds(ids);
        DescribeConversionTasksResult result = this.getEc2Client().describeConversionTasks(this.prepareRequest(request));
        return this.translateConversionTasks(result.getConversionTasks());
    }

    @Override
    public ConversionTaskDescription describeConversionTask(String id) throws Exception {
        DescribeConversionTasksRequest request = new DescribeConversionTasksRequest().withConversionTaskIds(new String[]{id});
        DescribeConversionTasksResult result = this.getEc2Client().describeConversionTasks(this.prepareRequest(request));
        return this.translateConversionTask((ConversionTask)result.getConversionTasks().get(0));
    }

    @Override
    public RequestResultPair<Boolean> deleteConversionTask(String taskId) throws Exception {
        CancelConversionTaskRequest request = new CancelConversionTaskRequest().withConversionTaskId(taskId);
        this.getEc2Client().cancelConversionTask(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<Boolean> deleteTags(List<String> resourceIds, List<TagType> tags) throws Exception {
        DeleteTagsRequest request = new DeleteTagsRequest().withResources(resourceIds).withTags(this.translateTagTypes(tags));
        this.getEc2Client().deleteTags(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public ConversionTaskDescription importVolume(String az, String comment, String diskImageFormat, String importManifestUrl, long diskImageSize, int volumeSize) throws Exception {
        DiskImageDetail image = new DiskImageDetail().withBytes(Long.valueOf(diskImageSize)).withFormat(diskImageFormat).withImportManifestUrl(importManifestUrl);
        VolumeDetail volume = new VolumeDetail().withSize(Long.valueOf(volumeSize));
        ImportVolumeRequest request = new ImportVolumeRequest().withAvailabilityZone(az).withDescription(comment).withImage(image).withVolume(volume);
        ImportVolumeResult result = this.getEc2Client().importVolume(this.prepareRequest(request));
        return this.translateConversionTask(result.getConversionTask());
    }

    @Override
    public RequestResultPair<KeyPairInfo> importKeyPair(String keyName, byte[] publicKeyMaterial) throws Exception {
        ImportKeyPairRequest request = new ImportKeyPairRequest().withKeyName(keyName).withPublicKeyMaterial(new String(publicKeyMaterial));
        ImportKeyPairResult result = this.getEc2Client().importKeyPair(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, new KeyPairInfo(result.getKeyName(), result.getKeyFingerprint(), null));
    }

    @Override
    public ConversionTaskDescription importInstance(String az, String description, String instanceType, String architecture, String platform, String userData, List<String> groupSet, String shutdownBehavior, String subnetId, String privateIp, Boolean monitoring, String diskImageFormat, String importManifestUrl, long diskImageSize, int volumeSize) throws Exception {
        Placement placement = null == az ? null : new Placement().withAvailabilityZone(az);
        MonitoringDetail monitoringDetail = null;
        if (monitoring != null) {
            monitoringDetail = new MonitoringDetail().withEnabled(monitoring);
        }
        ImportInstanceLaunchSpecification launchSpecification = new ImportInstanceLaunchSpecification().withInstanceType(instanceType).withArchitecture(architecture).withUserData(userData).withSecurityGroupNames(groupSet).withSubnetId(subnetId).withPrivateIpAddress(privateIp).withMonitoring(monitoringDetail).withPlacement(placement);
        DiskImageDetail diskImageDetail = new DiskImageDetail().withBytes(Long.valueOf(diskImageSize)).withFormat(diskImageFormat).withImportManifestUrl(importManifestUrl);
        VolumeDetail volumeDetail = new VolumeDetail().withSize(Long.valueOf(volumeSize));
        DiskImage diskImage = new DiskImage().withImage(diskImageDetail).withVolume(volumeDetail);
        ImportInstanceRequest request = new ImportInstanceRequest().withLaunchSpecification(launchSpecification).withPlatform(platform).withDescription(description).withDiskImages(new DiskImage[]{diskImage});
        ImportInstanceResult result = this.getEc2Client().importInstance(this.prepareRequest(request));
        return this.translateConversionTask(result.getConversionTask());
    }

    @Override
    public RequestResultPair<ExportTaskDescription> createInstanceExportTask(String instanceId, String targetEnvironment, String diskFormat, String containerFormat, String bucket, String prefix, String description) throws Exception {
        ExportToS3Task exportTask = new ExportToS3Task().withS3Bucket(bucket).withS3Prefix(prefix);
        if (null != diskFormat) {
            exportTask.setDiskImageFormat(diskFormat.toLowerCase());
        }
        if (null != containerFormat) {
            exportTask.setContainerFormat(containerFormat.toLowerCase());
        }
        CreateInstanceExportTaskRequest request = new CreateInstanceExportTaskRequest().withDescription(description).withInstanceId(instanceId).withTargetEnvironment(targetEnvironment.toLowerCase()).withExportToS3(exportTask);
        CreateInstanceExportTaskResult result = this.getEc2Client().createInstanceExportTask(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateExportTask(result.getExportTask()));
    }

    @Override
    public RequestResultPair<List<ExportTaskDescription>> describeExportTasks(String[] ids) throws Exception {
        DescribeExportTasksRequest request = new DescribeExportTasksRequest().withExportTaskIds(ids);
        DescribeExportTasksResult result = this.getEc2Client().describeExportTasks(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateExportTasks(result.getExportTaskSet()));
    }

    @Override
    public RequestResultPair<Boolean> cancelExportTask(String id) throws Exception {
        CancelExportTaskRequest request = new CancelExportTaskRequest().withExportTaskId(id);
        this.getEc2Client().cancelExportTask(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    public ExportTaskDescription translateExportTask(ExportTaskResponse exportTask) {
        if (exportTask == null) {
            return null;
        }
        String instanceId = null;
        String targetEnvironment = null;
        InstanceExportTaskResponse instanceExport = exportTask.getInstanceExport();
        if (instanceExport != null) {
            instanceId = instanceExport.getInstanceId();
            targetEnvironment = instanceExport.getTargetEnvironment();
        }
        String diskFormat = null;
        String containerFormat = null;
        String s3Bucket = null;
        String s3Prefix = null;
        ExportToS3TaskResponse exportToS3 = exportTask.getExportToS3();
        if (exportToS3 != null) {
            diskFormat = exportToS3.getDiskImageFormat();
            containerFormat = exportToS3.getContainerFormat();
            s3Bucket = exportToS3.getS3Bucket();
            s3Prefix = exportToS3.getS3Key();
        }
        return new ExportTaskDescription(exportTask.getExportTaskId(), exportTask.getDescription(), exportTask.getState(), exportTask.getStatusMessage(), new ExportTaskSourceDescription(instanceId, targetEnvironment), new ExportTaskDestinationDescription(diskFormat, containerFormat, s3Bucket, s3Prefix));
    }

    public List<ExportTaskDescription> translateExportTasks(List<ExportTaskResponse> responses) {
        if (responses == null) {
            return null;
        }
        ArrayList<ExportTaskDescription> descriptions = new ArrayList<ExportTaskDescription>(responses.size());
        for (ExportTaskResponse cur : responses) {
            descriptions.add(this.translateExportTask(cur));
        }
        return descriptions;
    }

    @Override
    public RequestResultPair<Boolean> deleteNetworkAcl(String networkAclId) throws Exception {
        DeleteNetworkAclRequest request = new DeleteNetworkAclRequest().withNetworkAclId(networkAclId);
        this.getEc2Client().deleteNetworkAcl(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<List<NetworkAclDescription>> describeNetworkAcls(String[] networkAclIds, List<Filter> filters) throws Exception {
        DescribeNetworkAclsRequest request = new DescribeNetworkAclsRequest().withNetworkAclIds(networkAclIds).withFilters(this.translateFilterDescriptions(filters));
        DescribeNetworkAclsResult result = this.getEc2Client().describeNetworkAcls(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateNetworkAcls(result.getNetworkAcls()));
    }

    @Override
    public RequestResultPair<NetworkAclDescription> createNetworkAcl(String vpcId) throws Exception {
        CreateNetworkAclRequest request = new CreateNetworkAclRequest().withVpcId(vpcId);
        CreateNetworkAclResult result = this.getEc2Client().createNetworkAcl(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateNetworkAcl(result.getNetworkAcl()));
    }

    @Override
    public RequestResultPair<NetworkAclEntryDescription> createNetworkAclEntry(String aclId, int ruleNumber, String cidr, boolean egress, String protocol, int[] rangeArray, int[] icmpArray, boolean allow) throws Exception {
        String action = allow ? "allow" : "deny";
        PortRange portRange = this.translatePortRangeArray(rangeArray);
        IcmpTypeCode icmpTypeCode = this.translateIcmpArray(icmpArray);
        CreateNetworkAclEntryRequest request = new CreateNetworkAclEntryRequest().withNetworkAclId(aclId).withRuleNumber(Integer.valueOf(ruleNumber)).withCidrBlock(cidr).withEgress(Boolean.valueOf(egress)).withProtocol(protocol).withPortRange(portRange).withIcmpTypeCode(icmpTypeCode).withRuleAction(action);
        this.getEc2Client().createNetworkAclEntry(this.prepareRequest(request));
        NetworkAclEntryDescription entry = new NetworkAclEntryDescription(action, cidr, this.translateIcmpTypeCode(icmpTypeCode), this.translatePortRange(portRange), protocol, ruleNumber, egress);
        return this.createResponse((AmazonWebServiceRequest)request, entry);
    }

    @Override
    public RequestResultPair<NetworkAclEntryDescription> replaceNetworkAclEntry(String aclId, int ruleNumber, String cidr, boolean egress, String protocol, int[] rangeArray, int[] icmpArray, boolean allow) throws Exception {
        String action = allow ? "allow" : "deny";
        PortRange portRange = this.translatePortRangeArray(rangeArray);
        IcmpTypeCode icmpTypeCode = this.translateIcmpArray(icmpArray);
        ReplaceNetworkAclEntryRequest request = new ReplaceNetworkAclEntryRequest().withNetworkAclId(aclId).withRuleNumber(Integer.valueOf(ruleNumber)).withCidrBlock(cidr).withEgress(Boolean.valueOf(egress)).withProtocol(protocol).withPortRange(portRange).withIcmpTypeCode(icmpTypeCode).withRuleAction(action);
        this.getEc2Client().replaceNetworkAclEntry(this.prepareRequest(request));
        NetworkAclEntryDescription entry = new NetworkAclEntryDescription(action, cidr, this.translateIcmpTypeCode(icmpTypeCode), this.translatePortRange(portRange), protocol, ruleNumber, egress);
        return this.createResponse((AmazonWebServiceRequest)request, entry);
    }

    @Override
    public RequestResultPair<Boolean> deleteNetworkAclEntry(String networkAclId, int ruleNumber, boolean egress) throws Exception {
        DeleteNetworkAclEntryRequest request = new DeleteNetworkAclEntryRequest().withNetworkAclId(networkAclId).withRuleNumber(Integer.valueOf(ruleNumber)).withEgress(Boolean.valueOf(egress));
        this.getEc2Client().deleteNetworkAclEntry(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<String> replaceNetworkAclAssociation(String assocId, String networkAclId) throws Exception {
        ReplaceNetworkAclAssociationRequest request = new ReplaceNetworkAclAssociationRequest().withAssociationId(assocId).withNetworkAclId(networkAclId);
        ReplaceNetworkAclAssociationResult result = this.getEc2Client().replaceNetworkAclAssociation(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, result.getNewAssociationId());
    }

    @Override
    public RequestResultPair<Boolean> deleteRoute(String routeTableId, String cidrBlock) throws Exception {
        DeleteRouteRequest request = new DeleteRouteRequest().withRouteTableId(routeTableId).withDestinationCidrBlock(cidrBlock);
        this.getEc2Client().deleteRoute(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<RouteDescription> replaceRoute(String routeTableId, String cidrBlock, String id, RouteResourceType routeResourceType) throws Exception {
        String gatewayId = null;
        String instanceId = null;
        String networkInterfaceId = null;
        switch (routeResourceType) {
            case gateway: {
                gatewayId = id;
                break;
            }
            case instance: {
                instanceId = id;
                break;
            }
            case networkInterface: {
                networkInterfaceId = id;
                break;
            }
            default: {
                throw new RuntimeException("Unknown resource type " + (Object)((Object)routeResourceType));
            }
        }
        ReplaceRouteRequest request = new ReplaceRouteRequest().withRouteTableId(routeTableId).withDestinationCidrBlock(cidrBlock).withGatewayId(gatewayId).withInstanceId(instanceId).withNetworkInterfaceId(networkInterfaceId);
        this.getEc2Client().replaceRoute(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, new RouteDescription(cidrBlock, gatewayId, instanceId, networkInterfaceId, null));
    }

    @Override
    public RequestResultPair<RouteDescription> createRoute(String routeTableId, String cidrBlock, String id, RouteResourceType routeResourceType) throws Exception {
        String gatewayId = null;
        String instanceId = null;
        String networkInterfaceId = null;
        switch (routeResourceType) {
            case gateway: {
                gatewayId = id;
                break;
            }
            case instance: {
                instanceId = id;
                break;
            }
            case networkInterface: {
                networkInterfaceId = id;
                break;
            }
            default: {
                throw new RuntimeException("Unknown resource type " + (Object)((Object)routeResourceType));
            }
        }
        CreateRouteRequest request = new CreateRouteRequest().withRouteTableId(routeTableId).withDestinationCidrBlock(cidrBlock).withGatewayId(gatewayId).withInstanceId(instanceId).withNetworkInterfaceId(networkInterfaceId);
        this.getEc2Client().createRoute(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, new RouteDescription(cidrBlock, gatewayId, instanceId, networkInterfaceId, null));
    }

    @Override
    public RequestResultPair<Boolean> disassociateRouteTable(String associationId) throws Exception {
        DisassociateRouteTableRequest request = new DisassociateRouteTableRequest().withAssociationId(associationId);
        this.getEc2Client().disassociateRouteTable(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<String> replaceRouteTableAssociation(String associationId, String routeTableId) throws Exception {
        ReplaceRouteTableAssociationRequest request = new ReplaceRouteTableAssociationRequest().withAssociationId(associationId).withRouteTableId(routeTableId);
        ReplaceRouteTableAssociationResult result = this.getEc2Client().replaceRouteTableAssociation(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, result.getNewAssociationId());
    }

    @Override
    public RequestResultPair<String> associateRouteTable(String routeTableId, String subnetId) throws Exception {
        AssociateRouteTableRequest request = new AssociateRouteTableRequest().withRouteTableId(routeTableId).withSubnetId(subnetId);
        AssociateRouteTableResult result = this.getEc2Client().associateRouteTable(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, result.getAssociationId());
    }

    @Override
    public RequestResultPair<Boolean> deleteRouteTable(String routeTableId) throws Exception {
        DeleteRouteTableRequest request = new DeleteRouteTableRequest().withRouteTableId(routeTableId);
        this.getEc2Client().deleteRouteTable(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<List<RouteTableDescription>> describeRouteTables(String[] routeTableIdSet, List<Filter> filters) throws Exception {
        DescribeRouteTablesRequest request = new DescribeRouteTablesRequest().withRouteTableIds(routeTableIdSet).withFilters(this.translateFilterDescriptions(filters));
        DescribeRouteTablesResult result = this.getEc2Client().describeRouteTables(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateRouteTables(result.getRouteTables()));
    }

    @Override
    public RequestResultPair<RouteTableDescription> createRouteTable(String vpcId) throws Exception {
        CreateRouteTableRequest request = new CreateRouteTableRequest().withVpcId(vpcId);
        CreateRouteTableResult result = this.getEc2Client().createRouteTable(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateRouteTable(result.getRouteTable()));
    }

    @Override
    public RequestResultPair<Boolean> detachInternetGateway(String internetGatewayId, String vpcId) throws Exception {
        DetachInternetGatewayRequest request = new DetachInternetGatewayRequest().withInternetGatewayId(internetGatewayId).withVpcId(vpcId);
        this.getEc2Client().detachInternetGateway(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<InternetGatewayAttachmentDescription> attachInternetGateway(String internetGatewayId, String vpcId) throws Exception {
        AttachInternetGatewayRequest request = new AttachInternetGatewayRequest().withInternetGatewayId(internetGatewayId).withVpcId(vpcId);
        this.getEc2Client().attachInternetGateway(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, new InternetGatewayAttachmentDescription(vpcId, "attaching"));
    }

    @Override
    public RequestResultPair<Boolean> deleteInternetGateway(String gatewayId) throws Exception {
        DeleteInternetGatewayRequest request = new DeleteInternetGatewayRequest().withInternetGatewayId(gatewayId);
        this.getEc2Client().deleteInternetGateway(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<List<InternetGatewayDescription>> describeInternetGateways(String[] gatewayIds, List<Filter> filters) throws Exception {
        DescribeInternetGatewaysRequest request = new DescribeInternetGatewaysRequest().withInternetGatewayIds(gatewayIds).withFilters(this.translateFilterDescriptions(filters));
        DescribeInternetGatewaysResult result = this.getEc2Client().describeInternetGateways(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateInternetGateways(result.getInternetGateways()));
    }

    @Override
    public RequestResultPair<InternetGatewayDescription> createInternetGateway() throws Exception {
        CreateInternetGatewayRequest request = new CreateInternetGatewayRequest();
        CreateInternetGatewayResult result = this.getEc2Client().createInternetGateway(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateInternetGateway(result.getInternetGateway()));
    }

    @Override
    public RequestResultPair<InstanceStatusContainer> describeInstanceStatus(String[] instanceIds, List<Filter> filters, Boolean includeAllInstances, String nextToken) throws Exception {
        DescribeInstanceStatusRequest request = new DescribeInstanceStatusRequest().withIncludeAllInstances(includeAllInstances).withInstanceIds(instanceIds).withFilters(this.translateFilterDescriptions(filters)).withNextToken(nextToken);
        DescribeInstanceStatusResult result = this.getEc2Client().describeInstanceStatus(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, new InstanceStatusContainer(this.translateInstanceStatuses(result.getInstanceStatuses()), result.getNextToken()));
    }

    @Override
    public RequestResultPair<InstanceStatusContainer> describeInstanceStatus(Integer maxResults, List<Filter> filters, Boolean includeAllInstances, String nextToken) throws Exception {
        DescribeInstanceStatusRequest request = new DescribeInstanceStatusRequest().withIncludeAllInstances(includeAllInstances).withMaxResults(maxResults).withFilters(this.translateFilterDescriptions(filters)).withNextToken(nextToken);
        DescribeInstanceStatusResult result = this.getEc2Client().describeInstanceStatus(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, new InstanceStatusContainer(this.translateInstanceStatuses(result.getInstanceStatuses()), result.getNextToken()));
    }

    @Override
    public RequestResultPair<List<NetworkInterfaceDescription>> describeNetworkInterfaces(Map<String, List<String>> filters, String ... networkInterfaceIds) throws Exception {
        DescribeNetworkInterfacesRequest request = new DescribeNetworkInterfacesRequest().withFilters(this.translateFilterMap(filters)).withNetworkInterfaceIds(networkInterfaceIds);
        DescribeNetworkInterfacesResult result = this.getEc2Client().describeNetworkInterfaces(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateNetworkInterfaces(result.getNetworkInterfaces()));
    }

    @Override
    public RequestResultPair<Boolean> deleteNetworkInterface(String networkInterfaceId) throws Exception {
        DeleteNetworkInterfaceRequest request = new DeleteNetworkInterfaceRequest().withNetworkInterfaceId(networkInterfaceId);
        this.getEc2Client().deleteNetworkInterface(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<String> attachNetworkInterface(String networkInterfaceId, String instanceId, int deviceIndex) throws Exception {
        AttachNetworkInterfaceRequest request = new AttachNetworkInterfaceRequest().withNetworkInterfaceId(networkInterfaceId).withInstanceId(instanceId).withDeviceIndex(Integer.valueOf(deviceIndex));
        AttachNetworkInterfaceResult result = this.getEc2Client().attachNetworkInterface(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, result.getAttachmentId());
    }

    @Override
    public RequestResultPair<Boolean> detachNetworkInterface(String attachmentId, boolean force) throws Exception {
        DetachNetworkInterfaceRequest request = new DetachNetworkInterfaceRequest().withAttachmentId(attachmentId).withForce(Boolean.valueOf(force));
        this.getEc2Client().detachNetworkInterface(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<Boolean> modifyNetworkInterfaceAttribute(String networkInterfaceId, ModifyNetworkInterfaceAttributeDescription attribute) throws Exception {
        ModifyNetworkInterfaceAttributeRequest request = new ModifyNetworkInterfaceAttributeRequest().withNetworkInterfaceId(networkInterfaceId);
        switch (attribute.getType()) {
            case attachment: {
                request.withAttachment(new NetworkInterfaceAttachmentChanges().withAttachmentId(attribute.getNetworkInterfaceAttachmentId()).withDeleteOnTermination(attribute.getDeleteOnTermination()));
                break;
            }
            case description: {
                request.withDescription(attribute.getAttributeValue());
                break;
            }
            case group: {
                request.withGroups(attribute.getGroupdIds());
                break;
            }
            case sourceDestCheck: {
                request.withSourceDestCheck(attribute.getFlag());
            }
        }
        this.getEc2Client().modifyNetworkInterfaceAttribute(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<Boolean> resetNetworkInterfaceAttribute(String networkInterfaceId, NetworkInterfaceAttributeType type) throws Exception {
        ResetNetworkInterfaceAttributeRequest request = new ResetNetworkInterfaceAttributeRequest().withNetworkInterfaceId(networkInterfaceId);
        switch (type) {
            case sourceDestCheck: {
                request.setSourceDestCheck("");
                break;
            }
            default: {
                throw new RuntimeException("Cannot reset type: " + (Object)((Object)type));
            }
        }
        this.getEc2Client().resetNetworkInterfaceAttribute(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<NetworkInterfaceAttributeDescription> describeNetworkInterfaceAttribute(String networkInterfaceId, NetworkInterfaceAttributeType type) throws Exception {
        NetworkInterfaceAttributeDescription attributeDescription2;
        DescribeNetworkInterfaceAttributeRequest request = new DescribeNetworkInterfaceAttributeRequest().withNetworkInterfaceId(networkInterfaceId);
        switch (type) {
            case attachment: {
                request.setAttachment("");
                break;
            }
            case description: {
                request.setDescription("");
                break;
            }
            case group: {
                request.setGroups("");
                break;
            }
            case sourceDestCheck: {
                request.setSourceDestCheck("");
                break;
            }
            default: {
                throw new RuntimeException("Cannot describe attribute " + (Object)((Object)type));
            }
        }
        DescribeNetworkInterfaceAttributeResult result = this.getEc2Client().describeNetworkInterfaceAttribute(this.prepareRequest(request));
        switch (type) {
            case attachment: {
                attributeDescription2 = NetworkInterfaceAttributeDescription.createAttachmentAttribute(result.getNetworkInterfaceId(), this.translateNetworkInterfaceAttachment(result.getAttachment()));
                break;
            }
            case description: {
                attributeDescription2 = NetworkInterfaceAttributeDescription.createDescriptionAttribute(result.getNetworkInterfaceId(), result.getDescription());
                break;
            }
            case group: {
                attributeDescription2 = NetworkInterfaceAttributeDescription.createGroupsAttribute(result.getNetworkInterfaceId(), this.translateGroupIdentifiers(result.getGroups()));
                break;
            }
            case sourceDestCheck: {
                NetworkInterfaceAttributeDescription attributeDescription2 = NetworkInterfaceAttributeDescription.createSourceDestCheckAttribute(result.getNetworkInterfaceId(), result.getSourceDestCheck());
            }
            default: {
                throw new RuntimeException("Unreachable, because this has been checked before.");
            }
        }
        return this.createResponse((AmazonWebServiceRequest)request, attributeDescription2);
    }

    @Override
    public RequestResultPair<NetworkInterfaceDescription> createNetworkInterface(String subnetId, String description, Collection<String> securityGroupIds, String primaryPrivateIpAddress, Collection<String> secondaryPrivateIpAddresses, Integer secondaryPrivateIpCount) throws Exception {
        CreateNetworkInterfaceRequest request = new CreateNetworkInterfaceRequest().withSubnetId(subnetId).withDescription(description).withGroups(securityGroupIds).withPrivateIpAddresses(this.translatePrivateIpAddressesRequest(primaryPrivateIpAddress, secondaryPrivateIpAddresses)).withSecondaryPrivateIpAddressCount(secondaryPrivateIpCount);
        CreateNetworkInterfaceResult result = this.getEc2Client().createNetworkInterface(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, this.translateNetworkInterface(result.getNetworkInterface()));
    }

    public RequestResultPair<InstanceStatusContainer> describeInstanceStatus(String[] instanceIds, Integer maxResults, List<Filter> filters, String nextToken) throws Exception {
        DescribeInstanceStatusRequest request = new DescribeInstanceStatusRequest().withInstanceIds(instanceIds).withMaxResults(maxResults).withFilters(this.translateFilterDescriptions(filters)).withNextToken(nextToken);
        DescribeInstanceStatusResult result = this.getEc2Client().describeInstanceStatus(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, new InstanceStatusContainer(this.translateInstanceStatuses(result.getInstanceStatuses()), result.getNextToken()));
    }

    @Override
    public RequestResultPair<VolumeStatusContainer> describeVolumeStatus(String[] volumeIds, BigInteger maxResults, List<Filter> filters, String nextToken) throws Exception {
        DescribeVolumeStatusRequest request = new DescribeVolumeStatusRequest().withVolumeIds(volumeIds).withMaxResults(Integer.valueOf(maxResults.intValue())).withFilters(this.translateFilterDescriptions(filters)).withNextToken(nextToken);
        DescribeVolumeStatusResult result = this.getEc2Client().describeVolumeStatus(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, new VolumeStatusContainer(this.translateVolumeStatuses(result.getVolumeStatuses()), result.getNextToken()));
    }

    @Override
    public RequestResultPair<Boolean> enableVolumeIO(String volumeId) throws Exception {
        EnableVolumeIORequest request = new EnableVolumeIORequest().withVolumeId(volumeId);
        this.getEc2Client().enableVolumeIO(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<Boolean> modifyVolumeAttribute(String volumeId, ModifyVolumeAttributeDescription attribute) throws Exception {
        ModifyVolumeAttributeRequest request = new ModifyVolumeAttributeRequest().withVolumeId(volumeId);
        switch (attribute.getType()) {
            case autoEnableIO: {
                request.withAutoEnableIO(attribute.getFlag());
            }
        }
        this.getEc2Client().modifyVolumeAttribute(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    @Override
    public RequestResultPair<VolumeAttributeDescription> describeVolumeAttribute(String volumeId, VolumeAttributeType type) throws Exception {
        DescribeVolumeAttributeRequest request = new DescribeVolumeAttributeRequest().withVolumeId(volumeId).withAttribute(type.name());
        DescribeVolumeAttributeResult result = this.getEc2Client().describeVolumeAttribute(this.prepareRequest(request));
        VolumeAttributeDescription attributeDescription = null;
        switch (type) {
            case autoEnableIO: {
                attributeDescription = VolumeAttributeDescription.createAutoEnableIOAttribute(result.getVolumeId(), result.getAutoEnableIO());
                break;
            }
            case productCodes: {
                attributeDescription = VolumeAttributeDescription.createProductCodesAttribute(result.getVolumeId(), this.translateProductCodes(result.getProductCodes()));
            }
        }
        return this.createResponse((AmazonWebServiceRequest)request, attributeDescription);
    }

    @Override
    public RequestResultPair<Boolean> reportInstanceStatus(String[] instanceIds, String statusState, XMLGregorianCalendar startTime, XMLGregorianCalendar endTime, String[] reasonCodes, String description) throws Exception {
        ReportInstanceStatusRequest request = new ReportInstanceStatusRequest().withInstances(instanceIds).withStatus(statusState).withStartTime(this.translateGregorianCalendar(startTime)).withEndTime(this.translateGregorianCalendar(endTime)).withReasonCodes(reasonCodes).withDescription(description);
        this.getEc2Client().reportInstanceStatus(this.prepareRequest(request));
        return this.createResponse((AmazonWebServiceRequest)request, true);
    }

    private <T> RequestResultPair<T> createResponse(AmazonWebServiceRequest request, T result) {
        String requestId = this.getEc2Client().getCachedResponseMetadata(request).getRequestId();
        return new RequestResultPair<T>(result, requestId);
    }

    private Collection<BlockDeviceMapping> translateBlockDeviceMappingDescription(List<BlockDeviceMappingDescription> inBdms) {
        if (null == inBdms) {
            return null;
        }
        ArrayList<BlockDeviceMapping> outBdms = new ArrayList<BlockDeviceMapping>(inBdms.size());
        for (BlockDeviceMappingDescription inBdm : inBdms) {
            BlockDeviceMapping outBdm = new BlockDeviceMapping();
            outBdm.setDeviceName(inBdm.getDeviceName());
            switch (inBdm.getType()) {
                case EBS: {
                    outBdm.setEbs(this.translateSnapshotDescription(inBdm));
                    break;
                }
                case EPHEMERAL: {
                    outBdm.setVirtualName(inBdm.getVirtualName());
                    break;
                }
                case NO_DEVICE: {
                    String name = inBdm.getVirtualName();
                    if (null != name && !"".equals(name)) break;
                    outBdm.setNoDevice("");
                }
            }
            outBdms.add(outBdm);
        }
        return outBdms;
    }

    private EbsBlockDevice translateSnapshotDescription(BlockDeviceMappingDescription inBdms) {
        EbsSnapshotDescription snapshot = inBdms.getSnapshot();
        if (null == snapshot) {
            return null;
        }
        return new EbsBlockDevice().withSnapshotId(snapshot.getSnapshotId()).withDeleteOnTermination(snapshot.getDeleteOnTermination()).withVolumeSize(snapshot.getVolumeSize()).withVolumeType(inBdms.getVolumeType()).withIops(inBdms.getMaxIops());
    }

    private Collection<com.amazonaws.services.ec2.model.Filter> translateFilterDescriptions(List<Filter> filterDescriptions) {
        if (null == filterDescriptions) {
            return null;
        }
        ArrayList<com.amazonaws.services.ec2.model.Filter> filters = new ArrayList<com.amazonaws.services.ec2.model.Filter>(filterDescriptions.size());
        for (Filter filterDescription : filterDescriptions) {
            filters.add(new com.amazonaws.services.ec2.model.Filter().withName(filterDescription.getName()).withValues(filterDescription.getValues()));
        }
        return filters;
    }

    private List<ImageDescription> translateImages(List<Image> images) {
        if (null == images) {
            return null;
        }
        ArrayList<ImageDescription> imageDescriptions = new ArrayList<ImageDescription>(images.size());
        for (Image image : images) {
            imageDescriptions.add(new ImageDescription(image.getImageId(), image.getImageLocation(), image.getName(), image.getOwnerId(), image.getImageOwnerAlias(), image.getState(), image.isPublic(), image.getArchitecture(), this.translateProductCodes(image.getProductCodes()), image.getImageType(), image.getKernelId(), image.getRamdiskId(), image.getPlatform(), image.getDescription(), image.getRootDeviceType(), image.getVirtualizationType(), image.getHypervisor(), this.translateBlockDeviceMappings(image.getBlockDeviceMappings()), this.translateTags(image.getTags())));
        }
        return imageDescriptions;
    }

    private List<ResourceTagDescription> translateTags(List<Tag> tags) {
        if (null == tags) {
            return null;
        }
        ArrayList<ResourceTagDescription> resourceTagDescriptions = new ArrayList<ResourceTagDescription>(tags.size());
        for (Tag tag : tags) {
            resourceTagDescriptions.add(new ResourceTagDescription(tag.getKey(), tag.getValue()));
        }
        return resourceTagDescriptions;
    }

    private List<BlockDeviceMappingDescription> translateBlockDeviceMappings(List<BlockDeviceMapping> bdms) {
        if (null == bdms) {
            return null;
        }
        ArrayList<BlockDeviceMappingDescription> bdmds = new ArrayList<BlockDeviceMappingDescription>(bdms.size());
        for (BlockDeviceMapping bdm : bdms) {
            if (null != bdm.getEbs()) {
                bdmds.add(new BlockDeviceMappingDescription(bdm.getDeviceName(), BlockDeviceMappingDescription.Type.EBS, this.translateEbs(bdm.getEbs()), bdm.getEbs().getVolumeType(), bdm.getEbs().getIops()));
                continue;
            }
            if (null != bdm.getNoDevice()) {
                bdmds.add(new BlockDeviceMappingDescription(bdm.getDeviceName(), BlockDeviceMappingDescription.Type.NO_DEVICE));
                continue;
            }
            bdmds.add(new BlockDeviceMappingDescription(bdm.getDeviceName(), BlockDeviceMappingDescription.Type.EBS, bdm.getVirtualName()));
        }
        return bdmds;
    }

    private Collection<InstanceBlockDeviceMappingSpecification> translateInstanceBlockDeviceMappingDescrptions(List<InstanceBlockDeviceMappingDescription> bdmds) {
        if (null == bdmds) {
            return null;
        }
        ArrayList<InstanceBlockDeviceMappingSpecification> bdms = new ArrayList<InstanceBlockDeviceMappingSpecification>(bdmds.size());
        for (InstanceBlockDeviceMappingDescription bdmd : bdmds) {
            bdms.add(this.translateInstanceBlockDeviceDescription(bdmd));
        }
        return bdms;
    }

    private InstanceBlockDeviceMappingSpecification translateInstanceBlockDeviceDescription(InstanceBlockDeviceMappingDescription bdmd) {
        if (null == bdmd) {
            return null;
        }
        InstanceBlockDeviceMappingSpecification bdm = new InstanceBlockDeviceMappingSpecification().withDeviceName(bdmd.getDeviceName());
        switch (bdmd.getType()) {
            case EBS: {
                bdm.setEbs(this.translateVolumeDescription(bdmd.getVolume()));
                break;
            }
            case EPHEMERAL: {
                bdm.setVirtualName(bdmd.getVirtualName());
                break;
            }
            case NO_DEVICE: {
                bdm.setNoDevice(bdmd.getVirtualName());
                break;
            }
            default: {
                throw new RuntimeException("Got unknown block device type " + (Object)((Object)bdmd.getType()));
            }
        }
        return bdm;
    }

    private EbsInstanceBlockDeviceSpecification translateVolumeDescription(EbsVolumeDescription volume) {
        if (null == volume) {
            return null;
        }
        return new EbsInstanceBlockDeviceSpecification().withVolumeId(volume.getVolumeId()).withDeleteOnTermination(volume.getDeleteOnTermination()).withVolumeType(volume.getVolumeType()).withIops(volume.getIops());
    }

    private LaunchPermissionModifications translateLaunchPermissionDescription(ImageListAttribute.ImageListAttributeOperationType operationType, ImageListAttribute attribute) {
        if (null == attribute) {
            return null;
        }
        LaunchPermissionModifications modifications = new LaunchPermissionModifications();
        if (null == attribute.items) {
            return modifications;
        }
        ArrayList permissions = new ArrayList(attribute.items.size());
        switch (operationType) {
            case add: {
                modifications.setAdd(permissions);
                break;
            }
            case remove: {
                modifications.setRemove(permissions);
            }
        }
        block8: for (ImageListAttributeItem item : attribute.items) {
            LaunchPermission permission = new LaunchPermission();
            switch (item.type) {
                case group: {
                    permission.setGroup(item.value);
                    continue block8;
                }
                case userId: {
                    permission.setUserId(item.value);
                    continue block8;
                }
            }
            throw new RuntimeException("Unknown item type.");
        }
        return modifications;
    }

    private EbsSnapshotDescription translateEbs(EbsBlockDevice ebs) {
        if (null == ebs) {
            return null;
        }
        return new EbsSnapshotDescription(ebs.getSnapshotId(), ebs.getVolumeSize(), ebs.isDeleteOnTermination());
    }

    private List<ProductCodeDescription> translateProductCodes(List<ProductCode> productCodes) {
        if (null == productCodes) {
            return null;
        }
        ArrayList<ProductCodeDescription> productCodesOut = new ArrayList<ProductCodeDescription>(productCodes.size());
        for (ProductCode productCode : productCodes) {
            ProductCodeDescription p = new ProductCodeDescription();
            p.setCode(productCode.getProductCodeId());
            p.setType(productCode.getType());
            productCodesOut.add(p);
        }
        return productCodesOut;
    }

    private List<InstanceBlockDeviceMappingResponseDescription> translateInstanceBlockDeviceMappings(List<InstanceBlockDeviceMapping> bdms) {
        if (null == bdms) {
            return null;
        }
        ArrayList<InstanceBlockDeviceMappingResponseDescription> bdmds = new ArrayList<InstanceBlockDeviceMappingResponseDescription>(bdms.size());
        for (InstanceBlockDeviceMapping bdm : bdms) {
            bdmds.add(new InstanceBlockDeviceMappingResponseDescription(bdm.getDeviceName(), this.translateInstanceEbs(bdm.getEbs())));
        }
        return bdmds;
    }

    private EbsVolumeDescription translateInstanceEbs(EbsInstanceBlockDevice ebs) {
        if (null == ebs) {
            return null;
        }
        return new EbsVolumeDescription(ebs.getVolumeId(), ebs.isDeleteOnTermination(), ebs.getStatus(), this.translateDate(ebs.getAttachTime()), null, null);
    }

    private Calendar translateDateToCalendar(Date date) {
        if (null == date) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setTime(date);
        return calendar;
    }

    private XMLGregorianCalendar translateDate(Date date) {
        if (null == date) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setTime(date);
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(calendar);
        }
        catch (DatatypeConfigurationException e) {
            return null;
        }
    }

    private DescribeImageAttributeResult translateImageAttribute(ImageAttribute.ImageAttributeType imageAttributeType, com.amazonaws.services.ec2.model.ImageAttribute imageAttribute) {
        ImageAttribute attr;
        if (null == imageAttribute) {
            return null;
        }
        switch (imageAttributeType) {
            case blockDeviceMapping: {
                BlockDeviceMappingAttribute bdmAttr = new BlockDeviceMappingAttribute();
                List bdms = imageAttribute.getBlockDeviceMappings();
                if (null != bdms) {
                    for (BlockDeviceMapping bdm : bdms) {
                        bdmAttr.items.add(new ImageMapAttributeItem(ImageMapAttributeItem.ImageMapAttributeItemType.blockDeviceMap, bdm.getVirtualName(), bdm.getDeviceName()));
                    }
                }
                attr = bdmAttr;
                break;
            }
            case kernel: {
                attr = new KernelAttribute(imageAttribute.getKernelId());
                break;
            }
            case ramdisk: {
                attr = new RamdiskAttribute(imageAttribute.getRamdiskId());
                break;
            }
            case launchPermission: {
                LaunchPermissionAttribute lpAttr = new LaunchPermissionAttribute();
                List permissions = imageAttribute.getLaunchPermissions();
                if (null != permissions) {
                    for (LaunchPermission permission : permissions) {
                        if (null != permission.getGroup()) {
                            lpAttr.addImageListAttributeItem(ImageListAttributeItem.ImageListAttributeItemType.group, permission.getGroup());
                            continue;
                        }
                        lpAttr.addImageListAttributeItem(ImageListAttributeItem.ImageListAttributeItemType.userId, permission.getUserId());
                    }
                }
                attr = lpAttr;
                break;
            }
            case productCodes: {
                ProductCodesAttribute pcAttr = new ProductCodesAttribute();
                List codes = imageAttribute.getProductCodes();
                if (null != codes) {
                    for (ProductCode code : codes) {
                        pcAttr.addImageListAttributeItem(ImageListAttributeItem.ImageListAttributeItemType.productCode, "[" + code.getType() + ": " + code.getProductCodeId() + "]");
                    }
                }
                attr = pcAttr;
                break;
            }
            default: {
                throw new RuntimeException("Unknown attribute type " + (Object)((Object)imageAttributeType));
            }
        }
        return new DescribeImageAttributeResult(imageAttribute.getImageId(), attr);
    }

    private ReservationDescription translateReservation(Reservation reservation) {
        if (null == reservation) {
            return null;
        }
        ReservationDescription reservationDescription = new ReservationDescription(reservation.getOwnerId(), reservation.getReservationId(), reservation.getRequesterId());
        if (null != reservation.getGroups()) {
            for (GroupIdentifier group : reservation.getGroups()) {
                reservationDescription.addGroup(group.getGroupName());
            }
        }
        if (null != reservation.getInstances()) {
            for (Instance instance : reservation.getInstances()) {
                reservationDescription.addInstance(this.translateInstance(instance));
            }
        }
        return reservationDescription;
    }

    private ReservationDescription.Instance translateInstance(Instance instance) {
        if (null == instance) {
            return null;
        }
        return new ReservationDescription.Instance(instance.getImageId(), instance.getInstanceId(), instance.getPublicDnsName(), instance.getPrivateDnsName(), instance.getState().getName(), instance.getState().getCode(), this.translateStateReason(instance.getStateReason()), instance.getKeyName(), this.translateAmiLaunchIndex(instance.getAmiLaunchIndex()), this.translateProductCodes(instance.getProductCodes()), instance.getInstanceType(), this.translateDateToCalendar(instance.getLaunchTime()), this.translatePlacement(instance.getPlacement()), instance.getKernelId(), instance.getRamdiskId(), instance.getPlatform(), this.translateMonitoring(instance.getMonitoring()), instance.getVpcId(), instance.getSubnetId(), instance.getPublicIpAddress(), instance.getPrivateIpAddress(), instance.getRootDeviceType(), instance.getVirtualizationType(), instance.getHypervisor(), this.translateInstanceBlockDeviceMappings(instance.getBlockDeviceMappings()), instance.getInstanceLifecycle(), instance.getSpotInstanceRequestId(), this.translateInstanceLicense(instance.getLicense()), this.translateInstanceNetworkInterfaces(instance.getNetworkInterfaces()), instance.isEbsOptimized(), this.translateIamInstanceProfile(instance.getIamInstanceProfile()), instance.getClientToken(), this.translateTags(instance.getTags()), this.translateRunSecurityGroups(instance.getSecurityGroups()));
    }

    private IamInstanceProfile translateIamInstanceProfile(com.amazonaws.services.ec2.model.IamInstanceProfile profile) {
        if (null == profile) {
            return null;
        }
        return new IamInstanceProfile(profile.getId(), profile.getArn());
    }

    private String translateStateReason(StateReason stateReason) {
        return null == stateReason ? null : stateReason.getMessage();
    }

    private MonitorInstance.MonitoringState translateMonitoring(Monitoring monitoring) {
        if (null == monitoring) {
            return null;
        }
        return MonitorInstance.MonitoringState.valueOf(monitoring.getState());
    }

    private String translateAmiLaunchIndex(Integer amiLaunchIndex) {
        return amiLaunchIndex == null ? null : amiLaunchIndex.toString();
    }

    private List<String> translateRunSecurityGroups(List<GroupIdentifier> securityGroups) {
        if (null == securityGroups) {
            return null;
        }
        ArrayList<String> groupDescriptions = new ArrayList<String>(securityGroups.size());
        for (GroupIdentifier securityGroup : securityGroups) {
            groupDescriptions.add(securityGroup.getGroupId());
        }
        return groupDescriptions;
    }

    private InstanceLicense translateInstanceLicense(com.amazonaws.services.ec2.model.InstanceLicense license) {
        if (null == license) {
            return null;
        }
        return new InstanceLicense(license.getPool());
    }

    private InstancePlacement translatePlacement(Placement placement) {
        if (null == placement) {
            return null;
        }
        return new InstancePlacement(placement.getAvailabilityZone(), placement.getGroupName(), placement.getTenancy());
    }

    private InstanceLicenseSpecification translateInstanceLicenseDescription(String licensePool) {
        if (null == licensePool) {
            return null;
        }
        return new InstanceLicenseSpecification().withPool(licensePool);
    }

    private Placement translatePlacementDescription(PlacementDescription placement) {
        if (null == placement) {
            return null;
        }
        return new Placement().withAvailabilityZone(placement.getAvailabilityZone()).withGroupName(placement.getGroupName()).withTenancy(this.translateTenancyDescription(placement.getTenancy()));
    }

    private String translateTenancyDescription(Tenancy tenancy) {
        if (null == tenancy) {
            return null;
        }
        return tenancy.externalName();
    }

    private List<InstanceStateChangeDescription> translateInstanceStateChange(List<InstanceStateChange> instanceStateChanges) {
        if (null == instanceStateChanges) {
            return null;
        }
        ArrayList<InstanceStateChangeDescription> instanceStateChangeDescriptions = new ArrayList<InstanceStateChangeDescription>(instanceStateChanges.size());
        for (InstanceStateChange instanceStateChange : instanceStateChanges) {
            instanceStateChangeDescriptions.add(new InstanceStateChangeDescription(instanceStateChange.getInstanceId(), instanceStateChange.getPreviousState().getName(), instanceStateChange.getPreviousState().getCode(), instanceStateChange.getCurrentState().getName(), instanceStateChange.getCurrentState().getCode()));
        }
        return instanceStateChangeDescriptions;
    }

    private List<ReservationDescription> translateReservations(List<Reservation> reservations) {
        if (null == reservations) {
            return null;
        }
        ArrayList<ReservationDescription> reservationDescriptions = new ArrayList<ReservationDescription>(reservations.size());
        for (Reservation reservation : reservations) {
            reservationDescriptions.add(this.translateReservation(reservation));
        }
        return reservationDescriptions;
    }

    private List<PlacementGroupDescription> translatePlacementGroups(List<PlacementGroup> placementGroups) {
        if (null == placementGroups) {
            return null;
        }
        ArrayList<PlacementGroupDescription> result = new ArrayList<PlacementGroupDescription>(placementGroups.size());
        for (PlacementGroup placementGroup : placementGroups) {
            result.add(this.tranlsagePlacementGroup(placementGroup));
        }
        return result;
    }

    private PlacementGroupDescription tranlsagePlacementGroup(PlacementGroup placementGroup) {
        if (null == placementGroup) {
            return null;
        }
        PlacementGroupDescription result = new PlacementGroupDescription();
        result.setGroupName(placementGroup.getGroupName());
        result.setState(placementGroup.getState());
        result.setStrategy(placementGroup.getStrategy());
        return result;
    }

    private List<SecurityGroupDescription> translateSecurityGroups(List<SecurityGroup> securityGroups) {
        if (null == securityGroups) {
            return null;
        }
        ArrayList<SecurityGroupDescription> result = new ArrayList<SecurityGroupDescription>(securityGroups.size());
        for (SecurityGroup securityGroup : securityGroups) {
            result.add(this.translateSecurityGroup(securityGroup));
        }
        return result;
    }

    private SecurityGroupDescription translateSecurityGroup(SecurityGroup securityGroup) {
        if (null == securityGroup) {
            return null;
        }
        SecurityGroupDescription group = new SecurityGroupDescription(securityGroup.getGroupName(), securityGroup.getDescription(), securityGroup.getOwnerId(), securityGroup.getGroupId(), securityGroup.getVpcId());
        group.tags = this.translateTags(securityGroup.getTags());
        List permissions = securityGroup.getIpPermissions();
        this.addPermissions(group, permissions, false);
        List egress = securityGroup.getIpPermissionsEgress();
        this.addPermissions(group, egress, true);
        return group;
    }

    private void addPermissions(SecurityGroupDescription group, List<IpPermission> permissions, boolean isEgress) {
        if (permissions != null) {
            for (IpPermission permission : permissions) {
                List ipRanges;
                String protocol = permission.getIpProtocol();
                if ("-1".equals(protocol)) {
                    protocol = "all";
                }
                SecurityGroupDescription.IpPermission groupPerms = group.addPermission(protocol, permission.getFromPort(), permission.getToPort(), isEgress);
                List uidGroupPairs = permission.getUserIdGroupPairs();
                if (uidGroupPairs != null) {
                    for (com.amazonaws.services.ec2.model.UserIdGroupPair pair : uidGroupPairs) {
                        groupPerms.addUserGroupPair(pair.getUserId(), pair.getGroupId(), pair.getGroupName());
                    }
                }
                if ((ipRanges = permission.getIpRanges()) == null) continue;
                for (String range : ipRanges) {
                    groupPerms.addIpRange(range);
                }
            }
        }
    }

    private List<IpPermission> translateIpPermissionsDescription(List<SecurityGroupDescription.IpPermission> perms) {
        if (null == perms) {
            return null;
        }
        ArrayList<IpPermission> result = new ArrayList<IpPermission>(perms.size());
        for (SecurityGroupDescription.IpPermission perm : perms) {
            result.add(this.translateIpPermissionDescription(perm));
        }
        return result;
    }

    private IpPermission translateIpPermissionDescription(SecurityGroupDescription.IpPermission perm) {
        if (null == perm) {
            return null;
        }
        return new IpPermission().withFromPort(perm.fromPort).withIpProtocol(perm.protocol).withIpRanges(perm.cidrIps).withToPort(perm.toPort).withUserIdGroupPairs(this.translateUserIdGroupPairDescription(perm.uid_group_pairs));
    }

    private List<com.amazonaws.services.ec2.model.UserIdGroupPair> translateUserIdGroupPairDescription(List<UserIdGroupPair> uidGroupPairs) {
        if (null == uidGroupPairs) {
            return null;
        }
        ArrayList<com.amazonaws.services.ec2.model.UserIdGroupPair> result = new ArrayList<com.amazonaws.services.ec2.model.UserIdGroupPair>(uidGroupPairs.size());
        for (UserIdGroupPair uidGroupPair : uidGroupPairs) {
            result.add(this.translateUserIdGroupPairDescription(uidGroupPair));
        }
        return result;
    }

    private com.amazonaws.services.ec2.model.UserIdGroupPair translateUserIdGroupPairDescription(UserIdGroupPair uidGroupPair) {
        if (null == uidGroupPair) {
            return null;
        }
        return new com.amazonaws.services.ec2.model.UserIdGroupPair().withGroupId(uidGroupPair.getGroupId()).withGroupName(uidGroupPair.getName()).withUserId(uidGroupPair.getUserId());
    }

    private List<KeyPairInfo> translateKeyPairs(List<com.amazonaws.services.ec2.model.KeyPairInfo> keyPairs) {
        if (null == keyPairs) {
            return null;
        }
        ArrayList<KeyPairInfo> result = new ArrayList<KeyPairInfo>(keyPairs.size());
        for (com.amazonaws.services.ec2.model.KeyPairInfo keyPair : keyPairs) {
            result.add(this.translateKeyPair(keyPair));
        }
        return result;
    }

    private KeyPairInfo translateKeyPair(com.amazonaws.services.ec2.model.KeyPairInfo keyPair) {
        if (null == keyPair) {
            return null;
        }
        return new KeyPairInfo(keyPair.getKeyName(), keyPair.getKeyFingerprint(), null);
    }

    private List<AvailabilityZoneDescription> translateAvailabilityZones(List<AvailabilityZone> availabilityZones) {
        if (null == availabilityZones) {
            return null;
        }
        ArrayList<AvailabilityZoneDescription> result = new ArrayList<AvailabilityZoneDescription>(availabilityZones.size());
        for (AvailabilityZone availabilityZone : availabilityZones) {
            result.add(this.translateAvailabilityZone(availabilityZone));
        }
        return result;
    }

    private AvailabilityZoneDescription translateAvailabilityZone(AvailabilityZone availabilityZone) {
        if (null == availabilityZone) {
            return null;
        }
        return new AvailabilityZoneDescription(availabilityZone.getZoneName(), availabilityZone.getState(), availabilityZone.getRegionName(), this.translateAvailabilityZoneMessages(availabilityZone.getMessages()));
    }

    private List<String> translateAvailabilityZoneMessages(List<AvailabilityZoneMessage> input) {
        if (null == input) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(input.size());
        for (AvailabilityZoneMessage item : input) {
            result.add(item.getMessage());
        }
        return result;
    }

    private List<RegionDescription> translateRegions(List<Region> regions) {
        if (null == regions) {
            return null;
        }
        ArrayList<RegionDescription> result = new ArrayList<RegionDescription>(regions.size());
        for (Region region : regions) {
            result.add(this.translateRegion(region));
        }
        return result;
    }

    private RegionDescription translateRegion(Region region) {
        if (null == region) {
            return null;
        }
        return new RegionDescription(region.getRegionName(), region.getEndpoint());
    }

    private List<AddressInfo> translateAddresses(List<Address> addresses) {
        if (null == addresses) {
            return null;
        }
        ArrayList<AddressInfo> result = new ArrayList<AddressInfo>(addresses.size());
        for (Address address : addresses) {
            result.add(this.translateAddress(address));
        }
        return result;
    }

    private AddressInfo translateAddress(Address address) {
        if (null == address) {
            return null;
        }
        return new AddressInfo(address.getPublicIp(), address.getInstanceId(), address.getAllocationId(), address.getDomain(), address.getAssociationId(), address.getNetworkInterfaceId(), address.getPrivateIpAddress());
    }

    private List<BundleInstanceTask> tranlsateBundleTasks(List<BundleTask> bundleTasks) {
        if (null == bundleTasks) {
            return null;
        }
        ArrayList<BundleInstanceTask> result = new ArrayList<BundleInstanceTask>(bundleTasks.size());
        for (BundleTask bundleTask : bundleTasks) {
            result.add(this.translateBundleTask(bundleTask));
        }
        return result;
    }

    private BundleInstanceTask translateBundleTask(BundleTask task) {
        String bucket = null;
        String prefix = null;
        if (null != task.getStorage() && null != task.getStorage().getS3()) {
            bucket = task.getStorage().getS3().getBucket();
            prefix = task.getStorage().getS3().getPrefix();
        }
        String bundleErrorCode = "";
        String bundleErrorMessage = "";
        if (task.getBundleTaskError() != null) {
            bundleErrorCode = task.getBundleTaskError().getCode();
            bundleErrorMessage = task.getBundleTaskError().getMessage();
        }
        return new BundleInstanceTask(task.getBundleId(), task.getInstanceId(), bucket, prefix, task.getState(), this.translateDateToCalendar(task.getStartTime()), this.translateDateToCalendar(task.getUpdateTime()), task.getProgress(), bundleErrorCode, bundleErrorMessage);
    }

    private List<VolumeDescription> translateVolumes(List<Volume> volumes) {
        if (null == volumes) {
            return null;
        }
        ArrayList<VolumeDescription> result = new ArrayList<VolumeDescription>(volumes.size());
        for (Volume volume : volumes) {
            result.add(this.translateVolume(volume));
        }
        return result;
    }

    private VolumeDescription translateVolume(Volume volume) {
        if (null == volume) {
            return null;
        }
        Integer iopsValue = null;
        if (null != volume.getIops()) {
            iopsValue = new Integer(volume.getIops());
        }
        return new VolumeDescription(volume.getVolumeId(), volume.getSize() == null ? null : volume.getSize().toString(), volume.getSnapshotId(), volume.getAvailabilityZone(), volume.getState(), this.translateDateToCalendar(volume.getCreateTime()), this.translateTags(volume.getTags()), volume.getVolumeType(), iopsValue);
    }

    private AttachmentDescription translateVolumeAttachment(VolumeAttachment attachment) {
        if (null == attachment) {
            return null;
        }
        return new AttachmentDescription(attachment.getVolumeId(), attachment.getInstanceId(), attachment.getDevice(), attachment.getState(), this.translateDateToCalendar(attachment.getAttachTime()));
    }

    private List<SnapshotDescription> translateSnapshots(List<Snapshot> snapshots) {
        if (null == snapshots) {
            return null;
        }
        ArrayList<SnapshotDescription> result = new ArrayList<SnapshotDescription>(snapshots.size());
        for (Snapshot snapshot : snapshots) {
            result.add(this.translateSnapshot(snapshot));
        }
        return result;
    }

    private SnapshotDescription translateSnapshot(Snapshot snapshot) {
        if (null == snapshot) {
            return null;
        }
        return new SnapshotDescription(snapshot.getSnapshotId(), snapshot.getVolumeId(), snapshot.getState(), this.translateDateToCalendar(snapshot.getStartTime()), snapshot.getProgress(), snapshot.getOwnerId(), this.translateIntegerToString(snapshot.getVolumeSize()), snapshot.getDescription());
    }

    private List<ReservedInstancesOfferingDescription> translateReservedInstancesOfferings(List<ReservedInstancesOffering> reservedInstancesOfferings) {
        if (null == reservedInstancesOfferings) {
            return null;
        }
        ArrayList<ReservedInstancesOfferingDescription> result = new ArrayList<ReservedInstancesOfferingDescription>(reservedInstancesOfferings.size());
        for (ReservedInstancesOffering reservedInstancesOffering : reservedInstancesOfferings) {
            result.add(this.translateReservedInstancesOffering(reservedInstancesOffering));
        }
        return result;
    }

    private ReservedInstancesOfferingDescription translateReservedInstancesOffering(ReservedInstancesOffering offering) {
        if (null == offering) {
            return null;
        }
        return new ReservedInstancesOfferingDescription(offering.getReservedInstancesOfferingId(), offering.getAvailabilityZone(), offering.getInstanceType(), offering.getDuration(), offering.getFixedPrice().floatValue(), offering.getUsagePrice().floatValue(), offering.getProductDescription(), offering.getCurrencyCode(), offering.getInstanceTenancy(), null);
    }

    private List<ReservedInstancesDescription> translateReservedInstancesList(List<ReservedInstances> reservedInstances) {
        if (null == reservedInstances) {
            return null;
        }
        ArrayList<ReservedInstancesDescription> result = new ArrayList<ReservedInstancesDescription>(reservedInstances.size());
        for (ReservedInstances ri : reservedInstances) {
            result.add(this.translateReservedInstancesItem(ri));
        }
        return result;
    }

    private ReservedInstancesDescription translateReservedInstancesItem(ReservedInstances ri) {
        if (null == ri) {
            return null;
        }
        return new ReservedInstancesDescription(ri.getReservedInstancesId(), ri.getAvailabilityZone(), ri.getInstanceType(), ri.getDuration(), ri.getFixedPrice().floatValue(), ri.getUsagePrice().floatValue(), ri.getProductDescription(), this.translateDateToCalendar(ri.getStart()), ri.getInstanceCount(), ri.getCurrencyCode(), ri.getInstanceTenancy(), ri.getState(), ri.getOfferingType(), this.translateTags(ri.getTags()));
    }

    private List<MonitorInstance> translateInstanceMonitoring(List<InstanceMonitoring> instanceMonitorings) {
        if (null == instanceMonitorings) {
            return null;
        }
        ArrayList<MonitorInstance> result = new ArrayList<MonitorInstance>(instanceMonitorings.size());
        for (InstanceMonitoring im : instanceMonitorings) {
            result.add(this.translateInstanceMonitoring(im));
        }
        return result;
    }

    private MonitorInstance translateInstanceMonitoring(InstanceMonitoring im) {
        if (null == im) {
            return null;
        }
        return new MonitorInstance(im.getInstanceId(), this.translateMonitoring(im.getMonitoring()));
    }

    private VpnGatewayAttachmentDescription translateVpcAttachment(VpcAttachment vpcAttachement) {
        if (null == vpcAttachement) {
            return null;
        }
        return new VpnGatewayAttachmentDescription(vpcAttachement.getVpcId(), vpcAttachement.getState());
    }

    private VpcDescription translateVpc(Vpc vpc) {
        if (null == vpc) {
            return null;
        }
        return new VpcDescription(vpc.getVpcId(), vpc.getState(), vpc.getCidrBlock(), vpc.getDhcpOptionsId(), vpc.getInstanceTenancy(), this.translateTags(vpc.getTags()));
    }

    private CustomerGatewayDescription translateCustomerGateway(CustomerGateway customerGateway) {
        if (null == customerGateway) {
            return null;
        }
        return new CustomerGatewayDescription(customerGateway.getCustomerGatewayId(), customerGateway.getState(), customerGateway.getType(), customerGateway.getIpAddress(), this.translateStringToInteger(customerGateway.getBgpAsn()), this.translateTags(customerGateway.getTags()));
    }

    private DhcpOptionsDescription translateDhcpOptions(DhcpOptions dhcpOptions) {
        if (null == dhcpOptions) {
            return null;
        }
        return new DhcpOptionsDescription(dhcpOptions.getDhcpOptionsId(), this.translateDhcpConfigurations(dhcpOptions.getDhcpConfigurations()), this.translateTags(dhcpOptions.getTags()));
    }

    private Map<String, List<String>> translateDhcpConfigurations(List<DhcpConfiguration> dhcpConfigurations) {
        if (null == dhcpConfigurations) {
            return null;
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (DhcpConfiguration configuration : dhcpConfigurations) {
            result.put(configuration.getKey(), configuration.getValues());
        }
        return result;
    }

    private List<DhcpConfiguration> translateDhcpOptionsMap(Map<String, List<String>> options) {
        if (null == options) {
            return null;
        }
        ArrayList<DhcpConfiguration> result = new ArrayList<DhcpConfiguration>(options.size());
        for (Map.Entry<String, List<String>> entry : options.entrySet()) {
            result.add(new DhcpConfiguration().withKey(entry.getKey()).withValues((Collection)entry.getValue()));
        }
        return result;
    }

    private List<SpotInstanceRequestDescription> translateSpotInstanceRequests(List<SpotInstanceRequest> spotInstanceRequests) {
        if (null == spotInstanceRequests) {
            return null;
        }
        ArrayList<SpotInstanceRequestDescription> result = new ArrayList<SpotInstanceRequestDescription>(spotInstanceRequests.size());
        for (SpotInstanceRequest spotInstanceRequest : spotInstanceRequests) {
            result.add(this.translateSpotInstanceRequest(spotInstanceRequest));
        }
        return result;
    }

    private SpotInstanceRequestDescription translateSpotInstanceRequest(SpotInstanceRequest spotInstanceRequest) {
        if (null == spotInstanceRequest) {
            return null;
        }
        SpotInstanceStateFault fault = spotInstanceRequest.getFault();
        String faultCode = null;
        String faultMessage = null;
        if (null != fault) {
            faultCode = fault.getCode();
            faultMessage = fault.getMessage();
        }
        return new SpotInstanceRequestDescription(spotInstanceRequest.getSpotPrice(), spotInstanceRequest.getSpotInstanceRequestId(), spotInstanceRequest.getState(), faultCode, faultMessage, spotInstanceRequest.getType(), spotInstanceRequest.getInstanceId(), spotInstanceRequest.getLaunchGroup(), spotInstanceRequest.getAvailabilityZoneGroup(), spotInstanceRequest.getCreateTime(), spotInstanceRequest.getValidUntil(), spotInstanceRequest.getValidFrom(), spotInstanceRequest.getProductDescription(), this.translateLaunchSpecificationResponse(spotInstanceRequest.getLaunchSpecification()), this.translateTags(spotInstanceRequest.getTags()), spotInstanceRequest.getLaunchedAvailabilityZone());
    }

    private LaunchSpecification translateLaunchSpecification(com.amazonaws.services.ec2.model.LaunchSpecification launchSpecification) {
        if (null == launchSpecification) {
            return null;
        }
        HashMap<String, String> blockDeviceMapping = null;
        List blockDeviceMappings = launchSpecification.getBlockDeviceMappings();
        if (null != blockDeviceMappings) {
            blockDeviceMapping = new HashMap<String, String>();
            for (BlockDeviceMapping item : blockDeviceMappings) {
                blockDeviceMapping.put(item.getVirtualName(), item.getDeviceName());
            }
        }
        ArrayList<String> groupIds = null;
        List securityGroups = launchSpecification.getAllSecurityGroups();
        if (null != securityGroups) {
            groupIds = new ArrayList<String>();
            for (GroupIdentifier curGroup : securityGroups) {
                groupIds.add(curGroup.getGroupId());
            }
        }
        return new LaunchSpecification(launchSpecification.getImageId(), launchSpecification.getKeyName(), groupIds, launchSpecification.getAddressingType(), launchSpecification.getInstanceType(), blockDeviceMapping, launchSpecification.getKernelId(), launchSpecification.getRamdiskId(), this.extractAvailabilityZone(launchSpecification.getPlacement()), launchSpecification.getMonitoringEnabled(), launchSpecification.isEbsOptimized(), launchSpecification.getSubnetId(), this.translateInstanceNetworkInterfaceSpecifications(launchSpecification.getNetworkInterfaces()), this.translateIamInstanceProfileRequest(launchSpecification.getIamInstanceProfile()));
    }

    private IamInstanceProfileRequestDescription translateIamInstanceProfileRequest(IamInstanceProfileRequest iamInstanceProfile) {
        if (null == iamInstanceProfile) {
            return null;
        }
        return new IamInstanceProfileRequestDescription(iamInstanceProfile.getArn(), iamInstanceProfile.getName());
    }

    private LaunchSpecification translateLaunchSpecificationResponse(LaunchSpecificationResponse launchSpecification) {
        if (null == launchSpecification) {
            return null;
        }
        HashMap<String, String> blockDeviceMapping = null;
        List blockDeviceMappings = launchSpecification.getBlockDeviceMappings();
        if (null != blockDeviceMappings) {
            blockDeviceMapping = new HashMap<String, String>();
            for (BlockDeviceMapping item : blockDeviceMappings) {
                blockDeviceMapping.put(item.getVirtualName(), item.getDeviceName());
            }
        }
        ArrayList<String> groupIds = null;
        List securityGroups = launchSpecification.getAllSecurityGroups();
        if (null != securityGroups) {
            groupIds = new ArrayList<String>();
            for (GroupIdentifier curGroup : securityGroups) {
                groupIds.add(curGroup.getGroupId());
            }
        }
        boolean ebsOptimized = false;
        if (null != launchSpecification.getEbsOptimized()) {
            ebsOptimized = launchSpecification.getEbsOptimized();
        }
        return new LaunchSpecification(launchSpecification.getImageId(), launchSpecification.getKeyName(), groupIds, launchSpecification.getAddressingType(), launchSpecification.getInstanceType(), blockDeviceMapping, launchSpecification.getKernelId(), launchSpecification.getRamdiskId(), this.extractAvailabilityZone(launchSpecification.getPlacement()), launchSpecification.getMonitoringEnabled(), ebsOptimized, launchSpecification.getSubnetId(), this.translateInstanceNetworkInterfaceResponses(launchSpecification.getNetworkInterfaces()), this.translateIamInstanceProfileRequest(launchSpecification.getIamInstanceProfile()));
    }

    private VpnConnectionDescription translateVpnConnection(VpnConnection vpnConnection) {
        if (null == vpnConnection) {
            return null;
        }
        return new VpnConnectionDescription(vpnConnection.getVpnConnectionId(), vpnConnection.getState(), vpnConnection.getCustomerGatewayConfiguration(), vpnConnection.getType(), vpnConnection.getCustomerGatewayId(), vpnConnection.getVpnGatewayId(), this.translateTags(vpnConnection.getTags()), this.translateVgwTelemetries(vpnConnection.getVgwTelemetry()));
    }

    private VpnGatewayDescription translateVpnGateway(VpnGateway vpnGateway) {
        if (null == vpnGateway) {
            return null;
        }
        return new VpnGatewayDescription(vpnGateway.getVpnGatewayId(), vpnGateway.getState(), vpnGateway.getType(), vpnGateway.getAvailabilityZone(), this.translateVpcAttachments(vpnGateway.getVpcAttachments()), this.translateTags(vpnGateway.getTags()));
    }

    private List<VpnGatewayAttachmentDescription> translateVpcAttachments(List<VpcAttachment> vpcAttachments) {
        if (null == vpcAttachments) {
            return null;
        }
        ArrayList<VpnGatewayAttachmentDescription> result = new ArrayList<VpnGatewayAttachmentDescription>(vpcAttachments.size());
        for (VpcAttachment attachment : vpcAttachments) {
            result.add(this.translateVpcAttachment(attachment));
        }
        return result;
    }

    private SubnetDescription translateSubnet(Subnet subnet) {
        if (null == subnet) {
            return null;
        }
        return new SubnetDescription(subnet.getSubnetId(), subnet.getState(), subnet.getVpcId(), subnet.getCidrBlock(), subnet.getAvailableIpAddressCount(), subnet.getAvailabilityZone(), this.translateTags(subnet.getTags()));
    }

    private List<CancelSpotInstanceRequestDescription> translateCancelledSpotInstanceRequests(List<CancelledSpotInstanceRequest> requests) {
        if (null == requests) {
            return null;
        }
        ArrayList<CancelSpotInstanceRequestDescription> result = new ArrayList<CancelSpotInstanceRequestDescription>(requests.size());
        for (CancelledSpotInstanceRequest request : requests) {
            result.add(this.translateCancelledSpotInstanceRequest(request));
        }
        return result;
    }

    private CancelSpotInstanceRequestDescription translateCancelledSpotInstanceRequest(CancelledSpotInstanceRequest request) {
        if (null == request) {
            return null;
        }
        return new CancelSpotInstanceRequestDescription(request.getSpotInstanceRequestId(), request.getState());
    }

    private SpotPriceHistoryContainer translateSpotPriceHistory(List<SpotPrice> spotPriceHistory, String nextToken) {
        return new SpotPriceHistoryContainer(this.translateSpotPriceHistory(spotPriceHistory), nextToken);
    }

    private List<SpotPriceHistoryDescription> translateSpotPriceHistory(List<SpotPrice> spotPriceHistory) {
        if (null == spotPriceHistory) {
            return null;
        }
        ArrayList<SpotPriceHistoryDescription> result = new ArrayList<SpotPriceHistoryDescription>(spotPriceHistory.size());
        for (SpotPrice price : spotPriceHistory) {
            result.add(this.translateSpotPrice(price));
        }
        return result;
    }

    private SpotPriceHistoryDescription translateSpotPrice(SpotPrice price) {
        if (null == price) {
            return null;
        }
        return new SpotPriceHistoryDescription(price.getInstanceType(), price.getProductDescription(), price.getTimestamp(), price.getSpotPrice(), price.getAvailabilityZone());
    }

    private SpotDatafeedSubscription translateSpotDataFeedSubscription(com.amazonaws.services.ec2.model.SpotDatafeedSubscription spotDatafeedSubscription) {
        if (null == spotDatafeedSubscription) {
            return null;
        }
        return new SpotDatafeedSubscription(spotDatafeedSubscription.getOwnerId(), spotDatafeedSubscription.getBucket(), spotDatafeedSubscription.getPrefix(), spotDatafeedSubscription.getState());
    }

    private List<VpcDescription> translateVpcs(List<Vpc> vpcs) {
        if (null == vpcs) {
            return null;
        }
        ArrayList<VpcDescription> result = new ArrayList<VpcDescription>(vpcs.size());
        for (Vpc vpc : vpcs) {
            result.add(this.translateVpc(vpc));
        }
        return result;
    }

    private List<com.amazonaws.services.ec2.model.Filter> translateFilterMap(Map<String, List<String>> filterMap) {
        if (null == filterMap) {
            return null;
        }
        ArrayList<com.amazonaws.services.ec2.model.Filter> result = new ArrayList<com.amazonaws.services.ec2.model.Filter>(filterMap.size());
        for (Map.Entry<String, List<String>> entry : filterMap.entrySet()) {
            result.add(new com.amazonaws.services.ec2.model.Filter(entry.getKey(), entry.getValue()));
        }
        return result;
    }

    private List<CustomerGatewayDescription> translateCustomerGateways(List<CustomerGateway> customerGateways) {
        if (null == customerGateways) {
            return null;
        }
        ArrayList<CustomerGatewayDescription> result = new ArrayList<CustomerGatewayDescription>(customerGateways.size());
        for (CustomerGateway customerGateway : customerGateways) {
            result.add(this.translateCustomerGateway(customerGateway));
        }
        return result;
    }

    private List<DhcpOptionsDescription> translateDhcpOptions(List<DhcpOptions> input) {
        if (null == input) {
            return null;
        }
        ArrayList<DhcpOptionsDescription> result = new ArrayList<DhcpOptionsDescription>(input.size());
        for (DhcpOptions item : input) {
            result.add(this.translateDhcpOptions(item));
        }
        return result;
    }

    private List<VpnGatewayDescription> translateVpnGateways(List<VpnGateway> input) {
        if (null == input) {
            return null;
        }
        ArrayList<VpnGatewayDescription> result = new ArrayList<VpnGatewayDescription>(input.size());
        for (VpnGateway item : input) {
            result.add(this.translateVpnGateway(item));
        }
        return result;
    }

    private List<VpnConnectionDescription> translateVpnConnections(List<VpnConnection> input) {
        if (null == input) {
            return null;
        }
        ArrayList<VpnConnectionDescription> result = new ArrayList<VpnConnectionDescription>(input.size());
        for (VpnConnection item : input) {
            result.add(this.translateVpnConnection(item));
        }
        return result;
    }

    private List<SubnetDescription> translateSubnets(List<Subnet> input) {
        if (null == input) {
            return null;
        }
        ArrayList<SubnetDescription> result = new ArrayList<SubnetDescription>(input.size());
        for (Subnet item : input) {
            result.add(this.translateSubnet(item));
        }
        return result;
    }

    private List<License> translateLicenses(List<com.amazonaws.services.ec2.model.License> input) {
        if (null == input) {
            return null;
        }
        ArrayList<License> result = new ArrayList<License>(input.size());
        for (com.amazonaws.services.ec2.model.License item : input) {
            result.add(this.translateLicense(item));
        }
        return result;
    }

    private License translateLicense(com.amazonaws.services.ec2.model.License license) {
        if (null == license) {
            return null;
        }
        return new License(license.getLicenseId(), license.getType(), license.getPool(), this.translateTags(license.getTags()));
    }

    private List<Tag> translateTagTypes(List<TagType> input) {
        if (null == input) {
            return null;
        }
        ArrayList<Tag> result = new ArrayList<Tag>(input.size());
        for (TagType item : input) {
            result.add(this.translateTagType(item));
        }
        return result;
    }

    private Tag translateTagType(TagType tag) {
        if (null == tag) {
            return null;
        }
        return new Tag().withKey(tag.getKey()).withValue(tag.getValue());
    }

    private List<TagDescription> translateTagDescriptions(List<com.amazonaws.services.ec2.model.TagDescription> input) {
        if (null == input) {
            return null;
        }
        ArrayList<TagDescription> result = new ArrayList<TagDescription>(input.size());
        for (com.amazonaws.services.ec2.model.TagDescription item : input) {
            result.add(this.translateTagDescription(item));
        }
        return result;
    }

    private TagDescription translateTagDescription(com.amazonaws.services.ec2.model.TagDescription tag) {
        if (null == tag) {
            return null;
        }
        return new TagDescription(tag.getResourceId(), tag.getResourceType(), tag.getKey(), tag.getValue());
    }

    private List<NetworkAclDescription> translateNetworkAcls(List<NetworkAcl> input) {
        if (null == input) {
            return null;
        }
        ArrayList<NetworkAclDescription> result = new ArrayList<NetworkAclDescription>(input.size());
        for (NetworkAcl item : input) {
            result.add(this.translateNetworkAcl(item));
        }
        return result;
    }

    private NetworkAclDescription translateNetworkAcl(NetworkAcl acl) {
        if (null == acl) {
            return null;
        }
        return new NetworkAclDescription(acl.getNetworkAclId(), acl.getVpcId(), this.translateNetworkAsssociations(acl.getAssociations()), this.translateNetworkAclEntries(acl.getEntries()), this.translateTags(acl.getTags()), acl.getIsDefault());
    }

    private List<NetworkAclEntryDescription> translateNetworkAclEntries(List<NetworkAclEntry> input) {
        if (null == input) {
            return null;
        }
        ArrayList<NetworkAclEntryDescription> result = new ArrayList<NetworkAclEntryDescription>(input.size());
        for (NetworkAclEntry item : input) {
            result.add(this.translateNetworkAclEntry(item));
        }
        return result;
    }

    private NetworkAclEntryDescription translateNetworkAclEntry(NetworkAclEntry entry) {
        if (null == entry) {
            return null;
        }
        String protocol = entry.getProtocol();
        if ("-1".equals(protocol)) {
            protocol = "all";
        }
        return new NetworkAclEntryDescription(entry.getRuleAction(), entry.getCidrBlock(), this.translateIcmpTypeCode(entry.getIcmpTypeCode()), this.translatePortRange(entry.getPortRange()), protocol, entry.getRuleNumber(), entry.isEgress());
    }

    private IcmpTypeCodeDescription translateIcmpTypeCode(IcmpTypeCode icmpTypeCode) {
        if (null == icmpTypeCode) {
            return null;
        }
        return new IcmpTypeCodeDescription(icmpTypeCode.getCode(), icmpTypeCode.getType());
    }

    private PortRangeDescription translatePortRange(PortRange portRange) {
        if (null == portRange) {
            return null;
        }
        return new PortRangeDescription(portRange.getFrom(), portRange.getTo());
    }

    private List<NetworkAclAssociationDescription> translateNetworkAsssociations(List<NetworkAclAssociation> input) {
        if (null == input) {
            return null;
        }
        ArrayList<NetworkAclAssociationDescription> result = new ArrayList<NetworkAclAssociationDescription>(input.size());
        for (NetworkAclAssociation item : input) {
            result.add(this.translateNetworkAsssociation(item));
        }
        return result;
    }

    private NetworkAclAssociationDescription translateNetworkAsssociation(NetworkAclAssociation association) {
        if (null == association) {
            return null;
        }
        return new NetworkAclAssociationDescription(association.getNetworkAclAssociationId(), association.getNetworkAclId(), association.getSubnetId());
    }

    private IcmpTypeCode translateIcmpArray(int[] icmpArray) {
        if (null == icmpArray) {
            return null;
        }
        IcmpTypeCode code = new IcmpTypeCode();
        if (icmpArray.length >= 1) {
            code.setType(Integer.valueOf(icmpArray[0]));
            if (icmpArray.length >= 2) {
                code.setCode(Integer.valueOf(icmpArray[1]));
            }
        }
        return code;
    }

    private PortRange translatePortRangeArray(int[] rangeArray) {
        if (null == rangeArray) {
            return null;
        }
        return new PortRange().withFrom(Integer.valueOf(rangeArray[0])).withTo(Integer.valueOf(rangeArray[1]));
    }

    private List<RouteTableDescription> translateRouteTables(List<RouteTable> input) {
        if (null == input) {
            return null;
        }
        ArrayList<RouteTableDescription> result = new ArrayList<RouteTableDescription>(input.size());
        for (RouteTable item : input) {
            result.add(this.translateRouteTable(item));
        }
        return result;
    }

    private RouteTableDescription translateRouteTable(RouteTable routeTable) {
        if (null == routeTable) {
            return null;
        }
        return new RouteTableDescription(routeTable.getRouteTableId(), this.translateRouteTableAssociations(routeTable.getAssociations()), this.translateRoutes(routeTable.getRoutes()), routeTable.getVpcId(), this.translateTags(routeTable.getTags()));
    }

    private List<RouteDescription> translateRoutes(List<Route> input) {
        if (null == input) {
            return null;
        }
        ArrayList<RouteDescription> result = new ArrayList<RouteDescription>(input.size());
        for (Route item : input) {
            result.add(this.translateRoute(item));
        }
        return result;
    }

    private RouteDescription translateRoute(Route route) {
        if (null == route) {
            return null;
        }
        return new RouteDescription(route.getDestinationCidrBlock(), route.getGatewayId(), route.getInstanceId(), route.getNetworkInterfaceId(), route.getState());
    }

    private List<RouteTableAssociationDescription> translateRouteTableAssociations(List<RouteTableAssociation> input) {
        if (null == input) {
            return null;
        }
        ArrayList<RouteTableAssociationDescription> result = new ArrayList<RouteTableAssociationDescription>(input.size());
        for (RouteTableAssociation item : input) {
            result.add(this.translateRouteTableAssociation(item));
        }
        return result;
    }

    private RouteTableAssociationDescription translateRouteTableAssociation(RouteTableAssociation association) {
        if (null == association) {
            return null;
        }
        return new RouteTableAssociationDescription(association.getRouteTableAssociationId(), association.getRouteTableId(), association.getSubnetId(), association.isMain());
    }

    private List<PrivateIpAddress> translatePrivateIpAddressesRequest(String primary, Collection<String> secondary) {
        if (null == primary && null == secondary) {
            return null;
        }
        ArrayList<PrivateIpAddress> addresses = new ArrayList<PrivateIpAddress>();
        if (null != primary) {
            PrivateIpAddress address = new PrivateIpAddress().withPrivateIpAddress(primary).withPrimary(Boolean.valueOf(true));
            addresses.add(address);
        }
        if (null != secondary) {
            for (String ip : secondary) {
                PrivateIpAddress address = new PrivateIpAddress().withPrivateIpAddress(ip);
                addresses.add(address);
            }
        }
        return addresses;
    }

    private List<InstancePrivateIpAddress> translateInstancePrivateIpAddressesRequest(String primary, Collection<String> secondary) {
        if (null == primary && null == secondary) {
            return null;
        }
        ArrayList<InstancePrivateIpAddress> addresses = new ArrayList<InstancePrivateIpAddress>();
        if (null != primary) {
            InstancePrivateIpAddress address = new InstancePrivateIpAddress().withPrivateIpAddress(primary).withPrimary(Boolean.valueOf(true));
            addresses.add(address);
        }
        if (null != secondary) {
            for (String ip : secondary) {
                InstancePrivateIpAddress address = new InstancePrivateIpAddress().withPrivateIpAddress(ip);
                addresses.add(address);
            }
        }
        return addresses;
    }

    private List<InstanceNetworkInterfaceSpecification> translateNetworkInterfaceAttachmentRequests(List<NetworkInterfaceAttachmentRequestDescription> input) {
        if (null == input) {
            return null;
        }
        ArrayList<InstanceNetworkInterfaceSpecification> result = new ArrayList<InstanceNetworkInterfaceSpecification>(input.size());
        for (NetworkInterfaceAttachmentRequestDescription item : input) {
            result.add(this.translateNetworkInterfaceAttachmentRequest(item));
        }
        return result;
    }

    private InstanceNetworkInterfaceSpecification translateNetworkInterfaceAttachmentRequest(NetworkInterfaceAttachmentRequestDescription attachment) {
        if (null == attachment) {
            return null;
        }
        InstanceNetworkInterfaceSpecification specification = new InstanceNetworkInterfaceSpecification();
        specification.setDeleteOnTermination(attachment.getDeleteOnTermination());
        specification.setDescription(attachment.getDescription());
        specification.setDeviceIndex(attachment.getDeviceIndex());
        specification.setGroups(attachment.getGroupIds());
        specification.setNetworkInterfaceId(attachment.getNetworkInterfaceId());
        specification.setSubnetId(attachment.getSubnetId());
        if (null != attachment.getSecondaryPrivateIpAddresses() || null != attachment.getPrivateIpAddress()) {
            specification.setPrivateIpAddresses(this.translateInstancePrivateIpAddressesRequest(attachment.getPrivateIpAddress(), attachment.getSecondaryPrivateIpAddresses()));
        }
        if (null != attachment.getSecondaryPrivateIpAddressesCount()) {
            specification.setSecondaryPrivateIpAddressCount(attachment.getSecondaryPrivateIpAddressesCount());
        }
        return specification;
    }

    private List<InstanceNetworkInterface> translateInstanceNetworkInterfaces(List<com.amazonaws.services.ec2.model.InstanceNetworkInterface> input) {
        if (null == input) {
            return null;
        }
        ArrayList<InstanceNetworkInterface> result = new ArrayList<InstanceNetworkInterface>(input.size());
        for (com.amazonaws.services.ec2.model.InstanceNetworkInterface item : input) {
            result.add(this.translateInstanceNetworkInterface(item));
        }
        return result;
    }

    private InstanceNetworkInterface translateInstanceNetworkInterface(com.amazonaws.services.ec2.model.InstanceNetworkInterface nic) {
        if (null == nic) {
            return null;
        }
        return new InstanceNetworkInterface(nic.getNetworkInterfaceId(), nic.getSubnetId(), nic.getVpcId(), nic.getOwnerId(), nic.getStatus(), nic.getPrivateIpAddress(), nic.getPrivateDnsName(), nic.getSourceDestCheck(), this.translateGroupIdentifiers(nic.getGroups()), this.translateInstanceNetworkInterfaceAttachment(nic.getAttachment()), this.translateInstanceNetworkInterfaceAssociation(nic.getAssociation()), this.translateInstancePrivateIpAddressesResponses(nic.getPrivateIpAddresses()));
    }

    private InstanceNetworkInterfaceAssociationDescription translateInstanceNetworkInterfaceAssociation(InstanceNetworkInterfaceAssociation association) {
        if (null == association) {
            return null;
        }
        return new InstanceNetworkInterfaceAssociationDescription(association.getPublicIp(), association.getIpOwnerId());
    }

    private InstanceNetworkInterfaceAttachmentDescription translateInstanceNetworkInterfaceAttachment(InstanceNetworkInterfaceAttachment attachment) {
        if (null == attachment) {
            return null;
        }
        return new InstanceNetworkInterfaceAttachmentDescription(attachment.getAttachmentId(), attachment.getDeviceIndex(), attachment.getStatus(), attachment.getAttachTime(), attachment.getDeleteOnTermination());
    }

    private List<InstanceNetworkInterfaceSpecification> translateNetworkInterfaceAttachmentRequestDescriptions(List<NetworkInterfaceAttachmentRequestDescription> input) {
        if (null == input) {
            return null;
        }
        ArrayList<InstanceNetworkInterfaceSpecification> result = new ArrayList<InstanceNetworkInterfaceSpecification>(input.size());
        for (NetworkInterfaceAttachmentRequestDescription item : input) {
            result.add(this.translateNetworkInterfaceAttachmentRequestDescription(item));
        }
        return result;
    }

    private InstanceNetworkInterfaceSpecification translateNetworkInterfaceAttachmentRequestDescription(NetworkInterfaceAttachmentRequestDescription attachment) {
        if (null == attachment) {
            return null;
        }
        InstanceNetworkInterfaceSpecification specification = new InstanceNetworkInterfaceSpecification();
        specification.setDeleteOnTermination(attachment.getDeleteOnTermination());
        specification.setDescription(attachment.getDescription());
        specification.setDeviceIndex(attachment.getDeviceIndex());
        specification.setGroups(attachment.getGroupIds());
        specification.setNetworkInterfaceId(attachment.getNetworkInterfaceId());
        specification.setPrivateIpAddress(attachment.getPrivateIpAddress());
        specification.setSubnetId(attachment.getSubnetId());
        if (null != attachment.getSecondaryPrivateIpAddresses()) {
            ArrayList<InstancePrivateIpAddress> addresses = new ArrayList<InstancePrivateIpAddress>();
            for (String cur : attachment.getSecondaryPrivateIpAddresses()) {
                addresses.add(new InstancePrivateIpAddress().withPrivateIpAddress(cur).withPrimary(Boolean.valueOf(false)));
            }
            specification.setPrivateIpAddresses(addresses);
        }
        if (null != attachment.getSecondaryPrivateIpAddressesCount()) {
            specification.setSecondaryPrivateIpAddressCount(attachment.getSecondaryPrivateIpAddressesCount());
        }
        return specification;
    }

    private String extractAvailabilityZone(SpotPlacement placement) {
        if (null == placement) {
            return null;
        }
        return placement.getAvailabilityZone();
    }

    private List<NetworkInterfaceDescription> translateInstanceNetworkInterfaceSpecifications(List<InstanceNetworkInterfaceSpecification> input) {
        if (null == input) {
            return null;
        }
        ArrayList<NetworkInterfaceDescription> result = new ArrayList<NetworkInterfaceDescription>(input.size());
        for (InstanceNetworkInterfaceSpecification item : input) {
            result.add(this.translateInstanceNetworkInterfaceSpecification(item));
        }
        return result;
    }

    private NetworkInterfaceDescription translateInstanceNetworkInterfaceSpecification(InstanceNetworkInterfaceSpecification nic) {
        if (null == nic) {
            return null;
        }
        return new NetworkInterfaceDescription(nic.getNetworkInterfaceId(), nic.getDescription(), nic.getSubnetId(), null, null, null, null, null, null, null, nic.getPrivateIpAddress(), null, null, this.translateGroupIdsToGroupDescriptions(nic.getGroups()), null, null, null, this.translateInstancePrivateIpAddresses(nic.getPrivateIpAddresses()));
    }

    private List<NetworkInterfaceDescription> translateInstanceNetworkInterfaceResponses(List<InstanceNetworkInterfaceResponse> input) {
        if (null == input) {
            return null;
        }
        ArrayList<NetworkInterfaceDescription> result = new ArrayList<NetworkInterfaceDescription>(input.size());
        for (InstanceNetworkInterfaceResponse item : input) {
            result.add(this.translateInstanceNetworkInterfaceResponse(item));
        }
        return result;
    }

    private NetworkInterfaceDescription translateInstanceNetworkInterfaceResponse(InstanceNetworkInterfaceResponse nic) {
        if (null == nic) {
            return null;
        }
        return new NetworkInterfaceDescription(nic.getNetworkInterfaceId(), nic.getDescription(), nic.getSubnetId(), null, null, null, null, null, null, null, nic.getPrivateIpAddress(), null, null, this.translateGroupIdsToGroupDescriptions(nic.getGroups()), null, null, null, this.translateInstancePrivateIpAddresses(nic.getPrivateIpAddresses()));
    }

    private List<NetworkInterfaceDescription> translateNetworkInterfaces(List<NetworkInterface> input) {
        if (null == input) {
            return null;
        }
        ArrayList<NetworkInterfaceDescription> result = new ArrayList<NetworkInterfaceDescription>(input.size());
        for (NetworkInterface item : input) {
            result.add(this.translateNetworkInterface(item));
        }
        return result;
    }

    private NetworkInterfaceDescription translateNetworkInterface(NetworkInterface nic) {
        if (null == nic) {
            return null;
        }
        return new NetworkInterfaceDescription(nic.getNetworkInterfaceId(), nic.getDescription(), nic.getSubnetId(), nic.getVpcId(), nic.getAvailabilityZone(), nic.getOwnerId(), nic.getRequesterId(), nic.getRequesterManaged(), nic.getStatus(), nic.getMacAddress(), nic.getPrivateIpAddress(), nic.getPrivateDnsName(), nic.getSourceDestCheck(), this.translateGroupIdentifiers(nic.getGroups()), this.translateNetworkInterfaceAttachment(nic.getAttachment()), this.translateNetworkInterfaceAssociation(nic.getAssociation()), this.translateTags(nic.getTagSet()), this.translatePrivateIpAddresses(nic.getPrivateIpAddresses()));
    }

    private List<PrivateIpAddressDescription> translatePrivateIpAddresses(List<PrivateIpAddress> input) {
        if (null == input) {
            return null;
        }
        ArrayList<PrivateIpAddressDescription> result = new ArrayList<PrivateIpAddressDescription>(input.size());
        for (PrivateIpAddress item : input) {
            result.add(this.translatePrivateIpAddress(item));
        }
        return result;
    }

    private PrivateIpAddressDescription translatePrivateIpAddress(PrivateIpAddress input) {
        if (null == input) {
            return null;
        }
        return new PrivateIpAddressDescription(input.getPrivateIpAddress(), input.isPrimary(), this.translateNetworkInterfaceAssociation(input.getAssociation()));
    }

    private List<PrivateIpAddressDescription> translateInstancePrivateIpAddresses(List<InstancePrivateIpAddress> input) {
        if (null == input) {
            return null;
        }
        ArrayList<PrivateIpAddressDescription> result = new ArrayList<PrivateIpAddressDescription>(input.size());
        for (InstancePrivateIpAddress item : input) {
            result.add(this.translateInstancePrivateIpAddress(item));
        }
        return result;
    }

    private PrivateIpAddressDescription translateInstancePrivateIpAddress(InstancePrivateIpAddress input) {
        if (null == input) {
            return null;
        }
        return new PrivateIpAddressDescription(input.getPrivateIpAddress(), input.isPrimary(), null);
    }

    private List<InstancePrivateIpAddressResponseDescription> translateInstancePrivateIpAddressesResponses(List<InstancePrivateIpAddressResponse> input) {
        if (null == input) {
            return null;
        }
        ArrayList<InstancePrivateIpAddressResponseDescription> result = new ArrayList<InstancePrivateIpAddressResponseDescription>(input.size());
        for (InstancePrivateIpAddressResponse item : input) {
            result.add(this.translateInstancePrivateIpAddressesResponse(item));
        }
        return result;
    }

    private InstancePrivateIpAddressResponseDescription translateInstancePrivateIpAddressesResponse(InstancePrivateIpAddressResponse input) {
        if (null == input) {
            return null;
        }
        return new InstancePrivateIpAddressResponseDescription(input.getPrivateIpAddress(), input.isPrimary(), this.translateInstanceNetworkInterfaceAssociation(input.getAssociation()));
    }

    private NetworkInterfaceAssociationDescription translateNetworkInterfaceAssociation(NetworkInterfaceAssociation association) {
        if (null == association) {
            return null;
        }
        return new NetworkInterfaceAssociationDescription(association.getPublicIp(), association.getIpOwnerId(), association.getAllocationId(), association.getAssociationId());
    }

    private NetworkInterfaceAttachmentDescription translateNetworkInterfaceAttachment(NetworkInterfaceAttachment attachment) {
        if (null == attachment) {
            return null;
        }
        return new NetworkInterfaceAttachmentDescription(attachment.getInstanceId(), attachment.getAttachmentId(), attachment.getStatus(), attachment.getDeleteOnTermination());
    }

    private List<GroupDescription> translateGroupIdentifiers(List<GroupIdentifier> input) {
        if (null == input) {
            return null;
        }
        ArrayList<GroupDescription> result = new ArrayList<GroupDescription>(input.size());
        for (GroupIdentifier item : input) {
            result.add(this.translateGroupIdentifier(item));
        }
        return result;
    }

    private GroupDescription translateGroupIdentifier(GroupIdentifier securityGroup) {
        if (null == securityGroup) {
            return null;
        }
        return new GroupDescription(securityGroup.getGroupId(), securityGroup.getGroupName());
    }

    private List<GroupDescription> translateGroupIdsToGroupDescriptions(List<String> input) {
        if (null == input) {
            return null;
        }
        ArrayList<GroupDescription> result = new ArrayList<GroupDescription>(input.size());
        for (String item : input) {
            result.add(this.translateGroupIdToGroupDescription(item));
        }
        return result;
    }

    private GroupDescription translateGroupIdToGroupDescription(String securityGroupId) {
        if (null == securityGroupId) {
            return null;
        }
        return new GroupDescription(securityGroupId, null);
    }

    private List<InternetGatewayDescription> translateInternetGateways(List<InternetGateway> input) {
        if (null == input) {
            return null;
        }
        ArrayList<InternetGatewayDescription> result = new ArrayList<InternetGatewayDescription>(input.size());
        for (InternetGateway item : input) {
            result.add(this.translateInternetGateway(item));
        }
        return result;
    }

    private InternetGatewayDescription translateInternetGateway(InternetGateway internetGateway) {
        if (null == internetGateway) {
            return null;
        }
        return new InternetGatewayDescription(this.translateTags(internetGateway.getTags()), this.translateInternetGatewayAttachmentDescriptions(internetGateway.getAttachments()), internetGateway.getInternetGatewayId());
    }

    private List<InternetGatewayAttachmentDescription> translateInternetGatewayAttachmentDescriptions(List<InternetGatewayAttachment> input) {
        if (null == input) {
            return null;
        }
        ArrayList<InternetGatewayAttachmentDescription> result = new ArrayList<InternetGatewayAttachmentDescription>(input.size());
        for (InternetGatewayAttachment item : input) {
            result.add(this.translateInternetGatewayAttachmentDescription(item));
        }
        return result;
    }

    private InternetGatewayAttachmentDescription translateInternetGatewayAttachmentDescription(InternetGatewayAttachment attachment) {
        if (null == attachment) {
            return null;
        }
        return new InternetGatewayAttachmentDescription(attachment.getVpcId(), attachment.getState());
    }

    private List<ConversionTaskDescription> translateConversionTasks(List<ConversionTask> input) {
        if (null == input) {
            return null;
        }
        ArrayList<ConversionTaskDescription> result = new ArrayList<ConversionTaskDescription>(input.size());
        for (ConversionTask item : input) {
            result.add(this.translateConversionTask(item));
        }
        return result;
    }

    private ConversionTaskDescription translateConversionTask(ConversionTask conversionTask) {
        if (null == conversionTask) {
            return null;
        }
        ImportInstanceConversionTask instanceConversionTask = this.translateImportInstance(conversionTask.getImportInstance());
        ImportVolumeConversionTask volumeConversionTask = this.translateImportVolume(conversionTask.getImportVolume());
        if (null != instanceConversionTask) {
            return new ConversionTaskDescription(conversionTask.getConversionTaskId(), conversionTask.getExpirationTime(), conversionTask.getState(), conversionTask.getStatusMessage(), instanceConversionTask);
        }
        if (null != volumeConversionTask) {
            return new ConversionTaskDescription(conversionTask.getConversionTaskId(), conversionTask.getExpirationTime(), conversionTask.getState(), conversionTask.getStatusMessage(), volumeConversionTask);
        }
        return new ConversionTaskDescription(conversionTask.getConversionTaskId(), conversionTask.getExpirationTime(), conversionTask.getState(), conversionTask.getStatusMessage());
    }

    private ImportVolumeConversionTask translateImportVolume(ImportVolumeTaskDetails importVolume) {
        if (null == importVolume) {
            return null;
        }
        DiskImageDescription image = importVolume.getImage();
        DiskImageVolumeDescription volume = importVolume.getVolume();
        long size = volume == null ? -1L : volume.getSize();
        return new ImportVolumeConversionTask(image == null ? null : image.getFormat(), image == null ? null : image.getSize(), volume == null ? null : volume.getId(), importVolume.getDescription(), importVolume.getAvailabilityZone(), image == null ? null : image.getImportManifestUrl(), importVolume.getBytesConverted(), (int)size);
    }

    private ImportInstanceConversionTask translateImportInstance(ImportInstanceTaskDetails importInstance) {
        if (null == importInstance) {
            return null;
        }
        return new ImportInstanceConversionTask(importInstance.getInstanceId(), importInstance.getPlatform(), this.translateImportInstanceVolumeDetails(importInstance.getVolumes()), importInstance.getDescription());
    }

    private List<ImportInstanceVolumeDetail> translateImportInstanceVolumeDetails(List<ImportInstanceVolumeDetailItem> input) {
        if (null == input) {
            return null;
        }
        ArrayList<ImportInstanceVolumeDetail> result = new ArrayList<ImportInstanceVolumeDetail>(input.size());
        for (ImportInstanceVolumeDetailItem item : input) {
            result.add(this.translateImportInstanceVolumeDetail(item));
        }
        return result;
    }

    private ImportInstanceVolumeDetail translateImportInstanceVolumeDetail(ImportInstanceVolumeDetailItem volumeDetail) {
        if (null == volumeDetail) {
            return null;
        }
        DiskImageVolumeDescription volume = volumeDetail.getVolume();
        DiskImageDescription image = volumeDetail.getImage();
        long size = volume == null ? -1L : volume.getSize();
        return new ImportInstanceVolumeDetail(image == null ? null : image.getFormat(), image == null ? null : image.getSize(), volume == null ? null : volume.getId(), volumeDetail.getDescription(), volumeDetail.getAvailabilityZone(), image == null ? null : image.getImportManifestUrl(), volumeDetail.getBytesConverted(), (int)size, volumeDetail.getStatus(), volumeDetail.getStatusMessage());
    }

    private List<VgwTelemetryDescription> translateVgwTelemetries(List<VgwTelemetry> input) {
        if (null == input) {
            return null;
        }
        ArrayList<VgwTelemetryDescription> result = new ArrayList<VgwTelemetryDescription>(input.size());
        for (VgwTelemetry item : input) {
            result.add(this.translateVgwTelemetry(item));
        }
        return result;
    }

    private VgwTelemetryDescription translateVgwTelemetry(VgwTelemetry telemetry) {
        if (null == telemetry) {
            return null;
        }
        return new VgwTelemetryDescription(telemetry.getOutsideIpAddress(), telemetry.getStatus(), telemetry.getLastStatusChange(), telemetry.getStatusMessage(), telemetry.getAcceptedRouteCount());
    }

    private List<VolumeStatusDescription> translateVolumeStatuses(List<VolumeStatusItem> input) {
        if (null == input) {
            return null;
        }
        ArrayList<VolumeStatusDescription> result = new ArrayList<VolumeStatusDescription>(input.size());
        for (VolumeStatusItem item : input) {
            result.add(this.translateVolumeStatus(item));
        }
        return result;
    }

    private VolumeStatusDescription translateVolumeStatus(VolumeStatusItem status) {
        if (null == status) {
            return null;
        }
        return new VolumeStatusDescription(status.getVolumeId(), status.getAvailabilityZone(), this.translateVolumeStatusSummary(status.getVolumeStatus()), this.translateVolumeEvents(status.getEvents()), this.translateVolumeActions(status.getActions()));
    }

    private VolumeStatus translateVolumeStatusSummary(VolumeStatusInfo volumeStatus) {
        if (null == volumeStatus) {
            return null;
        }
        return new VolumeStatus(volumeStatus.getStatus(), this.translateVolumeStatusDetails(volumeStatus.getDetails()));
    }

    private List<VolumeDetails> translateVolumeStatusDetails(List<VolumeStatusDetails> input) {
        if (null == input) {
            return null;
        }
        ArrayList<VolumeDetails> result = new ArrayList<VolumeDetails>(input.size());
        for (VolumeStatusDetails item : input) {
            result.add(this.translateVolumeStatusDetail(item));
        }
        return result;
    }

    private VolumeDetails translateVolumeStatusDetail(VolumeStatusDetails detail) {
        if (null == detail) {
            return null;
        }
        return new VolumeDetails(detail.getName(), detail.getStatus());
    }

    private List<EventSet> translateVolumeEvents(List<VolumeStatusEvent> input) {
        if (null == input) {
            return null;
        }
        ArrayList<EventSet> result = new ArrayList<EventSet>(input.size());
        for (VolumeStatusEvent item : input) {
            result.add(this.translateVolumeStatusEvents(item));
        }
        return result;
    }

    private EventSet translateVolumeStatusEvents(VolumeStatusEvent event) {
        return new EventSet(event.getEventType(), event.getEventId(), event.getDescription(), this.translateDateToCalendar(event.getNotBefore()), this.translateDateToCalendar(event.getNotAfter()));
    }

    private List<ActionSet> translateVolumeActions(List<VolumeStatusAction> input) {
        if (null == input) {
            return null;
        }
        ArrayList<ActionSet> result = new ArrayList<ActionSet>(input.size());
        for (VolumeStatusAction item : input) {
            result.add(this.translateVolumeStatusActions(item));
        }
        return result;
    }

    private ActionSet translateVolumeStatusActions(VolumeStatusAction action) {
        return new ActionSet(action.getCode(), action.getEventId(), action.getDescription(), action.getEventType());
    }

    private List<InstanceStatusDescription> translateInstanceStatuses(List<com.amazonaws.services.ec2.model.InstanceStatus> input) {
        if (null == input) {
            return null;
        }
        ArrayList<InstanceStatusDescription> result = new ArrayList<InstanceStatusDescription>(input.size());
        for (com.amazonaws.services.ec2.model.InstanceStatus item : input) {
            result.add(this.translateInstanceStatus(item));
        }
        return result;
    }

    private InstanceStatusDescription translateInstanceStatus(com.amazonaws.services.ec2.model.InstanceStatus status) {
        if (null == status) {
            return null;
        }
        return new InstanceStatusDescription(status.getInstanceId(), status.getAvailabilityZone(), this.translateInstanceStatusEvents(status.getEvents()), this.translateInstanceState(status.getInstanceState()), this.translateInstanceStatusSummary(status.getInstanceStatus()), this.translateInstanceStatusSummary(status.getSystemStatus()));
    }

    private InstanceStatus translateInstanceStatusSummary(InstanceStatusSummary instanceStatus) {
        if (null == instanceStatus) {
            return null;
        }
        return new InstanceStatus(instanceStatus.getStatus(), this.translateInstanceStatusDetails(instanceStatus.getDetails()));
    }

    private List<InstanceStatusDetail> translateInstanceStatusDetails(List<InstanceStatusDetails> input) {
        if (null == input) {
            return null;
        }
        ArrayList<InstanceStatusDetail> result = new ArrayList<InstanceStatusDetail>(input.size());
        for (InstanceStatusDetails item : input) {
            result.add(this.translateInstanceStatusDetail(item));
        }
        return result;
    }

    private InstanceStatusDetail translateInstanceStatusDetail(InstanceStatusDetails detail) {
        if (null == detail) {
            return null;
        }
        return new InstanceStatusDetail(detail.getName(), detail.getStatus(), this.translateDateToGregorianCalendar(detail.getImpairedSince()));
    }

    private InstanceState translateInstanceState(com.amazonaws.services.ec2.model.InstanceState instanceState) {
        if (null == instanceState) {
            return null;
        }
        return new InstanceState(instanceState.getCode(), instanceState.getName());
    }

    private List<Event> translateInstanceStatusEvents(List<InstanceStatusEvent> input) {
        if (null == input) {
            return null;
        }
        ArrayList<Event> result = new ArrayList<Event>(input.size());
        for (InstanceStatusEvent item : input) {
            result.add(this.translateInstanceStatusEvents(item));
        }
        return result;
    }

    private Event translateInstanceStatusEvents(InstanceStatusEvent event) {
        return new Event(event.getCode(), event.getDescription(), this.translateDateToCalendar(event.getNotBefore()), this.translateDateToCalendar(event.getNotAfter()));
    }

    private GregorianCalendar translateDateToGregorianCalendar(Date date) {
        if (null == date) {
            return null;
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        return calendar;
    }

    private Integer translateBigInteger(BigInteger n) {
        return null == n ? null : Integer.valueOf(n.intValue());
    }

    private Date translateGregorianCalendar(XMLGregorianCalendar calendar) {
        if (null == calendar) {
            return null;
        }
        return calendar.toGregorianCalendar().getTime();
    }

    private Date translateCalendar(Calendar calendar) {
        if (null == calendar) {
            return null;
        }
        return calendar.getTime();
    }

    private Integer translateStringToInteger(String str) {
        if (null == str) {
            return null;
        }
        try {
            return Integer.parseInt(str, 10);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private String translateIntegerToString(Integer i) {
        return null == i ? null : i.toString();
    }

    protected AmazonEC2 getEc2Client() {
        return this.ec2Client;
    }
}

