/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ec2.model.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DeleteTagsRequest
extends AmazonWebServiceRequest {
    private List<String> resources;
    private List<Tag> tags;

    public DeleteTagsRequest() {
    }

    public DeleteTagsRequest(List<String> resources) {
        this.resources = resources;
    }

    public List<String> getResources() {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        return this.resources;
    }

    public void setResources(Collection<String> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        ArrayList<String> resourcesCopy = new ArrayList<String>(resources.size());
        resourcesCopy.addAll(resources);
        this.resources = resourcesCopy;
    }

    public DeleteTagsRequest withResources(String ... resources) {
        if (this.getResources() == null) {
            this.setResources(new ArrayList<String>(resources.length));
        }
        for (String value : resources) {
            this.getResources().add(value);
        }
        return this;
    }

    public DeleteTagsRequest withResources(Collection<String> resources) {
        if (resources == null) {
            this.resources = null;
        } else {
            ArrayList<String> resourcesCopy = new ArrayList<String>(resources.size());
            resourcesCopy.addAll(resources);
            this.resources = resourcesCopy;
        }
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new ArrayList<Tag>();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ArrayList<Tag> tagsCopy = new ArrayList<Tag>(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public DeleteTagsRequest withTags(Tag ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public DeleteTagsRequest withTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ArrayList<Tag> tagsCopy = new ArrayList<Tag>(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.resources != null) {
            sb.append("Resources: " + this.resources + ", ");
        }
        if (this.tags != null) {
            sb.append("Tags: " + this.tags + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : ((Object)this.getResources()).hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : ((Object)this.getTags()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteTagsRequest)) {
            return false;
        }
        DeleteTagsRequest other = (DeleteTagsRequest)((Object)obj);
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        if (other.getResources() != null && !((Object)other.getResources()).equals(this.getResources())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || ((Object)other.getTags()).equals(this.getTags());
    }
}

