/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.CreateInstanceExportTaskRequest;
import com.amazonaws.services.ec2.model.ExportToS3Task;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateInstanceExportTaskRequestMarshaller
implements Marshaller<Request<CreateInstanceExportTaskRequest>, CreateInstanceExportTaskRequest> {
    public Request<CreateInstanceExportTaskRequest> marshall(CreateInstanceExportTaskRequest createInstanceExportTaskRequest) {
        ExportToS3Task exportToS3TaskExportToS3;
        if (createInstanceExportTaskRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createInstanceExportTaskRequest, "AmazonEC2");
        request.addParameter("Action", "CreateInstanceExportTask");
        request.addParameter("Version", "2012-12-01");
        if (createInstanceExportTaskRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createInstanceExportTaskRequest.getDescription()));
        }
        if (createInstanceExportTaskRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)createInstanceExportTaskRequest.getInstanceId()));
        }
        if (createInstanceExportTaskRequest.getTargetEnvironment() != null) {
            request.addParameter("TargetEnvironment", StringUtils.fromString((String)createInstanceExportTaskRequest.getTargetEnvironment()));
        }
        if ((exportToS3TaskExportToS3 = createInstanceExportTaskRequest.getExportToS3()) != null) {
            if (exportToS3TaskExportToS3.getDiskImageFormat() != null) {
                request.addParameter("ExportToS3.DiskImageFormat", StringUtils.fromString((String)exportToS3TaskExportToS3.getDiskImageFormat()));
            }
            if (exportToS3TaskExportToS3.getContainerFormat() != null) {
                request.addParameter("ExportToS3.ContainerFormat", StringUtils.fromString((String)exportToS3TaskExportToS3.getContainerFormat()));
            }
            if (exportToS3TaskExportToS3.getS3Bucket() != null) {
                request.addParameter("ExportToS3.S3Bucket", StringUtils.fromString((String)exportToS3TaskExportToS3.getS3Bucket()));
            }
            if (exportToS3TaskExportToS3.getS3Prefix() != null) {
                request.addParameter("ExportToS3.S3Prefix", StringUtils.fromString((String)exportToS3TaskExportToS3.getS3Prefix()));
            }
        }
        return request;
    }
}

