/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.BlockDeviceMappingDescription;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.cmd.MissingArgument;
import com.amazon.aes.webservices.client.cmd.MissingNonOption;
import com.amazon.aes.webservices.client.cmd.Outputter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class CreateImage
extends BaseCmd {
    private static final String[] NAME_DESC = new String[]{"The name of the image."};
    private static final String[] DESCRIPTION_DESC = new String[]{"The description of the image."};
    private static final String[] NO_REBOOT_DESC = new String[]{"If specified, the instance will not be rebooted during the bundle", "process."};

    public CreateImage(String[] args) {
        super("ec2cim", "ec2-create-image");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        result.addOption(CreateImage.createOptionWithArgs("n", "name", CreateImage.joinDescription(NAME_DESC), "NAME"));
        result.addOption(CreateImage.createOptionWithArgs("d", "description", CreateImage.joinDescription(DESCRIPTION_DESC), "DESCRIPTION"));
        result.addOption(new Option(null, "no-reboot", false, CreateImage.joinDescription(NO_REBOOT_DESC)));
        result.addOption(CreateImage.createOptionWithArgs("b", "block-device-mapping", BLOCK_DEVICE_MAPPING_DESC, "MAPPING"));
        return result;
    }

    @Override
    protected String getOptionString() {
        return "INSTANCE";
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Register an AMI manifest for use with EC2.");
        System.out.println("     The MANIFEST parameter is the manifest (in S3) to register.");
        System.out.println("     e.g. mybucketname/image.manifest");
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("name");
        this.printOption("description");
        this.printOption("no-reboot");
        this.printOption("block-device-mapping");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String instanceId;
        String string = instanceId = this.getNonOptions().length > 0 ? this.getNonOptions()[0] : null;
        if (instanceId == null || "".equals(instanceId)) {
            throw new MissingNonOption("instance");
        }
        String name = this.getOptionValue("name");
        if (name == null || "".equals(name)) {
            throw new MissingArgument("name");
        }
        List<BlockDeviceMappingDescription> blockDeviceMapping = this.getBlockDeviceMapping(this.getOptionValues("block-device-mapping"));
        String description = this.getOptionValue("description");
        RequestResultPair rsp = jec2.createImage(instanceId, name, description, this.isOptionSet("no-reboot"), blockDeviceMapping);
        out.outputImageId(System.out, (String)rsp.getResponse());
        out.printRequestId(System.out, (RequestResult)rsp);
        return true;
    }

    protected List<BlockDeviceMappingDescription> getBlockDeviceMapping(String[] blockDeviceOptions) {
        ArrayList<BlockDeviceMappingDescription> blockDevices = new ArrayList<BlockDeviceMappingDescription>();
        if (blockDeviceOptions == null || blockDeviceOptions.length == 0) {
            return blockDevices;
        }
        for (String blockDeviceOption : blockDeviceOptions) {
            try {
                blockDevices.add(BlockDeviceMappingDescription.valueOf((String)blockDeviceOption));
            }
            catch (Exception e) {
                throw new InvalidArgument("block-device-mapping", blockDeviceOption);
            }
        }
        return blockDevices;
    }

    public static void main(String[] args) {
        new CreateImage(args).invoke();
    }
}

