/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.team.internal.ftp;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.team.core.TeamException;

public class FTPException extends TeamException {
	public FTPException(IStatus status) {
		super(status);
	}
	
	public FTPException(String message) {
		super(new Status(IStatus.ERROR, FTPPlugin.ID, UNABLE, message, null));
	}

	public FTPException(String message, int code) {
		this(new Status(IStatus.ERROR, FTPPlugin.ID, code, message, null));
	}
	
	/*
	 * Static helper methods for creating exceptions
	 */
	public static FTPException wrapException(String message, CoreException e) {
		return new FTPException(new Status(IStatus.ERROR, FTPPlugin.ID, UNABLE, message, e));
	}
	public static final int DIRECTORY_EXIST = 521;

	public static final int DOES_NOT_EXIST = 550;

	public static final int CONNECTION_LOST = 601;
	
	public static final int BAD_RESPONSE_CODE = 602;

}
