/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.team.internal.ftp.client;

import java.io.FilterInputStream;
import java.io.IOException;

import org.eclipse.team.internal.ftp.FTPException;

public class DataTransferInputStream extends FilterInputStream {

	private DataConnection manager;
	
	/**
	 * Constructor for DataTransferInputStream.
	 * @param manager the data transfer manager that is managing the socket
	 * @param in the input stream to read from. It is either the input stream of
	 * the manager's socket or it filter's that stream.
	 */
	public DataTransferInputStream(DataConnection manager) throws FTPException {
		super(manager.getSocketInputStream());
		this.manager = manager;
	}

	/**
	 * @see InputStream#close()
	 */
	public void close() throws IOException {
		try {
			// The manager will close the input stream
			manager.closeSocket();
		} catch (FTPException e) {
			if (e.getStatus().getException() instanceof IOException) {
				throw (IOException)e.getStatus().getException();
			} else {
				throw new IOException(e.getMessage());
			}
		}
	}

}
