/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.team.internal.ftp.client;

import org.eclipse.team.internal.ftp.FTPException;

/**
 * Exception class for non-fatal errors thrown as a result of the
 * receipt of certain server responses.
 */
public class FTPServerException extends FTPException {
	
	public FTPServerException(String message, int code) {
		super(message, code);
	}
	public static String getTextOfMessage(String message, int code) {
		String codeString = Integer.toString(code);
		if (message.startsWith(codeString)) {
			message = message.substring(codeString.length() + 1);
		}
		return message;
	}
}
