/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.team.internal.webdav.core;

import java.io.ObjectInputStream;
import java.util.Properties;

import org.eclipse.team.internal.core.target.ISiteFactory;
import org.eclipse.team.internal.core.target.Site;

public class WebDavSiteFactory implements ISiteFactory {
	protected static final int CONFIG_FORMAT_VERSION = 2;

	public WebDavSiteFactory() {
		super();
	}
	
	/**
	 * Return a new target location for the given encoded description.
	 */	
	public Site newSite(ObjectInputStream is) {
		return new WebDavSite(is);
	}
	
	/**
	 * @see ISiteFactory#newLocation(Properties)
	 */
	public Site newSite(Properties properties) {
		return new WebDavSite(properties);
	}
}
