/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.tomcat.internal;

import org.eclipse.core.runtime.*;
/**
 */
public class TomcatPlugin extends Plugin {
	public final static String PLUGIN_ID = "org.eclipse.tomcat";

	// Preferences keys
	public final static String PREF_ACCEPT_COUNT = "acceptCount";
	public final static String PREF_MAX_PROCESSORS = "maxProcessors";
	public final static String PREF_MIN_PROCESSORS = "minProcessors";

	private static TomcatPlugin plugin;

	/**
	 */
	public TomcatPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		plugin = this;

	}

	/** 
	 * Logs an Error message with an exception. Note that the message should already 
	 * be localized to proper locale.
	 * ie: TomcatResources.getString() should already have been called
	 */
	public static synchronized void logError(String message, Throwable ex) {
		if (message == null)
			message = "";
		Status errorStatus =
			new Status(IStatus.ERROR, PLUGIN_ID, IStatus.OK, message, ex);
		TomcatPlugin.getDefault().getLog().log(errorStatus);
	}

	/**
	 */
	public static TomcatPlugin getDefault() {
		return plugin;
	}

	/**
	 */
	public void shutdown() throws CoreException {
		super.shutdown();
	}
	/**
	 */
	public void startup() throws CoreException {
		super.startup();
	}

}
