/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/

package org.eclipse.ui.editors.text;

import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;

/**
 * Help context ids for the text editor.
 * <p>
 * This interface contains constants only; it is not intended to be implemented.</p>
 */
public interface ITextEditorHelpContextIds extends IAbstractTextEditorHelpContextIds {
	
	/**
	 * Id for the text editor preference page.
	 * Value: <code>"org.eclipse.ui.text_editor_preference_page_context"</code>.
	 */
	public static final String TEXT_EDITOR_PREFERENCE_PAGE= PREFIX + "text_editor_preference_page_context"; //$NON-NLS-1$

	/**
	 * Id for the text editor.
	 * Value: <code>"org.eclipse.ui.text_editor_context"</code>.
	 */
	public static final String TEXT_EDITOR= PREFIX + "text_editor_context"; //$NON-NLS-1$
}
