/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.webdav.client;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.webdav.*;
import org.w3c.dom.Document;


/**
 * <b>Note:</b> This class/interface is part of an interim API that is still under 
 * development and expected to change significantly before reaching stability. 
 * It is being made available at this early stage to solicit feedback from pioneering 
 * adopters on the understanding that any code that uses this API will almost 
 * certainly be broken (repeatedly) as the API evolves.
 */
public class LocalDAVClient extends DAVClient {
	
	private IServer server;
	
	/**
	 * Creates a new local DAV client from a clone of the given local DAV
	 * client.
	 *
	 * @param localDAVClient the local DAV client to clone
	 */
	public LocalDAVClient(LocalDAVClient localDAVClient) {
		super(localDAVClient);

		server = localDAVClient.server;
	}

	/**
	 * Creates a new local DAV client that talks to the server at the
	 * specified origin. The origin server <code>URL</code> and the server
	 * must not be <code>null</code>.
	 *
	 * @param serverManager
	 * @param originServerUrl
	 */
	public LocalDAVClient(WebDAVFactory webDAVFactory, IServer server) {
		super(webDAVFactory);
		this.server = server;
	}

	/**
	 * Part of the <code>Server</code> interface.
	 * @see Server#baselineControl(Locator, Context, Document);
	 */
	public IResponse baselineControl(
		ILocator locator,
		IContext context,
		Document body)
		throws IOException {

		return server.baselineControl(locator, newContext(context, locator), body);
	}
	
	/**
	 * Part of the <code>Server</code> interface.
	 * @see Server#bind(Locator, Locator, Context);
	 */
	public IResponse bind(ILocator source, ILocator destination, IContext context) throws IOException {
		return server.bind(source, destination, newContext(context, source));
	}
	
	/**
	 * Part of the <code>Server</code> interface.
	 * @see Server#checkin(Locator, Context, Document);
	 */
	public IResponse checkin(ILocator locator, IContext context, Document body) throws IOException {
		return server.checkin(locator, newContext(context, locator), body);
	}
	
	/**
	 * Part of the <code>Server</code> interface.
	 * @see Server#checkout(Locator, Context);
	 */
	public IResponse checkout(ILocator locator, IContext context, Document body) throws IOException {
		return server.checkout(locator, newContext(context, locator), body);
	}
	
	/**
	 * @see Object#clone
	 */
	protected Object clone() {
		return new LocalDAVClient(this);
	}
	
	/**
	 * Part of the <code>Server</code> interface.
	 * @see Server#copy(Locator, Locator, Context, Document);
	 */
	public IResponse copy(
		ILocator source,
		ILocator destination,
		IContext context,
		Document body)
		throws IOException {
			
		return server.copy(source, destination, newContext(context, source), body);
	}
	/**
	 * Part of the <code>Server</code> interface.
	 * @see Server#delete(Locator, Context);
	 */
	public IResponse delete(ILocator locator, IContext context) throws IOException {
		return server.delete(locator, newContext(context, locator));
	}
	
	/**
	 * Part of the <code>Server</code> interface.
	 * @see Server#get(Locator, Context);
	 */
	public IResponse get(ILocator locator, IContext context) throws IOException {
		return server.get(locator, newContext(context, locator));
	}
	
	/**
	 * Part of the <code>Server</code> interface.
	 * @see Server#head(Locator, Context);
	 */
	public IResponse head(ILocator locator, IContext context) throws IOException {
		return server.head(locator, newContext(context, locator));
	}
	
	/**
	 * Part of the <code>Server</code> interface.
	 * @see Server#label(Locator, Context, Document);
	 */
	public IResponse label(ILocator locator, IContext context, Document body) throws IOException {
		return server.label(locator, newContext(context, locator), body);
	}
	
	/**
	 * Part of the <code>Server</code> interface.
	 * @see Server#lock(Locator, Context, Document);
	 */
	public IResponse lock(ILocator locator, IContext context, Document body) throws IOException {
		return server.lock(locator, newContext(context, locator), body);
	}
	
	/**
	 * Part of the <code>Server</code> interface.
	 * @see Server#merge(Locator, Context, Document);
	 */
	public IResponse merge(ILocator locator, IContext context, Document body) throws IOException {
		return server.merge(locator, newContext(context, locator), body);
	}
	
	/**
	 * Part of the <code>Server</code> interface.
	 * @see Server#mkactivity(Locator, Context, Document);
	 */
	public IResponse mkactivity(ILocator locator, IContext context, Document body) throws IOException {
		return server.mkactivity(locator, newContext(context, locator), body);
	}
	
	/**
	 * Part of the <code>Server</code> interface.
	 * @see Server#mkcol(Locator, Context, Document);
	 */
	public IResponse mkcol(ILocator locator, IContext context, Document element) throws IOException {
		return server.mkcol(locator, newContext(context, locator), element);
	}
	
	/**
	 * Part of the <code>Server</code> interface.
	 * @see Server#mkworkspace(Locator, Context, Document);
	 */
	public IResponse mkworkspace(ILocator locator, IContext context, Document body) throws IOException {
		return server.mkworkspace(locator, newContext(context, locator), body);
	}
	
	/**
	 * Part of the <code>Server</code> interface.
	 * @see Server#move(Locator, Locator, Context, Document);
	 */
	public IResponse move(
		ILocator source,
		ILocator destination,
		IContext context,
		Document body)
		throws IOException {
		return server.move(source, destination, newContext(context, source), body);
	}
	
	/**
	 * Part of the <code>Server</code> interface.
	 * @see Server#options(Locator, Context);
	 */
	public IResponse options(ILocator locator, IContext context) throws IOException {
		return server.options(locator, newContext(context, locator));
	}
	
	/**
	 * Part of the <code>Server</code> interface.
	 * @see Server#post(Locator, Context, InputStream);
	 */
	public IResponse post(ILocator locator, IContext context, InputStream input) throws IOException {
		return server.post(locator, newContext(context, locator), input);
	}
	
	/**
	 * Part of the <code>Server</code> interface.
	 * @see Server#propfind(Locator, Context, Document);
	 */
	public IResponse propfind(ILocator locator, IContext context, Document body) throws IOException {
		return server.propfind(locator, newContext(context, locator), body);
	}
	
	/**
	 * Part of the <code>Server</code> interface.
	 * @see Server#proppatch(Locator, Context, Document);
	 */
	public IResponse proppatch(ILocator locator, IContext context, Document body) throws IOException {
		return server.proppatch(locator, newContext(context, locator), body);
	}
	
	/**
	 * Part of the <code>Server</code> interface.
	 * @see Server#put(Locator, Context, InputStream);
	 */
	public IResponse put(ILocator locator, IContext context, InputStream input) throws IOException {
		return server.put(locator, newContext(context, locator), input);
	}
	
	/**
	 * Part of the <code>Server</code> interface.
	 * @see Server#report(Locator, Context, Document);
	 */
	public IResponse report(ILocator locator, IContext context, Document body) throws IOException {
		return server.report(locator, newContext(context, locator), body);
	}
	
	/**
	 * Part of the <code>Server</code> interface.
	 * @see Server#trace(Locator, Context, InputStream);
	 */
	public IResponse trace(ILocator locator, IContext context) throws IOException {
		return server.trace(locator, newContext(context, locator));
	}
	
	/**
	 * Part of the <code>Server</code> interface.
	 * @see Server#uncheckout(Locator, Context);
	 */
	public IResponse uncheckout(ILocator locator, IContext context) throws IOException {
		return server.uncheckout(locator, newContext(context, locator));
	}
	
	/**
	 * Part of the <code>Server</code> interface.
	 * @see Server#unlock(Locator, Context);
	 */
	public IResponse unlock(ILocator locator, IContext context) throws IOException {
		return server.unlock(locator, newContext(context, locator));
	}
	
	/**
	 * Part of the <code>Server</code> interface.
	 * @see Server#update(Locator, Context, Document);
	 */
	public IResponse update(ILocator locator, IContext context, Document body) throws IOException {
		return server.update(locator, newContext(context, locator), body);
	}
	
	/**
	 * Part of the <code>Server</code> interface.
	 * @see Server#version(Locator, Context);
	 */
	public IResponse versionControl(
		ILocator locator,
		IContext context,
		Document body)
		throws IOException {

		return server.versionControl(locator, newContext(context, locator), body);
	}
}
