/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.webdav.internal.kernel;

import java.io.*;
import javax.xml.parsers.*;
import org.apache.xml.serialize.*;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentMarshaler implements IDocumentMarshaler {

	public Document parse(Reader reader) throws IOException {
		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
			DocumentBuilder parser = factory.newDocumentBuilder();
			//	xmlParser.setProcessNamespace(true);
			return parser.parse(new InputSource(reader));
		} catch (ParserConfigurationException e) {
		} catch (SAXException e) {
		}
		return null;
	}

	public void print(Document document, Writer writer, String encoding)
		throws IOException {
		OutputFormat format = new OutputFormat();
		format.setEncoding(encoding);
		Serializer serializer =
			SerializerFactory.getSerializerFactory("xml").makeSerializer(writer, format); //$NON-NLS-1$
		serializer.asDOMSerializer().serialize(document);
	}
}
