# -*- coding: utf-8 -*-
#       ui.py
#       
#       Copyright 2008 Alberto Milone <alberto@alberto-desktop>
#       
#       This program is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published by
#       the Free Software Foundation; either version 2 of the License, or
#       (at your option) any later version.
#       
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#       
#       You should have received a copy of the GNU General Public License
#       along with this program; if not, write to the Free Software
#       Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
#       MA 02110-1301, USA.

import gettext

class AbstractUI:
    '''Abstract user interface.

    This encapsulates the entire program logic and all strings, but does not
    implement any concrete user interface.
    '''
    def __init__(self):
        '''
        Initialize system.
        '''
        self.gettext_domain = 'envyng'

        gettext.textdomain(self.gettext_domain)

        self.init_strings()
    
    def _(self, str, convert_keybindings=False):
        '''Keyboard accelerator aware gettext() wrapper.
        
        This optionally converts keyboard accelerators to the appropriate
        format for the frontend.

        All strings in the source code should use the '_' prefix for key
        accelerators (like in GTK). For inserting a real '_', use '__'.
        '''
        # KDE compatible conversion
        result = unicode(gettext.gettext(str), 'UTF-8')

        if convert_keybindings:
            result = self.convert_keybindings(result)

        return result
    
    def init_strings(self):
        '''Initialize all static strings which are used in UI implementations.'''

        self.string_auto_install = self._('Install the %s driver (Automatic Hardware Detection)')
        self.string_man_install = self._('Install the %s driver (Manual Selection of the Driver)')
        self.string_uninstall = self._('Uninstall the %s driver')
        self.string_request_selection = self._('<b>Please select the version of the driver you wish to install</b>')
        self.string_save_packages = self._('Save the packages')
        self.string_download_packages = self._('Download the packages without installing them')
        self.string_filename = self._('Path')
        
        
        self.string_description = self._('Unofficial ATI and NVIDIA driver installer')
        self.string_translators_names = self.getTranslators()#put the names of the translators here
        self.string_artists_names = self.getArtists()#put the names of the artists here
        self.string_written_by = self._('Written by')
        self.string_artists = self._('Artists')
        self.string_translators = self._('Translators')
        
        
        
        '''
        QT4 buttons, etc.
        '''
        self.string_close_button = self._('Close')
        self.string_apply_button = self._('Apply')
        self.string_about_button = self._('About')
        self.string_quit_button = self._('Quit')
        self.string_save_button = self._('Save...')
        self.string_ok_button = self._('Ok')
        
        
        
        self.string_invalid_path = self._('Invalid directory to save your files')
        self.string_error_title = self._('Error')
        self.string_select_dir = self._('EnvyNG - Select a directory...')
        self.string_connection_error = self._('EnvyNG requires an Internet connection in order to work')
        self.string_connection_ok = self._('OK: the Internet connection is available')
        self.string_install_deps = self._('Would you like EnvyNG to try to install its missing dependencies? (EnvyNG won\'t work without them)')
        
        self.string_connection_error_cmd = self._('ERROR: the Internet connection is not available')
        self.string_synaptic_temp_msg = self._('Please wait, this can take some time.')
        self.string_synaptic_finish_msg = self._('Installation is complete')
        
        
        self.string_operation_complete = self._('Operation Complete')
        self.string_apt_in_use = self._('EnvyNG has detected that one \
of the following applications is running: dpkg, apt-get,synaptic,\
update-manager, adept, adept-notifier. Make sure that they are not \
running and launch EnvyNG again. \
If this is not the case, make sure that your Internet connection\
is working properly')

        self.string_vte_tmp_msg = self._('Please, Wait until EnvyNG completes the operation')
        
        
        self.string_directory_error_title = self._('Directory Error:')
        self.string_directory_error_msg = self._('The directory you have chosen to save your packages does not exist')
        
        self.string_operation_complete_restart = self._('Do you want to restart your computer now? (select either 0 or 1)\n\t0 - Yes (recommended)\n\t1 - No\n')
        
        self.string_vte_error_msg = self._('There was an error in the installation process. You can see the log file /var/log/envy-installer.log')
        
        self.string_main_label = self._('Main')
        self.string_options_label = self._('Options')
        '''
        classes.py
        '''
        self.string_not_installed_notification = self._('EnvyNG: The following packages are not installed:')
        self.string_attempt_install = self._('\nEnvyNG: attempting to install the packages')
        self.string_ok_packages_installed = self._('\nOK: All the packages are installed')
        self.string_not_installed_error = self._('\nEnvyNG ERROR: The following packages cannot be installed:')
        self.string_packages_removal = self._('EnvyNG: The following packages will be removed:')
        self.string_attempt_packages_removal = self._('\nEnvyNG: attempting to remove the packages')
        
        self.string_missing_deps = self._('Some dependencies are missing')
        self.string_qt_show_error = self._('Error: EnvyNG couldn\'t carry out the task you chose because of the following error:\n')
        self.string_yes = self._('Yes')
        self.string_no = self._('No')
        self.string_license_button = self._('License')
        self.string_credits_button = self._('Credits')
        self.string_cancel_button = self._('Cancel')
        self.string_headers_missing = self._('EnvyNG has detected that the headers for your kernel are missing and cannot be installed')
        self.string_download_error = self._('The packages could not be downloaded')
        self.string_select_install_operation = self._('Please select the number corresponding to the desired driver and press ENTER (or type another number and press Enter to go back to the previous menu):')
        self.string_operation_complete_xorg_restart = self._('Do you want to restart the xserver now? (select either 0 or 1)\n\t0 - Yes (recommended)\n\t1 - No\n')
        self.string_remind_xserver_restart = self._('Remember to restart the Xserver manually')
        self.string_remind_computer_restart = self._('Remember to restart your computer manually')
        self.string_select_text_action = self._('Please select one of the activities displayed above and press ENTER:\n\n')
        self.string_text_install_nvidia = self._('Install the NVIDIA driver')
        self.string_text_uninstall_nvidia = self._('Uninstall the NVIDIA driver')
        self.string_text_install_ati = self._('Install the ATI driver')
        self.string_text_uninstall_ati = self._('Uninstall the ATI driver')
        self.string_text_restart_xorg = self._('Restart the Xserver')
        self.string_text_restart_computer = self._('Restart your computer')
        self.string_text_exit = self._('Exit')
        self.string_text_black_screen = self._('NOTE: IF THE SCREEN TURNS BLACK, PLEASE TYPE ALT+F1')
        self.string_menu_header_number = self._('Number')
        self.string_menu_header_candidate = self._('Candidate Version')
        self.string_menu_header_installed = self._('Installed Version')
        self.string_menu_header_compatible = self._('Compatible')
        self.string_menu_header_recommended = self._('Recommended')
        self.string_text_download = self._('Downloading File')
        self.string_text_error = self._('Error')
        self.string_text_success = self._('Success')
        self.string_package_download = self._('Downloading Package')
        self.string_package_install = self._('Installing Package')
        self.string_explanation = self._('Please select the driver you wish to install.\n\
\n\
The <span weight="bold">Recommended</span> driver is usually the best choice.\n\
\n\
Please do not install drivers which are not <span weight="bold">Compatible</span> unless you know what you\'re doing.')
        self.string_driver_menu = self._('Driver')
        self.string_enabled_menu = self._('Enabled')
        self.string_installed_menu = self._('Installed Version')
        self.string_compatible_menu = self._('Compatible')
        self.string_recommended_menu = self._('Recommended')
        self.string_operation_complete_gui_restart = self._('Operation Complete. Would you like to restart your computer now? (Recommended)')
        
    def getTranslators(self):
        translators = []
        translators1 = [
                        'André Gondim',
                        'Adolfo Fitoria',
                        'Alberto Milone',
                        'Alfredo Matos',
                        'amir',
                        'Andreu Escudero',
                        'Artem Gluvchynskyj',
                        'Babybern',
                        'badhorse',
                        'Bernhard Gehl',
                        'Bram Bonné',
                        'Bruno Ferreira',
                        'Bruno Lucas',
                        'C3PO',
                        'Carlos Diener',
                        'Carsten Oehlenschlaeger',
                        'Cédric Valmary',
                        'César Augusto Palma López',
                        'Cherya',
                        'Chia-ming Wu',
                        'Christian Schuerer',
                        'Claude Gagné',
                        'Cleber Santz',
                        'Dalton Scavassa',
                        'Daniel Nylander',
                        'David Eurenius',
                        'dominiko',
                        'edav',
                        'Edouard Rondepierre',
                        'Eversmann',
                        'Eversmann',
                        'Fábio Miguel Cardoso Oliveira',
                        'FaBMak',
                        'fernando_all4JC',
                        'Festor Wailon Dacoba',
                        'FredPT',
                        'har',
                        'Hokey',
                        'Ilya B',
                        'Jaapjan',
                        'Jakson Rochelly',
                        'Jan Frybort',
                        'jiu',
                        'Jukka Kauppinen',
                        'Kainourgiakis Giorgos',
                        'Kjetil Rydland',
                        'Laco Horváth',
                        'Magnus Lundborg',
                        'Malcolm Parsons',
                        'Manos Vasiliadis',
                        'Manuel Prömel',
                        'Martin',
                        'Niels Abspoel',
                        'Paco Molinero',
                        'Paul Hoell',
                        'Petros Dudis',
                        'Pierre Couillard',
                        'Piotr Wicijowski',
                        'Pittmann Tamás',
                        'Przemysław Kulczycki',
                        'Pumy',
                        'Ricardo Pérez López',
                        'Rodrigo Donado',
                        'Santiago Gómez',
                        'shiami',
                        'Sidney',
                        'somatik',
                        'Stan',
                        'Stig Poulsen',
                        'Strash',
                        'SvenVranckx',
                        'Tero Keinänen',
                        'ThomasDahlmann',
                        'tom',
                        'tomtom',
                        'Topo',
                        'tschirne',
                        'Vassilis Skoullis',
                        'Velten Mathieu',
                        'Vinzenz Vietzke',
                        'XioNoX',
                        'Yakari',
                        'Yann Dìnendal',
                        'Yann Sladek',
                        'yleetiny',
                        'Zirro',
                        'zolero',
                        'Zoran Olujic'
                       ]
        
        for elem in translators1:
            translators.append(unicode(elem, "utf-8"))
        translators.sort()
        
        return translators
    
    def getArtists(self):
        artists = []
        artists1 = [
                   'Alberto Gasparin'
                   ]
        
        for elem in artists1:
            artists.append(unicode(elem, "utf-8"))
        artists.sort()
        
        return artists
        
def main():
	
	return 0

if __name__ == '__main__': main()
