#!/usr/bin/env python

from Envy import objects
from Envy import main
from Envy import classes
from Envy import idcardlist
from Envy import xparse
from Envy import ui

from PyQt4.QtCore import *
from PyQt4.QtGui import *

from Envyngqt import ui_envyngqt
from Envyngqt import qtabout
from Envyngqt import qtlogger

import os
import tempfile
import time
import urllib


def aptcheck():
    """
    Check if any apt processes are running
    """
    p1 = Popen(['ps', '-U', 'root', '-o', 'comm'], stdout=PIPE)
    p = p1.communicate()[0]
    running = False
    pslist = p.split('\n')
    for process in pslist:
        if process.strip() in ["dpkg", "apt-get","synaptic","update-manager", "adept", "adept-notifier"]:
            running = True
            #print process
            break
    return running

'''
TODO: connect these variables
'''



class EnvyMainDlg(QDialog, ui_envyngqt.Ui_EnvyMainDlg):
    def __init__(self, parent=None):
        super(EnvyMainDlg, self).__init__(parent)
        self.setupUi(self)
        
        
        variables = classes.Vars()
        self.atilatest = variables.atimanlatest
        self.atinewlegacy = variables.atimannewlegacy
        self.atilegacy = variables.atimanlegacy
        self.nvbeta = variables.nvmanbeta
        self.nvlatest = variables.nvmanlatest
        self.nvnewlegacy = variables.nvmannewlegacy
        self.nvlegacy = variables.nvmanlegacy
        
        '''
        Translations
        '''
        self.translation = ui.AbstractUI()
        self.save_checkbox.setText(self.translation.string_save_packages)
        self.build_checkbox.setText(self.translation.string_download_packages)

        self.tabWidget.setTabText(0, QString(self.translation.string_main_label))
        self.tabWidget.setTabText(1, QString(self.translation.string_options_label))
        
        self.about_button.setText(self.translation.string_close_button)
        self.apply_button.setText(self.translation.string_apply_button)
        self.quit_button.setText(self.translation.string_quit_button)
        self.save_button.setText(self.translation.string_save_button)
        self.about_button.setText(self.translation.string_about_button)
        self.choice_label.setText(self.translation.string_request_selection)
        
        
        self.headerLabel.setPixmap(QPixmap('/usr/share/envyng-qt/pixmaps/envyapp3.png'))
        self.setWindowIcon(QIcon('/usr/share/envyng-qt/pixmaps/envyng.png'))
        #self.setIcon(QPixmap('/usr/share/envyng-qt/pixmaps/envyng.png'))
        
        self.qtdeps = ['python-qt4', 'adept-batch', 'kdesudo', 'kdesudo-kde4']
        
        self.atiVersions = {'latest': self.atilatest,  'middle': self.atinewlegacy, 'oldest': self.atilegacy,  'beta': None}
        self.nvidiaVersions = {'latest': self.nvlatest,  'middle': self.nvnewlegacy, 'oldest': self.nvlegacy,  'beta': self.nvbeta}
        self.driverMap = {'ATI': self.atiVersions, 'NVIDIA': self.nvidiaVersions}
        
        self.radioFlavours = {'latest': self.latest_radiobutton,
                                  'middle': self.middle_radiobutton,
                                  'oldest': self.oldest_radiobutton,
                                  'beta': self.beta_radiobutton}
        
        
        self.actionsList = ['automatic', 'manual', 'uninstall']
        self.driverFlavours = ['latest', 'middle', 'oldest', 'beta']
        self.curAction = self.actionsList[0]
        self.curFlavour = None
        
        self.driversList = ['ATI', 'NVIDIA']
        self.curDriver = self.driversList[0]
        
        
        self.savePackages = 0#do not save the packages by default
        self.buildOnly = 0#install the packages by default
        
        
        self.listWidget.setCurrentRow(0)
        #self.automatic_button.setChecked(1)
        
        self.setLabels()
        
        self.osdetect()
        self.depcheck()
        
    
    def setLabels(self):
        self.automatic_button.setText(self.translation.string_auto_install %(self.curDriver))
        self.manual_button.setText(self.translation.string_man_install %(self.curDriver))
        self.uninstall_button.setText(self.translation.string_uninstall %(self.curDriver))
        for flavour in self.driverMap[self.curDriver]:
            if self.driverMap[self.curDriver][flavour] == None:
                self.radioFlavours[flavour].hide()
            else:
                self.radioFlavours[flavour].setText(self.driverMap[self.curDriver][flavour])
                self.radioFlavours[flavour].show()
    
    @pyqtSignature("int")
    def on_listWidget_currentRowChanged(self, pos):
        print 'Driver',  self.driversList[pos], 'is selected'
        self.curDriver = self.driversList[pos]
        self.setLabels()
    
    @pyqtSignature("")
    def on_apply_button_clicked(self):
        print "Applybutton clicked"
        print "Selected action is %s" %(self.curAction)
        print "Selected driver is %s" %(self.curDriver)
        if self.curAction == 'manual':
            print "Selected flavour is %s" %(self.curFlavour)
        print "Save packages is %i" %(self.savePackages)
        print "Build only is %i" %(self.buildOnly)
        print ''
        self.applyChanges()
    
    
    def path_dialog(self):
        response = self.translation.string_ok_button
        # buttons texts
        OK = self.translation.string_ok_button

        dialog = QMessageBox(self)
        dialog.setText(self.translation.string_invalid_path)
        dialog.setWindowTitle(self.translation.string_directory_error_title)
        dialog.setIcon(QMessageBox.Critical)
        dialog.addButton(OK, QMessageBox.AcceptRole)
        dialog.exec_()
        response = dialog.clickedButton().text()
        if response == self.translation.string_ok_button:
            dialog.hide()
    
    
    
    
    
    def applyChanges(self):
        '''
        Execute the command and let qtlogger do the rest
        
        self.drv    -> ATI or NVIDIA
        self.ver    -> e.g. 169.09, etc.
        self.save -> save the packages
        self.build -> build the packages without installing them
        self.curAction -> e.g. automatic, install, uninstall
        '''
        self.drv = self.curDriver.lower()
        self.ver = self.curFlavour
        self.save = self.savePackages
        self.build = self.buildOnly
        self.completetxt = []
        logtxtfile = QString('/var/log/envy-installer.log')
        dir = QString('/usr/share/envy')
        
        '''
        QProcess bits
        '''
        
        #self.myProcess = QProcess()
        #self.connect(self.myProcess, SIGNAL("readyReadStandardOutput()"), self.readOutput)
        #self.connect(self.myProcess, SIGNAL("readyReadStandardError()"), self.readErrors)
        #self.connect(self.myProcess, SIGNAL("finished(int)"), self.endCommand)
        
        
        
        '''
        Installation Process
        '''
        
        self.canStart = 1
        
        
        
        if self.build == 0:
            self.mustRestart = 1#it needs a system restart
        else:
            self.mustRestart = 0#it doesn't need a system restart
        
        if self.curAction == 'automatic':
            if self.save == 1:#Save the packages
                '''
                self.savePath may exist even when self.save=0
                '''

                '''
                Automatic selection
                4 arguments
                '''
                self.getPath()#get self.savePath
                
                if not os.path.isdir(self.savePath):
                    self.canStart = 0
                    self.path_dialog()
                else:
                    command = QString('sudo python pulse.py %s %i %i %s' % (self.drv, self.save, self.build, self.savePath))
                    print 'python pulse.py %s %i %i %s \n' % (self.drv, self.save, self.build, self.savePath)
            else:#Do not Save the packages
                '''
                Automatic selection
                1 argument
                '''
                command = QString('sudo python pulse.py %s' % (self.drv))
                print 'python pulse.py %s \n' % (self.drv)
        
        elif self.curAction == 'manual':
            if self.save == 1:#Save the packages
                '''
                self.savePath may exist even when self.save=0
                '''
                self.getPath()#get self.savePath
                '''
                Manual selection
                5 arguments
                '''
                if not os.path.isdir(self.savePath):
                    self.canStart = 0
                    self.path_dialog()
                else:
                    command = QString('sudo python pulse.py %s %s %i %i %s' % (self.drv, self.ver, self.save, self.build, self.savePath))
                    print 'python pulse.py %s %s %i %i %s \n' % (self.drv, self.ver, self.save, self.build, self.savePath)
            
            else:#Do not Save the packages
                '''
                Manual selection
                2 arguments
                '''
                command = QString('sudo python pulse.py %s %s' % (self.drv, self.ver))
                print 'python pulse.py %s %s \n' % (self.drv, self.ver)
        
        elif self.curAction == 'uninstall':
            command = QString('sudo python pulse.py %s %s' % (self.drv, 'uninstall'))
            print 'python pulse.py %s %s \n' % (self.drv, 'uninstall')
            
        if self.canStart == 1:
            #self.mycommand = command
            #self.filename = logtxtfile
            #launch = qtlogger.EnvyTerm()
            #launch.show()
            launch = qtlogger.EnvyTerm(command, dir, logtxtfile, self.mustRestart, self)
            #launch.startCommand()
            launch.show()
            launch.startCommand()
    
    
    def getPath(self):
        '''
        Get self.savePath from the lineEdit
        '''
        self.savePath = self.lineEdit.text()
        print 'My savePath is ' + self.savePath
    
    @pyqtSignature("")
    def on_save_button_clicked(self):
        dir = '.'
        formats = ["*.%s" % unicode(format).lower() \
                   for format in QImageWriter.supportedImageFormats()]
        dir = unicode(QFileDialog.getExistingDirectory(self,
                        self.translation.string_select_dir, "/home", QFileDialog.ShowDirsOnly | QFileDialog.DontResolveSymlinks))
        if dir:
            self.savePath = dir
            self.lineEdit.setText(self.savePath)
    
    @pyqtSignature("bool")
    def on_automatic_button_toggled(self, istoggled):
        if istoggled == 1:
            print "Automatic enabled"
            self.curAction = 'automatic'
    
    @pyqtSignature("bool")
    def on_manual_button_toggled(self, istoggled):
        if istoggled == 1:
            print "Manual enabled"
            self.curAction = 'manual'
            self.latest_radiobutton.setChecked(istoggled)
    
    @pyqtSignature("bool")
    def on_uninstall_button_toggled(self, istoggled):
        if istoggled == 1:
            print "Uninstall enabled"
            self.curAction = 'uninstall'
    
    @pyqtSignature("bool")
    def on_latest_radiobutton_toggled(self, istoggled):
        if istoggled == 1:
            print "latest driver"
            self.curFlavour = 'latest'
    
    @pyqtSignature("bool")
    def on_middle_radiobutton_toggled(self, istoggled):
        if istoggled == 1:
            print "middle driver"
            self.curFlavour = 'middle'
    
    @pyqtSignature("bool")
    def on_oldest_radiobutton_toggled(self, istoggled):
        if istoggled == 1:
            print "oldest driver"
            self.curFlavour = 'oldest'
    
    @pyqtSignature("bool")
    def on_beta_radiobutton_toggled(self, istoggled):
        if istoggled == 1:
            print "beta driver"
            self.curFlavour = 'beta'
    
    @pyqtSignature("bool")
    def on_save_checkbox_toggled(self, istoggled):
        if istoggled == 1:
            print "Save enabled"
        elif istoggled == 0:
            print "Save disabled"
            self.build_checkbox.setChecked(istoggled)
        self.savePackages = istoggled
            
    
    @pyqtSignature("bool")
    def on_build_checkbox_toggled(self, istoggled):
        if istoggled == 1:
            print "Build Only enabled"
        elif istoggled == 0:
            print "Build Only disabled"
        self.buildOnly = istoggled
    
    @pyqtSignature("")
    def on_about_button_clicked(self):
        version = QString(objects.envyver())
        about = qtabout.AboutDlg(version, self)
        about.label.setPixmap(QPixmap('/usr/share/envyng-qt/pixmaps/envyng.png'))
        about.setWindowIcon(QIcon('/usr/share/envyng-qt/pixmaps/envyng.png'))
        about.show()

    def depTryNot(self):
        #self.sessioncheck()
        testme = classes.Shutilities()
        self.missingpkgs = testme.envydeps(self.qtdeps)
        if self.missingpkgs != None:#missing dependencies
            self.deperror()
        else:
            self.show()

        
    def depTry(self):
        self.sessioncheck()
        testme = classes.Shutilities()
        self.missingpkgs = testme.envydeps(self.qtdeps)
        if self.missingpkgs != None:#missing dependencies
            self.deperror()
        else:
            self.show()
    
    def deperror(self):
        pkgs = classes.Shutilities()
        errpkgs = pkgs.envydeps(self.qtdeps)
        #errpkgs = ['pacchetto1', 'pacchetto2', 'pacchetto3']

        response = False
        # buttons texts
        CLOSE = self.translation.string_close_button

        message = QMessageBox(self)
        message.setText(self.translation.string_connection_error)
        message.setWindowTitle(self.translation.string_error_title)
        message.setIcon(QMessageBox.Critical)
        message.addButton(CLOSE, QMessageBox.RejectRole)
        message.exec_()
        response = message.clickedButton().text()
#        if response == CLOSE:
#            self.depTry()
            #print response
        
        
    
    def initdepStart(self):#,  widget
        response = False
        # buttons texts
        YES = self.translation.string_yes
        NO = self.translation.string_no

        message = QMessageBox(self)
        message.setText(self.translation.string_install_deps)
        message.setWindowTitle('EnvyNG')
        message.setIcon(QMessageBox.Question)
        message.addButton(YES, QMessageBox.AcceptRole)
        message.addButton(NO, QMessageBox.RejectRole)
        #message.setDetailedText('(EnvyNG won\'t work without them)')
        message.exec_()
        response = message.clickedButton().text()
        if response == YES:
            self.depTry()
            #print response
        elif response == NO:
            self.depTryNot()
            #print response
        
    def depcheck(self, data=None):
        testme = classes.Shutilities()
        #self.missingpkgs = testme.envydeps(self.qtdeps)
        
        #if self.missingpkgs != None:#missing dependencies
        print 'TESTING CONNECTION'
        if classes.connectionCheck():
            print 'OK: Connection is available'
            self.show()
            self.checkLatest()

        else:
            print 'ERROR: Connection is not available'
            self.deperror()
        #else:
            #self.show()
        
    def kderefresh(self, data=None):
        '''
        dependency > make sure adept-batch is installed
        
        it uses apt-get like syntax
        
        adept_batch install, adept_batch remove
        '''
        commd = classes.Shutilities()
        commd.cmdoutput('kdesu /usr/bin/adept_batch update')
        
    def kdeinstall(self, data=None):
        commd = classes.Shutilities()
        commd.cmdoutput('kdesu /usr/bin/adept_batch install ' + \
        ' '.join(self.missingpkgs))
        
    def sessioncheck(self, data=None):
        '''
        FIX ME
        '''
        if os.path.isfile('/usr/bin/adept_batch') == True:
            self.kderefresh()
            self.kdeinstall()
        #elif self.session == 'kde' and os.path.isfile('/usr/bin/adept_batch') == True:
            #self.kderefresh()
            #self.kdeinstall()
    
    def osdetect(self, data=None):
        getver = classes.Specsdetect()
        getver.codename()
        self.osver = getver.details['osname']
    
    def checkLatest(self, data=None):
        variables = classes.Vars(1)
        self.atilatest = variables.atimanlatest
        self.atinewlegacy = variables.atimannewlegacy
        self.atilegacy = variables.atimanlegacy
        self.nvbeta = variables.nvmanbeta
        self.nvlatest = variables.nvmanlatest
        self.nvnewlegacy = variables.nvmannewlegacy
        self.nvlegacy = variables.nvmanlegacy
        
        self.atiVersions = {'latest': self.atilatest,  'middle': self.atinewlegacy, 'oldest': self.atilegacy,  'beta': None}
        self.nvidiaVersions = {'latest': self.nvlatest,  'middle': self.nvnewlegacy, 'oldest': self.nvlegacy,  'beta': self.nvbeta}
        self.driverMap = {'ATI': self.atiVersions, 'NVIDIA': self.nvidiaVersions}
        self.setLabels()



if __name__ == '__main__':
    import sys
    os.chdir('/usr/share/envy')
    app = QApplication(sys.argv)
    form = EnvyMainDlg()
    #form.show()
    app.exec_()
