/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.adapter.avalon;

import java.util.Hashtable;
import net.sourceforge.chaperon.model.grammar.Associativity;
import net.sourceforge.chaperon.model.grammar.Grammar;
import net.sourceforge.chaperon.model.grammar.Production;
import net.sourceforge.chaperon.model.symbol.Nonterminal;
import net.sourceforge.chaperon.model.symbol.SymbolList;
import net.sourceforge.chaperon.model.symbol.Terminal;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class GrammarFactory {
    public static final String NS = "http://chaperon.sourceforge.net/schema/grammar/1.0";
    public static final String GRAMMAR_ELEMENT = "grammar";
    public static final String PRODUCTION_ELEMENT = "production";
    public static final String PRECEDENCE_ATTRIBUTE = "precedence";
    public static final String NONTERMINALSYMBOL_ELEMENT = "nonterminal";
    public static final String TERMINALSYMBOL_ELEMENT = "terminal";
    public static final String STARTSYMBOL_ELEMENT = "start";
    public static final String PRIORITY_ELEMENT = "priority";
    public static final String ASSOCIATIVITY_ELEMENT = "associativity";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String SYMBOL_ATTRIBUTE = "symbol";

    public static Grammar createGrammar(Configuration config) throws ConfigurationException {
        int i;
        if (!config.getName().equals(GRAMMAR_ELEMENT)) {
            return null;
        }
        Hashtable terminals = new Hashtable();
        Hashtable nonterminals = new Hashtable();
        Grammar grammar = new Grammar();
        grammar.setLocation(config.getLocation());
        Configuration priorityconfig = config.getChild(PRIORITY_ELEMENT);
        if (priorityconfig != null) {
            Configuration[] terminalconfigs = priorityconfig.getChildren(TERMINALSYMBOL_ELEMENT);
            i = 0;
            while (i < terminalconfigs.length) {
                grammar.setPriority(GrammarFactory.getTerminal(terminals, terminalconfigs[i].getAttribute(SYMBOL_ATTRIBUTE)), terminalconfigs.length - i);
                ++i;
            }
        }
        Configuration[] assocconfigs = config.getChildren(ASSOCIATIVITY_ELEMENT);
        i = 0;
        while (i < assocconfigs.length) {
            grammar.setAssociativity(GrammarFactory.getTerminal(terminals, assocconfigs[i].getAttribute(SYMBOL_ATTRIBUTE)), new Associativity(assocconfigs[i].getAttribute(TYPE_ATTRIBUTE)));
            ++i;
        }
        Configuration[] productionconfigs = config.getChildren(PRODUCTION_ELEMENT);
        int i2 = 0;
        while (i2 < productionconfigs.length) {
            Production production = new Production(GrammarFactory.getNonterminal(nonterminals, productionconfigs[i2].getAttribute(SYMBOL_ATTRIBUTE)));
            production.setLocation(productionconfigs[i2].getLocation());
            if (productionconfigs[i2].getAttribute(PRECEDENCE_ATTRIBUTE, null) != null) {
                production.setPrecedence(GrammarFactory.getTerminal(terminals, productionconfigs[i2].getAttribute(PRECEDENCE_ATTRIBUTE)));
            }
            Configuration[] childs = productionconfigs[i2].getChildren();
            SymbolList definition = new SymbolList();
            int j = 0;
            while (j < childs.length) {
                if (childs[j].getName().equals(TERMINALSYMBOL_ELEMENT)) {
                    definition.addSymbol(GrammarFactory.getTerminal(terminals, childs[j].getAttribute(SYMBOL_ATTRIBUTE)));
                } else if (childs[j].getName().equals(NONTERMINALSYMBOL_ELEMENT)) {
                    definition.addSymbol(GrammarFactory.getNonterminal(nonterminals, childs[j].getAttribute(SYMBOL_ATTRIBUTE)));
                }
                ++j;
            }
            production.setDefinition(definition);
            grammar.addProduction(production);
            ++i2;
        }
        Configuration startconfig = config.getChild(STARTSYMBOL_ELEMENT);
        grammar.setStartSymbol(GrammarFactory.getNonterminal(nonterminals, startconfig.getAttribute(SYMBOL_ATTRIBUTE)));
        return grammar;
    }

    private static Nonterminal getNonterminal(Hashtable nonterminals, String name) {
        Nonterminal nonterminal = (Nonterminal)nonterminals.get(name);
        if (nonterminal == null) {
            nonterminal = new Nonterminal(name);
            nonterminals.put(name, nonterminal);
        }
        return nonterminal;
    }

    private static Terminal getTerminal(Hashtable terminals, String name) {
        Terminal terminal = (Terminal)terminals.get(name);
        if (terminal == null) {
            terminal = new Terminal(name);
            terminals.put(name, terminal);
        }
        return terminal;
    }
}

