/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.adapter.avalon;

import net.sourceforge.chaperon.model.pattern.Alternation;
import net.sourceforge.chaperon.model.pattern.BeginOfLine;
import net.sourceforge.chaperon.model.pattern.CharacterClass;
import net.sourceforge.chaperon.model.pattern.CharacterClassElement;
import net.sourceforge.chaperon.model.pattern.CharacterInterval;
import net.sourceforge.chaperon.model.pattern.CharacterSet;
import net.sourceforge.chaperon.model.pattern.CharacterString;
import net.sourceforge.chaperon.model.pattern.Concatenation;
import net.sourceforge.chaperon.model.pattern.EndOfLine;
import net.sourceforge.chaperon.model.pattern.Pattern;
import net.sourceforge.chaperon.model.pattern.PatternGroup;
import net.sourceforge.chaperon.model.pattern.UniversalCharacter;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;

public class PatternFactory {
    public static final String NS = "http://chaperon.sourceforge.net/schema/pattern/1.0";
    public static final String ALTERNATION_ELEMENT = "alt";
    public static final String BEGINOFLINE_ELEMENT = "bol";
    public static final String CHARACTERCLASS_ELEMENT = "cclass";
    public static final String EXCLUSIVE_ATTRIBUTE = "exclusive";
    public static final String CHARACTERINTERVAL_ELEMENT = "cinterval";
    public static final String CHARACTERINTERVAL_MIN_ATTRIBUTE = "min";
    public static final String CHARACTERINTERVAL_MAX_ATTRIBUTE = "max";
    public static final String CHARACTERSTRING_ELEMENT = "cstring";
    public static final String CHARACTERSTRING_SEQUENCE_ATTRIBUTE = "content";
    public static final String CHARACTERSET_ELEMENT = "cset";
    public static final String CHARACTERSET_CHARACTERS_ATTRIBUTE = "content";
    public static final String CODE_ATTRIBUTE = "code";
    public static final String CONCATENATION_ELEMENT = "concat";
    public static final String GROUP_ELEMENT = "group";
    public static final String UNIVERSALCHARACTER_ELEMENT = "cuniversal";
    public static final String ENDOFLINE_ELEMENT = "eol";
    public static final String MINOCCURS_ATTRIBUTE = "minOccurs";
    public static final String MAXOCCURS_ATTRIBUTE = "maxOccurs";

    private static CharacterClassElement createCharacterClassElement(Configuration config) throws ConfigurationException {
        if (config.getName().equals(CHARACTERINTERVAL_ELEMENT)) {
            CharacterInterval cinterval = new CharacterInterval();
            cinterval.setMinimum(config.getAttribute(CHARACTERINTERVAL_MIN_ATTRIBUTE).charAt(0));
            cinterval.setMaximum(config.getAttribute(CHARACTERINTERVAL_MAX_ATTRIBUTE).charAt(0));
            return cinterval;
        }
        if (config.getName().equals(CHARACTERSET_ELEMENT)) {
            CharacterSet cset = new CharacterSet();
            if (config.getAttribute(CODE_ATTRIBUTE, null) != null) {
                char character = (char)Integer.decode(config.getAttribute(CODE_ATTRIBUTE)).intValue();
                cset.setCharacters(String.valueOf(character));
            } else {
                cset.setCharacters(config.getAttribute("content"));
            }
            return cset;
        }
        return null;
    }

    public static Pattern createPattern(Configuration config) throws ConfigurationException {
        if (config.getName().equals(ALTERNATION_ELEMENT)) {
            Alternation alternation = new Alternation();
            alternation.setLocation(config.getLocation());
            alternation.setMinOccurs(PatternFactory.getMinOccursFromAttributes(config));
            alternation.setMaxOccurs(PatternFactory.getMaxOccursFromAttributes(config));
            Configuration[] childs = config.getChildren();
            int i = 0;
            while (i < childs.length) {
                alternation.addPattern(PatternFactory.createPattern(childs[i]));
                ++i;
            }
            return alternation;
        }
        if (config.getName().equals(BEGINOFLINE_ELEMENT)) {
            BeginOfLine bol = new BeginOfLine();
            bol.setLocation(config.getLocation());
            bol.setMinOccurs(PatternFactory.getMinOccursFromAttributes(config));
            bol.setMaxOccurs(PatternFactory.getMaxOccursFromAttributes(config));
            return bol;
        }
        if (config.getName().equals(CHARACTERCLASS_ELEMENT)) {
            CharacterClass cclass = new CharacterClass();
            cclass.setLocation(config.getLocation());
            cclass.setMinOccurs(PatternFactory.getMinOccursFromAttributes(config));
            cclass.setMaxOccurs(PatternFactory.getMaxOccursFromAttributes(config));
            cclass.setExclusive(config.getAttributeAsBoolean(EXCLUSIVE_ATTRIBUTE, false));
            Configuration[] childs = config.getChildren();
            int i = 0;
            while (i < childs.length) {
                cclass.addCharacterClassElement(PatternFactory.createCharacterClassElement(childs[i]));
                ++i;
            }
            return cclass;
        }
        if (config.getName().equals(CHARACTERSTRING_ELEMENT)) {
            CharacterString cstring = new CharacterString();
            cstring.setLocation(config.getLocation());
            cstring.setMinOccurs(PatternFactory.getMinOccursFromAttributes(config));
            cstring.setMaxOccurs(PatternFactory.getMaxOccursFromAttributes(config));
            if (config.getAttribute(CODE_ATTRIBUTE, null) != null) {
                char character = (char)Integer.decode(config.getAttribute(CODE_ATTRIBUTE)).intValue();
                cstring.setString(String.valueOf(character));
            } else {
                cstring.setString(config.getAttribute("content"));
            }
            return cstring;
        }
        if (config.getName().equals(CONCATENATION_ELEMENT)) {
            Concatenation concat = new Concatenation();
            concat.setLocation(config.getLocation());
            concat.setMinOccurs(PatternFactory.getMinOccursFromAttributes(config));
            concat.setMaxOccurs(PatternFactory.getMaxOccursFromAttributes(config));
            Configuration[] childs = config.getChildren();
            int i = 0;
            while (i < childs.length) {
                concat.addPattern(PatternFactory.createPattern(childs[i]));
                ++i;
            }
            return concat;
        }
        if (config.getName().equals(GROUP_ELEMENT)) {
            PatternGroup group = new PatternGroup();
            group.setLocation(config.getLocation());
            group.setMinOccurs(PatternFactory.getMinOccursFromAttributes(config));
            group.setMaxOccurs(PatternFactory.getMaxOccursFromAttributes(config));
            Configuration[] childs = config.getChildren();
            int i = 0;
            while (i < childs.length) {
                group.addPattern(PatternFactory.createPattern(childs[i]));
                ++i;
            }
            return group;
        }
        if (config.getName().equals(UNIVERSALCHARACTER_ELEMENT)) {
            UniversalCharacter cuniversal = new UniversalCharacter();
            cuniversal.setLocation(config.getLocation());
            cuniversal.setMinOccurs(PatternFactory.getMinOccursFromAttributes(config));
            cuniversal.setMaxOccurs(PatternFactory.getMaxOccursFromAttributes(config));
            return cuniversal;
        }
        if (config.getName().equals(ENDOFLINE_ELEMENT)) {
            EndOfLine eol = new EndOfLine();
            eol.setLocation(config.getLocation());
            eol.setMinOccurs(PatternFactory.getMinOccursFromAttributes(config));
            eol.setMaxOccurs(PatternFactory.getMaxOccursFromAttributes(config));
            return eol;
        }
        return null;
    }

    private static int getMaxOccursFromAttributes(Configuration config) throws ConfigurationException {
        String attribute = config.getAttribute(MAXOCCURS_ATTRIBUTE, null);
        if (attribute != null && attribute.length() > 0 && attribute.equals("*")) {
            return Integer.MAX_VALUE;
        }
        return config.getAttributeAsInteger(MAXOCCURS_ATTRIBUTE, 1);
    }

    private static int getMinOccursFromAttributes(Configuration config) throws ConfigurationException {
        return config.getAttributeAsInteger(MINOCCURS_ATTRIBUTE, 1);
    }
}

