/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.build;

import net.sourceforge.chaperon.build.EmptyList;
import net.sourceforge.chaperon.common.IntegerList;
import net.sourceforge.chaperon.model.grammar.Grammar;
import net.sourceforge.chaperon.model.symbol.Symbol;
import net.sourceforge.chaperon.model.symbol.SymbolList;
import net.sourceforge.chaperon.model.symbol.SymbolSet;
import net.sourceforge.chaperon.model.symbol.Terminal;
import org.apache.avalon.framework.logger.Logger;

public class FirstSetCollection {
    private Grammar grammar;
    private Symbol[] symbols;
    private SymbolSet[] firstsets;
    private Logger logger;
    private static final EmptyList EMPTYLIST = new EmptyList();

    public FirstSetCollection(Grammar grammar) {
        this(grammar, null);
    }

    public FirstSetCollection(Grammar grammar, Logger logger) {
        this.grammar = grammar;
        this.logger = logger;
        SymbolSet usedsymbols = grammar.getSymbols();
        this.symbols = new Symbol[usedsymbols.getSymbolCount()];
        this.firstsets = new SymbolSet[usedsymbols.getSymbolCount()];
        int i = 0;
        while (i < usedsymbols.getSymbolCount()) {
            if (logger != null) {
                logger.debug("Generating first set for " + usedsymbols.getSymbol(i).getName());
            }
            this.symbols[i] = usedsymbols.getSymbol(i);
            this.firstsets[i] = this.first(this.symbols[i]);
            ++i;
        }
    }

    private SymbolSet first(Symbol symbol) {
        return this.first(symbol, new SymbolSet());
    }

    private SymbolSet first(Symbol symbol, SymbolSet visited) {
        SymbolSet firstset = new SymbolSet();
        if (symbol instanceof Terminal) {
            firstset.addSymbol(symbol);
            return firstset;
        }
        if (visited.contains(symbol)) {
            return firstset;
        }
        visited.addSymbol(symbol);
        IntegerList productions = this.grammar.getProductionList(symbol);
        SymbolSet examined = new SymbolSet();
        int i = 0;
        while (i < productions.getCount()) {
            SymbolList productiondefinition = this.grammar.getProduction(productions.get(i)).getDefinition();
            if (productiondefinition.getSymbolCount() == 0) {
                firstset.addSymbol(EMPTYLIST);
            } else {
                boolean foundEmptyList;
                Symbol newsymbol;
                int j = 0;
                do {
                    foundEmptyList = true;
                    newsymbol = productiondefinition.getSymbol(j);
                    if (newsymbol instanceof Terminal) {
                        firstset.addSymbol(newsymbol);
                        continue;
                    }
                    if (newsymbol.equals(symbol) || examined.contains(newsymbol)) continue;
                    SymbolSet newfirstset = this.first(newsymbol, visited);
                    foundEmptyList = newfirstset.contains(EMPTYLIST);
                    int k = 0;
                    while (k < newfirstset.getSymbolCount()) {
                        if (!newfirstset.getSymbol(k).equals(EMPTYLIST)) {
                            firstset.addSymbol(newfirstset.getSymbol(k));
                        }
                        ++k;
                    }
                    examined.addSymbol(newsymbol);
                } while (!(newsymbol instanceof Terminal) && foundEmptyList && ++j < productiondefinition.getSymbolCount() && !productiondefinition.getSymbol(j - 1).equals(symbol));
            }
            ++i;
        }
        return firstset;
    }

    public SymbolSet getFirstSet(Symbol symbol) {
        int i = 0;
        while (i < this.symbols.length) {
            if (this.symbols[i].equals(symbol)) {
                return this.firstsets[i];
            }
            ++i;
        }
        throw new IllegalArgumentException("No first set found for symbol");
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        SymbolSet symbols = this.grammar.getSymbols();
        int symbol = 0;
        while (symbol < symbols.getSymbolCount()) {
            buffer.append("first(");
            buffer.append(symbols.getSymbol(symbol).toString());
            buffer.append(")=");
            buffer.append(this.getFirstSet(symbols.getSymbol(symbol)).toString());
            buffer.append("\n");
            ++symbol;
        }
        return buffer.toString();
    }
}

