/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.build.conflict;

import net.sourceforge.chaperon.build.ItemSetCollection;
import net.sourceforge.chaperon.build.conflict.Conflict;
import net.sourceforge.chaperon.model.grammar.Grammar;
import net.sourceforge.chaperon.model.symbol.Terminal;

public class ShiftReduceConflict
extends Conflict {
    private Grammar grammar;
    private ItemSetCollection itemsets;
    private int state;
    private Terminal symbol;
    private int production;

    public ShiftReduceConflict(Grammar grammar, ItemSetCollection itemsets, int state, Terminal symbol, int production) {
        this.grammar = grammar;
        this.itemsets = itemsets;
        this.state = state;
        this.symbol = symbol;
        this.production = production;
    }

    public int getProduction() {
        return this.production;
    }

    public int getState() {
        return this.state;
    }

    public Terminal getSymbol() {
        return this.symbol;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Shift/Reduce conflict in state ");
        buffer.append(String.valueOf(this.state));
        buffer.append(" at");
        buffer.append(System.getProperty("line.separator"));
        buffer.append(this.grammar.getProduction(this.production));
        buffer.append("[priority=");
        buffer.append(String.valueOf(this.grammar.getPriority(this.grammar.getProduction(this.production))));
        buffer.append(" associativity=");
        buffer.append(String.valueOf(this.grammar.getAssociativity(this.grammar.getProduction(this.production))));
        buffer.append("]");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("and symbol ");
        buffer.append(this.symbol);
        buffer.append("[priority=");
        buffer.append(String.valueOf(this.grammar.getPriority(this.symbol)));
        buffer.append(" associativity=");
        buffer.append(String.valueOf(this.grammar.getAssociativity(this.symbol)));
        buffer.append("]");
        return buffer.toString();
    }
}

