/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.common;

import java.util.EmptyStackException;
import net.sourceforge.chaperon.common.IntegerCollection;

public class IntegerList
implements IntegerCollection {
    private int capacityIncrement = 100;
    private int elementCount = 0;
    private int[] list = new int[10];
    private int dummy;

    public int add(int value) {
        this.ensureCapacity(this.elementCount + 1);
        this.list[this.elementCount++] = value;
        return this.elementCount - 1;
    }

    public void add(IntegerCollection collection) {
        int i = 0;
        while (i < collection.getCount()) {
            this.add(collection.get(i));
            ++i;
        }
    }

    public void add(int[] array) {
        int i = 0;
        while (i < array.length) {
            this.add(array[i]);
            ++i;
        }
    }

    public void clear() {
        this.elementCount = 0;
    }

    public boolean contains(int value) {
        int i = 0;
        while (i < this.elementCount) {
            if (this.list[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void ensureCapacity(int minCapacity) {
        if (this.list.length >= minCapacity) {
            return;
        }
        int newCapacity = this.list.length + this.capacityIncrement;
        if (this.capacityIncrement <= 0) {
            newCapacity = this.list.length * 2;
        }
        int[] newArray = new int[Math.max(newCapacity, minCapacity)];
        System.arraycopy(this.list, 0, newArray, 0, this.list.length);
        this.list = newArray;
    }

    public int get(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.list[index];
    }

    public int getCount() {
        return this.elementCount;
    }

    public int indexOf(int value) {
        int i = 0;
        while (i < this.elementCount) {
            if (this.list[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.elementCount <= 0;
    }

    public int peek() {
        if (this.elementCount <= 0) {
            throw new EmptyStackException();
        }
        return this.list[this.elementCount - 1];
    }

    public int pop() {
        if (this.elementCount <= 0) {
            throw new EmptyStackException();
        }
        return this.list[--this.elementCount];
    }

    public void push(int value) {
        this.add(value);
    }

    public void push(int[] values) {
        this.add(values);
    }

    public void remove(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        --this.elementCount;
        if (index < this.elementCount) {
            System.arraycopy(this.list, index + 1, this.list, index, this.elementCount - index);
        }
        this.list[this.elementCount] = 0;
    }

    public void removeValue(int value) {
        int index;
        while ((index = this.indexOf(value)) != -1) {
            this.remove(index);
        }
    }

    public void set(int index, int value) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.list[index] = value;
    }

    public void swap(int index1, int index2) {
        this.dummy = this.list[index1];
        this.list[index1] = this.list[index2];
        this.list[index2] = this.dummy;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        int i = 0;
        while (i < this.elementCount) {
            buffer.append(String.valueOf(this.list[i]));
            if (i < this.elementCount - 1) {
                buffer.append(",");
            }
            ++i;
        }
        buffer.append("]");
        return buffer.toString();
    }
}

