/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.cocoon.Constants;
import org.apache.cocoon.bean.CocoonBean;
import org.apache.cocoon.bean.helpers.OutputStreamListener;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Main {
    protected static final String HELP_OPT = "h";
    protected static final String VERSION_OPT = "v";
    protected static final String VERBOSE_OPT = "V";
    protected static final String LOG_KIT_OPT = "k";
    protected static final String LOGGER_OPT = "l";
    protected static final String LOG_LEVEL_OPT = "u";
    protected static final String CONTEXT_DIR_OPT = "c";
    protected static final String DEST_DIR_OPT = "d";
    protected static final String WORK_DIR_OPT = "w";
    protected static final String CONFIG_FILE_OPT = "C";
    protected static final String BROKEN_LINK_FILE_OPT = "b";
    protected static final String URI_FILE_OPT = "f";
    protected static final String XCONF_OPT = "x";
    protected static final String AGENT_OPT = "a";
    protected static final String ACCEPT_OPT = "p";
    protected static final String FOLLOW_LINKS_OPT = "r";
    protected static final String PRECOMPILE_ONLY_OPT = "P";
    protected static final String CONFIRM_EXTENSIONS_OPT = "e";
    protected static final String LOAD_CLASS_OPT = "L";
    protected static final String DEFAULT_FILENAME_OPT = "D";
    protected static final String URI_GROUP_NAME_OPT = "n";
    protected static final String HELP_LONG = "help";
    protected static final String VERSION_LONG = "version";
    protected static final String VERBOSE_LONG = "verbose";
    protected static final String LOG_KIT_LONG = "logKitconfig";
    protected static final String LOGGER_LONG = "Logger";
    protected static final String LOG_LEVEL_LONG = "logLevel";
    protected static final String CONTEXT_DIR_LONG = "contextDir";
    protected static final String DEST_DIR_LONG = "destDir";
    protected static final String WORK_DIR_LONG = "workDir";
    protected static final String CONFIG_FILE_LONG = "configFile";
    protected static final String BROKEN_LINK_FILE_LONG = "brokenLinkFile";
    protected static final String URI_FILE_LONG = "uriFile";
    protected static final String XCONF_LONG = "xconf";
    protected static final String AGENT_LONG = "userAgent";
    protected static final String ACCEPT_LONG = "accept";
    protected static final String FOLLOW_LINKS_LONG = "followLinks";
    protected static final String PRECOMPILE_ONLY_LONG = "precompileOnly";
    protected static final String CONFIRM_EXTENSIONS_LONG = "confirmExtensions";
    protected static final String LOAD_CLASS_LONG = "loadClass";
    protected static final String DEFAULT_FILENAME_LONG = "defaultFilename";
    protected static final String URI_LONG = "uri";
    protected static final String URI_GROUP_NAME_LONG = "uris";
    private static final String NODE_ROOT = "cocoon";
    private static final String ATTR_VERBOSE = "verbose";
    private static final String NODE_LOGGING = "logging";
    private static final String ATTR_LOG_KIT = "log-kit";
    private static final String ATTR_LOG_LEVEL = "level";
    private static final String ATTR_LOGGER = "logger";
    private static final String NODE_CONTEXT_DIR = "context-dir";
    private static final String NODE_DEST_DIR = "dest-dir";
    private static final String NODE_WORK_DIR = "work-dir";
    private static final String NODE_CONFIG_FILE = "config-file";
    private static final String NODE_URI_FILE = "uri-file";
    private static final String NODE_BROKEN_LINKS = "broken-links";
    private static final String ATTR_BROKEN_LINK_REPORT_TYPE = "type";
    private static final String ATTR_BROKEN_LINK_REPORT_FILE = "file";
    private static final String ATTR_BROKEN_LINK_GENERATE = "generate";
    private static final String ATTR_BROKEN_LINK_EXTENSION = "extension";
    private static final String NODE_AGENT = "user-agent";
    private static final String NODE_ACCEPT = "accept";
    private static final String ATTR_FOLLOW_LINKS = "follow-links";
    private static final String ATTR_PRECOMPILE_ONLY = "precompile-only";
    private static final String ATTR_CONFIRM_EXTENSIONS = "confirm-extensions";
    private static final String NODE_LOAD_CLASS = "load-class";
    private static final String NODE_DEFAULT_FILENAME = "default-filename";
    private static final String NODE_INCLUDE = "include";
    private static final String NODE_EXCLUDE = "exclude";
    private static final String ATTR_INCLUDE_EXCLUDE_PATTERN = "pattern";
    private static final String NODE_INCLUDE_LINKS = "include-links";
    private static final String ATTR_LINK_EXTENSION = "extension";
    private static final String NODE_URI = "uri";
    private static final String ATTR_URI_TYPE = "type";
    private static final String ATTR_URI_SOURCEPREFIX = "src-prefix";
    private static final String ATTR_URI_SOURCEURI = "src";
    private static final String ATTR_URI_DESTURI = "dest";
    private static final String NODE_URIS = "uris";
    private static final String ATTR_NAME = "name";
    private static Options options;
    private static OutputStreamListener listener;

    private static void setOptions() {
        options = new Options();
        options.addOption(new Option(HELP_OPT, HELP_LONG, false, "print this message and exit"));
        options.addOption(new Option(VERSION_OPT, VERSION_LONG, false, "print the version information and exit"));
        options.addOption(new Option(VERBOSE_OPT, "verbose", false, "enable verbose messages to System.out"));
        options.addOption(new Option(LOG_KIT_OPT, LOG_KIT_LONG, true, "use given file for LogKit Management configuration"));
        options.addOption(new Option(LOGGER_OPT, LOGGER_LONG, true, "use given logger category as default logger for the Cocoon engine"));
        options.addOption(new Option(LOG_LEVEL_OPT, LOG_LEVEL_LONG, true, "choose the minimum log level for logging (DEBUG, INFO, WARN, ERROR, FATAL_ERROR) for startup logging"));
        options.addOption(new Option(CONTEXT_DIR_OPT, CONTEXT_DIR_LONG, true, "use given dir as context"));
        options.addOption(new Option(DEST_DIR_OPT, DEST_DIR_LONG, true, "use given dir as destination"));
        options.addOption(new Option(WORK_DIR_OPT, WORK_DIR_LONG, true, "use given dir as working directory"));
        options.addOption(new Option(CONFIG_FILE_OPT, CONFIG_FILE_LONG, true, "specify alternate location of the configuration file (default is ${contextDir}/cocoon.xconf)"));
        options.addOption(new Option(BROKEN_LINK_FILE_OPT, BROKEN_LINK_FILE_LONG, true, "send a list of broken links to a file (one URI per line)"));
        options.addOption(new Option(URI_FILE_OPT, URI_FILE_LONG, true, "use a text file with uris to process (one URI per line)"));
        options.addOption(new Option(XCONF_OPT, XCONF_LONG, true, "specify a file containing XML configuration details for the command line interface"));
        options.addOption(new Option(AGENT_OPT, AGENT_LONG, true, "use given string for user-agent header"));
        options.addOption(new Option(ACCEPT_OPT, "accept", true, "use given string for accept header"));
        options.addOption(new Option(FOLLOW_LINKS_OPT, FOLLOW_LINKS_LONG, true, "process pages linked from starting page or not (boolean argument is expected, default is true)"));
        options.addOption(new Option(PRECOMPILE_ONLY_OPT, PRECOMPILE_ONLY_LONG, true, "generate java code for xsp and xmap files"));
        options.addOption(new Option(CONFIRM_EXTENSIONS_OPT, CONFIRM_EXTENSIONS_LONG, true, "confirm that file extensions match mime-type of pages and amend filename accordingly (default is true)"));
        options.addOption(new Option(LOAD_CLASS_OPT, LOAD_CLASS_LONG, true, "specify a class to be loaded at startup (specifically for use with JDBC). Can be used multiple times"));
        options.addOption(new Option(DEFAULT_FILENAME_OPT, DEFAULT_FILENAME_LONG, true, "specify a filename to be appended to a URI when the URI refers to a directory"));
        options.addOption(new Option(URI_GROUP_NAME_OPT, "uris", true, "specify which <uris> element to process in the configuration file specified with the -x parameter"));
    }

    public static void main(String[] args) throws Exception {
        Main.setOptions();
        CommandLine line = new PosixParser().parse(options, args);
        listener = new OutputStreamListener(System.out);
        CocoonBean cocoon = new CocoonBean();
        cocoon.addListener(listener);
        if (line.hasOption(HELP_OPT)) {
            Main.printUsage();
        } else if (line.hasOption(VERSION_OPT)) {
            Main.printVersion();
        }
        String uriGroup = null;
        if (line.hasOption(URI_GROUP_NAME_OPT)) {
            uriGroup = line.getOptionValue(URI_GROUP_NAME_OPT);
        }
        String destDir = null;
        if (line.hasOption(XCONF_OPT)) {
            destDir = Main.processXConf(cocoon, line.getOptionValue(XCONF_OPT), destDir, uriGroup);
        }
        if (line.hasOption(DEST_DIR_OPT)) {
            destDir = line.getOptionValue(DEST_DIR_OPT);
        }
        if (line.hasOption(VERBOSE_OPT)) {
            cocoon.setVerbose(true);
        }
        if (line.hasOption(PRECOMPILE_ONLY_OPT)) {
            cocoon.setPrecompileOnly(true);
        }
        if (line.hasOption(WORK_DIR_OPT)) {
            String workDir = line.getOptionValue(WORK_DIR_OPT);
            if (workDir.equals("")) {
                listener.messageGenerated("Careful, you must specify a work dir when using the -w/--workDir argument");
                System.exit(1);
            } else {
                cocoon.setWorkDir(line.getOptionValue(WORK_DIR_OPT));
            }
        }
        if (line.hasOption(CONTEXT_DIR_OPT)) {
            String contextDir = line.getOptionValue(CONTEXT_DIR_OPT);
            if (contextDir.equals("")) {
                listener.messageGenerated("Careful, you must specify a configuration file when using the -c/--contextDir argument");
                System.exit(1);
            } else {
                cocoon.setContextDir(contextDir);
            }
        }
        if (line.hasOption(CONFIG_FILE_OPT)) {
            cocoon.setConfigFile(line.getOptionValue(CONFIG_FILE_OPT));
        }
        if (line.hasOption(LOG_KIT_OPT)) {
            cocoon.setLogKit(line.getOptionValue(LOG_KIT_OPT));
        }
        if (line.hasOption(LOGGER_OPT)) {
            cocoon.setLogger(line.getOptionValue(LOGGER_OPT));
        }
        if (line.hasOption(LOG_LEVEL_OPT)) {
            cocoon.setLogLevel(line.getOptionValue(LOG_LEVEL_OPT));
        }
        if (line.hasOption(AGENT_OPT)) {
            cocoon.setAgentOptions(line.getOptionValue(AGENT_OPT));
        }
        if (line.hasOption(ACCEPT_OPT)) {
            cocoon.setAcceptOptions(line.getOptionValue(ACCEPT_OPT));
        }
        if (line.hasOption(DEFAULT_FILENAME_OPT)) {
            cocoon.setDefaultFilename(line.getOptionValue(DEFAULT_FILENAME_OPT));
        }
        if (line.hasOption(BROKEN_LINK_FILE_OPT)) {
            listener.setReportFile(line.getOptionValue(BROKEN_LINK_FILE_OPT));
        }
        if (line.hasOption(URI_FILE_OPT)) {
            cocoon.addTargets(Main.processURIFile(line.getOptionValue(URI_FILE_OPT)), destDir);
        }
        if (line.hasOption(FOLLOW_LINKS_OPT)) {
            cocoon.setFollowLinks(Main.yesno(line.getOptionValue(FOLLOW_LINKS_OPT)));
        }
        if (line.hasOption(CONFIRM_EXTENSIONS_OPT)) {
            cocoon.setConfirmExtensions(Main.yesno(line.getOptionValue(CONFIRM_EXTENSIONS_OPT, "yes")));
        }
        if (line.hasOption(LOAD_CLASS_OPT)) {
            cocoon.addLoadedClasses(Arrays.asList(line.getOptionValues(LOAD_CLASS_OPT)));
        }
        cocoon.addTargets(line.getArgList(), destDir);
        System.out.println(Main.getProlog());
        cocoon.initialize();
        cocoon.process();
        cocoon.dispose();
        listener.complete();
        int exitCode = listener.isSuccessful() ? 0 : 1;
        System.exit(exitCode);
    }

    private static boolean yesno(String in) {
        return "yes".equals(in) || "true".equals(in);
    }

    public static List processURIFile(String filename) {
        ArrayList<String> uris = new ArrayList<String>();
        try {
            BufferedReader uriFile = new BufferedReader(new FileReader(filename));
            boolean eof = false;
            while (!eof) {
                String uri = uriFile.readLine();
                if (null == uri) {
                    eof = true;
                    continue;
                }
                uris.add(uri.trim());
            }
            uriFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uris;
    }

    private static String processXConf(CocoonBean cocoon, String filename, String destDir, String uriGroup) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document conf = builder.parse(new File(filename).toURL().toExternalForm());
            Element root = conf.getDocumentElement();
            if (!NODE_ROOT.equals(root.getNodeName())) {
                throw new IllegalArgumentException("Expected root node of cocoon");
            }
            if (Main.hasAttribute(root, "verbose")) {
                cocoon.setVerbose(Main.getBooleanAttributeValue(root, "verbose"));
            }
            if (Main.hasAttribute(root, ATTR_FOLLOW_LINKS)) {
                cocoon.setFollowLinks(Main.getBooleanAttributeValue(root, ATTR_FOLLOW_LINKS));
            }
            if (Main.hasAttribute(root, ATTR_PRECOMPILE_ONLY)) {
                cocoon.setPrecompileOnly(Main.getBooleanAttributeValue(root, ATTR_PRECOMPILE_ONLY));
            }
            if (Main.hasAttribute(root, ATTR_CONFIRM_EXTENSIONS)) {
                cocoon.setConfirmExtensions(Main.getBooleanAttributeValue(root, ATTR_CONFIRM_EXTENSIONS));
            }
            if (destDir == null || destDir.length() == 0) {
                destDir = Main.getNodeValue(root, NODE_DEST_DIR);
            }
            NodeList nodes = root.getChildNodes();
            int i = 0;
            while (i < nodes.getLength()) {
                Node node = nodes.item(i);
                if (node.getNodeType() == 1) {
                    String nodeName = node.getNodeName();
                    if (nodeName.equals(NODE_BROKEN_LINKS)) {
                        Main.parseBrokenLinkNode(cocoon, node);
                    } else if (nodeName.equals(NODE_LOAD_CLASS)) {
                        cocoon.addLoadedClass(Main.getNodeValue(node));
                    } else if (nodeName.equals(NODE_LOGGING)) {
                        Main.parseLoggingNode(cocoon, node);
                    } else if (nodeName.equals(NODE_CONTEXT_DIR)) {
                        cocoon.setContextDir(Main.getNodeValue(node));
                    } else if (nodeName.equals(NODE_CONFIG_FILE)) {
                        cocoon.setConfigFile(Main.getNodeValue(node));
                    } else if (!nodeName.equals(NODE_DEST_DIR)) {
                        String pattern;
                        if (nodeName.equals(NODE_WORK_DIR)) {
                            cocoon.setWorkDir(Main.getNodeValue(node));
                        } else if (nodeName.equals(NODE_AGENT)) {
                            cocoon.setAgentOptions(Main.getNodeValue(node));
                        } else if (nodeName.equals("accept")) {
                            cocoon.setAcceptOptions(Main.getNodeValue(node));
                        } else if (nodeName.equals(NODE_DEFAULT_FILENAME)) {
                            cocoon.setDefaultFilename(Main.getNodeValue(node));
                        } else if (nodeName.equals(NODE_INCLUDE)) {
                            pattern = Main.parseIncludeExcludeNode(cocoon, node, NODE_INCLUDE);
                            cocoon.addIncludePattern(pattern);
                        } else if (nodeName.equals(NODE_EXCLUDE)) {
                            pattern = Main.parseIncludeExcludeNode(cocoon, node, NODE_EXCLUDE);
                            cocoon.addExcludePattern(pattern);
                        } else if (nodeName.equals(NODE_INCLUDE_LINKS)) {
                            Main.parseIncludeLinksNode(cocoon, node);
                        } else if (nodeName.equals("uri")) {
                            Main.parseURINode(cocoon, node, destDir);
                        } else if (nodeName.equals("uris")) {
                            Main.parseURIsNode(cocoon, node, destDir, uriGroup);
                        } else if (nodeName.equals(NODE_URI_FILE)) {
                            cocoon.addTargets(Main.processURIFile(Main.getNodeValue(node)), destDir);
                        } else {
                            throw new IllegalArgumentException("Unknown element: <" + nodeName + ">");
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getMessage());
        }
        return destDir;
    }

    private static void parseLoggingNode(CocoonBean cocoon, Node node) throws IllegalArgumentException {
        NodeList nodes;
        if (Main.hasAttribute(node, ATTR_LOG_KIT)) {
            cocoon.setLogKit(Main.getAttributeValue(node, ATTR_LOG_KIT));
        }
        if (Main.hasAttribute(node, ATTR_LOGGER)) {
            cocoon.setLogger(Main.getAttributeValue(node, ATTR_LOGGER));
        }
        if (Main.hasAttribute(node, ATTR_LOG_LEVEL)) {
            cocoon.setLogLevel(Main.getAttributeValue(node, ATTR_LOG_LEVEL));
        }
        if ((nodes = node.getChildNodes()).getLength() != 0) {
            throw new IllegalArgumentException("Unexpected children of <logging> node");
        }
    }

    private static void parseIncludeLinksNode(CocoonBean cocoon, Node node) throws IllegalArgumentException {
        if (Main.hasAttribute(node, "extension")) {
            cocoon.addIncludeLinkExtension(Main.getAttributeValue(node, "extension"));
        }
    }

    private static void parseBrokenLinkNode(CocoonBean cocoon, Node node) throws IllegalArgumentException {
        NodeList nodes;
        if (Main.hasAttribute(node, ATTR_BROKEN_LINK_REPORT_FILE)) {
            listener.setReportFile(Main.getAttributeValue(node, ATTR_BROKEN_LINK_REPORT_FILE));
        }
        if (Main.hasAttribute(node, "type")) {
            listener.setReportType(Main.getAttributeValue(node, "type"));
        }
        if (Main.hasAttribute(node, ATTR_BROKEN_LINK_GENERATE)) {
            cocoon.setBrokenLinkGenerate(Main.getBooleanAttributeValue(node, ATTR_BROKEN_LINK_GENERATE));
        }
        if (Main.hasAttribute(node, "extension")) {
            cocoon.setBrokenLinkExtension(Main.getAttributeValue(node, "extension"));
        }
        if ((nodes = node.getChildNodes()).getLength() != 0) {
            throw new IllegalArgumentException("Unexpected children of <broken-links> node");
        }
    }

    private static String parseIncludeExcludeNode(CocoonBean cocoon, Node node, String NODE_TYPE) throws IllegalArgumentException {
        NodeList nodes = node.getChildNodes();
        if (nodes.getLength() != 0) {
            throw new IllegalArgumentException("Unexpected children of <include> node");
        }
        if (Main.hasAttribute(node, ATTR_INCLUDE_EXCLUDE_PATTERN)) {
            return Main.getAttributeValue(node, ATTR_INCLUDE_EXCLUDE_PATTERN);
        }
        throw new IllegalArgumentException("Expected a pattern attribute for <" + NODE_TYPE + "> node");
    }

    private static void parseURIsNode(CocoonBean cocoon, Node node, String destDir, String uriGroup) throws IllegalArgumentException {
        boolean followLinks = cocoon.followLinks();
        boolean confirmExtensions = cocoon.confirmExtensions();
        String logger = cocoon.getLoggerName();
        String destURI = destDir;
        String root = null;
        String type = null;
        String name = null;
        if (Main.hasAttribute(node, ATTR_FOLLOW_LINKS)) {
            followLinks = Main.getBooleanAttributeValue(node, ATTR_FOLLOW_LINKS);
        }
        if (Main.hasAttribute(node, ATTR_CONFIRM_EXTENSIONS)) {
            confirmExtensions = Main.getBooleanAttributeValue(node, ATTR_CONFIRM_EXTENSIONS);
        }
        if (Main.hasAttribute(node, "type")) {
            type = Main.getAttributeValue(node, "type");
        }
        if (Main.hasAttribute(node, ATTR_URI_SOURCEPREFIX)) {
            root = Main.getAttributeValue(node, ATTR_URI_SOURCEPREFIX);
        }
        if (Main.hasAttribute(node, ATTR_URI_DESTURI)) {
            destURI = Main.getAttributeValue(node, ATTR_URI_DESTURI);
        }
        if (Main.hasAttribute(node, ATTR_LOGGER)) {
            logger = Main.getAttributeValue(node, ATTR_LOGGER);
        }
        if (Main.hasAttribute(node, ATTR_NAME) && (name = Main.getAttributeValue(node, ATTR_NAME)) != null && uriGroup != null && !name.equals(uriGroup)) {
            return;
        }
        NodeList nodes = node.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node child = nodes.item(i);
            if (child.getNodeType() == 1) {
                String childName = child.getNodeName();
                if (childName.equals("uri")) {
                    String _sourceURI = null;
                    String _destURI = destURI;
                    String _root = root;
                    String _type = type;
                    if (child.getAttributes().getLength() == 0) {
                        _sourceURI = Main.getNodeValue(child);
                    } else {
                        _sourceURI = Main.getAttributeValue(child, ATTR_URI_SOURCEURI);
                        if (Main.hasAttribute(child, "type")) {
                            _type = Main.getAttributeValue(child, "type");
                        }
                        if (Main.hasAttribute(child, ATTR_URI_SOURCEPREFIX)) {
                            _root = Main.getAttributeValue(child, ATTR_URI_SOURCEPREFIX);
                        }
                        if (Main.hasAttribute(child, ATTR_URI_DESTURI)) {
                            _destURI = Main.getAttributeValue(child, ATTR_URI_DESTURI);
                        }
                    }
                    cocoon.addTarget(_type, _root, _sourceURI, _destURI, followLinks, confirmExtensions, logger);
                } else {
                    throw new IllegalArgumentException("Unknown element: <" + childName + ">");
                }
            }
            ++i;
        }
    }

    private static void parseURINode(CocoonBean cocoon, Node node, String destDir) throws IllegalArgumentException {
        NodeList nodes = node.getChildNodes();
        if (nodes.getLength() != 0) {
            throw new IllegalArgumentException("Unexpected children of <uri> node");
        }
        if (node.getAttributes().getLength() == 0) {
            cocoon.addTarget(Main.getNodeValue(node), destDir);
        } else {
            String src = Main.getAttributeValue(node, ATTR_URI_SOURCEURI);
            String type = null;
            if (Main.hasAttribute(node, "type")) {
                type = Main.getAttributeValue(node, "type");
            }
            String root = null;
            if (Main.hasAttribute(node, ATTR_URI_SOURCEPREFIX)) {
                root = Main.getAttributeValue(node, ATTR_URI_SOURCEPREFIX);
            }
            String dest = null;
            if (Main.hasAttribute(node, ATTR_URI_DESTURI)) {
                dest = Main.getAttributeValue(node, ATTR_URI_DESTURI);
            }
            if (root != null && type != null & dest != null) {
                cocoon.addTarget(type, root, src, dest);
            } else if (root != null & dest != null) {
                cocoon.addTarget(root, src, dest);
            } else if (dest != null) {
                cocoon.addTarget(src, dest);
            } else {
                cocoon.addTarget(src, destDir);
            }
        }
    }

    private static String getNodeValue(Node root, String name) throws IllegalArgumentException {
        NodeList nodes = root.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            String nodeName;
            Node node = nodes.item(i);
            if (node.getNodeType() == 1 && (nodeName = node.getNodeName()).equals(name)) {
                return Main.getNodeValue(node);
            }
            ++i;
        }
        return null;
    }

    private static String getNodeValue(Node node) throws IllegalArgumentException {
        StringBuffer s = new StringBuffer();
        NodeList children = node.getChildNodes();
        boolean found = false;
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() != 3) {
                throw new IllegalArgumentException("Unexpected node:" + child.getLocalName());
            }
            s.append(child.getNodeValue());
            found = true;
            ++i;
        }
        if (!found) {
            throw new IllegalArgumentException("Expected value for " + node.getLocalName() + " node");
        }
        return s.toString();
    }

    private static String getAttributeValue(Node node, String attr) throws IllegalArgumentException {
        Node attribute;
        NamedNodeMap nodes = node.getAttributes();
        if (nodes != null && (attribute = nodes.getNamedItem(attr)) != null && attribute.getNodeValue() != null) {
            return attribute.getNodeValue();
        }
        throw new IllegalArgumentException("Missing " + attr + " attribute on <" + node.getNodeName() + "> node");
    }

    private static boolean hasAttribute(Node node, String attr) {
        NamedNodeMap nodes = node.getAttributes();
        if (nodes != null) {
            Node attribute = nodes.getNamedItem(attr);
            return attribute != null;
        }
        return false;
    }

    private static boolean getBooleanAttributeValue(Node node, String attr) {
        Node attribute;
        NamedNodeMap nodes = node.getAttributes();
        if (nodes != null && (attribute = nodes.getNamedItem(attr)) != null) {
            String value = attribute.getNodeValue();
            return "yes".equals(value) || "true".equals(value);
        }
        return false;
    }

    private static String getProlog() {
        String lSep = System.getProperty("line.separator");
        StringBuffer msg = new StringBuffer();
        msg.append("------------------------------------------------------------------------ ").append(lSep);
        msg.append(Constants.NAME).append(" ").append(Constants.VERSION).append(lSep);
        msg.append("Copyright (c) ").append(Constants.YEAR).append(" Apache Software Foundation. All rights reserved.").append(lSep);
        msg.append("------------------------------------------------------------------------ ").append(lSep).append(lSep);
        return msg.toString();
    }

    private static void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("cocoon cli [options] [targets]", Main.getProlog().toString(), options, "Note: the context directory defaults to './webapp'");
        System.exit(0);
    }

    private static void printVersion() {
        System.out.println(Constants.VERSION);
        System.exit(0);
    }
}

