/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.ComposerAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public class RequestParamAction
extends ComposerAction
implements ThreadSafe {
    public static final String MAP_URI = "requestURI";
    public static final String MAP_QUERY = "requestQuery";
    public static final String MAP_CONTEXTPATH = "context";
    public static final String PARAM_PARAMETERS = "parameters";
    public static final String PARAM_DEFAULT_PREFIX = "default.";

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters param) throws Exception {
        Request request = ObjectModelHelper.getRequest(objectModel);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(MAP_URI, request.getRequestURI());
        String query = request.getQueryString();
        if (query != null && query.length() > 0) {
            map.put(MAP_QUERY, "?" + query);
        } else {
            map.put(MAP_QUERY, "");
        }
        map.put(MAP_CONTEXTPATH, request.getContextPath());
        if ("true".equalsIgnoreCase(param.getParameter(PARAM_PARAMETERS, null))) {
            Enumeration e = request.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = request.getParameter(name);
                if (value == null || map.containsKey(name)) continue;
                map.put(name, value);
            }
            String[] paramNames = param.getNames();
            int i = 0;
            while (i < paramNames.length) {
                if (paramNames[i].startsWith(PARAM_DEFAULT_PREFIX) && request.getParameter(paramNames[i].substring(PARAM_DEFAULT_PREFIX.length())) == null) {
                    map.put(paramNames[i].substring(PARAM_DEFAULT_PREFIX.length()), param.getParameter(paramNames[i]));
                }
                ++i;
            }
        }
        return map;
    }
}

