/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.beans.PropertyDescriptor;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.TimeZone;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.flow.FlowHelper;
import org.apache.cocoon.components.flow.WebContinuation;
import org.apache.cocoon.components.flow.javascript.JavaScriptFlow;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.ServiceableGenerator;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.dom.DOMBuilder;
import org.apache.cocoon.xml.dom.DOMStreamer;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.util.Introspector;
import org.apache.commons.jexl.util.introspection.Info;
import org.apache.commons.jexl.util.introspection.UberspectImpl;
import org.apache.commons.jexl.util.introspection.VelMethod;
import org.apache.commons.jexl.util.introspection.VelPropertyGet;
import org.apache.commons.jexl.util.introspection.VelPropertySet;
import org.apache.commons.jxpath.CompiledExpression;
import org.apache.commons.jxpath.DynamicPropertyHandler;
import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathContextFactory;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.Variables;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaClass;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

public class JXTemplateGenerator
extends ServiceableGenerator {
    private static final JXPathContextFactory jxpathContextFactory = JXPathContextFactory.newInstance();
    private static final char[] EMPTY_CHARS = "".toCharArray();
    private static final Attributes EMPTY_ATTRS = new AttributesImpl();
    private static final Iterator EMPTY_ITER = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            return null;
        }

        public void remove() {
        }
    };
    private static final Iterator NULL_ITER = new Iterator(){

        public boolean hasNext() {
            return true;
        }

        public Object next() {
            return null;
        }

        public void remove() {
        }
    };
    private static final Locator NULL_LOCATOR = new LocatorImpl();
    static final String NS = "http://apache.org/cocoon/templates/jx/1.0";
    static final String TEMPLATE = "template";
    static final String FOR_EACH = "forEach";
    static final String IF = "if";
    static final String CHOOSE = "choose";
    static final String WHEN = "when";
    static final String OTHERWISE = "otherwise";
    static final String OUT = "out";
    static final String IMPORT = "import";
    static final String SET = "set";
    static final String MACRO = "macro";
    static final String PARAMETER = "parameter";
    static final String FORMAT_NUMBER = "formatNumber";
    static final String FORMAT_DATE = "formatDate";
    private static final char HYPHEN = '-';
    private static final char UNDERSCORE = '_';
    private static final String NUMBER = "number";
    private static final String CURRENCY = "currency";
    private static final String PERCENT = "percent";
    private XMLConsumer consumer;
    private JXPathContext jxpathContext;
    private MyJexlContext globalJexlContext;
    private Variables variables;
    private static Map cache;
    private Source inputSource;
    private Map definitions;
    static /* synthetic */ Class class$org$apache$commons$jexl$util$Introspector;

    private static Expression compileExpr(String expr, String errorPrefix, Locator location) throws SAXParseException {
        try {
            return JXTemplateGenerator.compileExpr(expr);
        }
        catch (Exception exc) {
            throw new SAXParseException(errorPrefix + exc.getMessage(), location, exc);
        }
        catch (Error err) {
            throw new SAXParseException(errorPrefix + err.getMessage(), location, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Expression compileExpr(String inStr) throws Exception {
        try {
            int ch;
            if (inStr == null) {
                return null;
            }
            StringReader in = new StringReader(inStr.trim());
            StringBuffer expr = new StringBuffer();
            boolean xpath = false;
            boolean inExpr = false;
            while ((ch = in.read()) != -1) {
                void var2_6;
                char c = (char)var2_6;
                if (inExpr) {
                    if (c == '\\') {
                        ch = in.read();
                        if (ch == -1) {
                            expr.append('\\');
                            continue;
                        }
                        expr.append((char)ch);
                        continue;
                    }
                    if (c == '}') {
                        String str = expr.toString();
                        return JXTemplateGenerator.compile(str, xpath);
                    }
                    expr.append(c);
                    continue;
                }
                if ((c == '$' || c == '#') && (ch = in.read()) == 123) {
                    inExpr = true;
                    xpath = c == '#';
                    continue;
                }
                return new Expression(inStr, null);
            }
        }
        catch (IOException ignored) {
            ignored.printStackTrace();
        }
        return new Expression(inStr, null);
    }

    private static Expression compileInt(String val, String msg, Locator location) throws SAXException {
        Expression res = JXTemplateGenerator.compileExpr(val, msg, location);
        if (res == null) {
            return null;
        }
        if (res.compiledExpression == null) {
            res.compiledExpression = Integer.valueOf(res.raw);
        }
        return res;
    }

    private static Expression compileNumber(String val, String msg, Locator location) throws SAXException {
        Expression res = JXTemplateGenerator.compileExpr(val, msg, location);
        if (res == null) {
            return null;
        }
        if (res.compiledExpression == null) {
            res.compiledExpression = Integer.valueOf(res.raw);
        }
        return res;
    }

    private static Expression compileBoolean(String val, String msg, Locator location) throws SAXException {
        Expression res = JXTemplateGenerator.compileExpr(val, msg, location);
        if (res == null) {
            return null;
        }
        if (res.compiledExpression == null) {
            res.compiledExpression = Boolean.valueOf(res.raw);
        }
        return res;
    }

    private static Expression compile(String variable, boolean xpath) throws Exception {
        Object compiled = xpath ? JXPathContext.compile((String)variable) : ExpressionFactory.createExpression((String)variable);
        return new Expression(variable, compiled);
    }

    private static Object getValue(Expression expr, JexlContext jexlContext, JXPathContext jxpathContext) throws Exception {
        if (expr == null) {
            return null;
        }
        Object compiled = expr.compiledExpression;
        try {
            if (compiled instanceof CompiledExpression) {
                CompiledExpression e = (CompiledExpression)compiled;
                return e.getValue(jxpathContext);
            }
            if (compiled instanceof org.apache.commons.jexl.Expression) {
                org.apache.commons.jexl.Expression e = (org.apache.commons.jexl.Expression)compiled;
                return e.evaluate(jexlContext);
            }
            return compiled;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw (Error)t;
        }
    }

    private static int getIntValue(Expression expr, JexlContext jexlContext, JXPathContext jxpathContext) throws Exception {
        Object res = JXTemplateGenerator.getValue(expr, jexlContext, jxpathContext);
        if (res instanceof Number) {
            return ((Number)res).intValue();
        }
        return 0;
    }

    private static Number getNumberValue(Expression expr, JexlContext jexlContext, JXPathContext jxpathContext) throws Exception {
        Object res = JXTemplateGenerator.getValue(expr, jexlContext, jxpathContext);
        if (res instanceof Number) {
            return (Number)res;
        }
        if (res == null) {
            return null;
        }
        return Double.valueOf(res.toString());
    }

    private static String getStringValue(Expression expr, JexlContext jexlContext, JXPathContext jxpathContext) throws Exception {
        Object res = JXTemplateGenerator.getValue(expr, jexlContext, jxpathContext);
        if (res != null) {
            return res.toString();
        }
        if (expr != null) {
            return expr.raw;
        }
        return null;
    }

    private static Boolean getBooleanValue(Expression expr, JexlContext jexlContext, JXPathContext jxpathContext) throws Exception {
        Object res = JXTemplateGenerator.getValue(expr, jexlContext, jxpathContext);
        if (res instanceof Boolean) {
            return (Boolean)res;
        }
        return null;
    }

    private Object getNode(Expression expr, JexlContext jexlContext, JXPathContext jxpathContext) throws Exception {
        try {
            Object compiled = expr.compiledExpression;
            if (compiled instanceof CompiledExpression) {
                CompiledExpression e = (CompiledExpression)compiled;
                return e.getPointer(jxpathContext, expr.raw).getNode();
            }
            if (compiled instanceof org.apache.commons.jexl.Expression) {
                org.apache.commons.jexl.Expression e = (org.apache.commons.jexl.Expression)compiled;
                return e.evaluate(jexlContext);
            }
            return compiled;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            throw (Error)t;
        }
    }

    private static Locale parseLocale(String locale, String variant) {
        Locale ret = null;
        String language = locale;
        String country = null;
        int index = -1;
        index = locale.indexOf(45);
        if (index > -1 || (index = locale.indexOf(95)) > -1) {
            language = locale.substring(0, index);
            country = locale.substring(index + 1);
        }
        if (language == null || language.length() == 0) {
            throw new IllegalArgumentException("No language in locale");
        }
        if (country == null) {
            ret = variant != null ? new Locale(language, "", variant) : new Locale(language, "");
        } else if (country.length() > 0) {
            ret = variant != null ? new Locale(language, country, variant) : new Locale(language, country);
        } else {
            throw new IllegalArgumentException("Empty country in locale");
        }
        return ret;
    }

    private JXPathContext getJXPathContext() {
        return this.jxpathContext;
    }

    private MyJexlContext getJexlContext() {
        return this.globalJexlContext;
    }

    private XMLConsumer getConsumer() {
        return this.consumer;
    }

    public void recycle() {
        if (this.resolver != null) {
            this.resolver.release(this.inputSource);
        }
        this.inputSource = null;
        this.consumer = null;
        this.jxpathContext = null;
        this.globalJexlContext = null;
        this.variables = null;
        this.definitions = null;
        super.recycle();
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, parameters);
        if (src != null) {
            try {
                this.inputSource = resolver.resolveURI(src);
            }
            catch (SourceException se) {
                throw SourceUtil.handle("Error during resolving of '" + src + "'.", se);
            }
            String uri = this.inputSource.getURI();
            Map map = cache;
            synchronized (map) {
                StartDocument startEvent = (StartDocument)cache.get(uri);
                if (startEvent != null) {
                    int valid = startEvent.compileTime.isValid();
                    if (valid == 0) {
                        SourceValidity validity = this.inputSource.getValidity();
                        valid = startEvent.compileTime.isValid(validity);
                    }
                    if (valid != 1) {
                        cache.remove(uri);
                    }
                }
            }
        }
        Object bean = FlowHelper.getContextObject(objectModel);
        WebContinuation kont = FlowHelper.getWebContinuation(objectModel);
        this.setContexts(bean, kont, ObjectModelHelper.getRequest(objectModel), ObjectModelHelper.getResponse(objectModel), ObjectModelHelper.getContext(objectModel), parameters, objectModel);
        this.definitions = new HashMap();
    }

    private void fillContext(Object contextObject, Map map) {
        if (contextObject == null) {
            return;
        }
        JXPathBeanInfo bi = JXPathIntrospector.getBeanInfo(contextObject.getClass());
        if (bi.isDynamic()) {
            Class cl = bi.getDynamicPropertyHandlerClass();
            try {
                DynamicPropertyHandler h = (DynamicPropertyHandler)cl.newInstance();
                String[] result = h.getPropertyNames(contextObject);
                int i = 0;
                while (i < result.length) {
                    try {
                        map.put(result[i], h.getProperty(contextObject, result[i]));
                    }
                    catch (Exception exc) {
                        exc.printStackTrace();
                    }
                    ++i;
                }
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        } else {
            PropertyDescriptor[] props = bi.getPropertyDescriptors();
            int i = 0;
            while (i < props.length) {
                try {
                    Method read = props[i].getReadMethod();
                    if (read != null) {
                        map.put(props[i].getName(), read.invoke(contextObject, null));
                    }
                }
                catch (Exception ignored) {
                    ignored.printStackTrace();
                }
                ++i;
            }
        }
    }

    private void setContexts(Object contextObject, WebContinuation kont, Request request, Response response, Context app, Parameters parameters, Map objectModel) {
        Map<String, Scriptable> map;
        if (this.variables == null) {
            this.variables = new MyVariables(contextObject, kont, request, response, app, parameters);
        }
        if (contextObject instanceof Map) {
            map = (HashMap)contextObject;
        } else {
            map = new HashMap();
            this.fillContext(contextObject, map);
        }
        this.jxpathContext = jxpathContextFactory.newContext(null, contextObject);
        this.jxpathContext.setVariables(this.variables);
        this.globalJexlContext = new MyJexlContext();
        this.globalJexlContext.setVars(map);
        map = this.globalJexlContext.getVars();
        if (contextObject != null) {
            map.put("flowContext", (Scriptable)contextObject);
            Scriptable javaPkg = JavaScriptFlow.getJavaPackage(objectModel);
            Scriptable pkgs = JavaScriptFlow.getPackages(objectModel);
            map.put("java", javaPkg);
            map.put("Packages", pkgs);
        }
        if (kont != null) {
            map.put("continuation", (Scriptable)kont);
        }
        map.put("request", (Scriptable)request);
        map.put("response", (Scriptable)response);
        map.put("context", (Scriptable)app);
        map.put("parameters", (Scriptable)parameters);
        Session session = request.getSession(false);
        if (session != null) {
            map.put("session", (Scriptable)session);
        }
    }

    public void setConsumer(XMLConsumer consumer) {
        this.consumer = consumer;
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        StartDocument startEvent;
        Map map = cache;
        synchronized (map) {
            startEvent = (StartDocument)cache.get(this.inputSource.getURI());
        }
        if (startEvent == null) {
            SourceValidity validity = this.inputSource.getValidity();
            Parser parser = new Parser();
            SourceUtil.parse(this.manager, this.inputSource, (ContentHandler)parser);
            startEvent = parser.getStartEvent();
            startEvent.compileTime = validity;
            Map map2 = cache;
            synchronized (map2) {
                cache.put(this.inputSource.getURI(), startEvent);
            }
        }
        this.execute(this.consumer, this.globalJexlContext, this.jxpathContext, startEvent, null);
    }

    private void characters(JexlContext jexlContext, JXPathContext jxpathContext, TextEvent event, CharHandler handler) throws SAXException {
        Iterator iter = event.substitutions.iterator();
        while (iter.hasNext()) {
            char[] chars;
            Object subst = iter.next();
            if (subst instanceof char[]) {
                chars = (char[])subst;
            } else {
                Expression expr = (Expression)subst;
                try {
                    Object val = JXTemplateGenerator.getValue(expr, jexlContext, jxpathContext);
                    chars = val != null ? val.toString().toCharArray() : EMPTY_CHARS;
                }
                catch (Exception e) {
                    throw new SAXParseException(e.getMessage(), event.location, e);
                }
                catch (Error err) {
                    throw new SAXParseException(err.getMessage(), event.location, null);
                }
            }
            handler.characters(chars, 0, chars.length);
        }
    }

    private void executeRaw(XMLConsumer consumer, Event startEvent, Event endEvent) throws SAXException {
        Event ev = startEvent;
        while (ev != endEvent) {
            StartElement startElement;
            TextEvent text;
            consumer.setDocumentLocator(ev.location);
            if (ev instanceof Characters) {
                text = (TextEvent)ev;
                consumer.characters(text.raw, 0, text.raw.length);
            } else if (ev instanceof EndDocument) {
                consumer.endDocument();
            } else if (ev instanceof StartElement) {
                StartElement startElement2 = (StartElement)ev;
                consumer.startElement(startElement2.namespaceURI, startElement2.localName, startElement2.raw, startElement2.attributes);
            } else if (ev instanceof EndElement) {
                EndElement endElement = (EndElement)ev;
                startElement = endElement.startElement;
                consumer.endElement(startElement.namespaceURI, startElement.localName, startElement.raw);
            } else if (ev instanceof EndPrefixMapping) {
                EndPrefixMapping endPrefixMapping = (EndPrefixMapping)ev;
                consumer.endPrefixMapping(endPrefixMapping.prefix);
            } else if (ev instanceof IgnorableWhitespace) {
                text = (TextEvent)ev;
                consumer.ignorableWhitespace(text.raw, 0, text.raw.length);
            } else if (ev instanceof ProcessingInstruction) {
                ProcessingInstruction pi = (ProcessingInstruction)ev;
                consumer.processingInstruction(pi.target, pi.data);
            } else if (ev instanceof SkippedEntity) {
                SkippedEntity skippedEntity = (SkippedEntity)ev;
                consumer.skippedEntity(skippedEntity.name);
            } else if (ev instanceof StartDocument) {
                StartDocument startDoc = (StartDocument)ev;
                if (startDoc.endDocument != null) {
                    consumer.startDocument();
                }
            } else if (ev instanceof StartPrefixMapping) {
                StartPrefixMapping startPrefixMapping = (StartPrefixMapping)ev;
                consumer.startPrefixMapping(startPrefixMapping.prefix, startPrefixMapping.uri);
            } else if (ev instanceof Comment) {
                text = (TextEvent)ev;
                consumer.comment(text.raw, 0, text.raw.length);
            } else if (ev instanceof EndCDATA) {
                consumer.endCDATA();
            } else if (ev instanceof EndDTD) {
                consumer.endDTD();
            } else if (ev instanceof EndEntity) {
                consumer.endEntity(((EndEntity)ev).name);
            } else if (ev instanceof StartCDATA) {
                consumer.startCDATA();
            } else if (ev instanceof StartDTD) {
                StartDTD startDTD = (StartDTD)ev;
                consumer.startDTD(startDTD.name, startDTD.publicId, startDTD.systemId);
            } else if (ev instanceof StartEntity) {
                consumer.startEntity(((StartEntity)ev).name);
            } else if (ev instanceof StartInstruction) {
                StartInstruction startInstruction = (StartInstruction)ev;
                startElement = startInstruction.startElement;
                consumer.startElement(startElement.namespaceURI, startElement.localName, startElement.raw, startElement.attributes);
            } else if (ev instanceof EndInstruction) {
                EndInstruction endInstruction = (EndInstruction)ev;
                StartInstruction startInstruction = endInstruction.startInstruction;
                StartElement startElement3 = startInstruction.startElement;
                consumer.endElement(startElement3.namespaceURI, startElement3.localName, startElement3.raw);
            }
            ev = ev.next;
        }
    }

    private void executeDOM(XMLConsumer consumer, MyJexlContext jexlContext, JXPathContext jxpathContext, Node node) throws SAXException {
        Parser parser = new Parser();
        DOMStreamer streamer = new DOMStreamer(parser);
        streamer.stream(node);
        this.execute(consumer, jexlContext, jxpathContext, parser.getStartEvent(), null);
    }

    private void call(Locator location, String messagePrefix, XMLConsumer consumer, MyJexlContext jexlContext, JXPathContext jxpathContext, Event startEvent, Event endEvent) throws SAXException {
        try {
            this.execute(consumer, jexlContext, jxpathContext, startEvent, endEvent);
        }
        catch (SAXParseException exc) {
            throw new SAXParseException(messagePrefix + ": " + exc.getMessage(), location, exc);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void execute(final XMLConsumer consumer, MyJexlContext jexlContext, JXPathContext jxpathContext, Event startEvent, Event endEvent) throws SAXException {
        ev = startEvent;
        while (ev != endEvent) {
            consumer.setDocumentLocator(ev.location);
            if (ev instanceof Characters) {
                text = (TextEvent)ev;
                iter = text.substitutions.iterator();
                while (iter.hasNext()) {
                    subst = iter.next();
                    if (subst instanceof char[]) {
                        chars = (char[])subst;
                    } else {
                        expr = (Expression)subst;
                        try {
                            val = this.getNode(expr, jexlContext, jxpathContext);
                            if (val instanceof Node) {
                                this.executeDOM(consumer, jexlContext, jxpathContext, (Node)val);
                                continue;
                            }
                            if (val instanceof NodeList) {
                                nodeList = (Node[])val;
                                i = 0;
                                len = nodeList.getLength();
                                while (i < len) {
                                    n = nodeList.item(i);
                                    this.executeDOM(consumer, jexlContext, jxpathContext, n);
                                    ++i;
                                }
                                continue;
                            }
                            if (val instanceof Node[]) {
                                nodeList = (Node[])val;
                                i = 0;
                                len = nodeList.length;
                                while (i < len) {
                                    n = nodeList[i];
                                    this.executeDOM(consumer, jexlContext, jxpathContext, n);
                                    ++i;
                                }
                                continue;
                            }
                            chars = val != null ? val.toString().toCharArray() : JXTemplateGenerator.EMPTY_CHARS;
                        }
                        catch (Exception e) {
                            throw new SAXParseException(e.getMessage(), ev.location, e);
                        }
                        catch (Error err) {
                            throw new SAXParseException(err.getMessage(), ev.location, null);
                        }
                    }
                    consumer.characters(chars, 0, chars.length);
                }
            } else if (ev instanceof EndDocument) {
                consumer.endDocument();
            } else if (ev instanceof EndElement) {
                endElement = (EndElement)ev;
                startElement = endElement.startElement;
                consumer.endElement(startElement.namespaceURI, startElement.localName, startElement.raw);
            } else if (ev instanceof EndPrefixMapping) {
                endPrefixMapping = (EndPrefixMapping)ev;
                consumer.endPrefixMapping(endPrefixMapping.prefix);
            } else if (ev instanceof IgnorableWhitespace) {
                text = (TextEvent)ev;
                this.characters(jexlContext, jxpathContext, text, new CharHandler(){

                    public void characters(char[] ch, int offset, int len) throws SAXException {
                        consumer.ignorableWhitespace(ch, offset, len);
                    }
                });
            } else if (ev instanceof ProcessingInstruction) {
                pi = (ProcessingInstruction)ev;
                consumer.processingInstruction(pi.target, pi.data);
            } else if (ev instanceof SkippedEntity) {
                skippedEntity = (SkippedEntity)ev;
                consumer.skippedEntity(skippedEntity.name);
            } else if (ev instanceof StartDocument) {
                startDoc = (StartDocument)ev;
                if (startDoc.endDocument != null) {
                    consumer.startDocument();
                }
            } else if (ev instanceof StartIf) {
                startIf = (StartIf)ev;
                try {
                    val = JXTemplateGenerator.getValue(startIf.test, jexlContext, jxpathContext);
                }
                catch (Exception e) {
                    throw new SAXParseException(e.getMessage(), ev.location, e);
                }
                catch (Error err) {
                    throw new SAXParseException(err.getMessage(), ev.location, null);
                }
                result = false;
                if (val instanceof Boolean) {
                    result = (Boolean)val;
                } else {
                    v0 = result = val != null;
                }
                if (!result) {
                    ev = startIf.endInstruction.next;
                    continue;
                }
            } else {
                if (ev instanceof StartForEach) {
                    startForEach = (StartForEach)ev;
                    items = startForEach.items;
                    iter = null;
                    try {
                        if (items == null) {
                            iter = JXTemplateGenerator.NULL_ITER;
                        } else {
                            expr = items;
                            if (expr.compiledExpression instanceof CompiledExpression) {
                                compiledExpression = (CompiledExpression)expr.compiledExpression;
                                val = compiledExpression.getPointer(jxpathContext, expr.raw).getNode();
                                iter = val instanceof NativeArray ? new JSIntrospector.NativeArrayIterator((NativeArray)val) : compiledExpression.iteratePointers(jxpathContext);
                            } else if (expr.compiledExpression instanceof org.apache.commons.jexl.Expression) {
                                e = (org.apache.commons.jexl.Expression)expr.compiledExpression;
                                result = e.evaluate((JexlContext)jexlContext);
                                if (result != null) {
                                    iter = Introspector.getUberspect().getIterator(result, new Info(ev.location.getSystemId(), ev.location.getLineNumber(), ev.location.getColumnNumber()));
                                }
                                if (iter == null) {
                                    iter = JXTemplateGenerator.EMPTY_ITER;
                                }
                            } else {
                                iter = new Iterator(items){
                                    Object val;
                                    private final /* synthetic */ Object val$items;
                                    {
                                        this.val = this.val$items = val$items;
                                    }

                                    public boolean hasNext() {
                                        return this.val != null;
                                    }

                                    public Object next() {
                                        Object res = this.val;
                                        this.val = null;
                                        return res;
                                    }

                                    public void remove() {
                                    }
                                };
                            }
                        }
                        begin = startForEach.begin == null ? 0 : JXTemplateGenerator.getIntValue(startForEach.begin, jexlContext, jxpathContext);
                        end = startForEach.end == null ? 0x7FFFFFFF : JXTemplateGenerator.getIntValue(startForEach.end, jexlContext, jxpathContext);
                        step = startForEach.step == null ? 1 : JXTemplateGenerator.getIntValue(startForEach.step, jexlContext, jxpathContext);
                    }
                    catch (Exception exc) {
                        throw new SAXParseException(exc.getMessage(), ev.location, exc);
                    }
                    catch (Error err) {
                        throw new SAXParseException(err.getMessage(), ev.location, null);
                    }
                    localJexlContext = new MyJexlContext(jexlContext);
                    i = 0;
                    while (i < begin && iter.hasNext()) {
                        iter.next();
                        ++i;
                    }
                    while (i <= end && iter.hasNext()) {
                        localJXPathContext = null;
                        value /* !! */  = iter.next();
                        if (value /* !! */  instanceof Pointer) {
                            ptr = (Pointer)value /* !! */ ;
                            localJXPathContext = jxpathContext.getRelativeContext(ptr);
                            try {
                                value /* !! */  = ptr.getNode();
                            }
                            catch (Exception exc) {
                                throw new SAXParseException(exc.getMessage(), ev.location, null);
                            }
                        } else {
                            localJXPathContext = JXTemplateGenerator.jxpathContextFactory.newContext(null, value /* !! */ );
                        }
                        localJXPathContext.setVariables(this.variables);
                        if (startForEach.var != null) {
                            localJexlContext.put(startForEach.var, value /* !! */ );
                        }
                        this.execute(consumer, localJexlContext, localJXPathContext, startForEach.next, startForEach.endInstruction);
                        skip = step - 1;
                        while (skip > 0 && iter.hasNext()) {
                            iter.next();
                            --skip;
                        }
                        ++i;
                    }
                    ev = startForEach.endInstruction.next;
                    continue;
                }
                if (ev instanceof StartChoose) {
                    startChoose = (StartChoose)ev;
                    startWhen = startChoose.firstChoice;
                    while (startWhen != null) {
                        try {
                            val = JXTemplateGenerator.getValue(startWhen.test, jexlContext, jxpathContext);
                        }
                        catch (Exception e) {
                            throw new SAXParseException(e.getMessage(), ev.location, e);
                        }
                        result = false;
                        if (val instanceof Boolean) {
                            result = (Boolean)val;
                        } else {
                            v1 = result = val != null;
                        }
                        if (result) {
                            this.execute(consumer, jexlContext, jxpathContext, startWhen.next, startWhen.endInstruction);
                            break;
                        }
                        startWhen = startWhen.nextChoice;
                    }
                    if (startWhen == null && startChoose.otherwise != null) {
                        this.execute(consumer, jexlContext, jxpathContext, startChoose.otherwise.next, startChoose.otherwise.endInstruction);
                    }
                    ev = startChoose.endInstruction.next;
                    continue;
                }
                if (ev instanceof StartSet) {
                    startSet = (StartSet)ev;
                    value = null;
                    if (startSet.value != null) {
                        try {
                            value = this.getNode(startSet.value, jexlContext, jxpathContext);
                        }
                        catch (Exception exc) {
                            throw new SAXParseException(exc.getMessage(), ev.location, exc);
                        }
                    } else {
                        builder = new DOMBuilder();
                        builder.startDocument();
                        builder.startElement("http://apache.org/cocoon/templates/jx/1.0", "set", "set", JXTemplateGenerator.EMPTY_ATTRS);
                        this.execute(builder, jexlContext, jxpathContext, startSet.next, startSet.endInstruction);
                        builder.endElement("http://apache.org/cocoon/templates/jx/1.0", "set", "set");
                        builder.endDocument();
                        node = builder.getDocument().getDocumentElement();
                        nodeList = node.getChildNodes();
                        len = nodeList.getLength();
                        nodeArr = new Node[len];
                        i = 0;
                        while (i < len) {
                            nodeArr[i] = nodeList.item(i);
                            ++i;
                        }
                        value = nodeArr;
                    }
                    jxpathContext.getVariables().declareVariable(startSet.var, (Object)value);
                    jexlContext.put(startSet.var, value);
                    ev = startSet.endInstruction.next;
                    continue;
                }
                if (ev instanceof StartElement) {
                    startElement = (StartElement)ev;
                    def = (StartDefine)this.definitions.get(startElement.qname);
                    if (def != null) {
                        attributeMap = new HashMap<String, String>();
                        i = startElement.attributeEvents.iterator();
                        while (i.hasNext()) {
                            attrEvent = (AttributeEvent)i.next();
                            attributeName = attrEvent.localName;
                            if (attrEvent instanceof CopyAttribute) {
                                copy = (CopyAttribute)attrEvent;
                                attributeValue = copy.value;
                            } else if (attrEvent instanceof SubstituteAttribute) {
                                substEvent = (SubstituteAttribute)attrEvent;
                                if (substEvent.substitutions.size() == 1 && substEvent.substitutions.get(0) instanceof Expression) {
                                    expr = (Expression)substEvent.substitutions.get(0);
                                    try {
                                        val = this.getNode(expr, jexlContext, jxpathContext);
                                    }
                                    catch (Exception e) {
                                        throw new SAXParseException(e.getMessage(), ev.location, e);
                                    }
                                    if (val == null) {
                                        val = "";
                                    }
                                    attributeValue = val;
                                } else {
                                    buf = new StringBuffer();
                                    ii = substEvent.substitutions.iterator();
                                    while (ii.hasNext()) {
                                        subst = (Subst)ii.next();
                                        if (subst instanceof Literal) {
                                            lit = (Literal)subst;
                                            buf.append(lit.value);
                                            continue;
                                        }
                                        if (!(subst instanceof Expression)) continue;
                                        expr = (Expression)subst;
                                        try {
                                            val = JXTemplateGenerator.getValue(expr, jexlContext, jxpathContext);
                                        }
                                        catch (Exception e) {
                                            throw new SAXParseException(e.getMessage(), ev.location, e);
                                        }
                                        if (val == null) {
                                            val = "";
                                        }
                                        buf.append(val.toString());
                                    }
                                    attributeValue = buf.toString();
                                }
                            } else {
                                throw new Error("this shouldn't have happened");
                            }
                            attributeMap.put(attributeName, (String)attributeValue);
                        }
                        builder = new DOMBuilder();
                        builder.startDocument();
                        builder.startElement(startElement.namespaceURI, startElement.localName, startElement.raw, JXTemplateGenerator.EMPTY_ATTRS);
                        this.executeRaw(builder, startElement.next, startElement.endElement);
                        builder.endElement(startElement.namespaceURI, startElement.localName, startElement.raw);
                        builder.endDocument();
                        node = builder.getDocument().getDocumentElement();
                        vars = (MyVariables)jxpathContext.getVariables();
                        saveLocals = vars.localVariables;
                        vars.localVariables = new HashMap<K, V>();
                        localJexlContext = new MyJexlContext(this.globalJexlContext);
                        children = node.getChildNodes();
                        len = children.getLength();
                        arr = new Node[len];
                        ii = 0;
                        while (ii < len) {
                            arr[ii] = children.item(ii);
                            ++ii;
                        }
                        localJexlContext.put("content", arr);
                        vars.localVariables.put("content", arr);
                        iter = def.parameters.entrySet().iterator();
                        while (iter.hasNext()) {
                            e = iter.next();
                            key = (String)e.getKey();
                            startParam = (StartParameter)e.getValue();
                            default_ = startParam.default_;
                            val /* !! */  = attributeMap.get(key);
                            if (val /* !! */  == null) {
                                val /* !! */  = default_;
                            }
                            localJexlContext.put(key, val /* !! */ );
                            vars.localVariables.put(key, val /* !! */ );
                        }
                        localJXPathContext = JXTemplateGenerator.jxpathContextFactory.newContext(null, (Object)arr);
                        localJXPathContext.setVariables((Variables)vars);
                        this.call(ev.location, startElement.localName, consumer, localJexlContext, localJXPathContext, def.body, def.endInstruction);
                        vars.localVariables = saveLocals;
                        ev = startElement.endElement.next;
                        continue;
                    }
                    i = startElement.attributeEvents.iterator();
                    attrs = new AttributesImpl();
                    while (i.hasNext()) {
                        attrEvent = (AttributeEvent)i.next();
                        if (attrEvent instanceof CopyAttribute) {
                            copy = (CopyAttribute)attrEvent;
                            attrs.addAttribute(copy.namespaceURI, copy.localName, copy.raw, copy.type, copy.value);
                            continue;
                        }
                        if (!(attrEvent instanceof SubstituteAttribute)) continue;
                        buf = new StringBuffer();
                        substEvent = (SubstituteAttribute)attrEvent;
                        ii = substEvent.substitutions.iterator();
                        while (ii.hasNext()) {
                            subst = (Subst)ii.next();
                            if (subst instanceof Literal) {
                                lit = (Literal)subst;
                                buf.append(lit.value);
                                continue;
                            }
                            if (!(subst instanceof Expression)) continue;
                            expr = (Expression)subst;
                            try {
                                val = JXTemplateGenerator.getValue(expr, jexlContext, jxpathContext);
                            }
                            catch (Exception e) {
                                throw new SAXParseException(e.getMessage(), ev.location, e);
                            }
                            if (val == null) {
                                val = "";
                            }
                            buf.append(val.toString());
                        }
                        attrs.addAttribute(attrEvent.namespaceURI, attrEvent.localName, attrEvent.raw, attrEvent.type, buf.toString());
                    }
                    consumer.startElement(startElement.namespaceURI, startElement.localName, startElement.raw, attrs);
                } else if (ev instanceof StartFormatNumber) {
                    startFormatNumber = (StartFormatNumber)ev;
                    try {
                        result = startFormatNumber.format(jexlContext, jxpathContext);
                        if (result == null) ** GOTO lbl535
                        chars = result.toCharArray();
                        consumer.characters(chars, 0, chars.length);
                    }
                    catch (Exception e) {
                        throw new SAXParseException(e.getMessage(), ev.location, e);
                    }
                } else if (ev instanceof StartFormatDate) {
                    startFormatDate = (StartFormatDate)ev;
                    try {
                        result = startFormatDate.format(jexlContext, jxpathContext);
                        if (result == null) ** GOTO lbl535
                        chars = result.toCharArray();
                        consumer.characters(chars, 0, chars.length);
                    }
                    catch (Exception e) {
                        throw new SAXParseException(e.getMessage(), ev.location, e);
                    }
                } else if (ev instanceof StartPrefixMapping) {
                    startPrefixMapping = (StartPrefixMapping)ev;
                    consumer.startPrefixMapping(startPrefixMapping.prefix, startPrefixMapping.uri);
                } else if (ev instanceof Comment) {
                    text = (TextEvent)ev;
                    buf = new StringBuffer();
                    this.characters(jexlContext, jxpathContext, text, new CharHandler(){

                        public void characters(char[] ch, int offset, int len) throws SAXException {
                            buf.append(ch, offset, len);
                        }
                    });
                    chars = new char[buf.length()];
                    buf.getChars(0, chars.length, chars, 0);
                    consumer.comment(chars, 0, chars.length);
                } else if (ev instanceof EndCDATA) {
                    consumer.endCDATA();
                } else if (ev instanceof EndDTD) {
                    consumer.endDTD();
                } else if (ev instanceof EndEntity) {
                    consumer.endEntity(((EndEntity)ev).name);
                } else if (ev instanceof StartCDATA) {
                    consumer.startCDATA();
                } else if (ev instanceof StartDTD) {
                    startDTD = (StartDTD)ev;
                    consumer.startDTD(startDTD.name, startDTD.publicId, startDTD.systemId);
                } else if (ev instanceof StartEntity) {
                    consumer.startEntity(((StartEntity)ev).name);
                } else if (ev instanceof StartOut) {
                    startOut = (StartOut)ev;
                    try {
                        val = this.getNode(startOut.compiledExpression, jexlContext, jxpathContext);
                        if (val instanceof Node) {
                            this.executeDOM(consumer, jexlContext, jxpathContext, (Node)val);
                        }
                        if (val instanceof NodeList) {
                            nodeList = (NodeList)val;
                            i = 0;
                            len = nodeList.getLength();
                            while (i < len) {
                                n = nodeList.item(i);
                                this.executeDOM(consumer, jexlContext, jxpathContext, n);
                                ++i;
                            }
                        }
                        if (val instanceof Node[]) {
                            nodeList = (Node[])val;
                            i = 0;
                            len = nodeList.length;
                            while (i < len) {
                                n = nodeList[i];
                                this.executeDOM(consumer, jexlContext, jxpathContext, n);
                                ++i;
                            }
                        }
                        if (val == null) {
                            val = "";
                        }
                        ch = val.toString().toCharArray();
                        consumer.characters(ch, 0, ch.length);
                    }
                    catch (Exception e) {
                        throw new SAXParseException(e.getMessage(), ev.location, e);
                    }
                } else if (!(ev instanceof StartTemplate)) {
                    if (ev instanceof StartDefine) {
                        startDefine = (StartDefine)ev;
                        this.definitions.put(startDefine.qname, startDefine);
                        ev = startDefine.endInstruction.next;
                        continue;
                    }
                    if (ev instanceof StartImport) {
                        startImport = (StartImport)ev;
                        e = startImport.uri;
                        if (e instanceof CopyAttribute) {
                            copy = (CopyAttribute)e;
                            uri = copy.value;
                        } else {
                            buf = new StringBuffer();
                            substAttr = (SubstituteAttribute)e;
                            i = substAttr.substitutions.iterator();
                            while (i.hasNext()) {
                                subst = (Subst)i.next();
                                if (subst instanceof Literal) {
                                    lit = (Literal)subst;
                                    buf.append(lit.value);
                                    continue;
                                }
                                if (!(subst instanceof Expression)) continue;
                                expr = (Expression)subst;
                                try {
                                    val = JXTemplateGenerator.getValue(expr, jexlContext, jxpathContext);
                                }
                                catch (Exception exc) {
                                    throw new SAXParseException(exc.getMessage(), ev.location, exc);
                                }
                                catch (Error err) {
                                    throw new SAXParseException(err.getMessage(), ev.location, null);
                                }
                                if (val == null) {
                                    val = "";
                                }
                                buf.append(val.toString());
                            }
                            uri = buf.toString();
                        }
                        input = null;
                        try {
                            try {
                                input = this.resolver.resolveURI(uri);
                                validity = null;
                                subst = JXTemplateGenerator.cache;
                                synchronized (subst) {
                                    doc = (StartDocument)JXTemplateGenerator.cache.get(input.getURI());
                                    if (doc != null) {
                                        recompile = false;
                                        if (doc.compileTime == null) {
                                            recompile = true;
                                        } else {
                                            valid = doc.compileTime.isValid();
                                            if (valid == 0) {
                                                validity = input.getValidity();
                                                valid = doc.compileTime.isValid(validity);
                                            }
                                            if (valid != 1) {
                                                recompile = true;
                                            }
                                        }
                                        if (recompile) {
                                            doc = null;
                                        }
                                    }
                                }
                                if (doc == null) {
                                    parser = new Parser();
                                    if (validity == null) {
                                        validity = input.getValidity();
                                    }
                                    SourceUtil.parse(this.manager, input, (ContentHandler)parser);
                                    doc = parser.getStartEvent();
                                    doc.compileTime = validity;
                                    valid = JXTemplateGenerator.cache;
                                    synchronized (valid) {
                                        JXTemplateGenerator.cache.put(input.getURI(), doc);
                                    }
                                }
                                var29_118 = null;
                            }
                            catch (Exception exc) {
                                throw new SAXParseException(exc.getMessage(), ev.location, exc);
                            }
                        }
                        catch (Throwable var28_121) {
                            var29_118 = null;
                            this.resolver.release(input);
                            throw var28_121;
                        }
                        this.resolver.release(input);
                        selectJXPath = jxpathContext;
                        selectJexl = jexlContext;
                        if (startImport.select != null) {
                            try {
                                obj = JXTemplateGenerator.getValue(startImport.select, jexlContext, jxpathContext);
                                selectJXPath = JXTemplateGenerator.jxpathContextFactory.newContext(null, obj);
                                selectJXPath.setVariables(this.variables);
                                selectJexl = new MyJexlContext(this.globalJexlContext);
                                this.fillContext(obj, selectJexl);
                            }
                            catch (Exception exc) {
                                throw new SAXParseException(exc.getMessage(), ev.location, exc);
                            }
                            catch (Error err) {
                                throw new SAXParseException(err.getMessage(), ev.location, null);
                            }
                        }
                        this.execute(consumer, selectJexl, selectJXPath, doc.next, doc.endDocument);
                        ev = startImport.endInstruction.next;
                        continue;
                    }
                }
            }
lbl535:
            // 30 sources

            ev = ev.next;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Field field = (class$org$apache$commons$jexl$util$Introspector == null ? (class$org$apache$commons$jexl$util$Introspector = JXTemplateGenerator.class$("org.apache.commons.jexl.util.Introspector")) : class$org$apache$commons$jexl$util$Introspector).getDeclaredField("uberSpect");
            field.setAccessible(true);
            field.set(null, (Object)new JSIntrospector());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        cache = new HashMap();
    }

    static interface CharHandler {
        public void characters(char[] var1, int var2, int var3) throws SAXException;
    }

    public static class TransformerAdapter
    extends AbstractTransformer {
        TemplateConsumer templateConsumer;

        public void recycle() {
            super.recycle();
            this.templateConsumer = null;
        }

        public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
            this.templateConsumer = new TemplateConsumer(resolver, objectModel, src, parameters);
        }

        public void setConsumer(XMLConsumer xmlConsumer) {
            super.setConsumer(this.templateConsumer);
            this.templateConsumer.setConsumer(xmlConsumer);
        }

        static class TemplateConsumer
        extends Parser
        implements XMLConsumer {
            JXTemplateGenerator gen = new JXTemplateGenerator();

            public TemplateConsumer(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
                this.gen.setup(resolver, objectModel, null, parameters);
            }

            public void endDocument() throws SAXException {
                super.endDocument();
                this.gen.execute(this.gen.getConsumer(), this.gen.getJexlContext(), this.gen.getJXPathContext(), this.getStartEvent(), null);
            }

            void setConsumer(XMLConsumer consumer) {
                this.gen.setConsumer(consumer);
            }
        }
    }

    static class Parser
    implements ContentHandler,
    LexicalHandler {
        StartDocument startEvent;
        Event lastEvent;
        Stack stack = new Stack();
        Locator locator;
        Locator charLocation;
        StringBuffer charBuf;

        StartDocument getStartEvent() {
            return this.startEvent;
        }

        private void addEvent(Event ev) throws SAXException {
            if (ev == null) {
                throw new NullPointerException("null event");
            }
            if (this.lastEvent == null) {
                this.startEvent = new StartDocument(this.locator);
                this.lastEvent = this.startEvent;
            } else {
                this.flushChars();
            }
            this.lastEvent.next = ev;
            this.lastEvent = ev;
        }

        void flushChars() throws SAXException {
            if (this.charBuf != null) {
                char[] chars = new char[this.charBuf.length()];
                this.charBuf.getChars(0, this.charBuf.length(), chars, 0);
                Characters ev = new Characters(this.charLocation, chars, 0, chars.length);
                this.lastEvent.next = ev;
                this.lastEvent = ev;
                this.charLocation = null;
                this.charBuf = null;
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.charBuf == null) {
                this.charBuf = new StringBuffer();
                this.charLocation = this.locator != null ? new LocatorImpl(this.locator) : NULL_LOCATOR;
            }
            this.charBuf.append(ch, start, length);
        }

        public void endDocument() throws SAXException {
            EndDocument endDoc;
            StartDocument startDoc = (StartDocument)this.stack.pop();
            startDoc.endDocument = endDoc = new EndDocument(this.locator);
            this.addEvent(endDoc);
        }

        public void endElement(String namespaceURI, String localName, String raw) throws SAXException {
            Event start = (Event)this.stack.pop();
            Event newEvent = null;
            if (JXTemplateGenerator.NS.equals(namespaceURI)) {
                EndInstruction endInstruction;
                StartInstruction startInstruction = (StartInstruction)start;
                newEvent = endInstruction = new EndInstruction(this.locator, startInstruction);
                if (start instanceof StartWhen) {
                    StartWhen startWhen = (StartWhen)start;
                    StartChoose startChoose = (StartChoose)this.stack.peek();
                    if (startChoose.firstChoice != null) {
                        StartWhen w = startChoose.firstChoice;
                        while (w.nextChoice != null) {
                            w = w.nextChoice;
                        }
                        w.nextChoice = startWhen;
                    } else {
                        startChoose.firstChoice = startWhen;
                    }
                } else if (start instanceof StartOtherwise) {
                    StartOtherwise startOtherwise = (StartOtherwise)start;
                    StartChoose startChoose = (StartChoose)this.stack.peek();
                    startChoose.otherwise = startOtherwise;
                }
            } else {
                StartElement startElement = (StartElement)start;
                startElement.endElement = new EndElement(this.locator, startElement);
                newEvent = startElement.endElement;
            }
            this.addEvent(newEvent);
            if (start instanceof StartDefine) {
                StartDefine startDefine = (StartDefine)start;
                startDefine.finish();
            }
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            EndPrefixMapping endPrefixMapping = new EndPrefixMapping(this.locator, prefix);
            this.addEvent(endPrefixMapping);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            IgnorableWhitespace ev = new IgnorableWhitespace(this.locator, ch, start, length);
            this.addEvent(ev);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            ProcessingInstruction pi = new ProcessingInstruction(this.locator, target, data);
            this.addEvent(pi);
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void skippedEntity(String name) throws SAXException {
            this.addEvent(new SkippedEntity(this.locator, name));
        }

        public void startDocument() {
            this.startEvent = new StartDocument(this.locator);
            this.lastEvent = this.startEvent;
            this.stack.push(this.lastEvent);
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void startElement(String namespaceURI, String localName, String qname, Attributes attrs) throws SAXException {
            void var5_21;
            Object var5_5 = null;
            StartElement startElement = new StartElement(this.locator, namespaceURI, localName, qname, attrs);
            if (JXTemplateGenerator.NS.equals(namespaceURI)) {
                if (localName.equals(JXTemplateGenerator.FOR_EACH)) {
                    StartForEach startForEach;
                    String items = attrs.getValue("items");
                    String select = attrs.getValue("select");
                    Expression begin = JXTemplateGenerator.compileInt(attrs.getValue("begin"), JXTemplateGenerator.FOR_EACH, this.locator);
                    Expression end = JXTemplateGenerator.compileInt(attrs.getValue("end"), JXTemplateGenerator.FOR_EACH, this.locator);
                    Expression step = JXTemplateGenerator.compileInt(attrs.getValue("step"), JXTemplateGenerator.FOR_EACH, this.locator);
                    String var = attrs.getValue("var");
                    if (items == null) {
                        if (select == null && (begin == null || end == null)) {
                            throw new SAXParseException("forEach: \"select\", \"items\", or both \"begin\" and \"end\" must be specified", this.locator, null);
                        }
                    } else if (select != null) {
                        throw new SAXParseException("forEach: only one of \"select\" or \"items\" may be specified", this.locator, null);
                    }
                    Expression expr = JXTemplateGenerator.compileExpr(items == null ? select : items, null, this.locator);
                    StartForEach startForEach2 = startForEach = new StartForEach(startElement, expr, var, begin, end, step);
                } else if (localName.equals(JXTemplateGenerator.FORMAT_NUMBER)) {
                    StartFormatNumber startFormatNumber;
                    Expression value = JXTemplateGenerator.compileExpr(attrs.getValue("value"), null, this.locator);
                    Expression type = JXTemplateGenerator.compileExpr(attrs.getValue("type"), null, this.locator);
                    Expression pattern = JXTemplateGenerator.compileExpr(attrs.getValue("pattern"), null, this.locator);
                    Expression currencyCode = JXTemplateGenerator.compileExpr(attrs.getValue("currencyCode"), null, this.locator);
                    Expression currencySymbol = JXTemplateGenerator.compileExpr(attrs.getValue("currencySymbol"), null, this.locator);
                    Expression isGroupingUsed = JXTemplateGenerator.compileBoolean(attrs.getValue("isGroupingUsed"), null, this.locator);
                    Expression maxIntegerDigits = JXTemplateGenerator.compileInt(attrs.getValue("maxIntegerDigits"), null, this.locator);
                    Expression minIntegerDigits = JXTemplateGenerator.compileInt(attrs.getValue("minIntegerDigits"), null, this.locator);
                    Expression maxFractionDigits = JXTemplateGenerator.compileInt(attrs.getValue("maxFractionDigits"), null, this.locator);
                    Expression minFractionDigits = JXTemplateGenerator.compileInt(attrs.getValue("minFractionDigits"), null, this.locator);
                    Expression var = JXTemplateGenerator.compileExpr(attrs.getValue("var"), null, this.locator);
                    Expression locale = JXTemplateGenerator.compileExpr(attrs.getValue("locale"), null, this.locator);
                    StartFormatNumber startFormatNumber2 = startFormatNumber = new StartFormatNumber(startElement, var, value, type, pattern, currencyCode, currencySymbol, isGroupingUsed, maxIntegerDigits, minIntegerDigits, maxFractionDigits, minFractionDigits, locale);
                } else if (localName.equals(JXTemplateGenerator.FORMAT_DATE)) {
                    StartFormatDate startFormatDate;
                    Expression var = JXTemplateGenerator.compileExpr(attrs.getValue("var"), null, this.locator);
                    Expression value = JXTemplateGenerator.compileExpr(attrs.getValue("value"), null, this.locator);
                    Expression type = JXTemplateGenerator.compileExpr(attrs.getValue("type"), null, this.locator);
                    Expression pattern = JXTemplateGenerator.compileExpr(attrs.getValue("pattern"), null, this.locator);
                    Expression timeZone = JXTemplateGenerator.compileExpr(attrs.getValue("timeZone"), null, this.locator);
                    Expression dateStyle = JXTemplateGenerator.compileExpr(attrs.getValue("dateStyle"), null, this.locator);
                    Expression timeStyle = JXTemplateGenerator.compileExpr(attrs.getValue("timeStyle"), null, this.locator);
                    Expression locale = JXTemplateGenerator.compileExpr(attrs.getValue("locale"), null, this.locator);
                    StartFormatDate startFormatDate2 = startFormatDate = new StartFormatDate(startElement, var, value, type, pattern, timeZone, dateStyle, timeStyle, locale);
                } else if (localName.equals(JXTemplateGenerator.CHOOSE)) {
                    StartChoose startChoose;
                    StartChoose startChoose2 = startChoose = new StartChoose(startElement);
                } else if (localName.equals(JXTemplateGenerator.WHEN)) {
                    StartWhen startWhen;
                    if (this.stack.size() == 0 || !(this.stack.peek() instanceof StartChoose)) {
                        throw new SAXParseException("<when> must be within <choose>", this.locator, null);
                    }
                    String test = attrs.getValue("test");
                    if (test == null) {
                        throw new SAXParseException("when: \"test\" is required", this.locator, null);
                    }
                    Expression expr = JXTemplateGenerator.compileExpr(test, "when: \"test\": ", this.locator);
                    StartWhen startWhen2 = startWhen = new StartWhen(startElement, expr);
                } else if (localName.equals(JXTemplateGenerator.OUT)) {
                    String value = attrs.getValue("value");
                    if (value == null) {
                        throw new SAXParseException("out: \"value\" is required", this.locator, null);
                    }
                    Expression expr = JXTemplateGenerator.compileExpr(value, "out: \"value\": ", this.locator);
                    StartOut startOut = new StartOut(startElement, expr);
                } else if (localName.equals(JXTemplateGenerator.OTHERWISE)) {
                    StartOtherwise startOtherwise;
                    if (this.stack.size() == 0 || !(this.stack.peek() instanceof StartChoose)) {
                        throw new SAXParseException("<otherwise> must be within <choose>", this.locator, null);
                    }
                    StartOtherwise startOtherwise2 = startOtherwise = new StartOtherwise(startElement);
                } else if (localName.equals(JXTemplateGenerator.IF)) {
                    StartIf startIf;
                    String test = attrs.getValue("test");
                    if (test == null) {
                        throw new SAXParseException("if: \"test\" is required", this.locator, null);
                    }
                    Expression expr = JXTemplateGenerator.compileExpr(test, "if: \"test\": ", this.locator);
                    StartIf startIf2 = startIf = new StartIf(startElement, expr);
                } else if (localName.equals(JXTemplateGenerator.MACRO)) {
                    StartDefine startDefine;
                    String name;
                    String namespace = attrs.getValue("targetNamespace");
                    if (namespace == null) {
                        namespace = "";
                    }
                    if ((name = attrs.getValue("name")) == null) {
                        throw new SAXParseException("macro: \"name\" is required", this.locator, null);
                    }
                    StartDefine startDefine2 = startDefine = new StartDefine(startElement, namespace, name);
                } else if (localName.equals(JXTemplateGenerator.PARAMETER)) {
                    boolean syntaxErr = false;
                    if (this.stack.size() < 1 || !(this.stack.peek() instanceof StartDefine)) {
                        syntaxErr = true;
                    } else {
                        StartParameter startParameter;
                        String name = attrs.getValue("name");
                        String optional = attrs.getValue("optional");
                        String default_ = attrs.getValue("default");
                        if (name == null) {
                            throw new SAXParseException("parameter: \"name\" is required", this.locator, null);
                        }
                        StartParameter startParameter2 = startParameter = new StartParameter(startElement, name, optional, default_);
                    }
                    if (syntaxErr) {
                        throw new SAXParseException("<parameter> not allowed here", this.locator, null);
                    }
                } else if (localName.equals(JXTemplateGenerator.SET)) {
                    StartSet startSet;
                    String var = attrs.getValue("var");
                    String value = attrs.getValue("value");
                    Expression valueExpr = null;
                    if (value != null) {
                        valueExpr = JXTemplateGenerator.compileExpr(value, "set: \"value\":", this.locator);
                    }
                    StartSet startSet2 = startSet = new StartSet(startElement, var, valueExpr);
                } else if (localName.equals(JXTemplateGenerator.IMPORT)) {
                    StartImport startImport;
                    AttributeEvent uri = null;
                    Iterator iter = startElement.attributeEvents.iterator();
                    while (iter.hasNext()) {
                        AttributeEvent e = (AttributeEvent)iter.next();
                        if (!e.localName.equals("uri")) continue;
                        uri = e;
                        break;
                    }
                    if (uri == null) {
                        throw new SAXParseException("import: \"uri\" is required", this.locator, null);
                    }
                    String select = attrs.getValue("context");
                    Expression expr = null;
                    if (select != null) {
                        expr = JXTemplateGenerator.compileExpr(select, "import: \"context\": ", this.locator);
                    }
                    StartImport startImport2 = startImport = new StartImport(startElement, uri, expr);
                } else {
                    StartTemplate startTemplate;
                    if (!localName.equals(JXTemplateGenerator.TEMPLATE)) throw new SAXParseException("unrecognized tag: " + localName, this.locator, null);
                    StartTemplate startTemplate2 = startTemplate = new StartTemplate(startElement);
                }
            } else {
                StartElement startElement2 = startElement;
            }
            this.stack.push(var5_21);
            this.addEvent((Event)var5_21);
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.addEvent(new StartPrefixMapping(this.locator, prefix, uri));
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            this.addEvent(new Comment(this.locator, ch, start, length));
        }

        public void endCDATA() throws SAXException {
            this.addEvent(new EndCDATA(this.locator));
        }

        public void endDTD() throws SAXException {
            this.addEvent(new EndDTD(this.locator));
        }

        public void endEntity(String name) throws SAXException {
            this.addEvent(new EndEntity(this.locator, name));
        }

        public void startCDATA() throws SAXException {
            this.addEvent(new StartCDATA(this.locator));
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            this.addEvent(new StartDTD(this.locator, name, publicId, systemId));
        }

        public void startEntity(String name) throws SAXException {
            this.addEvent(new StartEntity(this.locator, name));
        }
    }

    static class StartFormatDate
    extends StartInstruction {
        private static final String DATE = "date";
        private static final String TIME = "time";
        private static final String DATETIME = "both";
        Expression var;
        Expression value;
        Expression type;
        Expression pattern;
        Expression timeZone;
        Expression dateStyle;
        Expression timeStyle;
        Expression locale;
        private static final String DEFAULT = "default";
        private static final String SHORT = "short";
        private static final String MEDIUM = "medium";
        private static final String LONG = "long";
        private static final String FULL = "full";

        StartFormatDate(StartElement raw, Expression var, Expression value, Expression type, Expression pattern, Expression timeZone, Expression dateStyle, Expression timeStyle, Expression locale) {
            super(raw);
            this.var = var;
            this.value = value;
            this.type = type;
            this.pattern = pattern;
            this.timeZone = timeZone;
            this.dateStyle = dateStyle;
            this.timeStyle = timeStyle;
            this.locale = locale;
        }

        String format(JexlContext jexl, JXPathContext jxp) throws Exception {
            String var = JXTemplateGenerator.getStringValue(this.var, jexl, jxp);
            Object value = JXTemplateGenerator.getValue(this.value, jexl, jxp);
            Object locVal = JXTemplateGenerator.getValue(this.locale, jexl, jxp);
            String pattern = JXTemplateGenerator.getStringValue(this.pattern, jexl, jxp);
            Object timeZone = JXTemplateGenerator.getValue(this.timeZone, jexl, jxp);
            String type = JXTemplateGenerator.getStringValue(this.type, jexl, jxp);
            String timeStyle = JXTemplateGenerator.getStringValue(this.timeStyle, jexl, jxp);
            String dateStyle = JXTemplateGenerator.getStringValue(this.dateStyle, jexl, jxp);
            String formatted = null;
            Locale locale = locVal != null ? (locVal instanceof Locale ? (Locale)locVal : JXTemplateGenerator.parseLocale(locVal.toString(), null)) : Locale.getDefault();
            DateFormat formatter = this.createFormatter(locale, type, dateStyle, timeStyle);
            if (pattern != null) {
                try {
                    ((SimpleDateFormat)formatter).applyPattern(pattern);
                }
                catch (ClassCastException cce) {
                    formatter = new SimpleDateFormat(pattern, locale);
                }
            }
            TimeZone tz = null;
            if (timeZone instanceof String && ((String)timeZone).equals("")) {
                timeZone = null;
            }
            if (timeZone != null) {
                if (timeZone instanceof String) {
                    tz = TimeZone.getTimeZone((String)timeZone);
                } else if (timeZone instanceof TimeZone) {
                    tz = (TimeZone)timeZone;
                } else {
                    throw new IllegalArgumentException("Illegal timeZone value: \"" + timeZone + "\"");
                }
            }
            if (tz != null) {
                formatter.setTimeZone(tz);
            }
            formatted = formatter.format(value);
            if (var != null) {
                jexl.getVars().put(var, formatted);
                jxp.getVariables().declareVariable(var, (Object)formatted);
                return null;
            }
            return formatted;
        }

        private DateFormat createFormatter(Locale loc, String type, String dateStyle, String timeStyle) throws Exception {
            DateFormat formatter = null;
            if (type == null || DATE.equalsIgnoreCase(type)) {
                formatter = DateFormat.getDateInstance(this.getStyle(dateStyle), loc);
            } else if (TIME.equalsIgnoreCase(type)) {
                formatter = DateFormat.getTimeInstance(this.getStyle(timeStyle), loc);
            } else if (DATETIME.equalsIgnoreCase(type)) {
                formatter = DateFormat.getDateTimeInstance(this.getStyle(dateStyle), this.getStyle(timeStyle), loc);
            } else {
                throw new IllegalArgumentException("Invalid type: \"" + type + "\"");
            }
            return formatter;
        }

        private int getStyle(String style) {
            int ret = 2;
            if (style != null) {
                if (DEFAULT.equalsIgnoreCase(style)) {
                    ret = 2;
                } else if (SHORT.equalsIgnoreCase(style)) {
                    ret = 3;
                } else if (MEDIUM.equalsIgnoreCase(style)) {
                    ret = 2;
                } else if (LONG.equalsIgnoreCase(style)) {
                    ret = 1;
                } else if (FULL.equalsIgnoreCase(style)) {
                    ret = 0;
                } else {
                    throw new IllegalArgumentException("Invalid style: \"" + style + "\": should be \"default\" or \"short\" or \"medium\" or \"long\" or \"full\"");
                }
            }
            return ret;
        }
    }

    static class StartFormatNumber
    extends StartInstruction {
        Expression value;
        Expression type;
        Expression pattern;
        Expression currencyCode;
        Expression currencySymbol;
        Expression isGroupingUsed;
        Expression maxIntegerDigits;
        Expression minIntegerDigits;
        Expression maxFractionDigits;
        Expression minFractionDigits;
        Expression locale;
        Expression var;
        private static Class currencyClass;
        static /* synthetic */ Class class$java$lang$String;

        public StartFormatNumber(StartElement raw, Expression var, Expression value, Expression type, Expression pattern, Expression currencyCode, Expression currencySymbol, Expression isGroupingUsed, Expression maxIntegerDigits, Expression minIntegerDigits, Expression maxFractionDigits, Expression minFractionDigits, Expression locale) {
            super(raw);
            this.var = var;
            this.value = value;
            this.type = type;
            this.pattern = pattern;
            this.currencyCode = currencyCode;
            this.currencySymbol = currencySymbol;
            this.isGroupingUsed = isGroupingUsed;
            this.maxIntegerDigits = maxIntegerDigits;
            this.minIntegerDigits = minIntegerDigits;
            this.maxFractionDigits = maxFractionDigits;
            this.minFractionDigits = minFractionDigits;
            this.locale = locale;
        }

        String format(JexlContext jexl, JXPathContext jxp) throws Exception {
            String formatted;
            String var = JXTemplateGenerator.getStringValue(this.var, jexl, jxp);
            Number input = JXTemplateGenerator.getNumberValue(this.value, jexl, jxp);
            String type = JXTemplateGenerator.getStringValue(this.type, jexl, jxp);
            String pattern = JXTemplateGenerator.getStringValue(this.pattern, jexl, jxp);
            String currencyCode = JXTemplateGenerator.getStringValue(this.currencyCode, jexl, jxp);
            String currencySymbol = JXTemplateGenerator.getStringValue(this.currencySymbol, jexl, jxp);
            Boolean isGroupingUsed = JXTemplateGenerator.getBooleanValue(this.isGroupingUsed, jexl, jxp);
            Number maxIntegerDigits = JXTemplateGenerator.getNumberValue(this.maxIntegerDigits, jexl, jxp);
            Number minIntegerDigits = JXTemplateGenerator.getNumberValue(this.minIntegerDigits, jexl, jxp);
            Number maxFractionDigits = JXTemplateGenerator.getNumberValue(this.maxFractionDigits, jexl, jxp);
            Number minFractionDigits = JXTemplateGenerator.getNumberValue(this.minFractionDigits, jexl, jxp);
            String localeStr = JXTemplateGenerator.getStringValue(this.locale, jexl, jxp);
            Locale loc = localeStr == null ? Locale.getDefault() : JXTemplateGenerator.parseLocale(localeStr, null);
            if (loc != null) {
                NumberFormat formatter = null;
                if (pattern != null && !pattern.equals("")) {
                    DecimalFormatSymbols symbols = new DecimalFormatSymbols(loc);
                    formatter = new DecimalFormat(pattern, symbols);
                } else {
                    formatter = this.createFormatter(loc, type);
                }
                if (pattern != null && !pattern.equals("") || JXTemplateGenerator.CURRENCY.equalsIgnoreCase(type)) {
                    this.setCurrency(formatter, currencyCode, currencySymbol);
                }
                this.configureFormatter(formatter, isGroupingUsed, maxIntegerDigits, minIntegerDigits, maxFractionDigits, minFractionDigits);
                formatted = formatter.format(input);
            } else {
                formatted = input.toString();
            }
            if (var != null) {
                jexl.getVars().put(var, formatted);
                jxp.getVariables().declareVariable(var, (Object)formatted);
                return null;
            }
            return formatted;
        }

        private NumberFormat createFormatter(Locale loc, String type) throws Exception {
            NumberFormat formatter = null;
            if (type == null || JXTemplateGenerator.NUMBER.equalsIgnoreCase(type)) {
                formatter = NumberFormat.getNumberInstance(loc);
            } else if (JXTemplateGenerator.CURRENCY.equalsIgnoreCase(type)) {
                formatter = NumberFormat.getCurrencyInstance(loc);
            } else if (JXTemplateGenerator.PERCENT.equalsIgnoreCase(type)) {
                formatter = NumberFormat.getPercentInstance(loc);
            } else {
                throw new IllegalArgumentException("Invalid type: \"" + type + "\": should be \"number\" or \"currency\" or \"percent\"");
            }
            return formatter;
        }

        private void configureFormatter(NumberFormat formatter, Boolean isGroupingUsed, Number maxIntegerDigits, Number minIntegerDigits, Number maxFractionDigits, Number minFractionDigits) {
            if (isGroupingUsed != null) {
                formatter.setGroupingUsed(isGroupingUsed);
            }
            if (maxIntegerDigits != null) {
                formatter.setMaximumIntegerDigits(maxIntegerDigits.intValue());
            }
            if (minIntegerDigits != null) {
                formatter.setMinimumIntegerDigits(minIntegerDigits.intValue());
            }
            if (maxFractionDigits != null) {
                formatter.setMaximumFractionDigits(maxFractionDigits.intValue());
            }
            if (minFractionDigits != null) {
                formatter.setMinimumFractionDigits(minFractionDigits.intValue());
            }
        }

        private void setCurrency(NumberFormat formatter, String currencyCode, String currencySymbol) throws Exception {
            String code = null;
            String symbol = null;
            if (currencyCode == null && currencySymbol == null) {
                return;
            }
            if (currencyCode != null && currencySymbol != null) {
                if (currencyClass != null) {
                    code = currencyCode;
                } else {
                    symbol = currencySymbol;
                }
            } else if (currencyCode == null) {
                symbol = currencySymbol;
            } else if (currencyClass != null) {
                code = currencyCode;
            } else {
                symbol = currencyCode;
            }
            if (code != null) {
                Object[] methodArgs = new Object[1];
                Method m = currencyClass.getMethod("getInstance", class$java$lang$String == null ? (class$java$lang$String = StartFormatNumber.class$("java.lang.String")) : class$java$lang$String);
                methodArgs[0] = code;
                Object currency = m.invoke(null, methodArgs);
                Class[] paramTypes = new Class[]{currencyClass};
                Class<?> numberFormatClass = Class.forName("java.text.NumberFormat");
                m = numberFormatClass.getMethod("setCurrency", paramTypes);
                methodArgs[0] = currency;
                m.invoke((Object)formatter, methodArgs);
            } else {
                DecimalFormat df = (DecimalFormat)formatter;
                DecimalFormatSymbols dfs = df.getDecimalFormatSymbols();
                dfs.setCurrencySymbol(symbol);
                df.setDecimalFormatSymbols(dfs);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static {
            try {
                currencyClass = Class.forName("java.util.Currency");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class StartSet
    extends StartInstruction {
        final String var;
        final Expression value;

        StartSet(StartElement raw, String var, Expression value) {
            super(raw);
            this.var = var;
            this.value = value;
        }
    }

    static class StartParameter
    extends StartInstruction {
        final String name;
        final String optional;
        final String default_;

        StartParameter(StartElement raw, String name, String optional, String default_) {
            super(raw);
            this.name = name;
            this.optional = optional;
            this.default_ = default_;
        }
    }

    static class StartDefine
    extends StartInstruction {
        final String name;
        final String namespace;
        final String qname;
        final Map parameters;
        Event body;

        StartDefine(StartElement raw, String namespace, String name) {
            super(raw);
            this.namespace = namespace;
            this.name = name;
            this.qname = "{" + namespace + "}" + name;
            this.parameters = new HashMap();
        }

        void finish() throws SAXException {
            Event e = this.next;
            boolean params = true;
            while (e != this.endInstruction) {
                if (e instanceof StartParameter) {
                    StartParameter startParam = (StartParameter)e;
                    if (!params) {
                        throw new SAXParseException("<parameter> not allowed here: \"" + startParam.name + "\"", startParam.location, null);
                    }
                    StartParameter prev = this.parameters.put(startParam.name, startParam);
                    if (prev != null) {
                        throw new SAXParseException("duplicate parameter: \"" + startParam.name + "\"", this.location, null);
                    }
                    e = startParam.endInstruction.next;
                } else if (!(e instanceof IgnorableWhitespace)) {
                    if (e instanceof Characters) {
                        char[] ch = ((TextEvent)e).raw;
                        int i = 0;
                        while (i < ch.length) {
                            if (!Character.isWhitespace(ch[i])) {
                                if (params) {
                                    params = false;
                                    this.body = e;
                                }
                                break;
                            }
                            ++i;
                        }
                    } else if (params) {
                        params = false;
                        this.body = e;
                    }
                }
                e = e.next;
            }
            if (this.body == null) {
                this.body = this.endInstruction;
            }
        }
    }

    static class StartTemplate
    extends StartInstruction {
        StartTemplate(StartElement raw) {
            super(raw);
        }
    }

    static class StartImport
    extends StartInstruction {
        final AttributeEvent uri;
        final Expression select;

        StartImport(StartElement raw, AttributeEvent uri, Expression select) {
            super(raw);
            this.uri = uri;
            this.select = select;
        }
    }

    static class StartOut
    extends StartInstruction {
        final Expression compiledExpression;

        StartOut(StartElement raw, Expression expr) {
            super(raw);
            this.compiledExpression = expr;
        }
    }

    static class StartOtherwise
    extends StartInstruction {
        StartOtherwise(StartElement raw) {
            super(raw);
        }
    }

    static class StartWhen
    extends StartInstruction {
        final Expression test;
        StartWhen nextChoice;

        StartWhen(StartElement raw, Expression test) {
            super(raw);
            this.test = test;
        }
    }

    static class StartChoose
    extends StartInstruction {
        StartWhen firstChoice;
        StartOtherwise otherwise;

        StartChoose(StartElement raw) {
            super(raw);
        }
    }

    static class StartIf
    extends StartInstruction {
        final Expression test;

        StartIf(StartElement raw, Expression test) {
            super(raw);
            this.test = test;
        }
    }

    static class StartForEach
    extends StartInstruction {
        final Expression items;
        final String var;
        final Expression begin;
        final Expression end;
        final Expression step;

        StartForEach(StartElement raw, Expression items, String var, Expression begin, Expression end, Expression step) {
            super(raw);
            this.items = items;
            this.var = var;
            this.begin = begin;
            this.end = end;
            this.step = step;
        }
    }

    static class EndInstruction
    extends Event {
        final StartInstruction startInstruction;

        EndInstruction(Locator locator, StartInstruction startInstruction) {
            super(locator);
            this.startInstruction = startInstruction;
            startInstruction.endInstruction = this;
        }
    }

    static class StartInstruction
    extends Event {
        final StartElement startElement;
        EndInstruction endInstruction;

        StartInstruction(StartElement startElement) {
            super(startElement.location);
            this.startElement = startElement;
        }
    }

    static class StartEntity
    extends Event {
        final String name;

        public StartEntity(Locator location, String name) {
            super(location);
            this.name = name;
        }
    }

    static class StartDTD
    extends Event {
        final String name;
        final String publicId;
        final String systemId;

        StartDTD(Locator location, String name, String publicId, String systemId) {
            super(location);
            this.name = name;
            this.publicId = publicId;
            this.systemId = systemId;
        }
    }

    static class StartCDATA
    extends Event {
        StartCDATA(Locator location) {
            super(location);
        }
    }

    static class EndEntity
    extends Event {
        final String name;

        EndEntity(Locator location, String name) {
            super(location);
            this.name = name;
        }
    }

    static class EndDTD
    extends Event {
        EndDTD(Locator location) {
            super(location);
        }
    }

    static class EndCDATA
    extends Event {
        EndCDATA(Locator location) {
            super(location);
        }
    }

    static class Comment
    extends TextEvent {
        Comment(Locator location, char[] chars, int start, int length) throws SAXException {
            super(location, chars, start, length);
        }
    }

    static class StartPrefixMapping
    extends Event {
        final String prefix;
        final String uri;

        StartPrefixMapping(Locator location, String prefix, String uri) {
            super(location);
            this.prefix = prefix;
            this.uri = uri;
        }
    }

    static class StartElement
    extends Event {
        final String namespaceURI;
        final String localName;
        final String raw;
        final String qname;
        final List attributeEvents = new LinkedList();
        final Attributes attributes;
        EndElement endElement;

        /*
         * WARNING - void declaration
         */
        StartElement(Locator location, String namespaceURI, String localName, String raw, Attributes attrs) throws SAXException {
            super(location);
            this.namespaceURI = namespaceURI;
            this.localName = localName;
            this.raw = raw;
            this.qname = "{" + namespaceURI + "}" + localName;
            StringBuffer buf = new StringBuffer();
            int i = 0;
            int len = attrs.getLength();
            while (i < len) {
                String uri = attrs.getURI(i);
                String local = attrs.getLocalName(i);
                String qname = attrs.getQName(i);
                String type = attrs.getType(i);
                String value = attrs.getValue(i);
                StringReader in = new StringReader(value);
                buf.setLength(0);
                boolean inExpr = false;
                LinkedList<Subst> substEvents = new LinkedList<Subst>();
                boolean xpath = false;
                try {
                    int ch;
                    block6: while ((ch = in.read()) != -1) {
                        void var15_15;
                        char c = (char)var15_15;
                        while (true) {
                            if (inExpr) {
                                if (c == '\\') {
                                    ch = in.read();
                                    if (ch == -1) {
                                        buf.append('\\');
                                        continue block6;
                                    }
                                    buf.append((char)ch);
                                    continue block6;
                                }
                                if (c == '}') {
                                    Expression compiledExpression;
                                    String str = buf.toString();
                                    try {
                                        compiledExpression = JXTemplateGenerator.compile(str, xpath);
                                    }
                                    catch (Exception exc) {
                                        throw new SAXParseException(exc.getMessage(), location, exc);
                                    }
                                    catch (Error err) {
                                        throw new SAXParseException(err.getMessage(), location, null);
                                    }
                                    substEvents.add(compiledExpression);
                                    buf.setLength(0);
                                    inExpr = false;
                                    continue block6;
                                }
                                buf.append(c);
                                continue block6;
                            }
                            if (c == '\\') {
                                ch = in.read();
                                if (ch == -1) {
                                    buf.append('\\');
                                } else {
                                    buf.append((char)ch);
                                }
                            }
                            if (c != '$' && c != '#') break;
                            ch = in.read();
                            if (ch == 123) {
                                if (buf.length() > 0) {
                                    substEvents.add(new Literal(buf.toString()));
                                    buf.setLength(0);
                                }
                                inExpr = true;
                                xpath = c == '#';
                                continue block6;
                            }
                            buf.append(c);
                            if (ch == -1) continue block6;
                            c = (char)ch;
                        }
                        buf.append(c);
                    }
                }
                catch (IOException ignored) {
                    ignored.printStackTrace();
                }
                if (buf.length() > 0) {
                    if (substEvents.size() == 0) {
                        this.attributeEvents.add(new CopyAttribute(uri, local, qname, type, value));
                    } else {
                        substEvents.add(new Literal(buf.toString()));
                        this.attributeEvents.add(new SubstituteAttribute(uri, local, qname, type, substEvents));
                    }
                } else if (substEvents.size() > 0) {
                    this.attributeEvents.add(new SubstituteAttribute(uri, local, qname, type, substEvents));
                } else {
                    this.attributeEvents.add(new CopyAttribute(uri, local, qname, type, ""));
                }
                ++i;
            }
            this.attributes = new AttributesImpl(attrs);
        }
    }

    static class SubstituteAttribute
    extends AttributeEvent {
        final List substitutions;

        SubstituteAttribute(String namespaceURI, String localName, String raw, String type, List substs) {
            super(namespaceURI, localName, raw, type);
            this.substitutions = substs;
        }
    }

    static class Expression
    extends Subst {
        String raw;
        Object compiledExpression;

        Expression(String raw, Object expr) {
            this.raw = raw;
            this.compiledExpression = expr;
        }
    }

    static class Literal
    extends Subst {
        final String value;

        Literal(String val) {
            this.value = val;
        }
    }

    static class Subst {
        Subst() {
        }
    }

    static class CopyAttribute
    extends AttributeEvent {
        final String value;

        CopyAttribute(String namespaceURI, String localName, String raw, String type, String value) {
            super(namespaceURI, localName, raw, type);
            this.value = value;
        }
    }

    static abstract class AttributeEvent {
        final String namespaceURI;
        final String localName;
        final String raw;
        final String type;

        AttributeEvent(String namespaceURI, String localName, String raw, String type) {
            this.namespaceURI = namespaceURI;
            this.localName = localName;
            this.raw = raw;
            this.type = type;
        }
    }

    static class SkippedEntity
    extends Event {
        final String name;

        SkippedEntity(Locator location, String name) {
            super(location);
            this.name = name;
        }
    }

    static class ProcessingInstruction
    extends Event {
        final String target;
        final String data;

        ProcessingInstruction(Locator location, String target, String data) {
            super(location);
            this.target = target;
            this.data = data;
        }
    }

    static class IgnorableWhitespace
    extends TextEvent {
        IgnorableWhitespace(Locator location, char[] chars, int start, int length) throws SAXException {
            super(location, chars, start, length);
        }
    }

    static class EndPrefixMapping
    extends Event {
        final String prefix;

        EndPrefixMapping(Locator location, String prefix) {
            super(location);
            this.prefix = prefix;
        }
    }

    static class EndElement
    extends Event {
        final StartElement startElement;

        EndElement(Locator location, StartElement startElement) {
            super(location);
            this.startElement = startElement;
        }
    }

    static class EndDocument
    extends Event {
        EndDocument(Locator location) {
            super(location);
        }
    }

    static class StartDocument
    extends Event {
        SourceValidity compileTime;
        EndDocument endDocument;

        StartDocument(Locator location) {
            super(location);
        }
    }

    static class Characters
    extends TextEvent {
        Characters(Locator location, char[] chars, int start, int length) throws SAXException {
            super(location, chars, start, length);
        }
    }

    static class TextEvent
    extends Event {
        final List substitutions = new LinkedList();
        final char[] raw;

        /*
         * WARNING - void declaration
         */
        TextEvent(Locator location, char[] chars, int start, int length) throws SAXException {
            super(location);
            StringBuffer buf = new StringBuffer();
            this.raw = new char[length];
            System.arraycopy(chars, start, this.raw, 0, length);
            CharArrayReader in = new CharArrayReader(chars, start, length);
            boolean inExpr = false;
            boolean xpath = false;
            try {
                int ch;
                block4: while ((ch = in.read()) != -1) {
                    void var7_9;
                    char c = (char)var7_9;
                    while (true) {
                        if (inExpr) {
                            if (c == '\\') {
                                ch = in.read();
                                if (ch == -1) {
                                    buf.append('\\');
                                    continue block4;
                                }
                                buf.append((char)ch);
                                continue block4;
                            }
                            if (c == '}') {
                                Object compiledExpression;
                                String str = buf.toString();
                                try {
                                    compiledExpression = xpath ? JXPathContext.compile((String)str) : ExpressionFactory.createExpression((String)str);
                                }
                                catch (Exception exc) {
                                    throw new SAXParseException(exc.getMessage(), location, exc);
                                }
                                this.substitutions.add(new Expression(str, compiledExpression));
                                buf.setLength(0);
                                inExpr = false;
                                continue block4;
                            }
                            buf.append(c);
                            continue block4;
                        }
                        if (c == '\\') {
                            ch = in.read();
                            if (ch == -1) {
                                buf.append('\\');
                                continue block4;
                            }
                            buf.append((char)ch);
                            continue block4;
                        }
                        if (c != '$' && c != '#') break;
                        ch = in.read();
                        if (ch == 123) {
                            xpath = c == '#';
                            inExpr = true;
                            if (buf.length() <= 0) continue block4;
                            char[] charArray = new char[buf.length()];
                            buf.getChars(0, buf.length(), charArray, 0);
                            this.substitutions.add(charArray);
                            buf.setLength(0);
                            continue block4;
                        }
                        buf.append(c);
                        if (ch == -1) continue block4;
                        c = (char)ch;
                    }
                    buf.append(c);
                }
            }
            catch (IOException ignored) {
                ignored.printStackTrace();
            }
            if (buf.length() > 0) {
                char[] charArray = new char[buf.length()];
                buf.getChars(0, buf.length(), charArray, 0);
                this.substitutions.add(charArray);
            } else if (this.substitutions.size() == 0) {
                this.substitutions.add(EMPTY_CHARS);
            }
        }
    }

    static class Event {
        final Locator location;
        Event next;

        Event(Locator locator) {
            this.location = locator == null ? NULL_LOCATOR : new LocatorImpl(locator);
        }

        public String locationString() {
            String result = "";
            String systemId = this.location.getSystemId();
            if (systemId != null) {
                result = result + systemId + ", ";
            }
            result = result + "Line " + this.location.getLineNumber();
            int col = this.location.getColumnNumber();
            if (col > 0) {
                result = result + "." + col;
            }
            return result;
        }
    }

    static class MyVariables
    implements Variables {
        Map localVariables = new HashMap();
        static final String[] VARIABLES = new String[]{"continuation", "flowContext", "request", "response", "context", "session", "parameters"};
        Object bean;
        Object kont;
        Object request;
        Object response;
        Object session;
        Object context;
        Object parameters;

        MyVariables(Object bean, WebContinuation kont, Request request, Response response, Context context, Parameters parameters) {
            this.bean = bean;
            this.kont = kont;
            this.request = request;
            this.session = request.getSession(false);
            this.response = response;
            this.context = context;
            this.parameters = parameters;
        }

        public boolean isDeclaredVariable(String varName) {
            int i = 0;
            while (i < VARIABLES.length) {
                if (varName.equals(VARIABLES[i])) {
                    return true;
                }
                ++i;
            }
            return this.localVariables.containsKey(varName);
        }

        public Object getVariable(String varName) {
            if (varName.equals("continuation")) {
                return this.kont;
            }
            if (varName.equals("flowContext")) {
                return this.bean;
            }
            if (varName.equals("request")) {
                return this.request;
            }
            if (varName.equals("response")) {
                return this.response;
            }
            if (varName.equals("session")) {
                return this.session;
            }
            if (varName.equals("context")) {
                return this.context;
            }
            if (varName.equals("parameters")) {
                return this.parameters;
            }
            return this.localVariables.get(varName);
        }

        public void declareVariable(String varName, Object value) {
            this.localVariables.put(varName, value);
        }

        public void undeclareVariable(String varName) {
            this.localVariables.remove(varName);
        }
    }

    static class MyJexlContext
    extends HashMap
    implements JexlContext {
        MyJexlContext closure;

        public Map getVars() {
            return this;
        }

        public void setVars(Map map) {
            this.putAll(map);
        }

        public Object get(Object key) {
            Object result = super.get(key);
            if (result != null) {
                return result;
            }
            MyJexlContext c = this.closure;
            while (c != null) {
                result = c.get(key);
                if (result != null) {
                    return result;
                }
                c = c.closure;
            }
            return result;
        }

        MyJexlContext() {
        }

        MyJexlContext(MyJexlContext closure) {
            this.closure = closure;
        }
    }

    static class JSIntrospector
    extends UberspectImpl {
        JSIntrospector() {
        }

        public Iterator getIterator(Object obj, Info i) throws Exception {
            if (!(obj instanceof Scriptable)) {
                return super.getIterator(obj, i);
            }
            if (obj instanceof NativeArray) {
                return new NativeArrayIterator((NativeArray)obj);
            }
            return new ScriptableIterator((Scriptable)obj);
        }

        public VelMethod getMethod(Object obj, String methodName, Object[] args, Info i) throws Exception {
            if (!(obj instanceof Scriptable)) {
                return super.getMethod(obj, methodName, args, i);
            }
            return new JSMethod((Scriptable)obj, methodName);
        }

        public VelPropertyGet getPropertyGet(Object obj, String identifier, Info i) throws Exception {
            if (!(obj instanceof Scriptable)) {
                return super.getPropertyGet(obj, identifier, i);
            }
            return new JSPropertyGet((Scriptable)obj, identifier);
        }

        public VelPropertySet getPropertySet(Object obj, String identifier, Object arg, Info i) throws Exception {
            if (!(obj instanceof Scriptable)) {
                return super.getPropertySet(obj, identifier, arg, i);
            }
            return new JSPropertySet((Scriptable)obj, identifier);
        }

        static class ScriptableIterator
        implements Iterator {
            Scriptable scope;
            Object[] ids;
            int index;

            public ScriptableIterator(Scriptable scope) {
                this.scope = scope;
                this.ids = scope.getIds();
                this.index = 0;
            }

            public boolean hasNext() {
                return this.index < this.ids.length;
            }

            public Object next() {
                Object object;
                org.mozilla.javascript.Context.enter();
                try {
                    Object result = ScriptableObject.getProperty((Scriptable)this.scope, (String)this.ids[this.index++].toString());
                    if (result == Undefined.instance || result == Scriptable.NOT_FOUND) {
                        result = null;
                    } else if (!(result instanceof NativeJavaClass)) {
                        while (result instanceof Wrapper) {
                            result = ((Wrapper)result).unwrap();
                        }
                    }
                    object = result;
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    org.mozilla.javascript.Context.exit();
                    throw throwable;
                }
                org.mozilla.javascript.Context.exit();
                return object;
            }

            public void remove() {
                org.mozilla.javascript.Context.enter();
                try {
                    this.scope.delete(this.ids[this.index].toString());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    org.mozilla.javascript.Context.exit();
                    throw throwable;
                }
                org.mozilla.javascript.Context.exit();
            }
        }

        static class NativeArrayIterator
        implements Iterator {
            NativeArray arr;
            int index;

            public NativeArrayIterator(NativeArray arr) {
                this.arr = arr;
                this.index = 0;
            }

            public boolean hasNext() {
                return this.index < (int)this.arr.jsGet_length();
            }

            public Object next() {
                Object object;
                org.mozilla.javascript.Context.enter();
                try {
                    Object result = this.arr.get(this.index++, (Scriptable)this.arr);
                    if (result == Undefined.instance || result == Scriptable.NOT_FOUND) {
                        result = null;
                    } else if (!(result instanceof NativeJavaClass)) {
                        while (result instanceof Wrapper) {
                            result = ((Wrapper)result).unwrap();
                        }
                    }
                    object = result;
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    org.mozilla.javascript.Context.exit();
                    throw throwable;
                }
                org.mozilla.javascript.Context.exit();
                return object;
            }

            public void remove() {
                this.arr.delete(this.index);
            }
        }

        static class JSPropertySet
        implements VelPropertySet {
            Scriptable scope;
            String name;

            public JSPropertySet(Scriptable scope, String name) {
                this.scope = scope;
                this.name = name;
            }

            public Object invoke(Object thisArg, Object rhs) throws Exception {
                Object object;
                org.mozilla.javascript.Context.enter();
                try {
                    Object arg = rhs;
                    Scriptable thisObj = !(thisArg instanceof Scriptable) ? org.mozilla.javascript.Context.toObject((Object)thisArg, (Scriptable)this.scope) : (Scriptable)thisArg;
                    if (!(arg == null || arg instanceof Number || arg instanceof Boolean || arg instanceof String || arg instanceof Scriptable)) {
                        arg = org.mozilla.javascript.Context.toObject((Object)arg, (Scriptable)this.scope);
                    }
                    ScriptableObject.putProperty((Scriptable)thisObj, (String)this.name, (Object)arg);
                    object = rhs;
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    org.mozilla.javascript.Context.exit();
                    throw throwable;
                }
                org.mozilla.javascript.Context.exit();
                return object;
            }

            public boolean isCacheable() {
                return false;
            }

            public String getMethodName() {
                return this.name;
            }
        }

        static class JSPropertyGet
        implements VelPropertyGet {
            Scriptable scope;
            String name;

            public JSPropertyGet(Scriptable scope, String name) {
                this.scope = scope;
                this.name = name;
            }

            public Object invoke(Object thisArg) throws Exception {
                Object object;
                org.mozilla.javascript.Context.enter();
                try {
                    Scriptable thisObj = !(thisArg instanceof Scriptable) ? org.mozilla.javascript.Context.toObject((Object)thisArg, (Scriptable)this.scope) : (Scriptable)thisArg;
                    Object result = ScriptableObject.getProperty((Scriptable)thisObj, (String)this.name);
                    if (result == Undefined.instance || result == Scriptable.NOT_FOUND) {
                        result = null;
                    }
                    if (result instanceof Wrapper && !(result instanceof NativeJavaClass)) {
                        result = ((Wrapper)result).unwrap();
                    }
                    object = result;
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    org.mozilla.javascript.Context.exit();
                    throw throwable;
                }
                org.mozilla.javascript.Context.exit();
                return object;
            }

            public boolean isCacheable() {
                return false;
            }

            public String getMethodName() {
                return this.name;
            }
        }

        static class JSMethod
        implements VelMethod {
            Scriptable scope;
            String name;
            static /* synthetic */ Class class$java$lang$Object;

            public JSMethod(Scriptable scope, String name) {
                this.scope = scope;
                this.name = name;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public Object invoke(Object thisArg, Object[] args) throws Exception {
                Object object;
                org.mozilla.javascript.Context cx = org.mozilla.javascript.Context.enter();
                try {
                    try {
                        Scriptable thisObj = !(thisArg instanceof Scriptable) ? org.mozilla.javascript.Context.toObject((Object)thisArg, (Scriptable)this.scope) : (Scriptable)thisArg;
                        Object result = ScriptableObject.getProperty((Scriptable)thisObj, (String)this.name);
                        Object[] newArgs = null;
                        if (args != null) {
                            newArgs = new Object[args.length];
                            int i = 0;
                            while (i < args.length) {
                                newArgs[i] = args[i];
                                if (!(args[i] == null || args[i] instanceof Number || args[i] instanceof Boolean || args[i] instanceof String || args[i] instanceof Scriptable)) {
                                    newArgs[i] = org.mozilla.javascript.Context.toObject((Object)args[i], (Scriptable)this.scope);
                                }
                                ++i;
                            }
                        }
                        if ((result = ScriptRuntime.call((org.mozilla.javascript.Context)cx, (Object)result, (Object)thisObj, (Object[])newArgs, (Scriptable)this.scope)) == Undefined.instance || result == Scriptable.NOT_FOUND) {
                            result = null;
                        } else if (!(result instanceof NativeJavaClass)) {
                            while (result instanceof Wrapper) {
                                result = ((Wrapper)result).unwrap();
                            }
                        }
                        object = result;
                        Object var9_10 = null;
                    }
                    catch (JavaScriptException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    org.mozilla.javascript.Context.exit();
                    throw throwable;
                }
                org.mozilla.javascript.Context.exit();
                return object;
            }

            public boolean isCacheable() {
                return false;
            }

            public String getMethodName() {
                return this.name;
            }

            public Class getReturnType() {
                return class$java$lang$Object == null ? (class$java$lang$Object = JSMethod.class$("java.lang.Object")) : class$java$lang$Object;
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }
    }
}

