/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.Context;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.transformation.helpers.ParametersRecorder;
import org.apache.cocoon.transformation.helpers.TextRecorder;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.cocoon.xml.XMLUtils;
import org.apache.cocoon.xml.dom.DOMBuilder;
import org.apache.excalibur.source.SourceParameters;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractSAXTransformer
extends AbstractTransformer
implements Composable,
Configurable,
Recyclable {
    protected boolean ignoreWhitespaces;
    protected boolean ignoreEmptyCharacters;
    protected int ignoreEventsCount;
    protected int ignoreHooksCount;
    protected String namespaceURI;
    protected String defaultNamespaceURI;
    protected Stack stack = new Stack();
    protected Stack recorderStack = new Stack();
    protected Request request;
    protected Response response;
    protected Context context;
    protected Map objectModel;
    protected Parameters parameters;
    protected String source;
    protected ComponentManager manager;
    protected SourceResolver resolver;
    private boolean isInitialized;
    protected AttributesImpl emptyAttributes = new AttributesImpl();
    private List namespaces = new ArrayList(5);
    private String ourPrefix;
    private LexicalHandler originalLexicalHandler;
    private ContentHandler originalContentHandler;

    public void configure(Configuration configuration) throws ConfigurationException {
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN setup resolver=" + resolver + ", objectModel=" + objectModel + ", src=" + src + ", parameters=" + par);
        }
        if (this.defaultNamespaceURI == null) {
            this.defaultNamespaceURI = this.namespaceURI;
        }
        this.objectModel = objectModel;
        this.request = ObjectModelHelper.getRequest(objectModel);
        this.response = ObjectModelHelper.getResponse(objectModel);
        this.context = ObjectModelHelper.getContext(objectModel);
        this.resolver = resolver;
        this.parameters = par;
        this.source = src;
        this.isInitialized = false;
        this.namespaceURI = this.parameters.getParameter("namespaceURI", this.defaultNamespaceURI);
        this.ignoreHooksCount = 0;
        this.ignoreEventsCount = 0;
        this.ignoreWhitespaces = true;
        this.ignoreEmptyCharacters = false;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END setup");
        }
    }

    public void recycle() {
        super.recycle();
        this.objectModel = null;
        this.request = null;
        this.response = null;
        this.context = null;
        this.resolver = null;
        this.stack.clear();
        this.recorderStack.clear();
        this.parameters = null;
        this.source = null;
        this.namespaces.clear();
        this.ourPrefix = null;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
    }

    public void startDocument() throws SAXException {
        if (!this.isInitialized) {
            try {
                this.setupTransforming();
            }
            catch (ProcessingException local) {
                throw new SAXException("ProcessingException: " + (Object)((Object)local), (Exception)((Object)local));
            }
            catch (IOException ioe) {
                throw new SAXException("IOException: " + ioe, ioe);
            }
            this.isInitialized = true;
        }
        if (this.ignoreEventsCount == 0) {
            super.startDocument();
        }
    }

    public void endDocument() throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.endDocument();
        }
    }

    public void startElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        if (uri != null && this.namespaceURI != null && uri.equals(this.namespaceURI) && this.ignoreHooksCount == 0) {
            try {
                this.startTransformingElement(uri, name, raw, attr);
            }
            catch (ProcessingException pException) {
                throw new SAXException("ProcessingException: " + (Object)((Object)pException), (Exception)((Object)pException));
            }
            catch (IOException ioe) {
                throw new SAXException("Exception occured during processing: " + ioe, ioe);
            }
        } else if (this.ignoreEventsCount == 0) {
            super.startElement(uri, name, raw, attr);
        }
    }

    public void endElement(String uri, String name, String raw) throws SAXException {
        if (uri != null && this.namespaceURI != null && uri.equals(this.namespaceURI) && this.ignoreHooksCount == 0) {
            try {
                this.endTransformingElement(uri, name, raw);
            }
            catch (ProcessingException pException) {
                throw new SAXException("ProcessingException: " + (Object)((Object)pException), (Exception)((Object)pException));
            }
            catch (IOException ioe) {
                throw new SAXException("Exception occured during processing: " + ioe, ioe);
            }
        } else if (this.ignoreEventsCount == 0) {
            super.endElement(uri, name, raw);
        }
    }

    public void characters(char[] p0, int p1, int p2) throws SAXException {
        if (this.ignoreEventsCount == 0) {
            if (this.ignoreEmptyCharacters) {
                String value = new String(p0, p1, p2);
                if (value.trim().length() > 0) {
                    super.characters(p0, p1, p2);
                }
            } else {
                super.characters(p0, p1, p2);
            }
        }
    }

    public void ignorableWhitespace(char[] p0, int p1, int p2) throws SAXException {
        if (!this.ignoreWhitespaces && this.ignoreEventsCount == 0) {
            super.ignorableWhitespace(p0, p1, p2);
        }
    }

    protected void addRecorder(XMLConsumer recorder) {
        if (this.recorderStack.empty()) {
            this.originalLexicalHandler = this.lexicalHandler;
            this.originalContentHandler = this.contentHandler;
        }
        this.setContentHandler(recorder);
        this.setLexicalHandler(recorder);
        this.recorderStack.push(recorder);
    }

    protected Object removeRecorder() {
        Object recorder = this.recorderStack.pop();
        if (this.recorderStack.empty()) {
            this.setContentHandler(this.originalContentHandler);
            this.setLexicalHandler(this.originalLexicalHandler);
            this.originalLexicalHandler = null;
            this.originalContentHandler = null;
        } else {
            XMLConsumer next = (XMLConsumer)this.recorderStack.peek();
            this.setContentHandler(next);
            this.setLexicalHandler(next);
        }
        return recorder;
    }

    public void startRecording() throws SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN startRecording");
        }
        DOMBuilder builder = new DOMBuilder();
        this.addRecorder(builder);
        builder.startDocument();
        builder.startElement("", "cocoon", "cocoon", new AttributesImpl());
        this.sendStartPrefixMapping();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END startRecording");
        }
    }

    public DocumentFragment endRecording() throws SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN endRecording");
        }
        this.sendEndPrefixMapping();
        DOMBuilder builder = (DOMBuilder)this.removeRecorder();
        builder.endElement("", "cocoon", "cocoon");
        builder.endDocument();
        Document doc = builder.getDocument();
        DocumentFragment recordedDocFrag = doc.createDocumentFragment();
        Element root = doc.getDocumentElement();
        root.normalize();
        boolean appendedNode = false;
        while (root.hasChildNodes()) {
            Node child = root.getFirstChild();
            root.removeChild(child);
            if (!appendedNode && child.getNodeType() == 3 && child.getNodeValue().trim().length() <= 0) continue;
            recordedDocFrag.appendChild(child);
            appendedNode = true;
        }
        if (this.getLogger().isDebugEnabled()) {
            Object serializedXML = null;
            try {
                serializedXML = recordedDocFrag == null ? "null" : XMLUtils.serializeNodeToXML(recordedDocFrag);
            }
            catch (ProcessingException ignore) {
                serializedXML = recordedDocFrag;
            }
            this.getLogger().debug("END endRecording fragment=" + serializedXML);
        }
        return recordedDocFrag;
    }

    public void startTextRecording() throws SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN startTextRecording");
        }
        TextRecorder recorder = new TextRecorder();
        this.addRecorder(recorder);
        this.sendStartPrefixMapping();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END startTextRecording");
        }
    }

    public String endTextRecording() throws SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN endTextRecording");
        }
        this.sendEndPrefixMapping();
        TextRecorder recorder = (TextRecorder)this.removeRecorder();
        String text = recorder.getText();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END endTextRecording text=" + text);
        }
        return text;
    }

    public void startSerializedXMLRecording(Properties format) throws SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN startSerializedXMLRecording format=" + format);
        }
        this.stack.push(format == null ? XMLUtils.defaultSerializeToXMLFormat() : format);
        this.startRecording();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END startSerializedXMLRecording");
        }
    }

    public String endSerializedXMLRecording() throws SAXException, ProcessingException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN endSerializedXMLRecording");
        }
        DocumentFragment fragment = this.endRecording();
        String text = XMLUtils.serializeNode(fragment, (Properties)this.stack.pop());
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END endSerializedXMLRecording xml=" + text);
        }
        return text;
    }

    public void startParametersRecording() throws SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN startParametersRecording");
        }
        ParametersRecorder recorder = new ParametersRecorder();
        this.addRecorder(recorder);
        this.sendStartPrefixMapping();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END startParametersRecording");
        }
    }

    public SourceParameters endParametersRecording(Parameters source) throws SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN endParametersRecording source=" + source);
        }
        this.sendEndPrefixMapping();
        ParametersRecorder recorder = (ParametersRecorder)this.removeRecorder();
        SourceParameters pars = recorder.getParameters(source);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END endParametersRecording parameters=" + pars);
        }
        return pars;
    }

    public SourceParameters endParametersRecording(SourceParameters source) throws SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN endParametersRecording source=" + source);
        }
        this.sendEndPrefixMapping();
        ParametersRecorder recorder = (ParametersRecorder)this.removeRecorder();
        SourceParameters pars = recorder.getParameters(source);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END endParametersRecording parameters=" + pars);
        }
        return pars;
    }

    public void setupTransforming() throws IOException, ProcessingException, SAXException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BEGIN setupTransforming");
        }
        this.stack.clear();
        this.recorderStack.clear();
        this.ignoreWhitespaces = true;
        this.ignoreEmptyCharacters = false;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("END setupTransforming");
        }
    }

    public void startTransformingElement(String uri, String name, String raw, Attributes attr) throws ProcessingException, IOException, SAXException {
        if (this.ignoreEventsCount == 0) {
            super.startElement(uri, name, raw, attr);
        }
    }

    public void endTransformingElement(String uri, String name, String raw) throws ProcessingException, IOException, SAXException {
        if (this.ignoreEventsCount == 0) {
            super.endElement(uri, name, raw);
        }
    }

    public void sendTextEvent(String text) throws SAXException {
        this.characters(text.toCharArray(), 0, text.length());
    }

    public void sendStartElementEvent(String localname) throws SAXException {
        this.startElement("", localname, localname, this.emptyAttributes);
    }

    public void sendStartElementEventNS(String localname) throws SAXException {
        this.startElement(this.namespaceURI, localname, this.ourPrefix + ':' + localname, this.emptyAttributes);
    }

    public void sendStartElementEvent(String localname, Attributes attr) throws SAXException {
        this.startElement("", localname, localname, attr);
    }

    public void sendStartElementEventNS(String localname, Attributes attr) throws SAXException {
        this.startElement(this.namespaceURI, localname, this.ourPrefix + ':' + localname, attr);
    }

    public void sendEndElementEvent(String localname) throws SAXException {
        this.endElement("", localname, localname);
    }

    public void sendEndElementEventNS(String localname) throws SAXException {
        this.endElement(this.namespaceURI, localname, this.ourPrefix + ':' + localname);
    }

    public void sendEvents(Node node) throws SAXException {
        IncludeXMLConsumer.includeNode(node, this, this);
    }

    public void sendParametersEvents(SourceParameters pars) throws SAXException {
        if (pars != null) {
            Iterator names = pars.getParameterNames();
            while (names.hasNext()) {
                String currentName = (String)names.next();
                Iterator values = pars.getParameterValues(currentName);
                while (values.hasNext()) {
                    String currentValue = (String)values.next();
                    this.sendStartElementEvent(currentName);
                    this.sendTextEvent(currentValue);
                    this.sendEndElementEvent(currentName);
                }
            }
        }
    }

    public void startEntity(String name) throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.startEntity(name);
        }
    }

    public void endEntity(String name) throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.endEntity(name);
        }
    }

    protected void sendStartPrefixMapping() throws SAXException {
        int l = this.namespaces.size();
        int i = 0;
        while (i < l) {
            String[] prefixAndUri = (String[])this.namespaces.get(i);
            this.contentHandler.startPrefixMapping(prefixAndUri[0], prefixAndUri[1]);
            ++i;
        }
    }

    protected void sendEndPrefixMapping() throws SAXException {
        int l = this.namespaces.size();
        int i = 0;
        while (i < l) {
            String[] prefixAndUri = (String[])this.namespaces.get(i);
            this.contentHandler.endPrefixMapping(prefixAndUri[0]);
            ++i;
        }
    }

    public void setDocumentLocator(Locator locator) {
        if (this.ignoreEventsCount == 0) {
            super.setDocumentLocator(locator);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (prefix != null) {
            this.namespaces.add(new String[]{prefix, uri});
        }
        if (this.namespaceURI != null && this.namespaceURI.equals(uri)) {
            this.ourPrefix = prefix;
        }
        if (this.ignoreEventsCount == 0) {
            super.startPrefixMapping(prefix, uri);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (prefix != null) {
            boolean found = false;
            int l = this.namespaces.size();
            int i = l - 1;
            while (!found && i >= 0) {
                String currentPrefix = ((String[])this.namespaces.get(i))[0];
                if (currentPrefix.equals(prefix)) {
                    found = true;
                    continue;
                }
                --i;
            }
            if (!found) {
                throw new SAXException("Namespace for prefix '" + prefix + "' not found.");
            }
            this.namespaces.remove(i);
            if (prefix.equals(this.ourPrefix)) {
                this.ourPrefix = null;
                found = false;
                l = this.namespaces.size();
                i = l - 1;
                while (!found && i >= 0) {
                    String currentNS = ((String[])this.namespaces.get(i))[1];
                    if (currentNS.equals(this.namespaceURI)) {
                        found = true;
                        continue;
                    }
                    --i;
                }
                if (found) {
                    this.ourPrefix = ((String[])this.namespaces.get(i))[0];
                }
            }
        }
        if (this.ignoreEventsCount == 0) {
            super.endPrefixMapping(prefix);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.processingInstruction(target, data);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.skippedEntity(name);
        }
    }

    public void startDTD(String name, String public_id, String system_id) throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.startDTD(name, public_id, system_id);
        }
    }

    public void endDTD() throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.endDTD();
        }
    }

    public void startCDATA() throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.endCDATA();
        }
    }

    public void comment(char[] ary, int start, int length) throws SAXException {
        if (this.ignoreEventsCount == 0) {
            super.comment(ary, start, length);
        }
    }
}

