/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.treeprocessor.variables.PreparedVariableResolver;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.i18n.Bundle;
import org.apache.cocoon.i18n.BundleFactory;
import org.apache.cocoon.i18n.I18nUtils;
import org.apache.cocoon.sitemap.PatternException;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.transformation.helpers.MirrorRecorder;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.source.impl.validity.NOPValidity;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class I18nTransformer
extends AbstractTransformer
implements CacheableProcessingComponent,
Composable,
Configurable,
Disposable {
    public static final String I18N_NAMESPACE_URI = "http://apache.org/cocoon/i18n/2.1";
    public static final String I18N_OLD_NAMESPACE_URI = "http://apache.org/cocoon/i18n/2.0";
    private static boolean deprecationFound = false;
    public static final String I18N_TEXT_ELEMENT = "text";
    public static final String I18N_TRANSLATE_ELEMENT = "translate";
    public static final String I18N_CHOOSE_ELEMENT = "choose";
    public static final String I18N_WHEN_ELEMENT = "when";
    public static final String I18N_IF_ELEMENT = "if";
    public static final String I18N_OTHERWISE_ELEMENT = "otherwise";
    public static final String I18N_PARAM_ELEMENT = "param";
    public static final String I18N_PARAM_NAME_ATTRIBUTE = "name";
    public static final String I18N_DATE_ELEMENT = "date";
    public static final String I18N_DATE_TIME_ELEMENT = "date-time";
    public static final String I18N_TIME_ELEMENT = "time";
    public static final String I18N_NUMBER_ELEMENT = "number";
    public static final String I18N_CURRENCY_ELEMENT = "currency";
    public static final String I18N_PERCENT_ELEMENT = "percent";
    public static final String I18N_INT_CURRENCY_ELEMENT = "int-currency";
    public static final String I18N_CURRENCY_NO_UNIT_ELEMENT = "currency-no-unit";
    public static final String I18N_INT_CURRENCY_NO_UNIT_ELEMENT = "int-currency-no-unit";
    public static final String I18N_KEY_ATTRIBUTE = "key";
    public static final String I18N_ATTR_ATTRIBUTE = "attr";
    public static final String I18N_SRC_PATTERN_ATTRIBUTE = "src-pattern";
    public static final String I18N_PATTERN_ATTRIBUTE = "pattern";
    public static final String I18N_LOCALE_ATTRIBUTE = "locale";
    public static final String I18N_SRC_LOCALE_ATTRIBUTE = "src-locale";
    public static final String I18N_VALUE_ATTRIBUTE = "value";
    public static final String I18N_TYPE_ATTRIBUTE = "type";
    public static final String CURRENCY_LOCALE_ATTRIBUTE = "currency";
    public static final String I18N_CATALOGUE_ATTRIBUTE = "catalogue";
    public static final String I18N_LOCALE = "locale";
    public static final String I18N_CATALOGUE_NAME = "catalogue-name";
    public static final String I18N_CATALOGUE_LOCATION = "catalogue-location";
    public static final String I18N_DEFAULT_CATALOGUE_ID = "default-catalogue-id";
    public static final String I18N_UNTRANSLATED = "untranslated-text";
    public static final String I18N_CACHE_STARTUP = "cache-at-startup";
    public static final String I18N_CATALOGUE_PREFIX = "/catalogue/message";
    public static final String I18N_FRACTION_DIGITS_ATTRIBUTE = "fraction-digits";
    private static final SourceValidity I18N_NOP_VALIDITY = new NOPValidity();
    private static final int STATE_OUTSIDE = 0;
    private static final int STATE_INSIDE_TEXT = 10;
    private static final int STATE_INSIDE_PARAM = 20;
    private static final int STATE_INSIDE_TRANSLATE = 30;
    private static final int STATE_INSIDE_CHOOSE = 50;
    private static final int STATE_INSIDE_WHEN = 51;
    private static final int STATE_INSIDE_OTHERWISE = 52;
    private static final int STATE_INSIDE_DATE = 60;
    private static final int STATE_INSIDE_DATE_TIME = 61;
    private static final int STATE_INSIDE_TIME = 62;
    private static final int STATE_INSIDE_NUMBER = 63;
    private static final Set dateTypes;
    private static final Set numberTypes;
    private static final Map datePatterns;
    protected ComponentManager manager;
    private SourceResolver sourceResolver;
    protected Map objectModel;
    private int current_state;
    private int prev_state;
    private StringBuffer strBuffer;
    private String current_key;
    private String currentCatalogueId;
    private boolean translate_copy;
    private boolean translate_end;
    private MirrorRecorder tr_text_recorder;
    private MirrorRecorder text_recorder;
    private MirrorRecorder param_recorder;
    private int param_count;
    private String param_name;
    private HashMap indexedParams;
    private String param_value;
    private MessageFormat formatter;
    protected Locale locale;
    private HashMap formattingParams;
    private Bundle defaultCatalogue;
    private Map catalogues = new HashMap();
    protected BundleFactory factory;
    private String catalogueName;
    private String catalogueLocation;
    private String defaultCatalogueId;
    private String untranslated;
    private MirrorRecorder untranslatedRecorder;
    private boolean cacheAtStartup;
    private String globalUntranslated;

    public Locale getLocale() {
        return this.locale;
    }

    public Serializable getKey() {
        return this.catalogueLocation + '/' + this.catalogueName + '?' + this.locale;
    }

    public SourceValidity getValidity() {
        return I18N_NOP_VALIDITY;
    }

    public void compose(ComponentManager manager) {
        this.manager = manager;
        try {
            this.factory = (BundleFactory)manager.lookup("org.apache.cocoon.i18n.BundleFactory");
            this.debug("BundleFactory is obtained");
        }
        catch (ComponentException ce) {
            this.getLogger().error("BundleFactory is not loaded", (Throwable)ce);
        }
    }

    public void configure(Configuration conf) throws ConfigurationException {
        if (this.factory == null) {
            throw new ConfigurationException("BundleFactory component is not found.");
        }
        Configuration child = conf.getChild(I18N_CATALOGUE_NAME);
        this.catalogueName = child.getValue(null);
        child = conf.getChild(I18N_CATALOGUE_LOCATION);
        this.catalogueLocation = child.getValue(null);
        Configuration cataloguesConf = conf.getChild("catalogues", false);
        if ((this.catalogueName != null || this.catalogueLocation != null) && cataloguesConf != null) {
            throw new ConfigurationException("I18nTransformer: old and new configuration style are used at the same time. Use either the 'catalogue-name' and 'catalogue-location' elements or use the 'catalogues' element, but don't use both at the same time.");
        }
        if (this.catalogueName != null || this.catalogueLocation != null) {
            if (this.catalogueName == null || this.catalogueLocation == null) {
                throw new ConfigurationException("I18nTransformer: catalogue-name and catalogue-location must both be specified");
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("using old-style configuration: name = " + this.catalogueName + ", location = " + this.catalogueLocation);
            }
        } else {
            if (cataloguesConf == null) {
                throw new ConfigurationException("Missing configuration for the I18nTransformer: a 'catalogues' element specifying the catalogues is required.");
            }
            Configuration[] catalogueConfs = cataloguesConf.getChildren(I18N_CATALOGUE_ATTRIBUTE);
            int i = 0;
            while (i < catalogueConfs.length) {
                CatalogueInfo newCatalogueInfo;
                String id = catalogueConfs[i].getAttribute("id");
                String name = catalogueConfs[i].getAttribute(I18N_PARAM_NAME_ATTRIBUTE);
                String location = catalogueConfs[i].getAttribute("location");
                try {
                    newCatalogueInfo = new CatalogueInfo(name, location);
                }
                catch (PatternException e) {
                    throw new ConfigurationException("I18nTransformer: error in name or location attribute on catalogue element with id " + id, (Throwable)((Object)e));
                }
                this.catalogues.put(id, newCatalogueInfo);
                ++i;
            }
            this.defaultCatalogueId = cataloguesConf.getAttribute("default");
            if (!this.catalogues.containsKey(this.defaultCatalogueId)) {
                throw new ConfigurationException("I18nTransformer: default catalogue id '" + this.defaultCatalogueId + "' denotes a nonexisting catalogue");
            }
        }
        child = conf.getChild(I18N_UNTRANSLATED);
        this.untranslated = child.getValue(null);
        this.debug("Default untranslated text is '" + this.untranslated + "'");
        child = conf.getChild(I18N_CACHE_STARTUP);
        this.cacheAtStartup = child.getValueAsBoolean(false);
        this.debug((this.cacheAtStartup ? "will" : "won't") + " cache messages during startup, by default");
    }

    public void setup(SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws ProcessingException, SAXException, IOException {
        this.sourceResolver = resolver;
        this.objectModel = objectModel;
        try {
            String localCatLocation = null;
            String localCatName = null;
            String localUntranslated = null;
            String lc = null;
            String localDefaultCatalogueId = null;
            if (parameters != null) {
                localCatLocation = parameters.getParameter(I18N_CATALOGUE_LOCATION, null);
                localCatName = parameters.getParameter(I18N_CATALOGUE_NAME, null);
                localUntranslated = parameters.getParameter(I18N_UNTRANSLATED, null);
                lc = parameters.getParameter("locale", null);
                localDefaultCatalogueId = parameters.getParameter(I18N_DEFAULT_CATALOGUE_ID, null);
            }
            if (localUntranslated != null) {
                this.globalUntranslated = this.untranslated;
                this.untranslated = localUntranslated;
            }
            if (this.untranslated != null) {
                this.untranslatedRecorder = new MirrorRecorder();
                this.untranslatedRecorder.characters(this.untranslated.toCharArray(), 0, this.untranslated.length());
            }
            Locale locale = I18nUtils.parseLocale(lc);
            if (this.getLogger().isDebugEnabled()) {
                this.debug("using locale " + locale.toString());
            }
            this.locale = locale;
            this.current_state = 0;
            this.prev_state = 0;
            this.current_key = null;
            this.currentCatalogueId = null;
            this.translate_copy = false;
            this.tr_text_recorder = null;
            this.text_recorder = new MirrorRecorder();
            this.param_count = 0;
            this.param_name = null;
            this.param_value = null;
            this.param_recorder = null;
            this.indexedParams = new HashMap(3);
            this.formattingParams = null;
            this.strBuffer = null;
            if (localCatLocation != null || localCatName != null) {
                localCatName = localCatName != null ? localCatName : this.catalogueName;
                String string = localCatLocation = localCatLocation != null ? localCatLocation : this.catalogueLocation;
                if (localCatName == null || localCatLocation == null) {
                    throw new ProcessingException("I18nTransformer: incorrect usage: either catalogue-name or catalogue-location are not specified.");
                }
                this.defaultCatalogue = this.getCatalogue(localCatName, localCatLocation);
            } else {
                if ((localDefaultCatalogueId != null || localCatLocation != null) && localCatName != null) {
                    throw new ProcessingException("I18nTransformer: either specify 'catalogue-name' and 'catalogue-location' or specify 'default-catalogue-id', but don't mix the two configuration styles.");
                }
                if (localDefaultCatalogueId != null) {
                    CatalogueInfo catalogueInfo = (CatalogueInfo)this.catalogues.get(localDefaultCatalogueId);
                    if (catalogueInfo == null) {
                        throw new ProcessingException("I18nTransformer: '" + localDefaultCatalogueId + "' is not an existing catalogue id.");
                    }
                    this.defaultCatalogue = catalogueInfo.getCatalogue();
                } else {
                    this.defaultCatalogue = this.catalogueName != null && this.catalogueLocation != null ? this.getCatalogue(this.catalogueName, this.catalogueLocation) : ((CatalogueInfo)this.catalogues.get(this.defaultCatalogueId)).getCatalogue();
                }
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("using default catalogue " + this.defaultCatalogue);
            }
            this.formatter = new MessageFormat("");
            this.formatter.setLocale(locale);
        }
        catch (Exception e) {
            this.debug("exception generated, leaving unconfigured");
            throw new ProcessingException(e.getMessage(), e);
        }
    }

    private Bundle getCatalogue(String name, String location) throws Exception {
        BundleFactory bundleFactory = this.factory;
        synchronized (bundleFactory) {
            this.configureFactory(location);
            Bundle bundle = (Bundle)this.factory.select(name, this.locale);
            return bundle;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void configureFactory(String location) throws Exception {
        DefaultConfiguration configuration;
        block3: {
            configuration = new DefaultConfiguration(I18N_PARAM_NAME_ATTRIBUTE, "location");
            DefaultConfiguration cacheConf = new DefaultConfiguration(I18N_CACHE_STARTUP, "location");
            cacheConf.setValue(new Boolean(this.cacheAtStartup).toString());
            configuration.addChild((Configuration)cacheConf);
            DefaultConfiguration dirConf = new DefaultConfiguration(I18N_CATALOGUE_LOCATION, "location");
            this.debug("catalog location:" + location);
            Source source = null;
            try {
                source = this.sourceResolver.resolveURI(location);
                String systemId = source.getURI();
                this.debug("catalog directory:" + systemId);
                dirConf.setValue(systemId);
                configuration.addChild((Configuration)dirConf);
                Object var8_7 = null;
                if (source == null) break block3;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (source != null) {
                    this.sourceResolver.release(source);
                }
                throw throwable;
            }
            this.sourceResolver.release(source);
        }
        ((Configurable)this.factory).configure((Configuration)configuration);
        this.debug("factory configured");
    }

    public void startElement(String uri, String name, String raw, Attributes attr) throws SAXException {
        if (this.current_state != 0 && this.strBuffer != null) {
            this.i18nCharacters(this.strBuffer.toString());
            this.strBuffer = null;
        }
        if (I18N_OLD_NAMESPACE_URI.equals(uri)) {
            if (!deprecationFound) {
                deprecationFound = true;
                this.getLogger().warn("The namespace 'http://apache.org/cocoon/i18n/2.0' for i18n is not supported any more, use: 'http://apache.org/cocoon/i18n/2.1'");
            }
            this.debug("Starting deprecated i18n element: " + name);
            this.startI18NElement(name, attr);
        } else if (I18N_NAMESPACE_URI.equals(uri)) {
            this.debug("Starting i18n element: " + name);
            this.startI18NElement(name, attr);
        } else if (this.current_state == 0) {
            super.startElement(uri, name, raw, this.translateAttributes(name, attr));
        } else if (this.current_state == 20) {
            this.param_recorder.startElement(uri, name, raw, attr);
        } else if (this.current_state == 10) {
            this.text_recorder.startElement(uri, name, raw, attr);
        } else if ((this.current_state == 51 || this.current_state == 52) && this.translate_copy) {
            super.startElement(uri, name, raw, attr);
        }
    }

    public void endElement(String uri, String name, String raw) throws SAXException {
        if (this.current_state != 0 && this.strBuffer != null) {
            this.i18nCharacters(this.strBuffer.toString());
            this.strBuffer = null;
        }
        if (I18N_NAMESPACE_URI.equals(uri) || I18N_OLD_NAMESPACE_URI.equals(uri)) {
            this.endI18NElement(name);
        } else if (this.current_state == 20) {
            this.param_recorder.endElement(uri, name, raw);
        } else if (this.current_state == 10) {
            this.text_recorder.endElement(uri, name, raw);
        } else if (this.current_state != 50 && (this.current_state != 51 && this.current_state != 52 || this.translate_copy)) {
            super.endElement(uri, name, raw);
        }
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        if (this.current_state == 0 || (this.current_state == 51 || this.current_state == 52) && this.translate_copy) {
            super.characters(ch, start, len);
        } else {
            if (this.strBuffer == null) {
                this.strBuffer = new StringBuffer();
            }
            this.strBuffer.append(ch, start, len);
        }
    }

    private void startI18NElement(String name, Attributes attr) throws SAXException {
        this.debug("Start i18n element: " + name);
        if (I18N_TEXT_ELEMENT.equals(name)) {
            if (this.current_state != 0 && this.current_state != 20 && this.current_state != 30) {
                throw new SAXException(this.getClass().getName() + ": nested i18n:text elements are not allowed." + " Current state: " + this.current_state);
            }
            this.prev_state = this.current_state;
            this.current_state = 10;
            this.current_key = attr.getValue("", I18N_KEY_ATTRIBUTE);
            if (this.current_key == null) {
                this.current_key = attr.getValue(I18N_NAMESPACE_URI, I18N_KEY_ATTRIBUTE);
                if (this.current_key == null) {
                    this.current_key = attr.getValue(I18N_OLD_NAMESPACE_URI, I18N_KEY_ATTRIBUTE);
                }
            }
            this.currentCatalogueId = attr.getValue("", I18N_CATALOGUE_ATTRIBUTE);
            if (this.currentCatalogueId == null) {
                this.currentCatalogueId = attr.getValue(I18N_NAMESPACE_URI, I18N_CATALOGUE_ATTRIBUTE);
            }
            if (this.prev_state != 20) {
                this.tr_text_recorder = null;
            }
            if (this.current_key != null) {
                this.tr_text_recorder = this.getMirrorRecorder(this.current_key, null);
            }
        } else if (I18N_TRANSLATE_ELEMENT.equals(name)) {
            if (this.current_state != 0) {
                throw new SAXException(this.getClass().getName() + ": i18n:translate element must be used " + "outside of other i18n elements. Current state: " + this.current_state);
            }
            this.prev_state = this.current_state;
            this.current_state = 30;
        } else if (I18N_PARAM_ELEMENT.equals(name)) {
            if (this.current_state != 30) {
                throw new SAXException(this.getClass().getName() + ": i18n:param element can be used only inside " + "i18n:translate element. Current state: " + this.current_state);
            }
            this.param_name = attr.getValue(I18N_PARAM_NAME_ATTRIBUTE);
            if (this.param_name == null) {
                this.param_name = String.valueOf(this.param_count++);
            }
            this.param_recorder = new MirrorRecorder();
            this.setFormattingParams(attr);
            this.current_state = 20;
        } else if (I18N_CHOOSE_ELEMENT.equals(name)) {
            if (this.current_state != 0) {
                throw new SAXException(this.getClass().getName() + ": i18n:choose elements cannot be used" + "inside of other i18n elements.");
            }
            this.translate_copy = false;
            this.translate_end = false;
            this.prev_state = this.current_state;
            this.current_state = 50;
        } else if (I18N_WHEN_ELEMENT.equals(name) || I18N_IF_ELEMENT.equals(name)) {
            if (I18N_WHEN_ELEMENT.equals(name) && this.current_state != 50) {
                throw new SAXException(this.getClass().getName() + ": i18n:when elements are can be used only" + "inside of i18n:choose elements.");
            }
            if (I18N_IF_ELEMENT.equals(name) && this.current_state != 0) {
                throw new SAXException(this.getClass().getName() + ": i18n:if elements cannot be nested.");
            }
            String locale = attr.getValue("locale");
            if (locale == null) {
                throw new SAXException(this.getClass().getName() + ": i18n:" + name + " element cannot be used without 'locale' attribute.");
            }
            if ((!this.translate_end && this.current_state == 50 || this.current_state == 0) && this.locale.toString().startsWith(locale)) {
                this.debug("Locale matching: " + locale);
                this.translate_copy = true;
            }
            this.prev_state = this.current_state;
            this.current_state = 51;
        } else if (I18N_OTHERWISE_ELEMENT.equals(name)) {
            if (this.current_state != 50) {
                throw new SAXException(this.getClass().getName() + ": i18n:otherwise elements are not allowed " + "only inside i18n:choose.");
            }
            this.debug("Matching any locale");
            if (!this.translate_end) {
                this.translate_copy = true;
            }
            this.prev_state = this.current_state;
            this.current_state = 52;
        } else if (I18N_DATE_ELEMENT.equals(name)) {
            if (this.current_state != 0 && this.current_state != 10 && this.current_state != 20) {
                throw new SAXException(this.getClass().getName() + ": i18n:date elements are not allowed " + "inside of other i18n elements.");
            }
            this.setFormattingParams(attr);
            this.prev_state = this.current_state;
            this.current_state = 60;
        } else if (I18N_DATE_TIME_ELEMENT.equals(name)) {
            if (this.current_state != 0 && this.current_state != 10 && this.current_state != 20) {
                throw new SAXException(this.getClass().getName() + ": i18n:date-time elements are not allowed " + "inside of other i18n elements.");
            }
            this.setFormattingParams(attr);
            this.prev_state = this.current_state;
            this.current_state = 61;
        } else if (I18N_TIME_ELEMENT.equals(name)) {
            if (this.current_state != 0 && this.current_state != 10 && this.current_state != 20) {
                throw new SAXException(this.getClass().getName() + ": i18n:date elements are not allowed " + "inside of other i18n elements.");
            }
            this.setFormattingParams(attr);
            this.prev_state = this.current_state;
            this.current_state = 62;
        } else if (I18N_NUMBER_ELEMENT.equals(name)) {
            if (this.current_state != 0 && this.current_state != 10 && this.current_state != 20) {
                throw new SAXException(this.getClass().getName() + ": i18n:number elements are not allowed " + "inside of other i18n elements.");
            }
            this.setFormattingParams(attr);
            this.prev_state = this.current_state;
            this.current_state = 63;
        }
    }

    private void setFormattingParams(Attributes attr) {
        this.formattingParams = new HashMap(3);
        String attr_value = attr.getValue(I18N_SRC_PATTERN_ATTRIBUTE);
        if (attr_value != null) {
            this.formattingParams.put(I18N_SRC_PATTERN_ATTRIBUTE, attr_value);
        }
        if ((attr_value = attr.getValue(I18N_PATTERN_ATTRIBUTE)) != null) {
            this.formattingParams.put(I18N_PATTERN_ATTRIBUTE, attr_value);
        }
        if ((attr_value = attr.getValue(I18N_VALUE_ATTRIBUTE)) != null) {
            this.formattingParams.put(I18N_VALUE_ATTRIBUTE, attr_value);
        }
        if ((attr_value = attr.getValue("locale")) != null) {
            this.formattingParams.put("locale", attr_value);
        }
        if ((attr_value = attr.getValue("currency")) != null) {
            this.formattingParams.put("currency", attr_value);
        }
        if ((attr_value = attr.getValue(I18N_SRC_LOCALE_ATTRIBUTE)) != null) {
            this.formattingParams.put(I18N_SRC_LOCALE_ATTRIBUTE, attr_value);
        }
        if ((attr_value = attr.getValue(I18N_TYPE_ATTRIBUTE)) != null) {
            this.formattingParams.put(I18N_TYPE_ATTRIBUTE, attr_value);
        }
        if ((attr_value = attr.getValue(I18N_FRACTION_DIGITS_ATTRIBUTE)) != null) {
            this.formattingParams.put(I18N_FRACTION_DIGITS_ATTRIBUTE, attr_value);
        }
    }

    private void endI18NElement(String name) throws SAXException {
        this.debug("End i18n element: " + name);
        switch (this.current_state) {
            case 10: {
                this.endTextElement();
                break;
            }
            case 30: {
                this.endTranslateElement();
                break;
            }
            case 50: {
                this.endChooseElement();
                break;
            }
            case 51: 
            case 52: {
                this.endWhenElement();
                break;
            }
            case 20: {
                this.endParamElement();
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                this.endDate_TimeElement();
                break;
            }
            case 63: {
                this.endNumberElement();
            }
        }
    }

    private void i18nCharacters(String textValue) throws SAXException {
        if (textValue == null) {
            return;
        }
        if ((textValue = textValue.trim()).length() == 0) {
            return;
        }
        this.debug("i18n message text = '" + textValue + "'");
        switch (this.current_state) {
            case 10: {
                this.text_recorder.characters(textValue);
                break;
            }
            case 20: {
                this.param_recorder.characters(textValue);
                break;
            }
            case 51: 
            case 52: {
                break;
            }
            case 30: {
                if (this.tr_text_recorder == null) {
                    this.tr_text_recorder = new MirrorRecorder();
                }
                this.tr_text_recorder.characters(textValue);
                break;
            }
            case 50: {
                this.debug("No characters allowed inside <i18n:choose> tags");
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                if (this.formattingParams.get(I18N_VALUE_ATTRIBUTE) != null) break;
                this.formattingParams.put(I18N_VALUE_ATTRIBUTE, textValue);
                break;
            }
            default: {
                throw new IllegalStateException(this.getClass().getName() + " developer's fault: characters not handled" + "Current state: " + this.current_state);
            }
        }
    }

    private Attributes translateAttributes(String name, Attributes attr) {
        if (attr == null) {
            return attr;
        }
        AttributesImpl temp_attr = new AttributesImpl(attr);
        int i18n_attr_index = temp_attr.getIndex(I18N_NAMESPACE_URI, I18N_ATTR_ATTRIBUTE);
        if (i18n_attr_index == -1) {
            i18n_attr_index = temp_attr.getIndex(I18N_OLD_NAMESPACE_URI, I18N_ATTR_ATTRIBUTE);
        }
        if (i18n_attr_index != -1) {
            StringTokenizer st = new StringTokenizer(temp_attr.getValue(i18n_attr_index));
            temp_attr.removeAttribute(i18n_attr_index);
            while (st.hasMoreElements()) {
                String attr_name = st.nextToken();
                int attr_index = temp_attr.getIndex(attr_name);
                if (attr_index != -1) {
                    String result;
                    String text2translate = temp_attr.getValue(attr_index);
                    int colonPos = text2translate.indexOf(":");
                    String catalogueId = null;
                    if (colonPos != -1) {
                        catalogueId = text2translate.substring(0, colonPos);
                        text2translate = text2translate.substring(colonPos + 1, text2translate.length());
                    }
                    if ((result = this.getString(text2translate, catalogueId, this.untranslated == null ? text2translate : this.untranslated)) != null) {
                        temp_attr.setValue(attr_index, result);
                        continue;
                    }
                    this.getLogger().warn("translation not found for attribute " + attr_name + " in element: " + name);
                    continue;
                }
                this.getLogger().warn("i18n attribute '" + attr_name + "' not found in element: " + name);
            }
            return temp_attr;
        }
        return attr;
    }

    private void endTextElement() throws SAXException {
        switch (this.prev_state) {
            case 0: {
                if (this.tr_text_recorder == null) {
                    if (this.current_key == null) {
                        this.tr_text_recorder = this.getMirrorRecorder(this.text_recorder.text(), this.text_recorder);
                    } else {
                        if (this.getLogger().isDebugEnabled()) {
                            this.debug("translation not found for key " + this.current_key);
                        }
                        this.tr_text_recorder = this.text_recorder.empty() && this.untranslatedRecorder != null ? this.untranslatedRecorder : this.text_recorder;
                    }
                }
                if (this.tr_text_recorder != null) {
                    this.tr_text_recorder.send(this.contentHandler);
                }
                this.text_recorder.recycle();
                this.tr_text_recorder = null;
                this.current_key = null;
                this.currentCatalogueId = null;
                break;
            }
            case 30: {
                if (this.tr_text_recorder == null && !this.text_recorder.empty()) {
                    this.tr_text_recorder = this.getMirrorRecorder(this.text_recorder.text(), this.text_recorder);
                    if (this.tr_text_recorder == this.text_recorder) {
                        this.tr_text_recorder = (MirrorRecorder)this.text_recorder.clone();
                    }
                }
                this.text_recorder.recycle();
                break;
            }
            case 20: {
                if (this.text_recorder.empty()) break;
                this.getMirrorRecorder(this.text_recorder.text(), this.text_recorder).send(this.param_recorder);
                this.text_recorder.recycle();
            }
        }
        this.current_state = this.prev_state;
        this.prev_state = 0;
    }

    private void endParamElement() throws SAXException {
        String paramType = (String)this.formattingParams.get(I18N_TYPE_ATTRIBUTE);
        if (paramType != null) {
            this.debug("Param type: " + paramType);
            if (this.formattingParams.get(I18N_VALUE_ATTRIBUTE) == null && this.param_value != null) {
                this.debug("Put param value: " + this.param_value);
                this.formattingParams.put(I18N_VALUE_ATTRIBUTE, this.param_value);
            }
            if (dateTypes.contains(paramType)) {
                this.debug("Formatting date_time param: " + this.formattingParams);
                this.param_value = this.formatDate_Time(this.formattingParams);
            } else if (numberTypes.contains(paramType)) {
                this.debug("Formatting number param: " + this.formattingParams);
                this.param_value = this.formatNumber(this.formattingParams);
            }
            this.debug("Added substitution param: " + this.param_value);
        }
        this.param_value = null;
        this.current_state = 30;
        if (this.param_recorder == null) {
            return;
        }
        this.indexedParams.put(this.param_name, this.param_recorder.clone());
    }

    private void endTranslateElement() throws SAXException {
        if (this.tr_text_recorder != null) {
            if (this.getLogger().isDebugEnabled()) {
                this.debug("End of translate with params");
                this.debug("Fragment for substitution : " + this.tr_text_recorder.text());
            }
            this.tr_text_recorder.send(this.contentHandler, this.indexedParams);
            this.tr_text_recorder = null;
            this.text_recorder.recycle();
        }
        this.indexedParams.clear();
        this.param_count = 0;
        this.current_state = 0;
    }

    private void endChooseElement() {
        this.current_state = 0;
    }

    private void endWhenElement() {
        this.current_state = this.prev_state;
        if (this.translate_copy) {
            this.translate_copy = false;
            this.translate_end = true;
        }
    }

    private void endDate_TimeElement() throws SAXException {
        String result = this.formatDate_Time(this.formattingParams);
        switch (this.prev_state) {
            case 0: {
                this.contentHandler.characters(result.toCharArray(), 0, result.length());
                break;
            }
            case 20: {
                this.param_recorder.characters(result.toCharArray(), 0, result.length());
                break;
            }
            case 10: {
                this.text_recorder.characters(result.toCharArray(), 0, result.length());
            }
        }
        this.current_state = this.prev_state;
    }

    private Locale getLocale(Map params, String attribute) {
        String lc = (String)params.get(attribute);
        return I18nUtils.parseLocale(lc, this.locale);
    }

    private String formatDate_Time(Map params) throws SAXException {
        Integer patternValue;
        if (params == null) {
            throw new IllegalArgumentException("Nothing to format");
        }
        SimpleDateFormat to_fmt = null;
        SimpleDateFormat from_fmt = null;
        int srcStyle = 2;
        int style = 2;
        boolean realPattern = false;
        boolean realSrcPattern = false;
        Locale srcLoc = this.getLocale(params, I18N_SRC_LOCALE_ATTRIBUTE);
        Locale loc = this.getLocale(params, "locale");
        String srcPattern = (String)params.get(I18N_SRC_PATTERN_ATTRIBUTE);
        String pattern = (String)params.get(I18N_PATTERN_ATTRIBUTE);
        String value = (String)params.get(I18N_VALUE_ATTRIBUTE);
        if (srcPattern != null) {
            patternValue = (Integer)datePatterns.get(srcPattern.toUpperCase());
            if (patternValue != null) {
                srcStyle = patternValue;
            } else {
                realSrcPattern = true;
            }
        }
        if (pattern != null) {
            patternValue = (Integer)datePatterns.get(pattern.toUpperCase());
            if (patternValue != null) {
                style = patternValue;
            } else {
                realPattern = true;
            }
        }
        String paramType = (String)this.formattingParams.get(I18N_TYPE_ATTRIBUTE);
        if (this.current_state == 60 || I18N_DATE_ELEMENT.equals(paramType)) {
            to_fmt = (SimpleDateFormat)DateFormat.getDateInstance(style, loc);
            from_fmt = (SimpleDateFormat)DateFormat.getDateInstance(srcStyle, srcLoc);
        } else if (this.current_state == 61 || I18N_DATE_TIME_ELEMENT.equals(paramType)) {
            to_fmt = (SimpleDateFormat)DateFormat.getDateTimeInstance(style, style, loc);
            from_fmt = (SimpleDateFormat)DateFormat.getDateTimeInstance(srcStyle, srcStyle, srcLoc);
        } else {
            to_fmt = (SimpleDateFormat)DateFormat.getTimeInstance(style, loc);
            from_fmt = (SimpleDateFormat)DateFormat.getTimeInstance(srcStyle, srcLoc);
        }
        Date dateValue = null;
        if (realSrcPattern) {
            from_fmt.applyPattern(srcPattern);
        }
        if (realPattern) {
            to_fmt.applyPattern(pattern);
        }
        if (value == null) {
            dateValue = new Date();
        } else {
            try {
                dateValue = from_fmt.parse(value);
            }
            catch (ParseException pe) {
                throw new SAXException(this.getClass().getName() + "i18n:date - parsing error.", pe);
            }
        }
        this.debug("### Formatting date: " + dateValue + " with localized pattern " + to_fmt.toLocalizedPattern() + " for locale: " + this.locale);
        return to_fmt.format(dateValue);
    }

    private void endNumberElement() throws SAXException {
        String result = this.formatNumber(this.formattingParams);
        switch (this.prev_state) {
            case 0: {
                this.contentHandler.characters(result.toCharArray(), 0, result.length());
                break;
            }
            case 20: {
                this.param_recorder.characters(result.toCharArray(), 0, result.length());
                break;
            }
            case 10: {
                this.text_recorder.characters(result.toCharArray(), 0, result.length());
            }
        }
        this.current_state = this.prev_state;
    }

    private String formatNumber(Map params) throws SAXException {
        int i;
        if (params == null) {
            throw new SAXException(this.getClass().getName() + ": i18n:number - error in element attributes.");
        }
        String srcPattern = (String)params.get(I18N_SRC_PATTERN_ATTRIBUTE);
        String pattern = (String)params.get(I18N_PATTERN_ATTRIBUTE);
        String value = (String)params.get(I18N_VALUE_ATTRIBUTE);
        if (value == null) {
            return "";
        }
        String type = (String)params.get(I18N_TYPE_ATTRIBUTE);
        int fractionDigits = -1;
        try {
            String fd = (String)params.get(I18N_FRACTION_DIGITS_ATTRIBUTE);
            if (fd != null) {
                fractionDigits = Integer.parseInt(fd);
            }
        }
        catch (NumberFormatException nfe) {
            this.getLogger().warn("Error in number format with fraction-digits", (Throwable)nfe);
        }
        Number numberValue = null;
        Locale loc = this.getLocale(params, "locale");
        Locale srcLoc = this.getLocale(params, I18N_SRC_LOCALE_ATTRIBUTE);
        Locale currencyLoc = this.getLocale(params, "currency");
        Locale dgLoc = null;
        if (currencyLoc != null) {
            dgLoc = loc;
            loc = currencyLoc;
        }
        DecimalFormat from_fmt = (DecimalFormat)NumberFormat.getInstance(srcLoc);
        int int_currency = 0;
        if (srcPattern != null) {
            from_fmt.applyPattern(srcPattern);
        }
        DecimalFormat to_fmt = null;
        char dec = from_fmt.getDecimalFormatSymbols().getDecimalSeparator();
        int decAt = 0;
        boolean appendDec = false;
        if (type == null || type.equals(I18N_NUMBER_ELEMENT)) {
            to_fmt = (DecimalFormat)NumberFormat.getInstance(loc);
            to_fmt.setMaximumFractionDigits(309);
            int i2 = value.length() - 1;
            while (i2 >= 0 && value.charAt(i2) != dec) {
                --i2;
                ++decAt;
            }
            if (decAt < value.length()) {
                to_fmt.setMinimumFractionDigits(decAt);
            }
            decAt = 0;
            i = 0;
            while (i < value.length() && value.charAt(i) != dec) {
                if (Character.isDigit(value.charAt(i))) {
                    ++decAt;
                }
                ++i;
            }
            to_fmt.setMinimumIntegerDigits(decAt);
            if (value.charAt(value.length() - 1) == dec) {
                appendDec = true;
            }
        } else if (type.equals("currency")) {
            to_fmt = (DecimalFormat)NumberFormat.getCurrencyInstance(loc);
        } else if (type.equals(I18N_INT_CURRENCY_ELEMENT)) {
            to_fmt = (DecimalFormat)NumberFormat.getCurrencyInstance(loc);
            int_currency = 1;
            int i3 = 0;
            while (i3 < to_fmt.getMaximumFractionDigits()) {
                int_currency *= 10;
                ++i3;
            }
        } else if (type.equals(I18N_CURRENCY_NO_UNIT_ELEMENT)) {
            DecimalFormat tmp = (DecimalFormat)NumberFormat.getCurrencyInstance(loc);
            to_fmt = (DecimalFormat)NumberFormat.getInstance(loc);
            to_fmt.setMinimumFractionDigits(tmp.getMinimumFractionDigits());
            to_fmt.setMaximumFractionDigits(tmp.getMaximumFractionDigits());
        } else if (type.equals(I18N_INT_CURRENCY_NO_UNIT_ELEMENT)) {
            DecimalFormat tmp = (DecimalFormat)NumberFormat.getCurrencyInstance(loc);
            int_currency = 1;
            i = 0;
            while (i < tmp.getMaximumFractionDigits()) {
                int_currency *= 10;
                ++i;
            }
            to_fmt = (DecimalFormat)NumberFormat.getInstance(loc);
            to_fmt.setMinimumFractionDigits(tmp.getMinimumFractionDigits());
            to_fmt.setMaximumFractionDigits(tmp.getMaximumFractionDigits());
        } else if (type.equals(I18N_PERCENT_ELEMENT)) {
            to_fmt = (DecimalFormat)NumberFormat.getPercentInstance(loc);
        } else {
            throw new SAXException("&lt;i18n:number>: unknown type: " + type);
        }
        if (fractionDigits > -1) {
            to_fmt.setMinimumFractionDigits(fractionDigits);
            to_fmt.setMaximumFractionDigits(fractionDigits);
        }
        if (dgLoc != null) {
            DecimalFormat df = (DecimalFormat)NumberFormat.getCurrencyInstance(dgLoc);
            DecimalFormatSymbols dfsNew = df.getDecimalFormatSymbols();
            DecimalFormatSymbols dfsOrig = to_fmt.getDecimalFormatSymbols();
            dfsOrig.setDecimalSeparator(dfsNew.getDecimalSeparator());
            dfsOrig.setMonetaryDecimalSeparator(dfsNew.getMonetaryDecimalSeparator());
            dfsOrig.setGroupingSeparator(dfsNew.getGroupingSeparator());
            to_fmt.setDecimalFormatSymbols(dfsOrig);
        }
        if (pattern != null) {
            to_fmt.applyPattern(pattern);
        }
        if (value == null) {
            numberValue = new Long(0L);
        } else {
            try {
                numberValue = from_fmt.parse(value);
                if (int_currency > 0) {
                    numberValue = new Double(numberValue.doubleValue() / (double)int_currency);
                }
            }
            catch (ParseException pe) {
                throw new SAXException(this.getClass().getName() + "i18n:number - parsing error.", pe);
            }
        }
        String result = to_fmt.format(numberValue);
        if (appendDec) {
            result = result + dec;
        }
        this.debug("i18n:number result: " + result);
        return result;
    }

    private String getString(String key, String catalogueId, String defaultValue) {
        try {
            Node res;
            String value;
            Bundle catalogue = this.defaultCatalogue;
            if (catalogueId != null) {
                CatalogueInfo catalogueInfo = (CatalogueInfo)this.catalogues.get(catalogueId);
                if (catalogueInfo == null) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.debug("Catalogue not found: " + catalogueId + ", could not translate key " + key);
                    }
                    return defaultValue;
                }
                try {
                    catalogue = catalogueInfo.getCatalogue();
                }
                catch (Exception e) {
                    this.getLogger().error("Error getting catalogue " + catalogueInfo.getName() + " from location " + catalogueInfo.getLocation() + " for locale " + this.locale + ", will not translate key " + key);
                    return defaultValue;
                }
            }
            return (value = I18nTransformer.getTextValue(res = (Node)catalogue.getObject("/catalogue/message[@key='" + key + "']"))) != null ? value : defaultValue;
        }
        catch (MissingResourceException e) {
            return defaultValue;
        }
    }

    private static String getTextValue(Node node) {
        if (node == null) {
            return null;
        }
        NodeList list = node.getChildNodes();
        int listsize = list.getLength();
        Node item = null;
        StringBuffer itemValue = new StringBuffer();
        int i = 0;
        while (i < listsize) {
            item = list.item(i);
            if (item.getNodeType() == 3 || item.getNodeType() == 4) {
                itemValue.append(item.getNodeValue());
            }
            ++i;
        }
        return itemValue.toString();
    }

    private MirrorRecorder getMirrorRecorder(String key, MirrorRecorder defaultValue) {
        try {
            MirrorRecorder value;
            Bundle catalogue = this.defaultCatalogue;
            if (this.currentCatalogueId != null) {
                CatalogueInfo catalogueInfo = (CatalogueInfo)this.catalogues.get(this.currentCatalogueId);
                if (catalogueInfo == null) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.debug("Catalogue not found: " + this.currentCatalogueId + ", could not translate key " + key);
                    }
                    return defaultValue;
                }
                try {
                    catalogue = catalogueInfo.getCatalogue();
                }
                catch (Exception e) {
                    this.getLogger().error("Error getting catalogue " + catalogueInfo.getName() + " from location " + catalogueInfo.getLocation() + " for locale " + this.locale + ", will not translate key " + key);
                    return defaultValue;
                }
            }
            if ((value = new MirrorRecorder((Node)catalogue.getObject("/catalogue/message[@key='" + key + "']"))) == null) {
                return defaultValue;
            }
            return value;
        }
        catch (MissingResourceException e) {
            this.debug("Untranslated key: '" + key + "'");
            return defaultValue;
        }
    }

    private void debug(String msg) {
        this.getLogger().debug("I18nTransformer: " + msg);
    }

    public void recycle() {
        if (this.globalUntranslated != null) {
            this.untranslated = this.globalUntranslated;
        }
        this.untranslatedRecorder = null;
        this.factory.release(this.defaultCatalogue);
        this.defaultCatalogue = null;
        Iterator catalogueIt = this.catalogues.values().iterator();
        while (catalogueIt.hasNext()) {
            CatalogueInfo catalogueInfo = (CatalogueInfo)catalogueIt.next();
            catalogueInfo.releaseCatalog();
        }
        this.sourceResolver = null;
        this.objectModel = null;
        super.recycle();
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Component)this.factory);
        }
        this.factory = null;
    }

    static {
        HashSet<String> set = new HashSet<String>();
        set.add(I18N_DATE_ELEMENT);
        set.add(I18N_TIME_ELEMENT);
        set.add(I18N_DATE_TIME_ELEMENT);
        dateTypes = Collections.unmodifiableSet(set);
        set = new HashSet();
        set.add(I18N_NUMBER_ELEMENT);
        set.add(I18N_PERCENT_ELEMENT);
        set.add("currency");
        set.add(I18N_INT_CURRENCY_ELEMENT);
        set.add(I18N_CURRENCY_NO_UNIT_ELEMENT);
        set.add(I18N_INT_CURRENCY_NO_UNIT_ELEMENT);
        numberTypes = Collections.unmodifiableSet(set);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("SHORT", new Integer(3));
        map.put("MEDIUM", new Integer(2));
        map.put("LONG", new Integer(1));
        map.put("FULL", new Integer(0));
        datePatterns = Collections.unmodifiableMap(map);
    }

    private final class CatalogueInfo {
        PreparedVariableResolver name;
        PreparedVariableResolver location;
        String resolvedName;
        String resolvedLocation;
        Bundle catalogue;

        public CatalogueInfo(String name, String location) throws PatternException {
            this.name = new PreparedVariableResolver(name, I18nTransformer.this.manager);
            this.location = new PreparedVariableResolver(location, I18nTransformer.this.manager);
        }

        public String getName() {
            return this.resolvedName;
        }

        public String getLocation() {
            return this.resolvedLocation;
        }

        private void resolve() throws PatternException {
            if (this.resolvedLocation == null) {
                this.resolvedLocation = this.location.resolve(null, I18nTransformer.this.objectModel);
            }
            if (this.resolvedName == null) {
                this.resolvedName = this.name.resolve(null, I18nTransformer.this.objectModel);
            }
        }

        public Bundle getCatalogue() throws Exception {
            if (this.catalogue == null) {
                this.resolve();
                BundleFactory bundleFactory = I18nTransformer.this.factory;
                synchronized (bundleFactory) {
                    I18nTransformer.this.configureFactory(this.resolvedLocation);
                    this.catalogue = (Bundle)I18nTransformer.this.factory.select(this.resolvedName, I18nTransformer.this.locale);
                }
            }
            return this.catalogue;
        }

        public void releaseCatalog() {
            if (this.catalogue != null) {
                I18nTransformer.this.factory.release(this.catalogue);
            }
            this.catalogue = null;
            this.resolvedName = null;
            this.resolvedLocation = null;
        }
    }
}

