/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class LogTransformer
extends AbstractTransformer {
    private static String lf = System.getProperty("line.separator", "\n");
    private FileWriter logfile;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        boolean append = parameters.getParameterAsBoolean("append", false);
        String logfilename = parameters.getParameter("logfile", null);
        this.logfile = null;
        if (null != logfilename) {
            Source source = null;
            try {
                try {
                    source = resolver.resolveURI(logfilename);
                    String systemId = source.getURI();
                    if (!systemId.startsWith("file:")) {
                        throw new ProcessingException("The logfile parameter must point to a file: " + logfilename);
                    }
                    this.logfile = new FileWriter(systemId.substring(5), append);
                    Object var10_10 = null;
                }
                catch (SourceException se) {
                    throw SourceUtil.handle(se);
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                resolver.release(source);
                throw throwable;
            }
            resolver.release(source);
        }
        Date date = new Date();
        StringBuffer logEntry = new StringBuffer();
        logEntry.append("---------------------------- [");
        logEntry.append(date.toString());
        logEntry.append("] ----------------------------");
        this.log("setup", logEntry.toString());
    }

    public void recycle() {
        super.recycle();
        try {
            if (this.logfile != null) {
                this.logfile.close();
            }
        }
        catch (Exception e) {
            this.getLogger().warn("LogTransformer.recycle()", (Throwable)e);
        }
        this.logfile = null;
    }

    public void setDocumentLocator(Locator locator) {
        this.log("setDocumentLocator", locator != null ? "systemid=" + locator.getSystemId() + ",publicid=" + locator.getPublicId() : "(locator is null)");
        if (this.contentHandler != null) {
            this.contentHandler.setDocumentLocator(locator);
        }
    }

    public void startDocument() throws SAXException {
        this.log("startDocument", "");
        if (this.contentHandler != null) {
            this.contentHandler.startDocument();
        }
    }

    public void endDocument() throws SAXException {
        this.log("endDocument", "");
        if (this.contentHandler != null) {
            this.contentHandler.endDocument();
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.log("startPrefixMapping", "prefix=" + prefix + ",uri=" + uri);
        if (this.contentHandler != null) {
            this.contentHandler.startPrefixMapping(prefix, uri);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.log("endPrefixMapping", "prefix=" + prefix);
        if (this.contentHandler != null) {
            this.contentHandler.endPrefixMapping(prefix);
        }
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        this.log("startElement", "uri=" + uri + ",local=" + loc + ",raw=" + raw);
        int i = 0;
        while (i < a.getLength()) {
            this.log("            ", new Integer(i + 1).toString() + ". uri=" + a.getURI(i) + ",local=" + a.getLocalName(i) + ",qname=" + a.getQName(i) + ",type=" + a.getType(i) + ",value=" + a.getValue(i));
            ++i;
        }
        if (this.contentHandler != null) {
            this.contentHandler.startElement(uri, loc, raw, a);
        }
    }

    public void endElement(String uri, String loc, String qname) throws SAXException {
        this.log("endElement", "uri=" + uri + ",local=" + loc + ",qname=" + qname);
        if (this.contentHandler != null) {
            this.contentHandler.endElement(uri, loc, qname);
        }
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        this.log("characters", new String(ch, start, len));
        if (this.contentHandler != null) {
            this.contentHandler.characters(ch, start, len);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int len) throws SAXException {
        this.log("ignorableWhitespace", new String(ch, start, len));
        if (this.contentHandler != null) {
            this.contentHandler.ignorableWhitespace(ch, start, len);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.log("processingInstruction", "target=" + target + ",data=" + data);
        if (this.contentHandler != null) {
            this.contentHandler.processingInstruction(target, data);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        this.log("skippedEntity", "name=" + name);
        if (this.contentHandler != null) {
            this.contentHandler.skippedEntity(name);
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.log("startDTD", "name=" + name + ",publicId=" + publicId + ",systemId=" + systemId);
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startDTD(name, publicId, systemId);
        }
    }

    public void endDTD() throws SAXException {
        this.log("endDTD", "");
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endDTD();
        }
    }

    public void startEntity(String name) throws SAXException {
        this.log("startEntity", "name=" + name);
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startEntity(name);
        }
    }

    public void endEntity(String name) throws SAXException {
        this.log("endEntity", "name=" + name);
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endEntity(name);
        }
    }

    public void startCDATA() throws SAXException {
        this.log("startCDATA", "");
        if (this.lexicalHandler != null) {
            this.lexicalHandler.startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        this.log("endCDATA", "");
        if (this.lexicalHandler != null) {
            this.lexicalHandler.endCDATA();
        }
    }

    public void comment(char[] ch, int start, int len) throws SAXException {
        this.log("comment", new String(ch, start, len));
        if (this.lexicalHandler != null) {
            this.lexicalHandler.comment(ch, start, len);
        }
    }

    private void log(String location, String description) {
        StringBuffer logEntry = new StringBuffer();
        logEntry.append("[");
        logEntry.append(location);
        logEntry.append("] ");
        logEntry.append(description);
        logEntry.append(lf);
        String text = logEntry.toString();
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info(text);
        }
        try {
            if (null != this.logfile) {
                this.logfile.write(text, 0, text.length());
                this.logfile.flush();
            } else {
                System.out.println(text);
            }
        }
        catch (IOException ioe) {
            this.getLogger().debug("LogTransformer.log", (Throwable)ioe);
        }
    }

    public void destroy() {
        try {
            if (this.logfile != null) {
                this.logfile.close();
            }
        }
        catch (Exception e) {
            this.getLogger().debug("LogTransformer.destroy()", (Throwable)e);
        }
    }
}

