/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.xml;

import java.util.Vector;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.cocoon.xml.AbstractXMLConsumer;
import org.apache.cocoon.xml.NamespacesTable;
import org.xml.sax.Attributes;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class DocumentHandlerWrapper
extends AbstractXMLConsumer
implements LogEnabled {
    protected Logger log;
    private NamespacesTable namespaces = new NamespacesTable();
    private Vector undecl = new Vector();
    protected DocumentHandler documentHandler = null;

    public DocumentHandlerWrapper() {
    }

    public DocumentHandlerWrapper(DocumentHandler document) {
        this();
        this.setDocumentHandler(document);
    }

    public void enableLogging(Logger logger) {
        if (this.log == null) {
            this.log = logger;
        }
    }

    public void recycle() {
        this.documentHandler = null;
    }

    public void setDocumentHandler(DocumentHandler document) throws IllegalStateException {
        if (this.documentHandler != null) {
            throw new IllegalStateException();
        }
        this.documentHandler = document;
    }

    public void setDocumentLocator(Locator locator) {
        if (this.documentHandler == null) {
            return;
        }
        this.documentHandler.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        if (this.documentHandler == null) {
            throw new SAXException("DocumentHandler not set");
        }
        this.documentHandler.startDocument();
    }

    public void endDocument() throws SAXException {
        if (this.documentHandler == null) {
            throw new SAXException("DocumentHandler not set");
        }
        this.documentHandler.endDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.undecl.addElement(this.namespaces.addDeclaration(prefix, uri));
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (this.namespaces.removeDeclaration(prefix) == null) {
            throw new SAXException("Namespace prefix \"" + prefix + "\" never declared");
        }
    }

    public void startElement(String uri, String loc, String raw, Attributes a) throws SAXException {
        int x;
        if (this.documentHandler == null) {
            throw new SAXException("DocumentHandler not set");
        }
        NamespacesTable.Name name = this.namespaces.resolve(uri, raw, null, loc);
        AttributeListImpl a2 = new AttributeListImpl();
        if (this.undecl.size() > 0) {
            x = 0;
            while (x < this.undecl.size()) {
                NamespacesTable.Declaration dec = null;
                dec = (NamespacesTable.Declaration)this.undecl.elementAt(x);
                String aname = "xmlns";
                if (dec.getPrefix().length() > 0) {
                    aname = "xmlns:" + dec.getPrefix();
                }
                a2.addAttribute(aname, "CDATA", dec.getUri());
                ++x;
            }
            this.undecl.clear();
        }
        x = 0;
        while (x < a.getLength()) {
            NamespacesTable.Name aname = this.namespaces.resolve(a.getURI(x), a.getQName(x), null, a.getLocalName(x));
            a2.addAttribute(aname.getQName(), a.getType(x), a.getValue(x));
            ++x;
        }
        this.documentHandler.startElement(name.getQName(), a2);
    }

    public void endElement(String uri, String loc, String raw) throws SAXException {
        if (this.documentHandler == null) {
            throw new SAXException("DocumentHandler not set");
        }
        NamespacesTable.Name name = this.namespaces.resolve(uri, raw, null, loc);
        this.documentHandler.endElement(name.getQName());
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        if (this.documentHandler == null) {
            throw new SAXException("DocumentHandler not set");
        }
        this.documentHandler.characters(ch, start, len);
    }

    public void ignorableWhitespace(char[] ch, int start, int len) throws SAXException {
        if (this.documentHandler == null) {
            throw new SAXException("DocumentHandler not set");
        }
        this.documentHandler.ignorableWhitespace(ch, start, len);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this.documentHandler == null) {
            throw new SAXException("DocumentHandler not set");
        }
        this.documentHandler.processingInstruction(target, data);
    }
}

