/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import java.util.Vector;
import org.mortbay.util.CodeException;
import org.mortbay.util.Frame;
import org.mortbay.util.Log;
import org.mortbay.util.MultiException;
import org.mortbay.util.StringBufferWriter;

public class Code {
    private static final String __lock = "LOCK";
    private static final Class[] __noArgs;
    private static final String[] __nestedEx;
    private static StringBufferWriter __stringBufferWriter;
    private static PrintWriter __printWriter;
    boolean _debugOn = false;
    private boolean _suppressStack = true;
    private boolean _suppressWarnings = false;
    private int _verbose = 0;
    Vector _debugPatterns = null;
    private String _patterns = null;

    public static Code instance() {
        return Singleton.__instance;
    }

    protected Code() {
        Singleton.__instance = this;
        try {
            this._debugOn = System.getProperty("DEBUG") != null;
            String o = System.getProperty("DEBUG_OPTIONS");
            if (o != null) {
                Code.setSuppressStack(o.indexOf(83) < 0);
                Code.setSuppressWarnings(o.indexOf(87) < 0);
            } else {
                Code.setSuppressStack(false);
                Code.setSuppressWarnings(false);
            }
            String dp = System.getProperty("DEBUG_PATTERNS");
            Code.setDebugPatterns(dp);
            String v = System.getProperty("DEBUG_VERBOSE");
            if (v != null) {
                Code.setVerbose(Integer.parseInt(v));
            }
        }
        catch (Exception e) {
            System.err.println("Exception from getProperty!\nProbably running in applet\nUse Code.initParamsFromApplet or Code.setOption to control debug output.");
        }
    }

    public static synchronized void setDebug(boolean debug) {
        Code code = Code.instance();
        boolean oldDebug = code._debugOn;
        if (code._debugOn && !debug) {
            Code.debug(2, (Object)"DEBUG OFF");
        }
        code._debugOn = debug;
        if (!oldDebug && debug) {
            Code.debug(2, (Object)"DEBUG ON");
        }
    }

    public static boolean getDebug() {
        return Code.instance()._debugOn;
    }

    public static void setSuppressStack(boolean stack) {
        Code.instance()._suppressStack = stack;
    }

    public static boolean getSuppressStack() {
        return Code.instance()._suppressStack;
    }

    public static void setSuppressWarnings(boolean warnings) {
        Code.instance()._suppressWarnings = warnings;
    }

    public static boolean getSuppressWarnings() {
        return Code.instance()._suppressWarnings;
    }

    public static void setVerbose(int verbose) {
        Code.instance()._verbose = verbose;
    }

    public static int getVerbose() {
        return Code.instance()._verbose;
    }

    public static void setDebugPatterns(String patterns) {
        Code code = Code.instance();
        code._patterns = patterns;
        if (patterns != null && patterns.length() > 0) {
            code._debugPatterns = new Vector();
            StringTokenizer tok = new StringTokenizer(patterns, ", \t");
            while (tok.hasMoreTokens()) {
                String pattern = tok.nextToken();
                code._debugPatterns.addElement(pattern);
            }
        } else {
            code._debugPatterns = null;
        }
    }

    public static String getDebugPatterns() {
        return Code.instance()._patterns;
    }

    public static void assertTrue(boolean b, String m) {
        if (!b) {
            Log.message("ASSERT ", m, new Frame(1));
            throw new CodeException("ASSERT FAIL: " + m);
        }
    }

    public static void assertEquals(Object o1, Object o2, String m) {
        if (o1 != o2 && o1 != null && !o1.equals(o2)) {
            Log.message("ASSERT ", o1 + " != " + o2 + " : " + m, new Frame(1));
            throw new CodeException("ASSERT FAIL: " + m);
        }
    }

    public static void assertEquals(long o1, long o2, String m) {
        if (o1 != o2) {
            Log.message("ASSERT ", o1 + " != " + o2 + " : " + m, new Frame(1));
            throw new CodeException("ASSERT FAIL: " + m);
        }
    }

    public static void assertEquals(double o1, double o2, String m) {
        if (o1 != o2) {
            Log.message("ASSERT ", o1 + " != " + o2 + " : " + m, new Frame(1));
            throw new CodeException("ASSERT FAIL: " + m);
        }
    }

    public static void assertEquals(char o1, char o2, String m) {
        if (o1 != o2) {
            Log.message("ASSERT ", o1 + " != " + o2 + " : " + m, new Frame(1));
            throw new CodeException("ASSERT FAIL: " + m);
        }
    }

    public static void assertContains(String string, String sub, String m) {
        if (sub != null && (string == null || string.indexOf(sub) == -1)) {
            Log.message("ASSERT ", '\"' + string + "\" does not contain \"" + sub + "\" : " + m, new Frame(1));
            throw new CodeException("ASSERT FAIL: " + m);
        }
    }

    public static void warning(String m) {
        Code code = Code.instance();
        Frame frame = new Frame(1);
        if (!code._suppressWarnings || code.isDebugOnFor(frame)) {
            Log.message("WARN!! ", m, frame);
        }
    }

    public static void warning(String m, Throwable ex) {
        Code code = Code.instance();
        Frame frame = new Frame(1);
        if (!code._suppressWarnings || code.isDebugOnFor(frame)) {
            Log.message("WARN!! ", new LogMsg(new Object[]{m, ex}), frame);
        }
    }

    public static void warning(Throwable ex) {
        Code code = Code.instance();
        Frame frame = new Frame(1);
        if (!code._suppressWarnings || code.isDebugOnFor(frame)) {
            Log.message("WARN!! ", new LogMsg(ex), frame);
        }
    }

    public static void fail(String m) {
        Log.message("FAIL!! ", m, new Frame(1));
        throw new CodeException("FAIL: " + m);
    }

    public static void fail(String m, Throwable ex) {
        Code code = Code.instance();
        Log.message("FAIL!! ", new LogMsg(new Object[]{m, ex}), new Frame(1));
        throw new CodeException("FAIL: " + m + ex.toString());
    }

    public static void fail(Throwable ex) {
        Code code = Code.instance();
        Log.message("FAIL!! ", new LogMsg(ex), new Frame(1));
        throw new CodeException("FAIL: " + ex.toString());
    }

    public static void notImplemented() {
        Log.message("FAIL!! ", "Not Implemented", new Frame(1));
        throw new CodeException("Not Implemented");
    }

    public static boolean verbose() {
        return Code.instance()._verbose > 0;
    }

    public static boolean verbose(int v) {
        return Code.instance()._verbose >= v;
    }

    public static boolean debug() {
        Code code = Code.instance();
        if (code._debugOn) {
            Frame frame = new Frame(1, true);
            return code.isDebugOnFor(frame);
        }
        return false;
    }

    public static void debug(String m) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(1, true))) {
            frame.complete();
            Log.message("DEBUG  ", m, frame);
        }
    }

    public static void debug(String m, Throwable ex) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(1, true))) {
            frame.complete();
            Log.message("DEBUG  ", new LogMsg(new Object[]{m, ex}), frame);
        }
    }

    public static void debug(Throwable ex) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(1, true))) {
            frame.complete();
            Log.message("DEBUG  ", new LogMsg(ex), frame);
        }
    }

    public static void debug(int depth, Object o) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(depth, true))) {
            frame.complete();
            Log.message("DEBUG  ", new LogMsg(o), frame);
        }
    }

    public static void debug(Object o) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(1, true))) {
            frame.complete();
            Log.message("DEBUG  ", new LogMsg(o), frame);
        }
    }

    public static void debug(Object o1, Object o2) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(1, true))) {
            frame.complete();
            Log.message("DEBUG  ", new LogMsg(new Object[]{o1, o2}), frame);
        }
    }

    public static void debug(Object o1, long i) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(1, true))) {
            frame.complete();
            Log.message("DEBUG  ", new LogMsg(new Object[]{o1, new Long(i)}), frame);
        }
    }

    public static void debug(Object o1, Object o2, Object o3) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(1, true))) {
            frame.complete();
            Log.message("DEBUG  ", new LogMsg(new Object[]{o1, o2, o3}), frame);
        }
    }

    public static void debug(Object o1, Object o2, Object o3, Object o4) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(1, true))) {
            frame.complete();
            Log.message("DEBUG  ", new LogMsg(new Object[]{o1, o2, o3, o4}), frame);
        }
    }

    public static void debug(Object o1, long l1, Object o2, long l2) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(1, true))) {
            frame.complete();
            Log.message("DEBUG  ", new LogMsg(new Object[]{o1, new Long(l1), o2, new Long(l2)}), frame);
        }
    }

    public static void debug(Object o1, Object o2, Object o3, Object o4, Object o5) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(1, true))) {
            frame.complete();
            Log.message("DEBUG  ", new LogMsg(new Object[]{o1, o2, o3, o4, o5}), frame);
        }
    }

    public static void debug(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(1, true))) {
            frame.complete();
            Log.message("DEBUG  ", new LogMsg(new Object[]{o1, o2, o3, o4, o5, o6}), frame);
        }
    }

    public static void debug(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(1, true))) {
            frame.complete();
            Log.message("DEBUG  ", new LogMsg(new Object[]{o1, o2, o3, o4, o5, o6, o7}), frame);
        }
    }

    public static void debug(Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code.isDebugOnFor(frame = new Frame(1, true))) {
            frame.complete();
            Log.message("DEBUG  ", new LogMsg(new Object[]{o1, o2, o3, o4, o5, o6, o7, o8}), frame);
        }
    }

    public static void ignore(Throwable ex) {
        Frame frame;
        Code code = Code.instance();
        if (code._debugOn && code._verbose > 0 && code.isDebugOnFor(frame = new Frame(1, true))) {
            frame.complete();
            if (code._verbose > 1) {
                Log.message("DEBUG  ", new LogMsg(new Object[]{"IGNORED ", ex}), frame);
            } else {
                Log.message("DEBUG  ", new LogMsg(new Object[]{"IGNORED ", ex.toString()}), frame);
            }
        }
    }

    private boolean isDebugOnFor(Frame frame) {
        if (this._debugOn) {
            if (this._debugPatterns == null) {
                return true;
            }
            int i = this._debugPatterns.size();
            while (--i >= 0) {
                if (frame.getWhere().indexOf((String)this._debugPatterns.elementAt(i)) < 0) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void formatObject(StringBuffer buf, Object o) {
        if (o == null) {
            buf.append("null");
        } else if (o instanceof Throwable) {
            Throwable ex = (Throwable)o;
            buf.append('\n');
            if (Code.instance()._suppressStack) {
                buf.append(ex.toString());
                buf.append("\nNo stack available\n--");
            } else {
                PrintWriter printWriter = __printWriter;
                synchronized (printWriter) {
                    __stringBufferWriter.setStringBuffer(buf);
                    Code.expandThrowable(ex);
                    __printWriter.flush();
                }
            }
        } else {
            buf.append(o.toString());
        }
    }

    private static synchronized void expandThrowable(Throwable ex) {
        ex.printStackTrace(__printWriter);
        if (ex instanceof MultiException) {
            MultiException mx = (MultiException)ex;
            int i = 0;
            while (i < mx.size()) {
                __printWriter.print("[" + i + "]=");
                Exception ex2 = mx.getException(i);
                Code.expandThrowable(ex2);
                ++i;
            }
        } else {
            int i = 0;
            while (i < __nestedEx.length) {
                try {
                    Method getTargetException = ex.getClass().getMethod(__nestedEx[i], __noArgs);
                    Throwable ex2 = (Throwable)getTargetException.invoke((Object)ex, null);
                    if (ex2 != null) {
                        __printWriter.println(__nestedEx[i] + "():");
                        Code.expandThrowable(ex2);
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    static {
        try {
            new Frame(0);
        }
        catch (Error e) {
            e.printStackTrace();
            System.err.println("\nERROR: Jetty compiled for java 1.4 and cannot be run on this JVM");
            System.err.println("       Please use the org.mortbay.jetty-jdk1.2.jar instead\n");
            System.exit(1);
        }
        __noArgs = new Class[0];
        __nestedEx = new String[]{"getTargetException", "getTargetError", "getException", "getRootCause"};
        __stringBufferWriter = new StringBufferWriter();
        __printWriter = new PrintWriter(__stringBufferWriter);
    }

    public static final class LogMsg {
        private Object _item;
        private Object[] _items;

        private LogMsg(Object item) {
            this._item = item;
        }

        private LogMsg(Object[] items) {
            this._items = items;
        }

        public int size() {
            if (this._items == null) {
                return 1;
            }
            return this._items.length;
        }

        public Object item(int i) {
            if (this._items == null && i == 0) {
                return this._item;
            }
            return this._items[i];
        }

        public Throwable getThrowable() {
            int i = 0;
            while (i < this.size()) {
                if (this.item(i) instanceof Throwable) {
                    return (Throwable)this.item(i);
                }
                ++i;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuffer buf;
            StringBuffer stringBuffer = buf = new StringBuffer(256);
            synchronized (stringBuffer) {
                int i = 0;
                while (i < this.size()) {
                    Code.formatObject(buf, this.item(i));
                    ++i;
                }
                return buf.toString();
            }
        }
    }

    private static class Singleton {
        static Code __instance = new Code();

        private Singleton() {
        }
    }
}

