/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import org.mortbay.util.Code;
import org.mortbay.util.LazyList;
import org.mortbay.util.MultiMap;
import org.mortbay.util.StringUtil;
import org.mortbay.util.TypeUtil;

public class UrlEncoded
extends MultiMap {
    public UrlEncoded(UrlEncoded url) {
        super((Map)url);
    }

    public UrlEncoded() {
        super(6);
    }

    public UrlEncoded(String s) {
        super(6);
        this.decode(s, StringUtil.__ISO_8859_1);
    }

    public UrlEncoded(String s, String charset) {
        super(6);
        this.decode(s, charset);
    }

    public void decode(String query) {
        UrlEncoded.decodeTo(query, (MultiMap)this, StringUtil.__ISO_8859_1);
    }

    public void decode(String query, String charset) {
        UrlEncoded.decodeTo(query, (MultiMap)this, charset);
    }

    public String encode() {
        return this.encode(StringUtil.__ISO_8859_1, false);
    }

    public String encode(String charset) {
        return this.encode(charset, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String encode(String charset, boolean equalsForNullValue) {
        StringBuffer result;
        if (charset == null) {
            charset = StringUtil.__ISO_8859_1;
        }
        StringBuffer stringBuffer = result = new StringBuffer(128);
        synchronized (stringBuffer) {
            Iterator iter = this.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = entry.getKey().toString();
                LazyList list = (LazyList)entry.getValue();
                int s = LazyList.size(list);
                if (s == 0) {
                    result.append(URLEncoder.encode(key));
                    if (equalsForNullValue) {
                        result.append('=');
                    }
                } else {
                    int i = 0;
                    while (i < s) {
                        if (i > 0) {
                            result.append('&');
                        }
                        Object val = list.get(i);
                        result.append(UrlEncoded.encodeString(key, charset));
                        if (val != null) {
                            String str = val.toString();
                            if (str.length() > 0) {
                                result.append('=');
                                result.append(UrlEncoded.encodeString(str, charset));
                            } else if (equalsForNullValue) {
                                result.append('=');
                            }
                        } else if (equalsForNullValue) {
                            result.append('=');
                        }
                        ++i;
                    }
                }
                if (!iter.hasNext()) continue;
                result.append('&');
            }
            return result.toString();
        }
    }

    public static void decodeTo(String content, MultiMap map) {
        UrlEncoded.decodeTo(content, map, StringUtil.__ISO_8859_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(String content, MultiMap map, String charset) {
        if (charset == null) {
            charset = StringUtil.__ISO_8859_1;
        }
        MultiMap multiMap = map;
        synchronized (multiMap) {
            String key = null;
            String value = null;
            int mark = -1;
            boolean encoded = false;
            int i = 0;
            while (i < content.length()) {
                char c = content.charAt(i);
                switch (c) {
                    case '&': {
                        value = encoded ? UrlEncoded.decodeString(content, mark + 1, i - mark - 1, charset) : content.substring(mark + 1, i);
                        mark = i;
                        encoded = false;
                        if (key == null) break;
                        map.add(key, value);
                        key = null;
                        break;
                    }
                    case '=': {
                        if (key != null) break;
                        key = encoded ? UrlEncoded.decodeString(content, mark + 1, i - mark - 1, charset) : content.substring(mark + 1, i);
                        mark = i;
                        encoded = false;
                        break;
                    }
                    case '+': {
                        encoded = true;
                        break;
                    }
                    case '%': {
                        encoded = true;
                    }
                }
                ++i;
            }
            if (key != null) {
                value = encoded ? UrlEncoded.decodeString(content, mark + 1, content.length() - mark - 1, charset) : content.substring(mark + 1);
                map.add(key, value);
            } else if (mark < content.length()) {
                key = encoded ? UrlEncoded.decodeString(content, mark + 1, content.length() - mark - 1, charset) : content.substring(mark + 1);
                map.add(key, "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeTo(byte[] data, MultiMap map, String charset) {
        if (data == null || data.length == 0) {
            return;
        }
        if (charset == null) {
            charset = StringUtil.__ISO_8859_1;
        }
        MultiMap multiMap = map;
        synchronized (multiMap) {
            try {
                boolean pos = false;
                int ix = 0;
                int ox = 0;
                String key = null;
                String value = null;
                block11: while (ix < data.length) {
                    byte c = data[ix++];
                    switch ((char)c) {
                        case '&': {
                            value = new String(data, 0, ox, charset);
                            if (key != null) {
                                map.add(key, value);
                                key = null;
                            }
                            ox = 0;
                            break;
                        }
                        case '=': {
                            if (key != null) continue block11;
                            key = new String(data, 0, ox, charset);
                            ox = 0;
                            break;
                        }
                        case '+': {
                            data[ox++] = 32;
                            break;
                        }
                        case '%': {
                            data[ox++] = (byte)((TypeUtil.convertHexDigit(data[ix++]) << 4) + TypeUtil.convertHexDigit(data[ix++]));
                            break;
                        }
                        default: {
                            data[ox++] = c;
                        }
                    }
                }
                if (key != null) {
                    value = new String(data, 0, ox, charset);
                    map.add(key, value);
                }
            }
            catch (UnsupportedEncodingException e) {
                Code.warning(e);
            }
        }
    }

    public static String decodeString(String encoded) {
        return UrlEncoded.decodeString(encoded, 0, encoded.length(), StringUtil.__ISO_8859_1);
    }

    public static String decodeString(String encoded, String charset) {
        return UrlEncoded.decodeString(encoded, 0, encoded.length(), charset);
    }

    public static String decodeString(String encoded, int offset, int length, String charset) {
        StringBuffer buf;
        block23: {
            if (charset == null) {
                charset = StringUtil.__ISO_8859_1;
            }
            byte[] bytes = null;
            int n = 0;
            buf = null;
            int i = 0;
            while (i < length) {
                char c = encoded.charAt(offset + i);
                if (c < '\u0000' || c > '\u00ff') {
                    throw new IllegalArgumentException("Not decoded");
                }
                if (c == '+') {
                    if (buf == null) {
                        buf = new StringBuffer(length);
                        int j = 0;
                        while (j < i) {
                            buf.append(encoded.charAt(offset + j));
                            ++j;
                        }
                    }
                    if (n > 0) {
                        try {
                            buf.append(new String(bytes, 0, n, charset));
                        }
                        catch (UnsupportedEncodingException e) {
                            buf.append(new String(bytes, 0, n));
                        }
                        n = 0;
                    }
                    buf.append(' ');
                } else if (c == '%' && i + 2 < length) {
                    char cn = encoded.charAt(offset + i + 1);
                    byte b = cn >= 'a' && cn <= 'z' ? (byte)(10 + cn - 97) : (cn >= 'A' && cn <= 'Z' ? (byte)(10 + cn - 65) : (byte)(cn - 48));
                    cn = encoded.charAt(offset + i + 2);
                    b = cn >= 'a' && cn <= 'z' ? (byte)(b * 16 + 10 + cn - 97) : (cn >= 'A' && cn <= 'Z' ? (byte)(b * 16 + 10 + cn - 65) : (byte)(b * 16 + cn - 48));
                    if (buf == null) {
                        buf = new StringBuffer(length);
                        int j = 0;
                        while (j < i) {
                            buf.append(encoded.charAt(offset + j));
                            ++j;
                        }
                    }
                    i += 2;
                    if (bytes == null) {
                        bytes = new byte[length];
                    }
                    bytes[n++] = b;
                } else if (buf != null) {
                    if (n > 0) {
                        try {
                            buf.append(new String(bytes, 0, n, charset));
                        }
                        catch (UnsupportedEncodingException e) {
                            buf.append(new String(bytes, 0, n));
                        }
                        n = 0;
                    }
                    buf.append(c);
                }
                ++i;
            }
            if (buf == null) {
                if (offset == 0 && encoded.length() == length) {
                    return encoded;
                }
                return encoded.substring(offset, offset + length);
            }
            if (n <= 0) break block23;
            try {
                buf.append(new String(bytes, 0, n, charset));
            }
            catch (UnsupportedEncodingException e) {
                buf.append(new String(bytes, 0, n));
            }
        }
        return buf.toString();
    }

    public static String encodeString(String string) {
        return UrlEncoded.encodeString(string, StringUtil.__ISO_8859_1);
    }

    public static String encodeString(String string, String charset) {
        if (charset == null) {
            charset = StringUtil.__ISO_8859_1;
        }
        byte[] bytes = null;
        try {
            bytes = string.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            Code.warning(e);
            bytes = string.getBytes();
        }
        int len = bytes.length;
        byte[] encoded = new byte[bytes.length * 3];
        int n = 0;
        boolean noEncode = true;
        int i = 0;
        while (i < len) {
            byte b = bytes[i];
            if (b == 32) {
                noEncode = false;
                encoded[n++] = 43;
            } else if (b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57) {
                encoded[n++] = b;
            } else {
                noEncode = false;
                encoded[n++] = 37;
                byte nibble = (byte)((b & 0xF0) >> 4);
                encoded[n++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
                nibble = (byte)(b & 0xF);
                encoded[n++] = nibble >= 10 ? (byte)(65 + nibble - 10) : (byte)(48 + nibble);
            }
            ++i;
        }
        if (noEncode) {
            return string;
        }
        try {
            return new String(encoded, 0, n, charset);
        }
        catch (UnsupportedEncodingException e) {
            Code.warning(e);
            return new String(encoded, 0, n);
        }
    }

    public Object clone() {
        return new UrlEncoded(this);
    }
}

