/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.monitor.impl;

import org.apache.avalon.excalibur.monitor.impl.AbstractMonitor;

public class ActiveMonitor
extends AbstractMonitor
implements Runnable {
    private static final long DEFAULT_FREQUENCY = 60000L;
    private long m_frequency = 60000L;
    private int m_priority = 1;
    private final Thread m_monitorThread = new Thread(this);
    private volatile boolean m_keepRunning = true;

    public void setFrequency(long frequency) {
        this.m_frequency = frequency;
    }

    public void setPriority(int priority) {
        this.m_priority = priority;
    }

    public void start() throws Exception {
        this.m_keepRunning = true;
        this.m_monitorThread.setDaemon(true);
        this.m_monitorThread.setPriority(this.m_priority);
        this.m_monitorThread.start();
    }

    public void stop() throws Exception {
        this.m_keepRunning = false;
        this.m_monitorThread.interrupt();
        this.m_monitorThread.join();
    }

    public final void run() {
        try {
            while (this.m_keepRunning) {
                Thread.sleep(this.m_frequency);
                this.scanAllResources();
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
    }
}

