/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.xml.xpath;

import java.util.HashMap;
import java.util.List;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.excalibur.xml.xpath.EmptyNodeList;
import org.apache.excalibur.xml.xpath.PrefixResolver;
import org.apache.excalibur.xml.xpath.SimpleNodeList;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.jaxen.NamespaceContext;
import org.jaxen.dom.DOMXPath;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class JaxenProcessorImpl
extends AbstractLogEnabled
implements XPathProcessor,
Configurable,
Component,
ThreadSafe,
PrefixResolver {
    private final HashMap m_mappings = new HashMap();

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration namespaceMappings = configuration.getChild("namespace-mappings", true);
        Configuration[] namespaces = namespaceMappings.getChildren("namespace");
        int i = 0;
        while (i < namespaces.length) {
            String prefix = namespaces[i].getAttribute("prefix");
            String uri = namespaces[i].getAttribute("uri");
            this.m_mappings.put(prefix, uri);
            ++i;
        }
    }

    public Node selectSingleNode(Node contextNode, String str) {
        return this.selectSingleNode(contextNode, str, this);
    }

    public NodeList selectNodeList(Node contextNode, String str) {
        return this.selectNodeList(contextNode, str, this);
    }

    public boolean evaluateAsBoolean(Node contextNode, String str) {
        return this.evaluateAsBoolean(contextNode, str, this);
    }

    public Number evaluateAsNumber(Node contextNode, String str) {
        return this.evaluateAsNumber(contextNode, str, this);
    }

    public String evaluateAsString(Node contextNode, String str) {
        return this.evaluateAsString(contextNode, str, this);
    }

    public boolean evaluateAsBoolean(Node contextNode, String str, PrefixResolver resolver) {
        try {
            DOMXPath path = new DOMXPath(str);
            path.setNamespaceContext((NamespaceContext)new JaxenResolver(resolver));
            return path.booleanValueOf((Object)contextNode);
        }
        catch (Exception e) {
            return false;
        }
    }

    public Number evaluateAsNumber(Node contextNode, String str, PrefixResolver resolver) {
        try {
            DOMXPath path = new DOMXPath(str);
            path.setNamespaceContext((NamespaceContext)new JaxenResolver(resolver));
            return path.numberValueOf((Object)contextNode);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String evaluateAsString(Node contextNode, String str, PrefixResolver resolver) {
        try {
            DOMXPath path = new DOMXPath(str);
            path.setNamespaceContext((NamespaceContext)new JaxenResolver(resolver));
            return path.stringValueOf((Object)contextNode);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Node selectSingleNode(Node contextNode, String str, PrefixResolver resolver) {
        try {
            DOMXPath path = new DOMXPath(str);
            path.setNamespaceContext((NamespaceContext)new JaxenResolver(resolver));
            return (Node)path.selectSingleNode((Object)contextNode);
        }
        catch (Exception e) {
            return null;
        }
    }

    public NodeList selectNodeList(Node contextNode, String str, PrefixResolver resolver) {
        try {
            DOMXPath path = new DOMXPath(str);
            path.setNamespaceContext((NamespaceContext)new JaxenResolver(resolver));
            List list = path.selectNodes((Object)contextNode);
            return new SimpleNodeList(list);
        }
        catch (Exception e) {
            return new EmptyNodeList();
        }
    }

    public String prefixToNamespace(String prefix) {
        return (String)this.m_mappings.get(prefix);
    }

    private static class JaxenResolver
    implements NamespaceContext {
        private final PrefixResolver resolver;

        public JaxenResolver(PrefixResolver resolver) {
            this.resolver = resolver;
        }

        public String translateNamespacePrefixToUri(String prefix) {
            return this.resolver.prefixToNamespace(prefix);
        }
    }
}

