/*
 * Decompiled with CFR 0.152.
 */
package com.coyotegulch.jisp;

import java.io.IOException;
import java.io.InputStream;

class ObjectBytesInputStream
extends InputStream {
    private byte[] m_buffer;
    private int m_index;
    private int m_limit;
    private boolean m_closed;

    public ObjectBytesInputStream(byte[] byArray) throws IOException {
        this(byArray, 0, byArray.length);
    }

    public ObjectBytesInputStream(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n + n2 > byArray.length || n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.m_buffer = byArray;
        this.m_index = n;
        this.m_limit = n + n2;
    }

    public int read() throws IOException {
        int n = -1;
        if (this.m_closed) {
            throw new IOException("Stream closed");
        }
        if (this.m_index < this.m_limit) {
            n = this.m_buffer[this.m_index++] & 0xFF;
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = -1;
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n + n2 > byArray.length || n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.m_closed) {
            throw new IOException("Stream closed");
        }
        if (this.m_index < this.m_limit) {
            if (n2 > this.m_limit - this.m_index) {
                n2 = this.m_limit - this.m_index;
            }
            System.arraycopy(this.m_buffer, this.m_index, byArray, n, n2);
            this.m_index += n2;
            n3 = n2;
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        long l2 = 0L;
        if (this.m_closed) {
            throw new IOException("Stream closed");
        }
        if (l > 0L) {
            if (l > (long)(this.m_limit - this.m_index)) {
                l = this.m_limit - this.m_index;
            }
            this.m_index += (int)l;
            l2 = l;
        }
        return l2;
    }

    public int available() throws IOException {
        if (this.m_closed) {
            throw new IOException("Stream closed");
        }
        return this.m_limit - this.m_index;
    }

    public void close() {
        this.m_closed = true;
    }

    public boolean markSupported() {
        return false;
    }
}

