/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.parse.sax;

import com.thaiopensource.relaxng.XMLReaderCreator;
import com.thaiopensource.relaxng.parse.BuildException;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.IncludedGrammar;
import com.thaiopensource.relaxng.parse.Parseable;
import com.thaiopensource.relaxng.parse.ParsedPattern;
import com.thaiopensource.relaxng.parse.SchemaBuilder;
import com.thaiopensource.relaxng.parse.Scope;
import com.thaiopensource.relaxng.parse.sax.SchemaParser;
import java.io.IOException;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SAXParseable
implements Parseable {
    public static final String URI = "http://relaxng.org/ns/structure/1.0";
    private XMLReaderCreator xrc;
    private InputSource in;
    private ErrorHandler eh;

    public SAXParseable(XMLReaderCreator xMLReaderCreator, InputSource inputSource, ErrorHandler errorHandler) {
        this.xrc = xMLReaderCreator;
        this.in = inputSource;
        this.eh = errorHandler;
    }

    public ParsedPattern parse(SchemaBuilder schemaBuilder, Scope scope) throws BuildException, IllegalSchemaException {
        try {
            XMLReader xMLReader = this.xrc.createXMLReader();
            SchemaParser schemaParser = new SchemaParser(xMLReader, this.eh, schemaBuilder, null, scope);
            xMLReader.parse(this.in);
            return schemaParser.getStartPattern();
        }
        catch (SAXException sAXException) {
            throw SAXParseable.toBuildException(sAXException);
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    public ParsedPattern parseInclude(String string, SchemaBuilder schemaBuilder, IncludedGrammar includedGrammar) throws BuildException, IllegalSchemaException {
        try {
            XMLReader xMLReader = this.xrc.createXMLReader();
            SchemaParser schemaParser = new SchemaParser(xMLReader, this.eh, schemaBuilder, includedGrammar, includedGrammar);
            xMLReader.parse(this.makeInputSource(xMLReader, string));
            return schemaParser.getStartPattern();
        }
        catch (SAXException sAXException) {
            throw SAXParseable.toBuildException(sAXException);
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    public ParsedPattern parseExternal(String string, SchemaBuilder schemaBuilder, Scope scope) throws BuildException, IllegalSchemaException {
        try {
            XMLReader xMLReader = this.xrc.createXMLReader();
            SchemaParser schemaParser = new SchemaParser(xMLReader, this.eh, schemaBuilder, null, scope);
            xMLReader.parse(this.makeInputSource(xMLReader, string));
            return schemaParser.getStartPattern();
        }
        catch (SAXException sAXException) {
            throw SAXParseable.toBuildException(sAXException);
        }
        catch (IOException iOException) {
            throw new BuildException(iOException);
        }
    }

    private InputSource makeInputSource(XMLReader xMLReader, String string) throws IOException, SAXException {
        InputSource inputSource;
        EntityResolver entityResolver = xMLReader.getEntityResolver();
        if (entityResolver != null && (inputSource = entityResolver.resolveEntity(null, string)) != null) {
            return inputSource;
        }
        return new InputSource(string);
    }

    private static BuildException toBuildException(SAXException sAXException) {
        Exception exception = sAXException.getException();
        if (exception instanceof BuildException) {
            throw (BuildException)exception;
        }
        throw new BuildException(sAXException);
    }
}

