/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class UriOrFile {
    private UriOrFile() {
    }

    public static String toUri(String string) {
        if (!UriOrFile.hasScheme(string)) {
            try {
                return UriOrFile.fileToUri(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return string;
    }

    private static boolean hasScheme(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        if (!UriOrFile.isAlpha(string.charAt(0))) {
            return false;
        }
        int n2 = 1;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case ':': {
                    return n2 != 1;
                }
                case '+': 
                case '-': {
                    break;
                }
                default: {
                    if (UriOrFile.isAlnum(c)) break;
                    return false;
                }
            }
            ++n2;
        }
        return false;
    }

    private static boolean isAlpha(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
    }

    private static boolean isAlnum(char c) {
        return UriOrFile.isAlpha(c) || '0' <= c && c <= '9';
    }

    public static String fileToUri(String string) throws MalformedURLException {
        return UriOrFile.fileToUri(new File(string));
    }

    public static String fileToUri(File file) throws MalformedURLException {
        String string = file.getAbsolutePath().replace(File.separatorChar, '/');
        if (string.length() > 0 && string.charAt(0) != '/') {
            string = '/' + string;
        }
        return new URL("file", "", string).toString();
    }
}

