/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.xslt;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.xslt.XSLTProcessor;
import org.apache.cocoon.util.ClassUtils;
import org.apache.cocoon.util.TraxErrorHandler;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.store.Store;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;

public class XSLTProcessorImpl
extends AbstractLogEnabled
implements XSLTProcessor,
Composable,
Disposable,
Parameterizable,
URIResolver {
    protected ComponentManager manager;
    protected Store store;
    protected HashMap factories;
    protected SAXTransformerFactory factory;
    protected boolean useStore = true;
    protected boolean incrementalProcessing = false;
    protected SourceResolver resolver;
    protected TraxErrorHandler errorHandler;

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("XSLTProcessorImpl component initialized.");
        }
        this.store = (Store)manager.lookup(Store.TRANSIENT_STORE);
        this.errorHandler = new TraxErrorHandler(this.getLogger());
        this.resolver = (SourceResolver)manager.lookup(SourceResolver.ROLE);
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Component)this.store);
            this.store = null;
            this.manager.release((Component)this.resolver);
            this.resolver = null;
        }
        this.errorHandler = null;
        this.manager = null;
    }

    public void parameterize(Parameters params) throws ParameterException {
        this.useStore = params.getParameterAsBoolean("use-store", true);
        this.incrementalProcessing = params.getParameterAsBoolean("incremental-processing", false);
        this.factory = this.getTransformerFactory(params.getParameter("transformer-factory", "default"));
    }

    public void setSourceResolver(org.apache.cocoon.environment.SourceResolver resolver) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("XSLTProcessor: the setSourceResolver() method is deprecated.");
        }
    }

    public void setTransformerFactory(String classname) {
        this.factory = this.getTransformerFactory(classname);
    }

    public TransformerHandler getTransformerHandler(org.apache.cocoon.environment.Source stylesheet) throws ProcessingException {
        return this.getTransformerHandler(stylesheet, null);
    }

    public TransformerHandler getTransformerHandler(org.apache.cocoon.environment.Source stylesheet, XMLFilter filter) throws ProcessingException {
        try {
            String id = stylesheet.getSystemId();
            Templates templates = this.getTemplates(stylesheet, id);
            if (templates == null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Creating new Templates for " + id);
                }
                TemplatesHandler templatesHandler = this.factory.newTemplatesHandler();
                templatesHandler.setSystemId(id);
                if (filter != null) {
                    filter.setContentHandler(templatesHandler);
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Source = " + stylesheet + ", templatesHandler = " + templatesHandler);
                }
                stylesheet.toSAX(filter != null ? (ContentHandler)((Object)filter) : templatesHandler);
                templates = templatesHandler.getTemplates();
                this.putTemplates(templates, stylesheet, id);
            } else if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Reusing Templates for " + id);
            }
            TransformerHandler handler = this.factory.newTransformerHandler(templates);
            handler.getTransformer().setErrorListener((ErrorListener)this.errorHandler);
            handler.getTransformer().setURIResolver(this);
            return handler;
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (SAXException e) {
            if (e.getException() == null) {
                throw new ProcessingException("Exception in creating Transform Handler", (Throwable)e);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Got SAXException. Rethrowing cause exception.", (Throwable)e);
            }
            throw new ProcessingException("Exception in creating Transform Handler", (Throwable)e.getException());
        }
        catch (Exception e) {
            throw new ProcessingException("Exception in creating Transform Handler", (Throwable)e);
        }
    }

    public void transform(org.apache.cocoon.environment.Source source, org.apache.cocoon.environment.Source stylesheet, Parameters params, Result result) throws ProcessingException {
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("XSLTProcessorImpl: transform source = " + source + ", stylesheet = " + stylesheet + ", parameters = " + params + ", result = " + result);
            }
            TransformerHandler handler = this.getTransformerHandler(stylesheet);
            Transformer transformer = handler.getTransformer();
            if (params != null) {
                transformer.clearParameters();
                String[] names = params.getNames();
                int i = names.length - 1;
                while (i >= 0) {
                    transformer.setParameter(names[i], params.getParameter(names[i]));
                    --i;
                }
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("XSLTProcessorImpl: starting transform");
            }
            handler.setResult(result);
            source.toSAX((ContentHandler)handler);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("XSLTProcessorImpl: transform done");
            }
        }
        catch (Exception e) {
            throw new ProcessingException("Error in running Transformation", (Throwable)e);
        }
    }

    private SAXTransformerFactory getTransformerFactory(String factoryName) {
        SAXTransformerFactory _factory;
        if (factoryName == null || factoryName == "default") {
            _factory = (SAXTransformerFactory)TransformerFactory.newInstance();
        } else {
            try {
                _factory = (SAXTransformerFactory)ClassUtils.loadClass((String)factoryName).newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Cannot find the requested TrAX factory '" + factoryName + "'. Using default TrAX Transformer Factory instead.");
                }
                if (this.factory != null) {
                    return this.factory;
                }
                _factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            }
            catch (ClassCastException cce) {
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("The indicated class '" + factoryName + "' is not a TrAX Transformer Factory. Using default TrAX Transformer Factory instead.");
                }
                if (this.factory != null) {
                    return this.factory;
                }
                _factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            }
            catch (Exception e) {
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Error found loading the requested TrAX Transformer Factory '" + factoryName + "'. Using default TrAX Transformer Factory instead.");
                }
                if (this.factory != null) {
                    return this.factory;
                }
                _factory = (SAXTransformerFactory)TransformerFactory.newInstance();
            }
        }
        _factory.setErrorListener((ErrorListener)this.errorHandler);
        _factory.setURIResolver(this);
        if (_factory.getClass().getName().equals("org.apache.xalan.processor.TransformerFactoryImpl")) {
            _factory.setAttribute("http://xml.apache.org/xalan/features/incremental", new Boolean(this.incrementalProcessing));
        }
        return _factory;
    }

    private Templates getTemplates(org.apache.cocoon.environment.Source stylesheet, String id) throws IOException, ProcessingException {
        if (!this.useStore) {
            return null;
        }
        id = id + this.factory.getClass().getName();
        Templates templates = null;
        if (stylesheet.getLastModified() != 0L) {
            Object[] templateAndTime;
            if (this.store.containsKey((Object)id) && (templateAndTime = (Object[])this.store.get((Object)id)) != null && templateAndTime[1] != null) {
                long storedTime = (Long)templateAndTime[1];
                if (storedTime < stylesheet.getLastModified()) {
                    this.store.remove((Object)id);
                } else {
                    templates = (Templates)templateAndTime[0];
                }
            }
        } else if (this.store.containsKey((Object)id)) {
            this.store.remove((Object)id);
        }
        return templates;
    }

    private void putTemplates(Templates templates, org.apache.cocoon.environment.Source stylesheet, String id) throws IOException, ProcessingException {
        if (!this.useStore) {
            return;
        }
        id = id + this.factory.getClass().getName();
        if (stylesheet.getLastModified() != 0L) {
            Object[] templateAndTime = new Object[]{templates, new Long(stylesheet.getLastModified())};
            this.store.store((Object)id, (Object)templateAndTime);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public javax.xml.transform.Source resolve(String href, String base) throws TransformerException {
        StreamSource parent2;
        Source xslSource;
        block15: {
            javax.xml.transform.Source source;
            block14: {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("resolve(href = " + href + ", base = " + base + "); resolver = " + this.resolver);
                }
                xslSource = null;
                try {
                    try {
                        if (href.indexOf(":") > 1) {
                            xslSource = this.resolver.resolveURI(href);
                        } else {
                            if (base == null) {
                                throw new IllegalArgumentException("Null pointer passed as base");
                            }
                            if (!base.startsWith("file:")) {
                                int lastPathElementPos = base.lastIndexOf(47);
                                if (lastPathElementPos == -1) {
                                    source = null;
                                    Object var9_12 = null;
                                    break block14;
                                }
                                xslSource = this.resolver.resolveURI(base.substring(0, lastPathElementPos) + "/" + href);
                            } else {
                                File parent2 = new File(base.substring(5));
                                File parent22 = new File(parent2.getParentFile(), href);
                                xslSource = this.resolver.resolveURI(parent22.toURL().toExternalForm());
                            }
                        }
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("xslSource = " + xslSource + ", system id = " + xslSource.getURI());
                        }
                        parent2 = new StreamSource(xslSource.getInputStream(), xslSource.getURI());
                        break block15;
                    }
                    catch (MalformedURLException mue) {
                        javax.xml.transform.Source parent22 = null;
                        Object var9_14 = null;
                        this.resolver.release(xslSource);
                        return parent22;
                    }
                    catch (SourceException pe) {
                        throw new TransformerException(pe);
                    }
                    catch (IOException ioe) {
                        javax.xml.transform.Source source2 = null;
                        Object var9_15 = null;
                        this.resolver.release(xslSource);
                        return source2;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_16 = null;
                    this.resolver.release(xslSource);
                    throw throwable;
                }
            }
            this.resolver.release(xslSource);
            return source;
        }
        Object var9_13 = null;
        this.resolver.release(xslSource);
        return parent2;
    }
}

