/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import net.sourceforge.chaperon.adapter.avalon.GrammarFactory;
import net.sourceforge.chaperon.adapter.sax.ParserHandlerAdapter;
import net.sourceforge.chaperon.adapter.sax.ParserProcessorAdapter;
import net.sourceforge.chaperon.build.ParserAutomatonBuilder;
import net.sourceforge.chaperon.model.grammar.Grammar;
import net.sourceforge.chaperon.process.ParserAutomaton;
import net.sourceforge.chaperon.process.ParserHandler;
import net.sourceforge.chaperon.process.ParserProcessor;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.SAXConfigurationHandler;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.Transformer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceValidity;
import org.apache.excalibur.store.Store;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class ParserTransformer
extends ParserProcessorAdapter
implements Transformer,
LogEnabled,
Composable,
Parameterizable,
Recyclable,
Disposable,
CacheableProcessingComponent {
    private String grammar;
    private Source grammarSource;
    private Logger logger;
    private ComponentManager manager;
    private SourceResolver resolver;
    private ParserAutomaton automaton;
    private ParserHandlerAdapter adapter = new ParserHandlerAdapter(true);
    private boolean recovery = false;

    public void enableLogging(Logger logger) {
        this.logger = logger;
    }

    public void compose(ComponentManager manager) {
        this.manager = manager;
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        this.adapter.setFlatten(parameters.getParameterAsBoolean("flatten", false));
        this.recovery = parameters.getParameterAsBoolean("recovery", false);
    }

    public void setConsumer(XMLConsumer consumer) {
        this.setContentHandler((ContentHandler)consumer);
        this.setLexicalHandler((LexicalHandler)consumer);
        this.adapter.setContentHandler((ContentHandler)consumer);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setup(SourceResolver resolver, Map objectmodel, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        this.resolver = resolver;
        Store store = null;
        try {
            try {
                this.grammar = src;
                this.grammarSource = resolver.resolveURI(this.grammar);
                store = (Store)this.manager.lookup(Store.TRANSIENT_STORE);
                ParserAutomatonEntry entry = (ParserAutomatonEntry)store.get((Object)this.grammarSource.getURI());
                if (entry == null || entry.getValidity() == null || entry.getValidity().isValid(this.grammarSource.getValidity()) <= 0) {
                    this.logger.info("(Re)building the automaton from '" + this.grammarSource.getURI() + "'");
                    SAXConfigurationHandler confighandler = new SAXConfigurationHandler();
                    if (this.grammarSource.getInputStream() == null) {
                        throw new ProcessingException("Source '" + this.grammarSource.getURI() + "' not found");
                    }
                    SourceUtil.toSAX((ComponentManager)this.manager, (Source)this.grammarSource, null, (ContentHandler)confighandler);
                    Configuration config = confighandler.getConfiguration();
                    Grammar grammar = GrammarFactory.createGrammar((Configuration)config);
                    ParserAutomatonBuilder builder = new ParserAutomatonBuilder(grammar, this.logger);
                    this.automaton = builder.getParserAutomaton();
                    this.logger.info("Store automaton into store for '" + this.grammarSource.getURI() + "'");
                    store.store((Object)this.grammarSource.getURI(), (Object)new ParserAutomatonEntry(this.automaton, this.grammarSource.getValidity()));
                } else {
                    this.logger.info("Getting automaton from store for '" + this.grammarSource.getURI() + "'");
                    this.automaton = entry.getParserAutomaton();
                }
                if (this.getParserProcessor() == null) {
                    ParserProcessor processor = new ParserProcessor();
                    processor.setParserHandler((ParserHandler)this.adapter);
                    processor.setLogger(this.logger);
                    processor.setRecovery(this.recovery);
                    this.setParserProcessor(processor);
                }
                this.getParserProcessor().setParserAutomaton(this.automaton);
            }
            catch (ConfigurationException confige) {
                throw new ProcessingException("Error during retrieving the grammar", (Throwable)confige);
            }
            catch (SourceException se) {
                throw new ProcessingException("Error during resolving of '" + src + "'.", (Throwable)se);
            }
            catch (ComponentException ce) {
                throw new ProcessingException("Could not lookup for component", (Throwable)ce);
            }
            Object var12_14 = null;
            if (store == null) return;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (store == null) throw throwable;
            this.manager.release(store);
            throw throwable;
        }
        this.manager.release((Component)store);
    }

    public Serializable getKey() {
        return this.grammarSource.getURI();
    }

    public SourceValidity getValidity() {
        return this.grammarSource.getValidity();
    }

    public void recycle() {
        if (this.resolver != null && this.grammarSource != null) {
            this.resolver.release(this.grammarSource);
            this.grammarSource = null;
        }
        this.automaton = null;
    }

    public void dispose() {
        if (this.resolver != null && this.grammarSource != null) {
            this.resolver.release(this.grammarSource);
            this.grammarSource = null;
        }
        this.manager = null;
    }

    public class ParserAutomatonEntry
    implements Serializable {
        private SourceValidity validity = null;
        private ParserAutomaton automaton = null;

        public ParserAutomatonEntry(ParserAutomaton automaton, SourceValidity validity) {
            this.automaton = automaton;
            this.validity = validity;
        }

        public SourceValidity getValidity() {
            return this.validity;
        }

        public ParserAutomaton getParserAutomaton() {
            return this.automaton;
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            out.writeObject(this.validity);
            out.writeObject(this.automaton);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            this.validity = (SourceValidity)in.readObject();
            this.automaton = (ParserAutomaton)in.readObject();
        }
    }
}

