/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.avalon.excalibur.i18n.ResourceManager;
import org.apache.avalon.excalibur.i18n.Resources;
import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.AvalonFormatter;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;
import org.apache.log.output.io.FileTarget;

public class SimpleLogKitManager
extends AbstractLogEnabled
implements LoggerManager,
Contextualizable,
Configurable {
    private static final Resources REZ = ResourceManager.getPackageResources((Class)(class$org$apache$avalon$excalibur$logger$SimpleLogKitManager == null ? (class$org$apache$avalon$excalibur$logger$SimpleLogKitManager = SimpleLogKitManager.class$("org.apache.avalon.excalibur.logger.SimpleLogKitManager")) : class$org$apache$avalon$excalibur$logger$SimpleLogKitManager));
    private static final String DEFAULT_FORMAT = "%7.7{priority} %23.23{time:yyyy-MM-dd' 'HH:mm:ss.SSS} [%8.8{category}] (%{context}): %{message}\n%{throwable}";
    private File m_baseDirectory;
    private final Hierarchy m_hierarchy = new Hierarchy();
    private final Logger m_logkitLogger = this.m_hierarchy.getLoggerFor("");
    private org.apache.avalon.framework.logger.Logger m_logger = new LogKitLogger(this.m_logkitLogger);
    static /* synthetic */ Class class$org$apache$avalon$excalibur$logger$SimpleLogKitManager;

    public void contextualize(Context context) throws ContextException {
        this.m_baseDirectory = (File)context.get((Object)"app.home");
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] targets = configuration.getChildren("log-target");
        HashMap targetSet = this.configureTargets(targets);
        Configuration[] categories = configuration.getChildren("category");
        this.configureCategories(categories, targetSet);
    }

    public org.apache.avalon.framework.logger.Logger getLoggerForCategory(String name) {
        return this.m_logger.getChildLogger(name);
    }

    public org.apache.avalon.framework.logger.Logger getDefaultLogger() {
        return this.m_logger;
    }

    private HashMap configureTargets(Configuration[] targets) throws ConfigurationException {
        HashMap<String, FileTarget> targetSet = new HashMap<String, FileTarget>();
        int i = 0;
        while (i < targets.length) {
            Configuration target = targets[i];
            String name = target.getAttribute("name");
            String location = target.getAttribute("location").trim();
            String format = target.getAttribute("format", DEFAULT_FORMAT);
            if ('/' == location.charAt(0)) {
                location = location.substring(1);
            }
            AvalonFormatter formatter = new AvalonFormatter(format);
            File file = new File(this.m_baseDirectory, location);
            FileTarget logTarget = null;
            try {
                logTarget = new FileTarget(file.getAbsoluteFile(), true, (Formatter)formatter);
            }
            catch (IOException ioe) {
                String message = REZ.getString("target.nocreate", (Object)name, (Object)file, (Object)ioe.getMessage());
                throw new ConfigurationException(message, (Throwable)ioe);
            }
            targetSet.put(name, logTarget);
            ++i;
        }
        return targetSet;
    }

    private void configureCategories(Configuration[] categories, HashMap targets) throws ConfigurationException {
        int i = 0;
        while (i < categories.length) {
            String message;
            Configuration category = categories[i];
            String name = category.getAttribute("name", "");
            String target = category.getAttribute("target");
            String priorityName = category.getAttribute("priority");
            Logger logger = this.m_logkitLogger.getChildLogger(name);
            LogTarget logTarget = (LogTarget)targets.get(target);
            if (null == target) {
                String message2 = REZ.getString("unknown-target", (Object)target, (Object)name);
                throw new ConfigurationException(message2);
            }
            Priority priority = Priority.getPriorityForName((String)priorityName);
            if (!priority.getName().equals(priorityName)) {
                message = REZ.getString("unknown-priority", (Object)priorityName, (Object)name);
                throw new ConfigurationException(message);
            }
            if (this.getLogger().isDebugEnabled()) {
                message = REZ.getString("category-create", (Object)name, (Object)target, (Object)priorityName);
                this.getLogger().debug(message);
            }
            if (name.equals("")) {
                this.m_hierarchy.setDefaultPriority(priority);
                this.m_hierarchy.setDefaultLogTarget(logTarget);
            } else {
                logger.setPriority(priority);
                logger.setLogTargets(new LogTarget[]{logTarget});
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

