/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper;

import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.jasper.Constants;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.TldLocationsCache;
import org.apache.jasper.xmlparser.ParserUtils;

public final class EmbededServletOptions
implements Options {
    private Properties settings = new Properties();
    public boolean development = true;
    public boolean keepGenerated = true;
    public boolean largeFile = false;
    public boolean poolingEnabled = true;
    public boolean mappedFile = false;
    public boolean sendErrorToClient = false;
    public boolean classDebugInfo = true;
    public int checkInterval = 300;
    public boolean reloading = true;
    public File scratchDir;
    public String ieClassId = "clsid:8AD9C840-044E-11D1-B3E9-00805F499D93";
    public String classpath = null;
    public String compiler = null;
    private TldLocationsCache tldLocationsCache = null;
    private String javaEncoding = "UTF8";

    public String getProperty(String name) {
        return this.settings.getProperty(name);
    }

    public void setProperty(String name, String value) {
        this.settings.setProperty(name, value);
    }

    public boolean getKeepGenerated() {
        return this.keepGenerated;
    }

    public boolean getLargeFile() {
        return this.largeFile;
    }

    public boolean isPoolingEnabled() {
        return this.poolingEnabled;
    }

    public boolean getMappedFile() {
        return this.mappedFile;
    }

    public boolean getSendErrorToClient() {
        return this.sendErrorToClient;
    }

    public boolean getClassDebugInfo() {
        return this.classDebugInfo;
    }

    public int getCheckInterval() {
        return this.checkInterval;
    }

    public boolean getDevelopment() {
        return this.development;
    }

    public boolean getReloading() {
        return this.reloading;
    }

    public String getIeClassId() {
        return this.ieClassId;
    }

    public File getScratchDir() {
        return this.scratchDir;
    }

    public String getClassPath() {
        return this.classpath;
    }

    public String getCompiler() {
        return this.compiler;
    }

    public TldLocationsCache getTldLocationsCache() {
        return this.tldLocationsCache;
    }

    public void setTldLocationsCache(TldLocationsCache tldC) {
        this.tldLocationsCache = tldC;
    }

    public String getJavaEncoding() {
        return this.javaEncoding;
    }

    public EmbededServletOptions(ServletConfig config, ServletContext context) {
        String dir;
        String classpath;
        String ieClassId;
        String reloading;
        String development;
        String checkInterval;
        String debugInfo;
        String senderr;
        String mapFile;
        String largeFile;
        String keepgen;
        Enumeration enumeration = config.getInitParameterNames();
        while (enumeration.hasMoreElements()) {
            String k = (String)enumeration.nextElement();
            String v = config.getInitParameter(k);
            this.setProperty(k, v);
        }
        String validating = config.getInitParameter("validating");
        if ("false".equals(validating)) {
            ParserUtils.validating = false;
        }
        if ((keepgen = config.getInitParameter("keepgenerated")) != null) {
            if (keepgen.equalsIgnoreCase("true")) {
                this.keepGenerated = true;
            } else if (keepgen.equalsIgnoreCase("false")) {
                this.keepGenerated = false;
            } else {
                Constants.message("jsp.warning.keepgen", 2);
            }
        }
        if ((largeFile = config.getInitParameter("largefile")) != null) {
            if (largeFile.equalsIgnoreCase("true")) {
                this.largeFile = true;
            } else if (largeFile.equalsIgnoreCase("false")) {
                this.largeFile = false;
            } else {
                Constants.message("jsp.warning.largeFile", 2);
            }
        }
        if ((mapFile = config.getInitParameter("mappedfile")) != null) {
            if (mapFile.equalsIgnoreCase("true")) {
                this.mappedFile = true;
            } else if (mapFile.equalsIgnoreCase("false")) {
                this.mappedFile = false;
            } else {
                Constants.message("jsp.warning.mappedFile", 2);
            }
        }
        this.poolingEnabled = true;
        String poolingEnabledParam = config.getInitParameter("enablePooling");
        if (poolingEnabledParam != null && !poolingEnabledParam.equalsIgnoreCase("true")) {
            if (poolingEnabledParam.equalsIgnoreCase("false")) {
                this.poolingEnabled = false;
            } else {
                Constants.message("jsp.warning.enablePooling", 2);
            }
        }
        if ((senderr = config.getInitParameter("sendErrToClient")) != null) {
            if (senderr.equalsIgnoreCase("true")) {
                this.sendErrorToClient = true;
            } else if (senderr.equalsIgnoreCase("false")) {
                this.sendErrorToClient = false;
            } else {
                Constants.message("jsp.warning.sendErrToClient", 2);
            }
        }
        if ((debugInfo = config.getInitParameter("classdebuginfo")) != null) {
            if (debugInfo.equalsIgnoreCase("true")) {
                this.classDebugInfo = true;
            } else if (debugInfo.equalsIgnoreCase("false")) {
                this.classDebugInfo = false;
            } else {
                Constants.message("jsp.warning.classDebugInfo", 2);
            }
        }
        if ((checkInterval = config.getInitParameter("checkInterval")) != null) {
            try {
                this.checkInterval = new Integer(checkInterval);
                if (this.checkInterval == 0) {
                    this.checkInterval = 300;
                    Constants.message("jsp.warning.checkInterval", 2);
                }
            }
            catch (NumberFormatException ex) {
                Constants.message("jsp.warning.checkInterval", 2);
            }
        }
        if ((development = config.getInitParameter("development")) != null) {
            if (development.equalsIgnoreCase("true")) {
                this.development = true;
            } else if (development.equalsIgnoreCase("false")) {
                this.development = false;
            } else {
                Constants.message("jsp.warning.development", 2);
            }
        }
        if ((reloading = config.getInitParameter("reloading")) != null) {
            if (reloading.equalsIgnoreCase("true")) {
                this.reloading = true;
            } else if (reloading.equalsIgnoreCase("false")) {
                this.reloading = false;
            } else {
                Constants.message("jsp.warning.reloading", 2);
            }
        }
        if ((ieClassId = config.getInitParameter("ieClassId")) != null) {
            this.ieClassId = ieClassId;
        }
        if ((classpath = config.getInitParameter("classpath")) != null) {
            this.classpath = classpath;
        }
        if ((dir = config.getInitParameter("scratchdir")) != null) {
            this.scratchDir = new File(dir);
        } else {
            this.scratchDir = (File)context.getAttribute("javax.servlet.context.tempdir");
            if (this.scratchDir == null && (dir = System.getProperty("java.io.tmpdir")) != null) {
                this.scratchDir = new File(dir);
            }
        }
        if (this.scratchDir == null) {
            Constants.message("jsp.error.no.scratch.dir", Integer.MIN_VALUE);
            return;
        }
        if (!(this.scratchDir.exists() && this.scratchDir.canRead() && this.scratchDir.canWrite() && this.scratchDir.isDirectory())) {
            Constants.message("jsp.error.bad.scratch.dir", new Object[]{this.scratchDir.getAbsolutePath()}, Integer.MIN_VALUE);
        }
        this.compiler = config.getInitParameter("compiler");
        String javaEncoding = config.getInitParameter("javaEncoding");
        if (javaEncoding != null) {
            this.javaEncoding = javaEncoding;
        }
        this.tldLocationsCache = new TldLocationsCache(context);
    }
}

