/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.DefaultErrorHandler;
import org.apache.jasper.compiler.ErrorHandler;
import org.apache.jasper.compiler.JavacErrorDetail;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.Node;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ErrorDispatcher {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org.apache.jasper.resources.messages");
    private ErrorHandler errHandler = new DefaultErrorHandler(this);

    ErrorDispatcher() {
    }

    void jspError(String errCode) throws JasperException {
        this.dispatch(null, errCode, null, null);
    }

    void jspError(Mark where, String errCode) throws JasperException {
        this.dispatch(where, errCode, null, null);
    }

    void jspError(Node n, String errCode) throws JasperException {
        this.dispatch(n.getStart(), errCode, null, null);
    }

    void jspError(String errCode, String arg) throws JasperException {
        this.dispatch(null, errCode, new Object[]{arg}, null);
    }

    void jspError(Mark where, String errCode, String arg) throws JasperException {
        this.dispatch(where, errCode, new Object[]{arg}, null);
    }

    void jspError(Node n, String errCode, String arg) throws JasperException {
        this.dispatch(n.getStart(), errCode, new Object[]{arg}, null);
    }

    void jspError(String errCode, String arg1, String arg2) throws JasperException {
        this.dispatch(null, errCode, new Object[]{arg1, arg2}, null);
    }

    void jspError(Mark where, String errCode, String arg1, String arg2) throws JasperException {
        this.dispatch(where, errCode, new Object[]{arg1, arg2}, null);
    }

    void jspError(Node n, String errCode, String arg1, String arg2) throws JasperException {
        this.dispatch(n.getStart(), errCode, new Object[]{arg1, arg2}, null);
    }

    void jspError(Exception e) throws JasperException {
        this.dispatch(null, null, null, e);
    }

    void jspError(String errCode, String arg, Exception e) throws JasperException {
        this.dispatch(null, errCode, new Object[]{arg}, e);
    }

    void jspError(Node n, String errCode, String arg, Exception e) throws JasperException {
        this.dispatch(n.getStart(), errCode, new Object[]{arg}, e);
    }

    void javacError(String errMsg, String fname, Node.Nodes page) throws JasperException, IOException {
        JavacErrorDetail[] errDetails = this.parseJavacMessage(errMsg, fname, page);
        this.errHandler.javacError(errDetails);
    }

    String getString(String errCode) {
        String errMsg = errCode;
        try {
            errMsg = bundle.getString(errCode);
        }
        catch (MissingResourceException e) {}
        return errMsg;
    }

    String getString(String errCode, String arg) {
        return this.getString(errCode, new Object[]{arg});
    }

    String getString(String errCode, String arg1, String arg2) {
        return this.getString(errCode, new Object[]{arg1, arg2});
    }

    String getString(String errCode, Object[] args) {
        String errMsg = errCode;
        try {
            errMsg = bundle.getString(errCode);
            if (args != null) {
                MessageFormat formatter = new MessageFormat(errMsg);
                errMsg = formatter.format(args);
            }
        }
        catch (MissingResourceException e) {}
        return errMsg;
    }

    private void dispatch(Mark where, String errCode, Object[] args, Exception e) throws JasperException {
        String file = null;
        int line = -1;
        int column = -1;
        String errMsg = this.getString(errCode, args);
        if (where != null) {
            file = where.getFile();
            line = where.getLineNumber();
            column = where.getColumnNumber();
        } else if (e instanceof SAXParseException) {
            file = ((SAXParseException)e).getSystemId();
            line = ((SAXParseException)e).getLineNumber();
            column = ((SAXParseException)e).getColumnNumber();
        }
        Exception nestedEx = e;
        if (e instanceof SAXException) {
            nestedEx = ((SAXException)e).getException();
        }
        this.errHandler.jspError(file, line, column, errMsg, nestedEx);
    }

    private JavacErrorDetail[] parseJavacMessage(String errMsg, String fname, Node.Nodes page) throws IOException, JasperException {
        String line;
        Vector<JavacErrorDetail> errVec = new Vector<JavacErrorDetail>();
        StringBuffer partialErrMsg = new StringBuffer();
        int lineNum = -1;
        Node errNode = null;
        BufferedReader reader = new BufferedReader(new StringReader(errMsg));
        while ((line = reader.readLine()) != null) {
            int beginColon = line.indexOf(58, 2);
            int endColon = line.indexOf(58, beginColon + 1);
            if (beginColon >= 0 && endColon >= 0) {
                if (errNode != null) {
                    errVec.add(new JavacErrorDetail(fname, lineNum, errNode.getStart().getFile(), errNode.getStart().getLineNumber(), partialErrMsg.toString()));
                    partialErrMsg = new StringBuffer();
                }
                String lineNumStr = line.substring(beginColon + 1, endColon);
                try {
                    lineNum = Integer.parseInt(lineNumStr);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                ErrorVisitor errVisitor = new ErrorVisitor(lineNum);
                page.visit(errVisitor);
                errNode = errVisitor.getJspSourceNode();
            }
            partialErrMsg.append(line);
            partialErrMsg.append('\n');
        }
        reader.close();
        String pageFile = null;
        int pageLine = -1;
        if (errNode != null) {
            pageFile = errNode.getStart().getFile();
            pageLine = errNode.getStart().getLineNumber();
        }
        errVec.add(new JavacErrorDetail(fname, lineNum, pageFile, pageLine, partialErrMsg.toString()));
        Object[] errDetails = null;
        if (errVec.size() > 0) {
            errDetails = new JavacErrorDetail[errVec.size()];
            errVec.copyInto(errDetails);
        }
        return errDetails;
    }

    static class ErrorVisitor
    extends Node.Visitor {
        private int lineNum;
        Node found;

        public ErrorVisitor(int lineNum) {
            this.lineNum = lineNum;
        }

        public void doVisit(Node n) throws JasperException {
            if (this.lineNum >= n.getBeginJavaLine() && this.lineNum < n.getEndJavaLine()) {
                this.found = n;
            }
        }

        public Node getJspSourceNode() {
            return this.found;
        }
    }
}

