/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.servlet;

import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jasper.Constants;
import org.apache.jasper.EmbededServletOptions;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.JspRuntimeContext;
import org.apache.jasper.logging.DefaultLogger;
import org.apache.jasper.logging.Logger;
import org.apache.jasper.servlet.JspServletWrapper;

public class JspServlet
extends HttpServlet {
    private Logger.Helper loghelper;
    private ServletContext context;
    private ServletConfig config;
    private Options options;
    private JspRuntimeContext rctxt;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.config = config;
        this.context = config.getServletContext();
        Constants.jasperLog = new DefaultLogger(this.context);
        Constants.jasperLog.setName("JASPER_LOG");
        Constants.jasperLog.setTimestamp("false");
        Constants.jasperLog.setVerbosityLevel(config.getInitParameter("logVerbosityLevel"));
        this.loghelper = new Logger.Helper("JASPER_LOG", "JspServlet");
        this.options = new EmbededServletOptions(config, this.context);
        this.rctxt = new JspRuntimeContext(this.context, this.options);
        Constants.message("jsp.message.scratch.dir.is", new Object[]{this.options.getScratchDir().toString()}, 3);
        Constants.message("jsp.message.dont.modify.servlets", 3);
    }

    boolean preCompile(HttpServletRequest request) throws ServletException {
        String value;
        String queryString = request.getQueryString();
        if (queryString == null) {
            return false;
        }
        int start = queryString.indexOf("jsp_precompile");
        if (start < 0) {
            return false;
        }
        if ((queryString = queryString.substring(start + "jsp_precompile".length())).length() == 0) {
            return true;
        }
        if (queryString.startsWith("&")) {
            return true;
        }
        if (!queryString.startsWith("=")) {
            return false;
        }
        int limit = queryString.length();
        int ampersand = queryString.indexOf("&");
        if (ampersand > 0) {
            limit = ampersand;
        }
        if ((value = queryString.substring(1, limit)).equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return true;
        }
        throw new ServletException("Cannot have request parameter jsp_precompile set to " + value);
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String includeUri = (String)request.getAttribute("javax.servlet.include.servlet_path");
            String jspUri = includeUri == null ? request.getServletPath() : includeUri;
            String jspFile = (String)request.getAttribute("org.apache.catalina.jsp_file");
            if (jspFile != null) {
                jspUri = jspFile;
            }
            boolean precompile = this.preCompile(request);
            Logger jasperLog = Constants.jasperLog;
            if (jasperLog != null && jasperLog.matchVerbosityLevel(3)) {
                jasperLog.log("JspEngine --> " + jspUri);
                jasperLog.log("\t     ServletPath: " + request.getServletPath());
                jasperLog.log("\t        PathInfo: " + request.getPathInfo());
                jasperLog.log("\t        RealPath: " + this.context.getRealPath(jspUri));
                jasperLog.log("\t      RequestURI: " + request.getRequestURI());
                jasperLog.log("\t     QueryString: " + request.getQueryString());
                jasperLog.log("\t  Request Params: ");
                Enumeration e = request.getParameterNames();
                while (e.hasMoreElements()) {
                    String name = (String)e.nextElement();
                    jasperLog.log("\t\t " + name + " = " + request.getParameter(name));
                }
            }
            this.serviceJspFile(request, response, jspUri, null, precompile);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ServletException(e);
        }
    }

    public void destroy() {
        if (Constants.jasperLog != null) {
            Constants.jasperLog.log("JspServlet.destroy()", 3);
        }
        this.rctxt.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serviceJspFile(HttpServletRequest request, HttpServletResponse response, String jspUri, Throwable exception, boolean precompile) throws ServletException, IOException {
        JspServletWrapper wrapper = this.rctxt.getWrapper(jspUri);
        if (wrapper == null) {
            if (this.context.getResourceAsStream(jspUri) == null) {
                response.sendError(404, jspUri);
                return;
            }
            boolean isErrorPage = exception != null;
            JspServlet jspServlet = this;
            synchronized (jspServlet) {
                wrapper = this.rctxt.getWrapper(jspUri);
                if (wrapper == null) {
                    wrapper = new JspServletWrapper(this.config, this.options, jspUri, isErrorPage, this.rctxt);
                    this.rctxt.addWrapper(jspUri, wrapper);
                }
            }
        }
        wrapper.service(request, response, precompile);
    }
}

